/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.actions.ToolwindowFusEventFields;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.internal.statistic.collectors.fus.DataContextUtils;
import com.intellij.internal.statistic.collectors.fus.actions.ProjectState;
import com.intellij.internal.statistic.collectors.fus.actions.ProjectStateObserver;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsBuiltInAllowedlist;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventDataCollector;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.FusInputEvent;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.util.TimeoutUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.awt.event.InputEvent;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001b\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J0\u0010\b\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0018\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl;", "Lcom/intellij/ide/actions/ActionsCollector;", "<init>", "()V", "myUpdateStats", "Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "Lcom/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl$ActionUpdateStatsKey;", "kotlin.jvm.PlatformType", "record", "", "actionId", "", "event", "Ljava/awt/event/InputEvent;", "context", "Ljava/lang/Class;", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "lang", "Lcom/intellij/lang/Language;", "onActionConfiguredByActionId", "recordUpdate", "durationMs", "", "ActionUpdateStatsKey", "Stats", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ActionsCollectorImpl
extends ActionsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Object2LongMap<ActionUpdateStatsKey> myUpdateStats = Object2LongMaps.synchronize((Object2LongMap)((Object2LongMap)new Object2LongOpenHashMap()));
    @NotNull
    public static final String DEFAULT_ID = "third.party";
    @NotNull
    private static final Map<AnActionEvent, Stats> ourStats = new WeakHashMap();

    public ActionsCollectorImpl() {
        ActionsEventLogGroup.ACTION_UPDATED.hashCode();
    }

    public void record(@Nullable String actionId, @Nullable InputEvent event, @NotNull Class<?> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Companion.recordCustomActionInvoked(null, actionId, event, context);
    }

    public void record(@Nullable Project project2, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable Language lang) {
        Companion.recordActionInvoked(project2, action2, event, arg_0 -> ActionsCollectorImpl.record$lambda$0(lang, arg_0));
    }

    public void onActionConfiguredByActionId(@NotNull AnAction action2, @NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        ActionsBuiltInAllowedlist.getInstance().registerDynamicActionId(action2, actionId);
    }

    public void recordUpdate(@NotNull AnAction action2, @NotNull AnActionEvent event, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (durationMs <= 5L) {
            return;
        }
        DataContext dataContext2 = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext dataContext3 = Utils.getCachedOnlyDataContext(dataContext2);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext3);
        ActionsEventLogGroup.ACTION_UPDATED.log(project2, arg_0 -> ActionsCollectorImpl.recordUpdate$lambda$0(action2, project2, dataContext3, this, durationMs, arg_0));
    }

    private static final Unit record$lambda$0(Language $lang, List eventPairs) {
        Intrinsics.checkNotNullParameter((Object)eventPairs, (String)"eventPairs");
        eventPairs.add(EventFields.CurrentFile.with((Object)$lang));
        return Unit.INSTANCE;
    }

    private static final Unit recordUpdate$lambda$0(AnAction $action, Project $project, DataContext $dataContext, ActionsCollectorImpl this$0, long $durationMs, EventDataCollector $this$log) {
        Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo($action.getClass());
        String actionId = Companion.addActionClass((List)$this$log, $action, info);
        Language language = DataContextUtils.INSTANCE.getInjectedOrFileLanguage($project, $dataContext);
        if (language == null) {
            language = Language.ANY;
        }
        Language language2 = language;
        Intrinsics.checkNotNull((Object)language2);
        String string = language2.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        ActionUpdateStatsKey statsKey = new ActionUpdateStatsKey(actionId, string);
        long reportedData = this$0.myUpdateStats.getLong((Object)statsKey);
        if (reportedData == 0L || $durationMs >= (long)2 * reportedData) {
            this$0.myUpdateStats.put((Object)statsKey, $durationMs);
            $this$log.add((Object)EventFields.PluginInfo.with((Object)info));
            $this$log.add((Object)EventFields.Language.with((Object)language));
            $this$log.add((Object)EventFields.DurationMs.with((Object)$durationMs));
        } else {
            $this$log.skip();
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final void recordCustomActionInvoked(@Nullable Project project2, @Nullable String actionId, @Nullable InputEvent event, @NotNull Class<?> context) {
        Companion.recordCustomActionInvoked(project2, actionId, event, context);
    }

    @JvmStatic
    public static final void recordActionInvoked(@NotNull Project project2, @NotNull Function1<? super List<EventPair<?>>, Unit> dataBuilder) {
        Companion.recordActionInvoked(project2, dataBuilder);
    }

    @JvmStatic
    public static final void recordActionInvoked(@Nullable Project project2, @Nullable AnAction action2, @Nullable AnActionEvent event, @NotNull Function1<? super List<EventPair<?>>, Unit> customDataProvider) {
        Companion.recordActionInvoked(project2, action2, event, customDataProvider);
    }

    @JvmStatic
    public static final void recordActionGroupExpanded(@NotNull ActionGroup action2, @NotNull DataContext context, @NotNull String place, boolean submenu, long durationMs, @Nullable List<? extends AnAction> result2) {
        Companion.recordActionGroupExpanded(action2, context, place, submenu, durationMs, result2);
    }

    @JvmStatic
    public static final void record(@NotNull VarargEventId eventId, @Nullable Project project2, @NotNull Function1<? super List<EventPair<?>>, Unit> dataBuilder) {
        Companion.record(eventId, project2, dataBuilder);
    }

    @JvmStatic
    public static final void record(@NotNull VarargEventId eventId, @Nullable Project project2, @Nullable AnAction action2, @Nullable AnActionEvent event, @NotNull Function1<? super List<EventPair<?>>, Unit> customDataProvider) {
        Companion.record(eventId, project2, action2, event, customDataProvider);
    }

    @JvmStatic
    @NotNull
    public static final List<EventPair<?>> actionEventData(@NotNull AnActionEvent event) {
        return Companion.actionEventData(event);
    }

    @JvmStatic
    @NotNull
    public static final String addActionClass(@NotNull List<EventPair<?>> data2, @NotNull AnAction action2, @NotNull PluginInfo info) {
        return Companion.addActionClass(data2, action2, info);
    }

    @JvmStatic
    public static final boolean canReportActionId(@NotNull String actionId) {
        return Companion.canReportActionId(actionId);
    }

    @JvmStatic
    public static final void onBeforeActionInvoked(@NotNull AnAction action2, @NotNull AnActionEvent event) {
        Companion.onBeforeActionInvoked(action2, event);
    }

    @JvmStatic
    public static final void onAfterActionInvoked(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
        Companion.onAfterActionInvoked(action2, event, result2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl$ActionUpdateStatsKey;", "", "actionId", "", "language", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getActionId", "()Ljava/lang/String;", "getLanguage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    private static final class ActionUpdateStatsKey {
        @NotNull
        private final String actionId;
        @NotNull
        private final String language;

        public ActionUpdateStatsKey(@NotNull String actionId, @NotNull String language) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            this.actionId = actionId;
            this.language = language;
        }

        @NotNull
        public final String getActionId() {
            return this.actionId;
        }

        @NotNull
        public final String getLanguage() {
            return this.language;
        }

        @NotNull
        public final String component1() {
            return this.actionId;
        }

        @NotNull
        public final String component2() {
            return this.language;
        }

        @NotNull
        public final ActionUpdateStatsKey copy(@NotNull String actionId, @NotNull String language) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return new ActionUpdateStatsKey(actionId, language);
        }

        public static /* synthetic */ ActionUpdateStatsKey copy$default(ActionUpdateStatsKey actionUpdateStatsKey, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = actionUpdateStatsKey.actionId;
            }
            if ((n & 2) != 0) {
                string2 = actionUpdateStatsKey.language;
            }
            return actionUpdateStatsKey.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ActionUpdateStatsKey(actionId=" + this.actionId + ", language=" + this.language + ")";
        }

        public int hashCode() {
            int result2 = this.actionId.hashCode();
            result2 = result2 * 31 + this.language.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActionUpdateStatsKey)) {
                return false;
            }
            ActionUpdateStatsKey actionUpdateStatsKey = (ActionUpdateStatsKey)other;
            if (!Intrinsics.areEqual((Object)this.actionId, (Object)actionUpdateStatsKey.actionId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.language, (Object)actionUpdateStatsKey.language);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0007J3\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2!\u0010\u0014\u001a\u001d\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\u0012\u0004\u0012\u00020\u000b0\u0015\u00a2\u0006\u0002\b\u0018H\u0007JD\u0010\u0013\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u001c\u0010\u001b\u001a\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\u0012\u0004\u0012\u00020\u000b0\u0015H\u0007J@\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010%H\u0007J=\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(2\b\u0010\f\u001a\u0004\u0018\u00010\r2!\u0010\u0014\u001a\u001d\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\u0012\u0004\u0012\u00020\u000b0\u0015\u00a2\u0006\u0002\b\u0018H\u0007JL\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u001c\u0010\u001b\u001a\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\u0012\u0004\u0012\u00020\u000b0\u0015H\u0007J\u001c\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170%2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170%2\u0006\u0010\u000f\u001a\u00020\bH\u0007J*\u0010+\u001a\u00020\u00052\u0010\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.H\u0007J\u0018\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020.2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010/\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u00101\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u001f\u00102\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00052\b\u00103\u001a\u0004\u0018\u000104H\u0000\u00a2\u0006\u0002\b5J\u001e\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u0002082\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050:J\u0018\u0010;\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\bH\u0007J \u0010<\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010$\u001a\u00020=H\u0007J\u0010\u0010>\u001a\u00020?2\u0006\u0010$\u001a\u00020=H\u0002JJ\u0010@\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\b2\b\u0010A\u001a\u0004\u0018\u00010B2\b\u0010C\u001a\u0004\u0018\u00010B2\b\u0010D\u001a\u0004\u0018\u00010E2\u0010\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl$Companion;", "", "<init>", "()V", "DEFAULT_ID", "", "ourStats", "", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Lcom/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl$Stats;", "recordCustomActionInvoked", "", "project", "Lcom/intellij/openapi/project/Project;", "actionId", "event", "Ljava/awt/event/InputEvent;", "context", "Ljava/lang/Class;", "recordActionInvoked", "dataBuilder", "Lkotlin/Function1;", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "Lkotlin/ExtensionFunctionType;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "customDataProvider", "recordActionGroupExpanded", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/actionSystem/DataContext;", "place", "submenu", "", "durationMs", "", "result", "", "record", "eventId", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "projectData", "actionEventData", "addActionClass", "data", "info", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "getActionId", "pluginInfo", "canReportActionId", "onActionLoadedFromXml", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "onActionLoadedFromXml$intellij_platform_ide_impl", "onActionsLoadedFromKeymapXml", "keymap", "Lcom/intellij/openapi/keymap/Keymap;", "actionIds", "", "onBeforeActionInvoked", "onAfterActionInvoked", "Lcom/intellij/openapi/actionSystem/AnActionResult;", "toReportedResult", "Lcom/intellij/internal/statistic/eventLog/events/ObjectEventData;", "addLanguageContextFields", "contextBefore", "Lcom/intellij/lang/Language;", "injectedContextBefore", "fileTypeBefore", "Lcom/intellij/openapi/fileTypes/FileType;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nActionsCollectorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionsCollectorImpl.kt\ncom/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,358:1\n1#2:359\n30#3,2:360\n1834#4,4:362\n*S KotlinDebug\n*F\n+ 1 ActionsCollectorImpl.kt\ncom/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl$Companion\n*L\n217#1:360,2\n153#1:362,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        public final void recordCustomActionInvoked(@Nullable Project project, @Nullable String actionId, @Nullable InputEvent event, @NotNull Class<?> context) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            if (!StringUtil.isNotEmpty((String)actionId)) ** GOTO lbl-1000
            v0 = ActionsBuiltInAllowedlist.getInstance();
            v1 = actionId;
            Intrinsics.checkNotNull((Object)v1);
            if (v0.isCustomAllowedAction(v1)) {
                v2 = actionId;
            } else lbl-1000:
            // 2 sources

            {
                v2 = "third.party";
            }
            recorded = v2;
            ActionsEventLogGroup.CUSTOM_ACTION_INVOKED.log(project, (Object)recorded, (Object)new FusInputEvent(event, null));
        }

        @JvmStatic
        public final void recordActionInvoked(@NotNull Project project2, @NotNull Function1<? super List<EventPair<?>>, Unit> dataBuilder) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(dataBuilder, (String)"dataBuilder");
            this.record(ActionsEventLogGroup.ACTION_FINISHED, project2, dataBuilder);
        }

        @JvmStatic
        public final void recordActionInvoked(@Nullable Project project2, @Nullable AnAction action2, @Nullable AnActionEvent event, @NotNull Function1<? super List<EventPair<?>>, Unit> customDataProvider) {
            Intrinsics.checkNotNullParameter(customDataProvider, (String)"customDataProvider");
            this.record(ActionsEventLogGroup.ACTION_FINISHED, project2, action2, event, customDataProvider);
        }

        @JvmStatic
        public final void recordActionGroupExpanded(@NotNull ActionGroup action2, @NotNull DataContext context, @NotNull String place, boolean submenu, long durationMs, @Nullable List<? extends AnAction> result2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            DataContext dataContext2 = Utils.getCachedOnlyDataContext(context);
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
            ActionsEventLogGroup.ACTION_GROUP_EXPANDED.log(project2, arg_0 -> Companion.recordActionGroupExpanded$lambda$0(action2, result2, project2, dataContext2, place, submenu, durationMs, arg_0));
        }

        @JvmStatic
        public final void record(@NotNull VarargEventId eventId, @Nullable Project project2, @NotNull Function1<? super List<EventPair<?>>, Unit> dataBuilder) {
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            Intrinsics.checkNotNullParameter(dataBuilder, (String)"dataBuilder");
            List<EventPair<?>> projectPairs = this.projectData(project2);
            eventId.log(project2, arg_0 -> Companion.record$lambda$0(projectPairs, dataBuilder, arg_0));
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @JvmStatic
        public final void record(@NotNull VarargEventId eventId, @Nullable Project project, @Nullable AnAction action, @Nullable AnActionEvent event, @NotNull Function1<? super List<EventPair<?>>, Unit> customDataProvider) {
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            Intrinsics.checkNotNullParameter(customDataProvider, (String)"customDataProvider");
            if (action == null) {
                return;
            }
            if (project == null) ** GOTO lbl-1000
            it = var8_6 = project;
            $i$a$-takeIf-ActionsCollectorImpl$Companion$record$isLookupActive$1 = false;
            v0 /* !! */  = var7_9 = project.isDisposed() == false != false ? var8_6 : null;
            if (var7_9 == null || (var8_6 = (LookupManager)var7_9.getServiceIfCreated(LookupManager.class)) == null) ** GOTO lbl-1000
            it = var8_6;
            $i$a$-let-ActionsCollectorImpl$Companion$record$isLookupActive$2 = false;
            v1 = event;
            var9_7 = v1 != null && (v1 = v1.getDataContext()) != null ? (Editor)v1.getData(CommonDataKeys.HOST_EDITOR) : null;
            if (var9_7 != null) {
                it = var9_7;
                $i$a$-let-ActionsCollectorImpl$Companion$record$isLookupActive$3 = false;
                v2 = LookupManager.getActiveLookup((Editor)it);
            } else lbl-1000:
            // 3 sources

            {
                v2 = null;
            }
            isLookupActive = v2 != null;
            v3 = event;
            toolWindowId = v3 != null && (v3 = v3.getDataContext()) != null && (v3 = (ToolWindow)v3.getData(PlatformDataKeys.TOOL_WINDOW)) != null ? v3.getId() : null;
            projectPairs = this.projectData(project);
            eventId.log(project, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, record$lambda$4(com.intellij.openapi.actionSystem.AnAction com.intellij.openapi.actionSystem.AnActionEvent java.util.List com.intellij.internal.statistic.eventLog.events.VarargEventId boolean java.lang.String kotlin.jvm.functions.Function1 com.intellij.internal.statistic.eventLog.events.EventDataCollector ), (Lcom/intellij/internal/statistic/eventLog/events/EventDataCollector;)Lkotlin/Unit;)((AnAction)action, (AnActionEvent)event, projectPairs, (VarargEventId)eventId, (boolean)isLookupActive, (String)toolWindowId, customDataProvider));
            if (Intrinsics.areEqual((Object)eventId, (Object)ActionsEventLogGroup.ACTION_FINISHED)) {
                FeatureUsageTracker.getInstance().triggerFeatureUsedByAction(this.getActionId(action));
            }
        }

        private final List<EventPair<?>> projectData(Project project2) {
            if (project2 == null || project2.isDisposed()) {
                return CollectionsKt.emptyList();
            }
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ProjectStateObserver> serviceClass$iv = ProjectStateObserver.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ProjectState state2 = ((ProjectStateObserver)object).getState();
            Object[] objectArray = new EventPair[]{EventFields.Dumb.with((Object)state2.isDumb()), ActionsEventLogGroup.INCOMPLETE_DEPENDENCIES_MODE.with((Object)state2.getDependenciesState())};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @JvmStatic
        @NotNull
        public final List<EventPair<?>> actionEventData(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            List data2 = new ArrayList();
            data2.add(EventFields.InputEvent.with((Object)FusInputEvent.Companion.from(event)));
            String string = event.getPlace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
            String place = string;
            data2.add(EventFields.ActionPlace.with((Object)place));
            data2.add(ActionsEventLogGroup.CONTEXT_MENU.with((Object)event.isFromContextMenu()));
            return data2;
        }

        @JvmStatic
        @NotNull
        public final String addActionClass(@NotNull List<EventPair<?>> data2, @NotNull AnAction action2, @NotNull PluginInfo info) {
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Class<?> actionClass = action2.getClass();
            String actionId = this.getActionId(info, action2);
            if (action2 instanceof ActionWithDelegate) {
                String string;
                Object delegate = ActionUtil.getDelegateChainRoot((AnAction)action2);
                PluginInfo delegateInfo = PluginInfoDetectorKt.getPluginInfo(delegate.getClass());
                if (delegate instanceof AnAction) {
                    string = this.getActionId(delegateInfo, (AnAction)delegate);
                } else if (delegateInfo.isSafeToReport()) {
                    String string2 = delegate.getClass().getName();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                } else {
                    string = ActionsCollectorImpl.DEFAULT_ID;
                }
                actionId = string;
                data2.add(ActionsEventLogGroup.ACTION_CLASS.with(delegate.getClass()));
                v2 = data2.add(ActionsEventLogGroup.ACTION_PARENT.with(actionClass));
            } else {
                v2 = data2.add(ActionsEventLogGroup.ACTION_CLASS.with(actionClass));
            }
            data2.add(ActionsEventLogGroup.ACTION_ID.with((Object)actionId));
            return actionId;
        }

        private final String getActionId(PluginInfo pluginInfo, AnAction action2) {
            if (!pluginInfo.isSafeToReport()) {
                return ActionsCollectorImpl.DEFAULT_ID;
            }
            return this.getActionId(action2);
        }

        private final String getActionId(AnAction action2) {
            String string;
            String actionId = ActionManager.getInstance().getId(action2);
            if (actionId == null && action2 instanceof ActionIdProvider) {
                actionId = ((ActionIdProvider)action2).getId();
            }
            if (actionId != null && !this.canReportActionId(actionId)) {
                String string2 = action2.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                return string2;
            }
            if (actionId == null) {
                actionId = ActionsBuiltInAllowedlist.getInstance().getDynamicActionId(action2);
            }
            if ((string = actionId) == null) {
                String string3 = action2.getClass().getName();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            }
            return string;
        }

        @JvmStatic
        public final boolean canReportActionId(@NotNull String actionId) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            return ActionsBuiltInAllowedlist.getInstance().isAllowedActionId(actionId);
        }

        public final void onActionLoadedFromXml$intellij_platform_ide_impl(@NotNull String actionId, @Nullable IdeaPluginDescriptor plugin) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            ActionsBuiltInAllowedlist.getInstance().addActionLoadedFromXml(actionId, plugin);
        }

        public final void onActionsLoadedFromKeymapXml(@NotNull Keymap keymap2, @NotNull Set<String> actionIds) {
            Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
            Intrinsics.checkNotNullParameter(actionIds, (String)"actionIds");
            ActionsBuiltInAllowedlist.getInstance().addActionsLoadedFromKeymapXml(keymap2, actionIds);
        }

        @JvmStatic
        public final void onBeforeActionInvoked(@NotNull AnAction action2, @NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Project project2 = event.getProject();
            DataContext dataContext2 = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            DataContext context = Utils.getCachedOnlyDataContext(dataContext2);
            Stats stats = new Stats(project2, DataContextUtils.getFileLanguage(context), DataContextUtils.INSTANCE.getInjectedOrFileLanguage(project2, context), DataContextUtils.getFileType(context));
            ourStats.put(event, stats);
        }

        @JvmStatic
        public final void onAfterActionInvoked(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Stats stats = (Stats)ourStats.remove(event);
            Object object = stats;
            Project project2 = object != null && (object = ((Stats)object).getProjectRef()) != null ? (Project)((Reference)object).get() : null;
            this.recordActionInvoked(project2, action2, event, arg_0 -> Companion.onAfterActionInvoked$lambda$0(stats, result2, project2, event, action2, arg_0));
        }

        private final ObjectEventData toReportedResult(AnActionResult result2) {
            ObjectEventData objectEventData;
            AnActionResult anActionResult = result2;
            if (anActionResult instanceof AnActionResult.Performed) {
                EventPair[] eventPairArray = new EventPair[]{ActionsEventLogGroup.RESULT_TYPE.with((Object)"performed")};
                ObjectEventData objectEventData2 = new ObjectEventData(eventPairArray);
                objectEventData = objectEventData2;
            } else if (anActionResult instanceof AnActionResult.Ignored) {
                EventPair[] eventPairArray = new EventPair[]{ActionsEventLogGroup.RESULT_TYPE.with((Object)"ignored")};
                ObjectEventData objectEventData3 = new ObjectEventData(eventPairArray);
                objectEventData = objectEventData3;
            } else if (anActionResult instanceof AnActionResult.Failed) {
                EventPair[] eventPairArray = new EventPair[]{ActionsEventLogGroup.RESULT_TYPE.with((Object)"failed"), ActionsEventLogGroup.ERROR.with(((AnActionResult.Failed)result2).getCause().getClass())};
                ObjectEventData objectEventData4 = new ObjectEventData(eventPairArray);
                objectEventData = objectEventData4;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return objectEventData;
        }

        private final void addLanguageContextFields(Project project2, AnActionEvent event, Language contextBefore, Language injectedContextBefore, FileType fileTypeBefore, List<EventPair<?>> data2) {
            DataContext dataContext2 = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            DataContext dataContext3 = Utils.getCachedOnlyDataContext(dataContext2);
            Language language = DataContextUtils.getFileLanguage(dataContext3);
            Language language2 = language;
            if (language2 == null) {
                language2 = contextBefore;
            }
            data2.add(EventFields.CurrentFile.with((Object)language2));
            Language injectedLanguage = DataContextUtils.INSTANCE.getInjectedOrFileLanguage(project2, dataContext3);
            Language language3 = injectedLanguage;
            if (language3 == null) {
                language3 = injectedContextBefore;
            }
            data2.add(EventFields.Language.with((Object)language3));
            FileType fileType2 = DataContextUtils.getFileType(dataContext3);
            FileType fileType3 = fileType2;
            if (fileType3 == null) {
                fileType3 = fileTypeBefore;
            }
            data2.add(EventFields.FileType.with((Object)fileType3));
        }

        private static final Unit recordActionGroupExpanded$lambda$0(ActionGroup $action, List $result, Project $project, DataContext $dataContext, String $place, boolean $submenu, long $durationMs, EventDataCollector $this$log) {
            Language language;
            int size2;
            Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo($action.getClass());
            List list2 = $result;
            if (list2 != null) {
                Iterable $this$count$iv = list2;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v1 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        AnAction it = (AnAction)element$iv;
                        boolean bl = false;
                        if (!(!(it instanceof Separator)) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v1 = count$iv;
                }
            } else {
                v1 = size2 = -1;
            }
            if ((language = DataContextUtils.INSTANCE.getInjectedOrFileLanguage($project, $dataContext)) == null) {
                language = Language.ANY;
            }
            Language language2 = language;
            Companion.addActionClass((List)$this$log, (AnAction)$action, info);
            $this$log.add((Object)EventFields.PluginInfo.with((Object)info));
            $this$log.add((Object)EventFields.Language.with((Object)language2));
            $this$log.add((Object)EventFields.ActionPlace.with((Object)$place));
            $this$log.add((Object)ActionsEventLogGroup.IS_SUBMENU.with((Object)$submenu));
            $this$log.add((Object)EventFields.DurationMs.with((Object)$durationMs));
            $this$log.add((Object)EventFields.Size.with((Object)size2));
            return Unit.INSTANCE;
        }

        private static final Unit record$lambda$0(List $projectPairs, Function1 $dataBuilder, EventDataCollector $this$log) {
            Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
            $this$log.addAll((Collection)$projectPairs);
            $dataBuilder.invoke((Object)$this$log);
            return Unit.INSTANCE;
        }

        private static final Unit record$lambda$4(AnAction $action, AnActionEvent $event, List $projectPairs, VarargEventId $eventId, boolean $isLookupActive, String $toolWindowId, Function1 $customDataProvider, EventDataCollector $this$log) {
            Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo($action.getClass());
            $this$log.add((Object)EventFields.PluginInfoFromInstance.with((Object)$action));
            if ($event != null) {
                if ($action instanceof ToggleAction) {
                    $this$log.add((Object)ActionsEventLogGroup.TOGGLE_ACTION.with((Object)Toggleable.isSelected((Presentation)$event.getPresentation())));
                }
                $this$log.addAll((Collection)Companion.actionEventData($event));
                $this$log.addAll((Collection)$projectPairs);
                if (Intrinsics.areEqual((Object)$eventId, (Object)ActionsEventLogGroup.ACTION_FINISHED)) {
                    $this$log.add((Object)ActionsEventLogGroup.LOOKUP_ACTIVE.with((Object)$isLookupActive));
                    $this$log.add((Object)ToolwindowFusEventFields.TOOLWINDOW.with((Object)$toolWindowId));
                }
            }
            $customDataProvider.invoke((Object)$this$log);
            Companion.addActionClass((List)$this$log, $action, info);
            return Unit.INSTANCE;
        }

        private static final Unit onAfterActionInvoked$lambda$0(Stats $stats, AnActionResult $result, Project $project, AnActionEvent $event, AnAction $action, List eventPairs) {
            long durationMillis;
            Intrinsics.checkNotNullParameter((Object)eventPairs, (String)"eventPairs");
            Stats stats = $stats;
            long l = durationMillis = stats != null ? TimeoutUtil.getDurationMillis((long)stats.getStart()) : -1L;
            if ($stats != null) {
                eventPairs.add(EventFields.StartTime.with((Object)$stats.getStartMs()));
                if ($stats.isDumb() != null) {
                    eventPairs.add(ActionsEventLogGroup.DUMB_START.with((Object)$stats.isDumb()));
                }
            }
            ObjectEventData reportedResult = Companion.toReportedResult($result);
            eventPairs.add(ActionsEventLogGroup.RESULT.with((Object)reportedResult));
            Stats stats2 = $stats;
            Language contextBefore = stats2 != null ? stats2.getFileLanguage() : null;
            Stats stats3 = $stats;
            Language injectedContextBefore = stats3 != null ? stats3.getInjectedFileLanguage() : null;
            Stats stats4 = $stats;
            FileType fileTypeBefore = stats4 != null ? stats4.getFileType() : null;
            Companion.addLanguageContextFields($project, $event, contextBefore, injectedContextBefore, fileTypeBefore, eventPairs);
            if ($action instanceof FusAwareAction) {
                List<EventPair<?>> list2 = ((FusAwareAction)$action).getAdditionalUsageData($event);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getAdditionalUsageData(...)");
                List<EventPair<?>> additionalUsageData = list2;
                eventPairs.add(ActionsEventLogGroup.ADDITIONAL.with((Object)new ObjectEventData(additionalUsageData)));
            }
            eventPairs.add(EventFields.DurationMs.with((Object)StatisticsUtil.INSTANCE.roundDuration(durationMillis)));
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\f\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\"\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0015\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\n\n\u0002\u0010#\u001a\u0004\b \u0010\"\u00a8\u0006$"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl$Stats;", "", "project", "Lcom/intellij/openapi/project/Project;", "fileLanguage", "Lcom/intellij/lang/Language;", "injectedFileLanguage", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/Language;Lcom/intellij/lang/Language;Lcom/intellij/openapi/fileTypes/FileType;)V", "getFileLanguage", "()Lcom/intellij/lang/Language;", "getInjectedFileLanguage", "setInjectedFileLanguage", "(Lcom/intellij/lang/Language;)V", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "setFileType", "(Lcom/intellij/openapi/fileTypes/FileType;)V", "startMs", "", "getStartMs", "()J", "start", "getStart", "projectRef", "Ljava/lang/ref/WeakReference;", "getProjectRef", "()Ljava/lang/ref/WeakReference;", "setProjectRef", "(Ljava/lang/ref/WeakReference;)V", "isDumb", "", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "intellij.platform.ide.impl"})
    private static final class Stats {
        @Nullable
        private final Language fileLanguage;
        @Nullable
        private Language injectedFileLanguage;
        @Nullable
        private FileType fileType;
        private final long startMs;
        private final long start;
        @NotNull
        private WeakReference<Project> projectRef;
        @Nullable
        private final Boolean isDumb;

        public Stats(@Nullable Project project2, @Nullable Language fileLanguage, @Nullable Language injectedFileLanguage, @Nullable FileType fileType2) {
            this.fileLanguage = fileLanguage;
            this.injectedFileLanguage = injectedFileLanguage;
            this.fileType = fileType2;
            this.startMs = System.currentTimeMillis();
            this.start = System.nanoTime();
            this.projectRef = new WeakReference<Project>(project2);
            this.isDumb = project2 != null && !project2.isDisposed() ? Boolean.valueOf(DumbService.Companion.isDumb(project2)) : null;
        }

        @Nullable
        public final Language getFileLanguage() {
            return this.fileLanguage;
        }

        @Nullable
        public final Language getInjectedFileLanguage() {
            return this.injectedFileLanguage;
        }

        public final void setInjectedFileLanguage(@Nullable Language language) {
            this.injectedFileLanguage = language;
        }

        @Nullable
        public final FileType getFileType() {
            return this.fileType;
        }

        public final void setFileType(@Nullable FileType fileType2) {
            this.fileType = fileType2;
        }

        public final long getStartMs() {
            return this.startMs;
        }

        public final long getStart() {
            return this.start;
        }

        @NotNull
        public final WeakReference<Project> getProjectRef() {
            return this.projectRef;
        }

        public final void setProjectRef(@NotNull WeakReference<Project> weakReference) {
            Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
            this.projectRef = weakReference;
        }

        @Nullable
        public final Boolean isDumb() {
            return this.isDumb;
        }
    }
}

