/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.ApplicationNotificationsModel;
import com.intellij.notification.impl.ProjectNotificationsModelListener;
import com.intellij.notification.impl.ui.AutoProportionController;
import com.intellij.notification.impl.ui.MySplitter;
import com.intellij.notification.impl.ui.NotificationComponent;
import com.intellij.notification.impl.ui.NotificationGroupComponent;
import com.intellij.notification.impl.ui.NotificationsPanel;
import com.intellij.notification.impl.ui.SearchController;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SingleTextSelectionHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#J\b\u0010%\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0010H\u0016J\u0016\u0010&\u001a\u00020#2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100)H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020#H\u0016J\u0010\u0010.\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0010H\u0016J\b\u0010/\u001a\u00020#H\u0016J\b\u00100\u001a\u00020#H\u0016J\b\u00101\u001a\u00020#H\u0016J\u0006\u00102\u001a\u00020#J\b\u00103\u001a\u00020#H\u0016J\u0006\u00104\u001a\u00020#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/notification/impl/ui/NotificationsPanel;", "Lcom/intellij/notification/impl/ProjectNotificationsModelListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "mainPanel", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "myNotifications", "Ljava/util/ArrayList;", "Lcom/intellij/notification/Notification;", "suggestions", "Lcom/intellij/notification/impl/ui/NotificationGroupComponent;", "timeline", "searchController", "Lcom/intellij/notification/impl/ui/SearchController;", "autoProportionController", "Lcom/intellij/notification/impl/ui/AutoProportionController;", "singleSelectionHandler", "Lcom/intellij/util/ui/SingleTextSelectionHandler;", "searchUpdateAlarm", "Lcom/intellij/util/SingleEdtTaskScheduler;", "splitterWrapper", "Ljavax/swing/JPanel;", "createSearchComponent", "Lcom/intellij/ui/SearchTextField;", "createActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "setEmptyState", "", "clearEmptyState", "handleFocus", "add", "notification", "notifications", "", "getNotifications", "isEmpty", "", "clearUnreadStates", "remove", "expireAll", "clearTimeline", "clearAll", "updateComponents", "dispose", "fullRepaint", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNotificationsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationsPanel.kt\ncom/intellij/notification/impl/ui/NotificationsPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1514:1\n1915#2,2:1515\n777#2:1517\n873#2,2:1518\n1915#2,2:1520\n*S KotlinDebug\n*F\n+ 1 NotificationsPanel.kt\ncom/intellij/notification/impl/ui/NotificationsPanel\n*L\n246#1:1515,2\n110#1:1517\n110#1:1518,2\n110#1:1520,2\n*E\n"})
public final class NotificationsPanel
implements ProjectNotificationsModelListener,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final JBPanelWithEmptyText mainPanel;
    @NotNull
    private final ArrayList<Notification> myNotifications;
    @NotNull
    private final NotificationGroupComponent suggestions;
    @NotNull
    private final NotificationGroupComponent timeline;
    @NotNull
    private final SearchController searchController;
    @NotNull
    private final AutoProportionController autoProportionController;
    @NotNull
    private final SingleTextSelectionHandler singleSelectionHandler;
    @NotNull
    private final SingleEdtTaskScheduler searchUpdateAlarm;
    @NotNull
    private final JPanel splitterWrapper;

    public NotificationsPanel(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project2;
        this.mainPanel = new JBPanelWithEmptyText((LayoutManager)new BorderLayout());
        this.myNotifications = new ArrayList();
        this.singleSelectionHandler = new SingleTextSelectionHandler();
        this.searchUpdateAlarm = SingleEdtTaskScheduler.Companion.createSingleEdtTaskScheduler$default((SingleEdtTaskScheduler.Companion)SingleEdtTaskScheduler.Companion, null, (int)1, null);
        this.mainPanel.setBackground(NotificationComponent.Companion.getBG_COLOR());
        this.setEmptyState();
        this.handleFocus();
        this.suggestions = new NotificationGroupComponent(this, true, this.project);
        this.timeline = new NotificationGroupComponent(this, false, this.project);
        this.searchController = new SearchController(this, this.suggestions, this.timeline);
        this.mainPanel.add((Component)this.createSearchComponent(), (Object)"North");
        final MySplitter splitter2 = new MySplitter();
        splitter2.setFirstComponent((JComponent)((Object)this.suggestions));
        splitter2.setSecondComponent((JComponent)((Object)this.timeline));
        this.splitterWrapper = (JPanel)new NonOpaquePanel(){

            public boolean isVisible() {
                return super.isVisible() && splitter2.isVisible();
            }
        };
        this.mainPanel.add((Component)this.splitterWrapper);
        this.autoProportionController = new AutoProportionController(splitter2, this.suggestions, this.timeline);
        this.suggestions.setRemoveCallback(ApplicationNotificationsModel::remove);
        this.timeline.setRemoveCallback(ApplicationNotificationsModel::remove);
        this.timeline.setClearCallback((Function0<Unit>)((Function0)() -> NotificationsPanel._init_$lambda$0(this)));
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> NotificationsPanel._init_$lambda$1(this, arg_0));
        Topic topic2 = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, arg_0 -> NotificationsPanel._init_$lambda$2(this, arg_0));
    }

    @NotNull
    public final JComponent getComponent() {
        return (JComponent)this.mainPanel;
    }

    private final SearchTextField createSearchComponent() {
        SearchTextField searchField2 = new SearchTextField(this){
            final /* synthetic */ NotificationsPanel this$0;
            {
                this.this$0 = $receiver;
                super(false);
            }

            public Dimension getPreferredSize() {
                Dimension size2 = super.getPreferredSize();
                size2.height = JBUIScale.scale((int)35);
                Intrinsics.checkNotNull((Object)size2);
                return size2;
            }

            public void updateUI() {
                block0: {
                    super.updateUI();
                    JBTextField jBTextField = this.getTextEditor();
                    if (jBTextField == null) break block0;
                    jBTextField.setBorder(null);
                }
            }

            protected boolean preprocessEventForTextField(KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getKeyCode() == 27 && event.getID() == 401) {
                    this.setVisible(false);
                    NotificationsPanel.access$getSearchController$p(this.this$0).cancelSearch();
                    NotificationsPanel.access$getSplitterWrapper$p(this.this$0).setBorder(null);
                    return true;
                }
                return super.preprocessEventForTextField(event);
            }
        };
        searchField2.getTextEditor().setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)3));
        searchField2.setBorder(JBUI.Borders.customLineBottom((Color)JBColor.border()));
        searchField2.setVisible(false);
        if (ExperimentalUI.Companion.isNewUI()) {
            Color color = JBUI.CurrentTheme.ToolWindow.background();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background(...)");
            this.searchController.setBackground(color);
            searchField2.getTextEditor().setBackground(this.searchController.getBackground());
        } else {
            Color color = UIUtil.getTextFieldBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getTextFieldBackground(...)");
            this.searchController.setBackground(color);
        }
        this.searchController.setSearchField(searchField2);
        searchField2.addDocumentListener((DocumentListener)new DocumentAdapter(this, searchField2){
            final /* synthetic */ NotificationsPanel this$0;
            final /* synthetic */ createSearchComponent.searchField.1 $searchField;
            {
                this.this$0 = $receiver;
                this.$searchField = $searchField;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SingleEdtTaskScheduler singleEdtTaskScheduler = NotificationsPanel.access$getSearchUpdateAlarm$p(this.this$0);
                ModalityState modalityState = ModalityState.stateForComponent((Component)((Component)((Object)this.$searchField)));
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
                singleEdtTaskScheduler.cancelAndRequest(100L, modalityState, NotificationsPanel.access$getSearchController$p(this.this$0)::doSearch);
            }
        });
        return searchField2;
    }

    @NotNull
    public final ActionGroup createActions() {
        AnAction markAction;
        DumbAwareAction gearAction2 = new DumbAwareAction(this){
            final /* synthetic */ NotificationsPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                NotificationsPanel.access$getSearchController$p(this.this$0).startSearch();
                NotificationsPanel.access$getSplitterWrapper$p(this.this$0).setBorder((Border)JBUI.Borders.emptyTop((int)4));
            }
        };
        ActionManager actionManager = ActionManager.getInstance();
        AnAction findAction = actionManager.getAction("Find");
        if (findAction == null) {
            gearAction2.getTemplatePresentation().setText(ActionsBundle.actionText((String)"Find"));
        } else {
            gearAction2.copyFrom(findAction);
            gearAction2.registerCustomShortcutSet(findAction.getShortcutSet(), (JComponent)this.mainPanel);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)gearAction2);
        group2.addSeparator();
        AnAction clearAction = actionManager.getAction("ClearAllNotifications");
        if (clearAction != null) {
            group2.add(clearAction);
        }
        if ((markAction = actionManager.getAction("MarkNotificationsAsRead")) != null) {
            group2.add(markAction);
        }
        return (ActionGroup)group2;
    }

    public final void setEmptyState() {
        this.mainPanel.getEmptyText().appendLine(IdeBundle.message((String)"notifications.toolwindow.empty.text.first.line", (Object[])new Object[0]));
        this.mainPanel.getEmptyText().appendLine(IdeBundle.message((String)"notifications.toolwindow.empty.text.second.line", (Object[])new Object[0]));
    }

    public final void clearEmptyState() {
        this.mainPanel.getEmptyText().clear();
    }

    private final void handleFocus() {
        AWTEventListener listener2 = arg_0 -> NotificationsPanel.handleFocus$lambda$0(this, arg_0);
        Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 16L);
        Disposer.register((Disposable)this, () -> NotificationsPanel.handleFocus$lambda$1(listener2));
    }

    @Override
    public void add(@NotNull Notification notification2) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        if (notification2.isSuggestionType()) {
            this.suggestions.add(notification2, this.singleSelectionHandler);
        } else {
            this.timeline.add(notification2, this.singleSelectionHandler);
        }
        this.myNotifications.add(notification2);
        this.searchController.update();
        this.autoProportionController.update();
    }

    @Override
    public void add(@NotNull List<? extends Notification> notifications) {
        Intrinsics.checkNotNullParameter(notifications, (String)"notifications");
        Iterable $this$forEach$iv = notifications;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Notification it = (Notification)element$iv;
            boolean bl = false;
            if (it.isSuggestionType()) {
                this.suggestions.add(it, this.singleSelectionHandler);
            } else {
                this.timeline.add(it, this.singleSelectionHandler);
            }
            this.myNotifications.add(it);
        }
        this.searchController.update();
        this.autoProportionController.update();
    }

    @NotNull
    public ArrayList<Notification> getNotifications() {
        return new ArrayList<Notification>((Collection)this.myNotifications);
    }

    @Override
    public boolean isEmpty() {
        return this.suggestions.isEmpty() && this.timeline.isEmpty();
    }

    @Override
    public void clearUnreadStates() {
        this.suggestions.clearNewState();
        this.timeline.clearNewState();
    }

    @Override
    public void remove(@NotNull Notification notification2) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        if (notification2.isSuggestionType()) {
            this.suggestions.remove(notification2);
        } else {
            this.timeline.remove(notification2);
        }
        this.myNotifications.remove(notification2);
        this.searchController.update();
        this.autoProportionController.update();
    }

    @Override
    public void expireAll() {
        ArrayList notifications = new ArrayList(this.myNotifications);
        this.suggestions.expireAll();
        this.timeline.expireAll();
        this.myNotifications.clear();
        this.searchController.update();
        Iterator iterator = notifications.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Notification n = (Notification)iterator2.next();
            n.expire();
        }
    }

    @Override
    public void clearTimeline() {
        Set notifications = CollectionsKt.toSet((Iterable)this.timeline.clear());
        this.myNotifications.removeAll(notifications);
        this.searchController.update();
        this.autoProportionController.update();
    }

    @Override
    public void clearAll() {
        this.suggestions.clear();
        this.timeline.clear();
        this.myNotifications.clear();
        this.searchController.update();
        this.autoProportionController.update();
    }

    public final void updateComponents() {
        this.suggestions.updateComponents();
        this.timeline.updateComponents();
    }

    public void dispose() {
        this.searchUpdateAlarm.cancel();
    }

    public final void fullRepaint() {
        this.mainPanel.doLayout();
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$0(NotificationsPanel this$0) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ApplicationNotificationsModel.getNotifications(this$0.project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Notification it = (Notification)element$iv$iv;
            boolean bl = false;
            if (!(!it.isSuggestionType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Notification it = (Notification)element$iv;
            boolean bl = false;
            it.expire();
        }
        ApplicationNotificationsModel.INSTANCE.clearTimeline(this$0.project);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(NotificationsPanel this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.suggestions.updateLaf();
        this$0.timeline.updateLaf();
    }

    private static final void _init_$lambda$2(NotificationsPanel this$0, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.suggestions.updateLaf();
        this$0.timeline.updateLaf();
    }

    private static final void handleFocus$lambda$0(NotificationsPanel this$0, AWTEvent it) {
        if (it instanceof MouseEvent && ((MouseEvent)it).getID() == 501 && !UIUtil.isFocusAncestor((Component)((Component)this$0.mainPanel)) && UIUtil.isAncestor((Component)((Component)this$0.mainPanel), (Component)((MouseEvent)it).getComponent())) {
            ((MouseEvent)it).getComponent().requestFocus();
        }
    }

    private static final void handleFocus$lambda$1(AWTEventListener $listener) {
        Toolkit.getDefaultToolkit().removeAWTEventListener($listener);
    }

    public static final /* synthetic */ SearchController access$getSearchController$p(NotificationsPanel $this) {
        return $this.searchController;
    }

    public static final /* synthetic */ JPanel access$getSplitterWrapper$p(NotificationsPanel $this) {
        return $this.splitterWrapper;
    }

    public static final /* synthetic */ SingleEdtTaskScheduler access$getSearchUpdateAlarm$p(NotificationsPanel $this) {
        return $this.searchUpdateAlarm;
    }
}

