/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl.islands;

import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.openapi.application.impl.islands.IslandsGradientPainterKt;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.wm.IdeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000e\u001a\u00020\bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/application/impl/islands/IslandsGradientPainter;", "Lcom/intellij/openapi/ui/AbstractPainter;", "frame", "Lcom/intellij/openapi/wm/IdeFrame;", "mainColor", "Ljava/awt/Color;", "enabled", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/wm/IdeFrame;Ljava/awt/Color;Lkotlin/jvm/functions/Function0;)V", "projectWindowCustomizer", "Lcom/intellij/ide/ProjectWindowCustomizerService;", "doPaint", "needsRepaint", "executePaint", "", "component", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics2D;", "intellij.platform.ide.impl"})
public final class IslandsGradientPainter
extends AbstractPainter {
    @NotNull
    private final IdeFrame frame;
    @NotNull
    private final Color mainColor;
    @NotNull
    private final Function0<Boolean> enabled;
    @NotNull
    private final ProjectWindowCustomizerService projectWindowCustomizer;
    private boolean doPaint;

    public IslandsGradientPainter(@NotNull IdeFrame frame, @NotNull Color mainColor, @NotNull Function0<Boolean> enabled2) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)mainColor, (String)"mainColor");
        Intrinsics.checkNotNullParameter(enabled2, (String)"enabled");
        this.frame = frame;
        this.mainColor = mainColor;
        this.enabled = enabled2;
        this.projectWindowCustomizer = ProjectWindowCustomizerService.Companion.getInstance();
        this.doPaint = true;
    }

    public boolean needsRepaint() {
        return (Boolean)this.enabled.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executePaint(@NotNull Component component2, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.doPaint) {
            try {
                this.doPaint = false;
                if (IslandsGradientPainterKt.isIslandsGradientColor(g.getPaint())) {
                    IslandsGradientPainterKt.islandsGradientPaint(this.frame, this.mainColor, this.projectWindowCustomizer, component2, g);
                }
            }
            finally {
                this.doPaint = true;
            }
        }
    }
}

