/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl.islands;

import com.intellij.ide.ProjectGradients;
import com.intellij.ide.ProjectWidgetGradientLocationService;
import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.ui.GradientTextureCache;
import com.intellij.openapi.application.impl.islands.GradientCache;
import com.intellij.openapi.application.impl.islands.IslandsInactiveFrameGraphics2D;
import com.intellij.openapi.application.impl.islands.IslandsUICustomizationKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomWindowHeaderUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Window;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a8\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0002\u001a(\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"islandsGradientColors", "", "", "isIslandsGradientColor", "", "paint", "Ljava/awt/Paint;", "islandsGradientPaint", "", "frame", "Lcom/intellij/openapi/wm/IdeFrame;", "mainColor", "Ljava/awt/Color;", "projectWindowCustomizer", "Lcom/intellij/ide/ProjectWindowCustomizerService;", "component", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics2D;", "doGradientPaint", "project", "Lcom/intellij/openapi/project/Project;", "getGradientCache", "Lcom/intellij/openapi/application/impl/islands/GradientCache;", "root", "Ljavax/swing/JComponent;", "key", "doColorGradientPaint", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIslandsGradientPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IslandsGradientPainter.kt\ncom/intellij/openapi/application/impl/islands/IslandsGradientPainterKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,223:1\n30#2,2:224\n*S KotlinDebug\n*F\n+ 1 IslandsGradientPainter.kt\ncom/intellij/openapi/application/impl/islands/IslandsGradientPainterKt\n*L\n88#1:224,2\n*E\n"})
public final class IslandsGradientPainterKt {
    @NotNull
    private static final Set<String> islandsGradientColors;

    public static final boolean isIslandsGradientColor(@Nullable Paint paint) {
        Object object = paint instanceof JBColor ? (JBColor)paint : null;
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        Object colorName = object;
        return islandsGradientColors.contains(colorName);
    }

    public static final void islandsGradientPaint(@NotNull IdeFrame frame, @NotNull Color mainColor, @NotNull ProjectWindowCustomizerService projectWindowCustomizer, @NotNull Component component2, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)mainColor, (String)"mainColor");
        Intrinsics.checkNotNullParameter((Object)projectWindowCustomizer, (String)"projectWindowCustomizer");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (CustomWindowHeaderUtil.INSTANCE.isCompactHeader$intellij_platform_ide_impl()) {
            return;
        }
        if (component2 instanceof IdeGlassPaneEx && !((IdeGlassPaneEx)((Object)component2)).isColorfulToolbar()) {
            return;
        }
        Project project2 = frame.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (Registry.Companion.is("idea.islands.color.gradient.enabled", false)) {
            IslandsGradientPainterKt.doColorGradientPaint(project3, projectWindowCustomizer, component2, g);
        } else {
            IslandsGradientPainterKt.doGradientPaint(frame, mainColor, project3, projectWindowCustomizer, component2, g);
        }
    }

    private static final void doGradientPaint(IdeFrame frame, Color mainColor, Project project2, ProjectWindowCustomizerService projectWindowCustomizer, Component component2, Graphics2D g) {
        block9: {
            Rectangle rightBounds;
            Rectangle bounds;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ProjectWidgetGradientLocationService> serviceClass$iv = ProjectWidgetGradientLocationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            float centerX = ((ProjectWidgetGradientLocationService)object).getGradientOffsetRelativeToRootPane();
            ScaleContext ctx = ScaleContext.Companion.create(g);
            int length = JBUI.getInt((String)"RecentProject.MainToolbarGradient.width", (int)700);
            int height = JBUI.getInt((String)"RecentProject.MainToolbarGradient.height", (int)200);
            int leftWidth = PaintUtil.alignIntToInt((int)((int)centerX), (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL, null);
            int rightWidth = PaintUtil.alignIntToInt((int)length, (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL, null);
            int totalWidth = PaintUtil.alignIntToInt((int)(leftWidth + rightWidth), (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL, null);
            Rectangle fullBounds = new Rectangle(totalWidth, height);
            Rectangle rectangle = g.getClipBounds();
            if (rectangle == null || (rectangle = rectangle.intersection(fullBounds)) == null) {
                rectangle = fullBounds;
            }
            if ((bounds = rectangle).isEmpty()) {
                return;
            }
            JComponent jComponent = frame.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            GradientCache cache = IslandsGradientPainterKt.getGradientCache(jComponent, "GradientCache");
            Color centerColor = projectWindowCustomizer.getGradientProjectColor(project2);
            Color blendedColor = cache.getBlendedColor(mainColor, centerColor);
            TexturePaint leftGradientTexture = GradientTextureCache.getHorizontalTexture$default(cache.getLeft(), g, leftWidth, mainColor, blendedColor, 0, 0, 48, null);
            TexturePaint rightGradientTexture = GradientTextureCache.getHorizontalTexture$default(cache.getRight(), g, rightWidth, blendedColor, mainColor, leftWidth, 0, 32, null);
            Composite initialComposite = g.getComposite();
            IslandsInactiveFrameGraphics2D islandsInactiveFrameGraphics2D = g instanceof IslandsInactiveFrameGraphics2D ? (IslandsInactiveFrameGraphics2D)((Object)g) : null;
            Window window = SwingUtilities.getWindowAncestor(frame.getComponent());
            boolean bl = window != null ? !window.isActive() : false;
            if (bl) {
                Rectangle componentBounds;
                IslandsInactiveFrameGraphics2D islandsInactiveFrameGraphics2D2 = islandsInactiveFrameGraphics2D;
                if (islandsInactiveFrameGraphics2D2 != null) {
                    islandsInactiveFrameGraphics2D2.setPreserveComposite(true);
                }
                Rectangle componentFullBounds = new Rectangle(component2.getWidth(), component2.getHeight());
                Rectangle rectangle2 = g.getClipBounds();
                if (rectangle2 == null || (rectangle2 = rectangle2.intersection(componentFullBounds)) == null) {
                    rectangle2 = componentFullBounds;
                }
                if (!(componentBounds = rectangle2).isEmpty()) {
                    g.setColor(mainColor);
                    g.fillRect(componentBounds.x, componentBounds.y, componentBounds.width, componentBounds.height);
                }
                g.setComposite(AlphaComposite.getInstance(3, IslandsUICustomizationKt.getIslandsInactiveAlpha()));
            }
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            PaintUtil.alignTxToInt((Graphics2D)g, null, (boolean)true, (boolean)false, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
            Rectangle leftBounds = bounds.intersection(new Rectangle(leftWidth, height));
            if (!leftBounds.isEmpty()) {
                g.setPaint(leftGradientTexture);
                g.fillRect(leftBounds.x, leftBounds.y, leftBounds.width, leftBounds.height);
            }
            if (!(rightBounds = bounds.intersection(new Rectangle(leftWidth, 0, rightWidth, height))).isEmpty()) {
                g.setPaint(rightGradientTexture);
                g.fillRect(rightBounds.x, rightBounds.y, rightBounds.width, rightBounds.height);
            }
            PaintUtil.alignTxToInt((Graphics2D)g, null, (boolean)false, (boolean)true, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
            g.setComposite(initialComposite);
            Color startColor = SystemInfo.isMac ? Gray.TRANSPARENT : ColorUtil.toAlpha((Color)mainColor, (int)0);
            g.setPaint(new GradientPaint(0.0f, 0.0f, startColor, 0.0f, height, mainColor));
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            IslandsInactiveFrameGraphics2D islandsInactiveFrameGraphics2D3 = islandsInactiveFrameGraphics2D;
            if (islandsInactiveFrameGraphics2D3 == null) break block9;
            islandsInactiveFrameGraphics2D3.setPreserveComposite(false);
        }
    }

    private static final GradientCache getGradientCache(JComponent root, String key) {
        Object gradientCache = root.getClientProperty(key);
        if (gradientCache instanceof GradientCache) {
            return (GradientCache)gradientCache;
        }
        GradientCache newValue = new GradientCache();
        root.putClientProperty(key, newValue);
        return newValue;
    }

    private static final void doColorGradientPaint(Project project2, ProjectWindowCustomizerService projectWindowCustomizer, Component component2, Graphics2D g) {
        block2: {
            IslandsInactiveFrameGraphics2D islandsInactiveFrameGraphics2D = g instanceof IslandsInactiveFrameGraphics2D ? (IslandsInactiveFrameGraphics2D)((Object)g) : null;
            Composite initialComposite = g.getComposite();
            ProjectGradients info = projectWindowCustomizer.getProjectGradients$intellij_platform_ide_impl(project2);
            Window window = SwingUtilities.getWindowAncestor(component2);
            boolean bl = window != null ? !window.isActive() : false;
            if (bl) {
                IslandsInactiveFrameGraphics2D islandsInactiveFrameGraphics2D2 = islandsInactiveFrameGraphics2D;
                if (islandsInactiveFrameGraphics2D2 != null) {
                    islandsInactiveFrameGraphics2D2.setPreserveComposite(true);
                }
                g.setComposite(AlphaComposite.getInstance(3, IslandsUICustomizationKt.getIslandsInactiveAlpha()));
            }
            Object[] objectArray = new float[]{info.getDiagonalFraction1(0.0f), info.getDiagonalFraction2(0.13f), info.getDiagonalFraction3(0.3f), info.getDiagonalFraction4(1.0f)};
            float[] fArray = objectArray;
            objectArray = new JBColor[4];
            objectArray[0] = (float)info.getDiagonalColor1();
            objectArray[1] = (float)info.getDiagonalColor2();
            objectArray[2] = (float)info.getDiagonalColor3();
            objectArray[3] = (float)info.getDiagonalColor4();
            g.setPaint(new LinearGradientPaint(0.0f, 0.0f, component2.getWidth(), component2.getHeight(), fArray, (Color[])objectArray));
            g.fillRect(0, 0, component2.getWidth(), component2.getHeight());
            float ovalRadius = (float)component2.getWidth() / 4.0f;
            int ovalWidth = component2.getWidth() / 2;
            float ovalCenterX = (float)component2.getWidth() * 0.2f;
            float ovalCenterY = 36.0f;
            Object[] objectArray2 = new float[]{0.0f, 1.0f};
            float[] fArray2 = objectArray2;
            objectArray2 = new JBColor[2];
            objectArray2[0] = (float)info.getRadialColor1();
            objectArray2[1] = (float)info.getRadialColor2();
            g.setPaint(new RadialGradientPaint(ovalCenterX, ovalCenterY, ovalRadius, fArray2, (Color[])objectArray2));
            g.fillOval((int)(ovalCenterX - ovalRadius), (int)(ovalCenterY - ovalRadius), ovalWidth, ovalWidth);
            g.setPaint(new GradientPaint(0.0f, 0.0f, (Color)info.getHorizontalColor1(), component2.getWidth(), 0.0f, (Color)info.getHorizontalColor2()));
            g.fillRect(0, 0, component2.getWidth(), component2.getHeight());
            g.setPaint(new GradientPaint(0.0f, 0.0f, (Color)info.getVerticalColor1(), 0.0f, component2.getHeight(), (Color)info.getVerticalColor2()));
            g.fillRect(0, 0, component2.getWidth(), component2.getHeight());
            g.setComposite(initialComposite);
            IslandsInactiveFrameGraphics2D islandsInactiveFrameGraphics2D3 = islandsInactiveFrameGraphics2D;
            if (islandsInactiveFrameGraphics2D3 == null) break block2;
            islandsInactiveFrameGraphics2D3.setPreserveComposite(false);
        }
    }

    static {
        Object[] objectArray = new String[]{"MainWindow.background", "MainToolbar.background", "MainToolbar.inactiveBackground", "ToolWindow.Stripe.background", "StatusBar.background"};
        islandsGradientColors = SetsKt.setOf((Object[])objectArray);
    }
}

