/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.EditorChangeAction;
import com.intellij.openapi.command.impl.UndoDocumentUtil;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DocumentUndoProvider
implements DocumentListener {
    private static final Key<Boolean> UNDOING_EDITOR_CHANGE = Key.create((String)"DocumentUndoProvider.UNDOING_EDITOR_CHANGE");

    private DocumentUndoProvider() {
    }

    @NotNull
    private static UndoManagerImpl getUndoManager(@Nullable Project project2) {
        UndoManagerImpl undoManagerImpl = (UndoManagerImpl)(project2 == null ? UndoManager.getGlobalInstance() : UndoManager.getInstance((Project)project2));
        if (undoManagerImpl == null) {
            DocumentUndoProvider.$$$reportNull$$$0(0);
        }
        return undoManagerImpl;
    }

    public static void startDocumentUndo(@Nullable Document doc) {
        if (doc != null) {
            doc.putUserData(UNDOING_EDITOR_CHANGE, (Object)Boolean.TRUE);
        }
    }

    public static void finishDocumentUndo(@Nullable Document doc) {
        if (doc != null) {
            doc.putUserData(UNDOING_EDITOR_CHANGE, null);
        }
    }

    public void beforeDocumentChange(@NotNull DocumentEvent e) {
        Project lightEditProject;
        Document document2;
        if (e == null) {
            DocumentUndoProvider.$$$reportNull$$$0(1);
        }
        if (!DocumentUndoProvider.shouldProcess(document2 = e.getDocument())) {
            return;
        }
        DocumentUndoProvider.handleBeforeDocumentChange(DocumentUndoProvider.getUndoManager(null), document2);
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager != null) {
            for (Project project2 : projectManager.getOpenProjects()) {
                DocumentUndoProvider.handleBeforeDocumentChange(DocumentUndoProvider.getUndoManager(project2), document2);
            }
        }
        if ((lightEditProject = LightEditUtil.getProjectIfCreated()) != null) {
            DocumentUndoProvider.handleBeforeDocumentChange(DocumentUndoProvider.getUndoManager(lightEditProject), document2);
        }
    }

    private static void handleBeforeDocumentChange(@NotNull UndoManagerImpl undoManager, @NotNull Document document2) {
        if (undoManager == null) {
            DocumentUndoProvider.$$$reportNull$$$0(2);
        }
        if (document2 == null) {
            DocumentUndoProvider.$$$reportNull$$$0(3);
        }
        if (undoManager.isActive() && DocumentUndoProvider.isUndoable(undoManager, document2) && undoManager.isUndoOrRedoInProgress() && document2.getUserData(UNDOING_EDITOR_CHANGE) != Boolean.TRUE) {
            throw new IllegalStateException("Do not change documents during undo as it will break undo sequence.");
        }
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        Project lightEditProject;
        Document document2;
        if (e == null) {
            DocumentUndoProvider.$$$reportNull$$$0(4);
        }
        if (!DocumentUndoProvider.shouldProcess(document2 = e.getDocument())) {
            return;
        }
        DocumentUndoProvider.handleDocumentChanged(DocumentUndoProvider.getUndoManager(null), document2, e);
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager != null) {
            for (Project project2 : projectManager.getOpenProjects()) {
                DocumentUndoProvider.handleDocumentChanged(DocumentUndoProvider.getUndoManager(project2), document2, e);
            }
        }
        if ((lightEditProject = LightEditUtil.getProjectIfCreated()) != null) {
            DocumentUndoProvider.handleDocumentChanged(DocumentUndoProvider.getUndoManager(lightEditProject), document2, e);
        }
    }

    private static void handleDocumentChanged(@NotNull UndoManagerImpl undoManager, @NotNull Document document2, @NotNull DocumentEvent e) {
        if (undoManager == null) {
            DocumentUndoProvider.$$$reportNull$$$0(5);
        }
        if (document2 == null) {
            DocumentUndoProvider.$$$reportNull$$$0(6);
        }
        if (e == null) {
            DocumentUndoProvider.$$$reportNull$$$0(7);
        }
        if (undoManager.isActive() && DocumentUndoProvider.isUndoable(undoManager, document2)) {
            DocumentUndoProvider.registerUndoableAction(undoManager, e);
        } else {
            DocumentUndoProvider.registerNonUndoableAction(undoManager, document2);
        }
    }

    private static boolean shouldProcess(@NotNull Document document2) {
        if (document2 == null) {
            DocumentUndoProvider.$$$reportNull$$$0(8);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return false;
        }
        return !UndoDocumentUtil.isCopy(document2) && DocumentUndoProvider.shouldRecordActions(document2);
    }

    private static boolean shouldRecordActions(@NotNull Document document2) {
        if (document2 == null) {
            DocumentUndoProvider.$$$reportNull$$$0(9);
        }
        if (UndoUtil.isUndoDisabledFor((Document)document2)) {
            return false;
        }
        VirtualFile vFile = FileDocumentManager.getInstance().getFile(document2);
        if (vFile == null) {
            return true;
        }
        return vFile.getUserData(AbstractFileViewProvider.FREE_THREADED) != Boolean.TRUE && !UndoUtil.isUndoDisabledFor((VirtualFile)vFile);
    }

    private static void registerUndoableAction(@NotNull UndoManagerImpl undoManager, @NotNull DocumentEvent e) {
        if (undoManager == null) {
            DocumentUndoProvider.$$$reportNull$$$0(10);
        }
        if (e == null) {
            DocumentUndoProvider.$$$reportNull$$$0(11);
        }
        undoManager.undoableActionPerformed((UndoableAction)new EditorChangeAction(e));
    }

    private static void registerNonUndoableAction(@NotNull UndoManagerImpl undoManager, @NotNull Document document2) {
        if (undoManager == null) {
            DocumentUndoProvider.$$$reportNull$$$0(12);
        }
        if (document2 == null) {
            DocumentUndoProvider.$$$reportNull$$$0(13);
        }
        DocumentReference ref2 = DocumentReferenceManager.getInstance().create(document2);
        undoManager.nonundoableActionPerformed(ref2, false);
    }

    private static boolean isUndoable(@NotNull UndoManagerImpl undoManager, @NotNull Document document2) {
        DocumentReference ref2;
        VirtualFile file2;
        if (undoManager == null) {
            DocumentUndoProvider.$$$reportNull$$$0(14);
        }
        if (document2 == null) {
            DocumentUndoProvider.$$$reportNull$$$0(15);
        }
        if ((file2 = (ref2 = DocumentReferenceManager.getInstance().create(document2)).getFile()) != null && UndoUtil.isForceUndoFlagSet((VirtualFile)file2)) {
            return true;
        }
        return !UndoManagerImpl.isRefresh() || undoManager.isUndoRedoAvailable(ref2, true) || undoManager.isUndoRedoAvailable(ref2, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/DocumentUndoProvider";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoManager";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/DocumentUndoProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleBeforeDocumentChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleDocumentChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcess";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldRecordActions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerUndoableAction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerNonUndoableAction";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalArgumentException(string);
        };
    }
}

