/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.diagnostic.Dumpable;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.DistractionFreeModeController;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.AttachmentFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorCoreUtil;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.Interval;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.impl.TextRangeInterval;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorUtil {
    private static final Logger LOG = Logger.getInstance(EditorUtil.class);

    private EditorUtil() {
    }

    public static boolean isRealFileEditor(@Nullable Editor editor2) {
        return editor2 != null && TextEditorProvider.getInstance().getTextEditor(editor2) instanceof TextEditorImpl;
    }

    public static boolean isPasswordEditor(@Nullable Editor editor2) {
        return editor2 != null && editor2.getContentComponent() instanceof JPasswordField;
    }

    @Nullable
    public static EditorEx getEditorEx(@Nullable FileEditor fileEditor) {
        Editor editor2;
        if (fileEditor instanceof TextEditor) {
            TextEditor te = (TextEditor)fileEditor;
            editor2 = te.getEditor();
        } else {
            editor2 = null;
        }
        Editor editor3 = editor2;
        return editor3 instanceof EditorEx ? (EditorEx)editor3 : null;
    }

    public static int getLastVisualLineColumnNumber(@NotNull Editor editor2, int line) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(0);
        }
        if (editor2 instanceof EditorImpl) {
            EditorImpl editorImpl = (EditorImpl)editor2;
            int lineEndOffset = line >= editorImpl.getVisibleLineCount() ? editor2.getDocument().getTextLength() : new VisualLinesIterator(editorImpl, line).getVisualLineEndOffset();
            return editor2.offsetToVisualPosition((int)lineEndOffset, (boolean)true, (boolean)true).column;
        }
        return (Integer)EditorThreading.compute(() -> {
            Document document2 = editor2.getDocument();
            int lastLine = document2.getLineCount() - 1;
            if (lastLine < 0) {
                return 0;
            }
            VisualPosition visStart = new VisualPosition(line, 0);
            LogicalPosition logStart = editor2.visualToLogicalPosition(visStart);
            int lastLogLine = logStart.line;
            while (lastLogLine < document2.getLineCount() - 1) {
                logStart = new LogicalPosition(logStart.line + 1, logStart.column);
                VisualPosition tryVisible = editor2.logicalToVisualPosition(logStart);
                if (tryVisible.line != visStart.line) break;
                lastLogLine = logStart.line;
            }
            int resultLogLine = Math.min(lastLogLine, lastLine);
            VisualPosition resVisStart = editor2.offsetToVisualPosition(document2.getLineStartOffset(resultLogLine));
            VisualPosition resVisEnd = editor2.offsetToVisualPosition(document2.getLineEndOffset(resultLogLine));
            if (resVisStart.line == resVisEnd.line) {
                return resVisEnd.column;
            }
            int visualLinesToSkip = line - resVisStart.line;
            List softWraps = editor2.getSoftWrapModel().getSoftWrapsForLine(resultLogLine);
            for (int i2 = 0; i2 < softWraps.size(); ++i2) {
                SoftWrap softWrap = (SoftWrap)softWraps.get(i2);
                CharSequence text2 = document2.getCharsSequence();
                if (visualLinesToSkip <= 0) {
                    VisualPosition visual = editor2.offsetToVisualPosition(softWrap.getStart() - 1);
                    int result2 = visual.column;
                    int x = editor2.visualPositionToXY((VisualPosition)visual).x;
                    return result2 + EditorUtil.textWidthInColumns(editor2, text2, softWrap.getStart() - 1, softWrap.getStart(), x);
                }
                int softWrapLineFeeds = StringUtil.countNewLines((CharSequence)softWrap.getText());
                if (softWrapLineFeeds < visualLinesToSkip) {
                    visualLinesToSkip -= softWrapLineFeeds;
                    continue;
                }
                if (softWrapLineFeeds == visualLinesToSkip) {
                    if (i2 >= softWraps.size() - 1) {
                        return resVisEnd.column;
                    }
                    SoftWrap nextSoftWrap = (SoftWrap)softWraps.get(i2 + 1);
                    VisualPosition visual = editor2.offsetToVisualPosition(nextSoftWrap.getStart() - 1);
                    int result3 = visual.column;
                    int x = editor2.visualPositionToXY((VisualPosition)visual).x;
                    result3 += EditorUtil.textWidthInColumns(editor2, text2, nextSoftWrap.getStart() - 1, nextSoftWrap.getStart(), x);
                    int lineFeedIndex = StringUtil.indexOf((CharSequence)nextSoftWrap.getText(), (char)'\n');
                    return result3 += EditorUtil.textWidthInColumns(editor2, nextSoftWrap.getText(), 0, lineFeedIndex, 0);
                }
                int softWrapStartOffset = 0;
                int softWrapEndOffset = 0;
                int softWrapTextLength = softWrap.getText().length();
                while (visualLinesToSkip-- > 0) {
                    softWrapStartOffset = softWrapEndOffset + 1;
                    if (softWrapStartOffset >= softWrapTextLength) {
                        assert (false);
                        return resVisEnd.column;
                    }
                    softWrapEndOffset = StringUtil.indexOf((CharSequence)softWrap.getText(), (char)'\n', (int)softWrapStartOffset, (int)softWrapTextLength);
                    if (softWrapEndOffset >= 0) continue;
                    assert (false);
                    return resVisEnd.column;
                }
                VisualPosition visual = editor2.offsetToVisualPosition(softWrap.getStart() - 1);
                int result4 = visual.column;
                int x = editor2.visualPositionToXY((VisualPosition)visual).x;
                result4 += EditorUtil.textWidthInColumns(editor2, text2, softWrap.getStart() - 1, softWrap.getStart(), x);
                return result4 += EditorUtil.calcColumnNumber(editor2, softWrap.getText(), softWrapStartOffset, softWrapEndOffset);
            }
            String editorInfo = "editor's class: " + String.valueOf(editor2.getClass()) + ", all soft wraps: " + String.valueOf(editor2.getSoftWrapModel().getSoftWrapsForRange(0, document2.getTextLength())) + ", fold regions: " + Arrays.toString(editor2.getFoldingModel().getAllFoldRegions());
            LOG.error("Can't calculate last visual column", new Throwable(), new Attachment[]{AttachmentFactory.createContext((String)String.format("Target visual line: %d, mapped logical line: %d, visual lines range for the mapped logical line: [%s]-[%s], soft wraps for the target logical line: %s. Editor info: %s", line, resultLogLine, resVisStart, resVisEnd, softWraps, editorInfo))});
            return resVisEnd.column;
        });
    }

    public static int getVisualLineEndOffset(@NotNull Editor editor2, int line) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(1);
        }
        return (Integer)EditorThreading.compute(() -> {
            VisualPosition endLineVisualPosition = new VisualPosition(line, EditorUtil.getLastVisualLineColumnNumber(editor2, line));
            return editor2.visualPositionToOffset(endLineVisualPosition);
        });
    }

    public static float calcVerticalScrollProportion(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(2);
        }
        return ((Float)EditorThreading.compute(() -> {
            Rectangle viewArea = editor2.getScrollingModel().getVisibleAreaOnScrollingFinished();
            if (viewArea.height == 0) {
                return Float.valueOf(0.0f);
            }
            LogicalPosition pos = editor2.getCaretModel().getLogicalPosition();
            Point location = editor2.logicalPositionToXY(pos);
            return Float.valueOf((float)(location.y - viewArea.y) / (float)viewArea.height);
        })).floatValue();
    }

    public static void setVerticalScrollProportion(@NotNull Editor editor2, float proportion) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(3);
        }
        EditorThreading.run(() -> {
            Rectangle viewArea = editor2.getScrollingModel().getVisibleArea();
            LogicalPosition caretPosition = editor2.getCaretModel().getLogicalPosition();
            Point caretLocation = editor2.logicalPositionToXY(caretPosition);
            int yPos = caretLocation.y;
            yPos = (int)((float)yPos - (float)viewArea.height * proportion);
            editor2.getScrollingModel().scrollVertically(yPos);
        });
    }

    public static int calcRelativeCaretPosition(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(4);
        }
        return (Integer)EditorThreading.compute(() -> {
            int caretY = editor2.visualLineToY(editor2.getCaretModel().getVisualPosition().line);
            int viewAreaPosition = editor2.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
            return caretY - viewAreaPosition;
        });
    }

    public static void setRelativeCaretPosition(@NotNull Editor editor2, int position) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(5);
        }
        EditorThreading.run(() -> {
            int caretY = editor2.visualLineToY(editor2.getCaretModel().getVisualPosition().line);
            editor2.getScrollingModel().scrollVertically(caretY - position);
        });
    }

    public static void fillVirtualSpaceUntilCaret(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(6);
        }
        LogicalPosition position = editor2.getCaretModel().getLogicalPosition();
        EditorUtil.fillVirtualSpaceUntil(editor2, position.column, position.line);
    }

    public static void fillVirtualSpaceUntil(@NotNull Editor editor2, int columnNumber, int lineNumber) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(7);
        }
        int offset = editor2.logicalPositionToOffset(new LogicalPosition(lineNumber, columnNumber));
        String filler = EditorModificationUtilEx.calcStringToFillVirtualSpace((Editor)editor2);
        if (!filler.isEmpty()) {
            WriteAction.run(() -> {
                editor2.getDocument().insertString(offset, (CharSequence)filler);
                editor2.getCaretModel().moveToOffset(offset + filler.length());
            });
        }
    }

    private static int getTabLength(int colNumber, int tabSize2) {
        if (tabSize2 <= 0) {
            tabSize2 = 1;
        }
        return tabSize2 - colNumber % tabSize2;
    }

    public static int calcColumnNumber(@NotNull Editor editor2, @NotNull CharSequence text2, int start2, int offset) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            EditorUtil.$$$reportNull$$$0(9);
        }
        return EditorUtil.calcColumnNumber(editor2, text2, start2, offset, EditorUtil.getTabSize(editor2));
    }

    public static int calcColumnNumber(@Nullable Editor editor2, @NotNull CharSequence text2, int start2, int offset, int tabSize2) {
        int i2;
        if (text2 == null) {
            EditorUtil.$$$reportNull$$$0(10);
        }
        if (editor2 instanceof TextComponentEditor) {
            return offset - start2;
        }
        boolean useOptimization = true;
        if (editor2 != null) {
            SoftWrap softWrap = editor2.getSoftWrapModel().getSoftWrap(start2);
            boolean bl = useOptimization = softWrap == null;
        }
        if (useOptimization) {
            boolean hasNonTabs = false;
            for (i2 = start2; i2 < offset; ++i2) {
                if (text2.charAt(i2) == '\t') {
                    if (!hasNonTabs) continue;
                    useOptimization = false;
                    break;
                }
                hasNonTabs = true;
            }
        }
        if (editor2 != null && useOptimization) {
            Document document2 = editor2.getDocument();
            if (start2 < offset - 1 && document2.getLineNumber(start2) != document2.getLineNumber(offset - 1)) {
                String editorInfo = editor2 instanceof EditorImpl ? ". Editor info: " + ((EditorImpl)editor2).dumpState() : "";
                Object documentInfo = text2 instanceof Dumpable ? ((Dumpable)text2).dumpState() : "Text holder class: " + String.valueOf(text2.getClass());
                LOG.error("detected incorrect offset -> column number calculation", new Throwable(), new Attachment[]{AttachmentFactory.createContext((String)("start: " + start2 + ", given offset: " + offset + ", given tab size: " + tabSize2 + ". " + (String)documentInfo + editorInfo))});
            }
        }
        int shift = 0;
        for (i2 = start2; i2 < offset; ++i2) {
            char c = text2.charAt(i2);
            if (c != '\t') continue;
            shift += EditorUtil.getTabLength(i2 + shift - start2, tabSize2) - 1;
        }
        return offset - start2 + shift;
    }

    @NotNull
    public static FontInfo fontForChar(char c, @JdkConstants.FontStyle int style, @NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(11);
        }
        FontInfo fontInfo = (FontInfo)EditorThreading.compute(() -> {
            EditorColorsScheme colorsScheme = editor2.getColorsScheme();
            return ComplementaryFontsRegistry.getFontAbleToDisplay(c, style, colorsScheme.getFontPreferences(), FontInfo.getFontRenderContext(editor2.getContentComponent()));
        });
        if (fontInfo == null) {
            EditorUtil.$$$reportNull$$$0(12);
        }
        return fontInfo;
    }

    public static Icon scaleIconAccordingEditorFont(Icon icon2, Editor editor2) {
        float scale;
        if (Registry.is((String)"editor.scale.gutter.icons") && editor2 instanceof EditorImpl && icon2 instanceof ScalableIcon && Math.abs(1.0f - (scale = ((EditorImpl)editor2).getScale())) > 0.1f) {
            return ((ScalableIcon)icon2).scale(scale);
        }
        return icon2;
    }

    public static int charWidth(char c, @JdkConstants.FontStyle int fontType, @NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(13);
        }
        return EditorUtil.fontForChar(c, fontType, editor2).charWidth(c);
    }

    public static int getSpaceWidth(@JdkConstants.FontStyle int fontType, @NotNull Editor editor2) {
        int width;
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(14);
        }
        return (width = EditorUtil.charWidth(' ', fontType, editor2)) > 0 ? width : 1;
    }

    public static int getPlainSpaceWidth(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(15);
        }
        return EditorUtil.getSpaceWidth(0, editor2);
    }

    public static int getTabSize(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(16);
        }
        return editor2.getSettings().getTabSize(editor2.getProject());
    }

    public static int nextTabStop(int x, @NotNull Editor editor2) {
        int tabSize2;
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(17);
        }
        if ((tabSize2 = EditorUtil.getTabSize(editor2)) <= 0) {
            tabSize2 = 1;
        }
        return EditorUtil.nextTabStop(x, editor2, tabSize2);
    }

    public static int nextTabStop(int x, @NotNull Editor editor2, int tabSize2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(18);
        }
        int leftInset = (Integer)EditorThreading.compute(() -> editor2.getContentComponent().getInsets().left);
        return EditorUtil.nextTabStop(x - leftInset, EditorUtil.getSpaceWidth(0, editor2), tabSize2) + leftInset;
    }

    public static int nextTabStop(int x, int plainSpaceWidth, int tabSize2) {
        if (tabSize2 <= 0) {
            return x + plainSpaceWidth;
        }
        int nTabs = x / (tabSize2 *= plainSpaceWidth);
        return (nTabs + 1) * tabSize2;
    }

    public static float nextTabStop(float x, float plainSpaceWidth, int tabSize2) {
        if (tabSize2 <= 0) {
            return x + plainSpaceWidth;
        }
        float tabSizePixels = (float)tabSize2 * plainSpaceWidth;
        int nTabs = (int)((x + plainSpaceWidth / 2.0f) / tabSizePixels);
        return (float)(nTabs + 1) * tabSizePixels;
    }

    public static int textWidthInColumns(@NotNull Editor editor2, @NotNull CharSequence text2, int start2, int end, int x) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(19);
        }
        if (text2 == null) {
            EditorUtil.$$$reportNull$$$0(20);
        }
        int startToUse = start2;
        int lastTabSymbolIndex = -1;
        block8: for (int i2 = end - 1; i2 >= start2; --i2) {
            switch (text2.charAt(i2)) {
                case '\n': {
                    startToUse = i2 + 1;
                    break block8;
                }
                case '\t': {
                    if (lastTabSymbolIndex < 0) {
                        lastTabSymbolIndex = i2;
                    }
                }
                default: {
                    continue block8;
                }
            }
        }
        if (lastTabSymbolIndex < 0) {
            return end - startToUse;
        }
        int result2 = 0;
        int spaceSize = EditorUtil.getSpaceWidth(0, editor2);
        block9: for (int i3 = startToUse; i3 <= lastTabSymbolIndex; ++i3) {
            SoftWrap softWrap = editor2.getSoftWrapModel().getSoftWrap(i3);
            if (softWrap != null) {
                x = softWrap.getIndentInPixels();
            }
            char c = text2.charAt(i3);
            int prevX = x;
            switch (c) {
                case '\t': {
                    x = EditorUtil.nextTabStop(x, editor2);
                    result2 += EditorUtil.columnsNumber(x - prevX, spaceSize);
                    continue block9;
                }
                case '\n': {
                    result2 = 0;
                    x = 0;
                    continue block9;
                }
                default: {
                    x += EditorUtil.charWidth(c, 0, editor2);
                    ++result2;
                }
            }
        }
        return result2 += end - lastTabSymbolIndex - 1;
    }

    public static int columnsNumber(int width, int plainSpaceSize) {
        int result2 = width / plainSpaceSize;
        if (width % plainSpaceSize > 0) {
            ++result2;
        }
        return result2;
    }

    public static int columnsNumber(float width, float plainSpaceSize) {
        return (int)Math.ceil(width / plainSpaceSize);
    }

    public static int textWidth(@NotNull Editor editor2, @NotNull CharSequence text2, int start2, int end, @JdkConstants.FontStyle int fontType, int x) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(21);
        }
        if (text2 == null) {
            EditorUtil.$$$reportNull$$$0(22);
        }
        int result2 = 0;
        for (int i2 = start2; i2 < end; ++i2) {
            char c = text2.charAt(i2);
            if (c != '\t') {
                FontInfo font = EditorUtil.fontForChar(c, fontType, editor2);
                result2 += font.charWidth(c);
                continue;
            }
            result2 += EditorUtil.nextTabStop(x + result2, editor2) - result2 - x;
        }
        return result2;
    }

    @NotNull
    public static TextRange calcCaretLineTextRange(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(23);
        }
        return EditorUtil.logicalPairToTextRange(editor2, EditorUtil.calcCaretLineRange(editor2));
    }

    @NotNull
    public static Pair<LogicalPosition, LogicalPosition> calcCaretLineRange(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(24);
        }
        VisualPosition caretPosition = editor2.getCaretModel().getCurrentCaret().getVisualPosition();
        return EditorUtil.calcSurroundingRange(editor2, caretPosition, caretPosition);
    }

    @NotNull
    public static TextRange calcCaretLineTextRange(@NotNull Caret caret) {
        if (caret == null) {
            EditorUtil.$$$reportNull$$$0(25);
        }
        return EditorUtil.logicalPairToTextRange(caret.getEditor(), EditorUtil.calcCaretLineRange(caret));
    }

    @NotNull
    public static Pair<LogicalPosition, LogicalPosition> calcCaretLineRange(@NotNull Caret caret) {
        if (caret == null) {
            EditorUtil.$$$reportNull$$$0(26);
        }
        VisualPosition caretPosition = caret.getVisualPosition();
        return EditorUtil.calcSurroundingRange(caret.getEditor(), caretPosition, caretPosition);
    }

    @NotNull
    public static TextRange calcSurroundingTextRange(@NotNull Editor editor2, @NotNull VisualPosition start2, @NotNull VisualPosition end) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(27);
        }
        if (start2 == null) {
            EditorUtil.$$$reportNull$$$0(28);
        }
        if (end == null) {
            EditorUtil.$$$reportNull$$$0(29);
        }
        return EditorUtil.logicalPairToTextRange(editor2, EditorUtil.calcSurroundingRange(editor2, start2, end));
    }

    @NotNull
    public static Pair<LogicalPosition, LogicalPosition> calcSurroundingRange(@NotNull Editor editor2, @NotNull VisualPosition start2, @NotNull VisualPosition end) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(30);
        }
        if (start2 == null) {
            EditorUtil.$$$reportNull$$$0(31);
        }
        if (end == null) {
            EditorUtil.$$$reportNull$$$0(32);
        }
        Pair pair = (Pair)EditorThreading.compute(() -> {
            Document document2 = editor2.getDocument();
            FoldingModel foldingModel = editor2.getFoldingModel();
            LogicalPosition first = editor2.visualToLogicalPosition(new VisualPosition(start2.line, 0));
            int line = first.line;
            int offset = document2.getLineStartOffset(line);
            while (offset >= 0) {
                FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(offset);
                if (foldRegion == null) {
                    first = new LogicalPosition(line, 0);
                    break;
                }
                int foldEndLine = document2.getLineNumber(foldRegion.getStartOffset());
                if (foldEndLine <= line) {
                    first = new LogicalPosition(line, 0);
                    break;
                }
                line = foldEndLine;
                offset = document2.getLineStartOffset(line);
            }
            LogicalPosition second = editor2.visualToLogicalPosition(new VisualPosition(end.line, 0));
            int line2 = second.line;
            int offset2 = document2.getLineEndOffset(line2);
            while (offset2 <= document2.getTextLength()) {
                FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(offset2);
                if (foldRegion == null) {
                    second = new LogicalPosition(line2 + 1, 0);
                    break;
                }
                int foldEndLine = document2.getLineNumber(foldRegion.getEndOffset());
                if (foldEndLine <= line2) {
                    second = new LogicalPosition(line2 + 1, 0);
                    break;
                }
                line2 = foldEndLine;
                offset2 = document2.getLineEndOffset(line2);
            }
            if (second.line >= document2.getLineCount()) {
                second = editor2.offsetToLogicalPosition(document2.getTextLength());
            }
            return Pair.create((Object)first, (Object)second);
        });
        if (pair == null) {
            EditorUtil.$$$reportNull$$$0(33);
        }
        return pair;
    }

    @NotNull
    private static TextRange logicalPairToTextRange(@NotNull Editor editor2, @NotNull Pair<LogicalPosition, LogicalPosition> logicalPair) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(34);
        }
        if (logicalPair == null) {
            EditorUtil.$$$reportNull$$$0(35);
        }
        TextRange textRange = TextRange.create((int)editor2.logicalPositionToOffset((LogicalPosition)logicalPair.first), (int)editor2.logicalPositionToOffset((LogicalPosition)logicalPair.second));
        if (textRange == null) {
            EditorUtil.$$$reportNull$$$0(36);
        }
        return textRange;
    }

    public static int getNotFoldedLineStartOffset(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(37);
        }
        return EditorUtil.getNotFoldedLineStartOffset(editor2, offset, false);
    }

    public static int getNotFoldedLineStartOffset(@NotNull Editor editor2, int startOffset, boolean stopAtInvisibleFoldRegions) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(38);
        }
        return (Integer)EditorThreading.compute(() -> EditorUtil.getNotFoldedLineStartOffset(editor2.getDocument(), editor2.getFoldingModel(), startOffset, stopAtInvisibleFoldRegions));
    }

    @ApiStatus.Internal
    public static int getNotFoldedLineStartOffset(@NotNull Document document2, @NotNull FoldingModel foldingModel, int startOffset, boolean stopAtInvisibleFoldRegions) {
        FoldRegion foldRegion;
        if (document2 == null) {
            EditorUtil.$$$reportNull$$$0(39);
        }
        if (foldingModel == null) {
            EditorUtil.$$$reportNull$$$0(40);
        }
        int offset = startOffset;
        while (!((foldRegion = foldingModel.getCollapsedRegionAtOffset((offset = DocumentUtil.getLineStartOffset((int)offset, (Document)document2)) - 1)) == null || stopAtInvisibleFoldRegions && foldRegion.getPlaceholderText().isEmpty() || foldRegion.getStartOffset() >= offset)) {
            offset = foldRegion.getStartOffset();
        }
        return offset;
    }

    public static int getNotFoldedLineEndOffset(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(41);
        }
        return EditorUtil.getNotFoldedLineEndOffset(editor2, offset, false);
    }

    public static int getNotFoldedLineEndOffset(@NotNull Editor editor2, int startOffset, boolean stopAtInvisibleFoldRegions) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(42);
        }
        return (Integer)EditorThreading.compute(() -> EditorUtil.getNotFoldedLineEndOffset(editor2.getDocument(), editor2.getFoldingModel(), startOffset, stopAtInvisibleFoldRegions));
    }

    @ApiStatus.Internal
    public static int getNotFoldedLineEndOffset(@NotNull Document document2, @NotNull FoldingModel foldingModel, int startOffset, boolean stopAtInvisibleFoldRegions) {
        FoldRegion foldRegion;
        if (document2 == null) {
            EditorUtil.$$$reportNull$$$0(43);
        }
        if (foldingModel == null) {
            EditorUtil.$$$reportNull$$$0(44);
        }
        int offset = startOffset;
        while (!((foldRegion = foldingModel.getCollapsedRegionAtOffset(offset = EditorUtil.getLineEndOffset(offset, document2))) == null || stopAtInvisibleFoldRegions && foldRegion.getPlaceholderText().isEmpty() || foldRegion.getEndOffset() <= offset)) {
            offset = foldRegion.getEndOffset();
        }
        return offset;
    }

    private static int getLineEndOffset(int offset, Document document2) {
        if (offset >= document2.getTextLength()) {
            return offset;
        }
        int lineNumber = document2.getLineNumber(offset);
        return document2.getLineEndOffset(lineNumber);
    }

    public static void scrollToTheEnd(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(45);
        }
        EditorUtil.scrollToTheEnd(editor2, false);
    }

    public static void scrollToTheEnd(@NotNull Editor editor2, boolean preferVerticalScroll) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(46);
        }
        editor2.getSelectionModel().removeSelection();
        Document document2 = editor2.getDocument();
        int lastLine = Math.max(0, document2.getLineCount() - 1);
        boolean caretWasAtLastLine = editor2.getCaretModel().getLogicalPosition().line == lastLine;
        editor2.getCaretModel().moveToOffset(document2.getTextLength());
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        if (preferVerticalScroll && document2.getLineStartOffset(lastLine) == document2.getLineEndOffset(lastLine)) {
            int scrollOffset;
            if (editor2 instanceof EditorEx) {
                JScrollBar verticalScrollBar = ((EditorEx)editor2).getScrollPane().getVerticalScrollBar();
                scrollOffset = verticalScrollBar.getMaximum() - verticalScrollBar.getModel().getExtent();
            } else {
                scrollOffset = editor2.getContentComponent().getHeight() - scrollingModel.getVisibleArea().height;
            }
            scrollingModel.scrollVertically(scrollOffset);
        } else if (!caretWasAtLastLine) {
            scrollingModel.scrollTo(new LogicalPosition(lastLine, 0), ScrollType.RELATIVE);
        } else {
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public static boolean isChangeFontSize(@NotNull MouseWheelEvent e) {
        if (e == null) {
            EditorUtil.$$$reportNull$$$0(47);
        }
        if (e.getWheelRotation() == 0) {
            return false;
        }
        return SystemInfo.isMac ? !e.isControlDown() && e.isMetaDown() && !e.isAltDown() && !e.isShiftDown() : e.isControlDown() && !e.isMetaDown() && !e.isAltDown() && !e.isShiftDown();
    }

    public static boolean isCaretInVirtualSpace(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(48);
        }
        return EditorUtil.inVirtualSpace(editor2, editor2.getCaretModel().getLogicalPosition());
    }

    public static boolean inVirtualSpace(@NotNull Editor editor2, @NotNull LogicalPosition logicalPosition) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(49);
        }
        if (logicalPosition == null) {
            EditorUtil.$$$reportNull$$$0(50);
        }
        return EditorCoreUtil.inVirtualSpace((Editor)editor2, (LogicalPosition)logicalPosition);
    }

    public static void reinitSettings() {
        EditorFactory.getInstance().refreshAllEditors();
    }

    @NotNull
    public static TextRange getSelectionInAnyMode(Editor editor2) {
        TextRange textRange = (TextRange)EditorThreading.compute(() -> {
            List carets = editor2.getCaretModel().getAllCarets();
            return ((Caret)carets.get(0)).getSelectionRange().union(((Caret)carets.get(carets.size() - 1)).getSelectionRange());
        });
        if (textRange == null) {
            EditorUtil.$$$reportNull$$$0(51);
        }
        return textRange;
    }

    public static int logicalToVisualLine(@NotNull Editor editor2, int logicalLine) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(52);
        }
        return (Integer)EditorThreading.compute(() -> {
            LogicalPosition logicalPosition = new LogicalPosition(logicalLine, 0);
            VisualPosition visualPosition = editor2.logicalToVisualPosition(logicalPosition);
            return visualPosition.line;
        });
    }

    @NotNull
    public static @NotNull Pair<@NotNull Interval, @Nullable Interval> logicalLineToYRange(@NotNull Editor editor2, int logicalLine) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(53);
        }
        if (logicalLine < 0) {
            throw new IllegalArgumentException("Logical line is negative: " + logicalLine);
        }
        Pair pair = (Pair)EditorThreading.compute(() -> {
            boolean topOverlapped;
            boolean bottomOverlapped;
            int startVisualLine;
            int endVisualLine;
            Document document2 = editor2.getDocument();
            if (logicalLine >= document2.getLineCount()) {
                startVisualLine = endVisualLine = EditorUtil.logicalToVisualLine(editor2, logicalLine);
                bottomOverlapped = false;
                topOverlapped = false;
            } else {
                int lineStartOffset = document2.getLineStartOffset(logicalLine);
                int lineEndOffset = document2.getLineEndOffset(logicalLine);
                FoldRegion foldRegion = editor2.getFoldingModel().getCollapsedRegionAtOffset(lineStartOffset);
                if (foldRegion instanceof CustomFoldRegion) {
                    int startY = editor2.visualLineToY(editor2.offsetToVisualLine(foldRegion.getStartOffset(), false));
                    TextRangeInterval interval = new TextRangeInterval(startY, startY + ((CustomFoldRegion)foldRegion).getHeightInPixels());
                    return Pair.create((Object)interval, foldRegion.getStartOffset() == document2.getLineStartOffset(logicalLine) && foldRegion.getEndOffset() == document2.getLineEndOffset(logicalLine) ? interval : null);
                }
                startVisualLine = editor2.offsetToVisualLine(lineStartOffset, false);
                endVisualLine = startVisualLine + editor2.getSoftWrapModel().getSoftWrapsForRange(lineStartOffset + 1, lineEndOffset - 1).size();
                topOverlapped = editor2.getFoldingModel().isOffsetCollapsed(lineStartOffset - 1);
                bottomOverlapped = logicalLine + 1 < document2.getLineCount() && editor2.getFoldingModel().isOffsetCollapsed(document2.getLineStartOffset(logicalLine + 1) - 1);
            }
            int lineHeight = editor2.getLineHeight();
            int startY = editor2.visualLineToY(startVisualLine);
            int endY = (endVisualLine == startVisualLine ? startY : editor2.visualLineToY(endVisualLine)) + lineHeight;
            int startYEx = topOverlapped ? startY + lineHeight : startY;
            int endYEx = bottomOverlapped ? endY - lineHeight : endY;
            return Pair.create((Object)new TextRangeInterval(startY, endY), (Object)(startYEx < endYEx ? new TextRangeInterval(startYEx, endYEx) : null));
        });
        if (pair == null) {
            EditorUtil.$$$reportNull$$$0(54);
        }
        return pair;
    }

    @NotNull
    public static Interval yToLogicalLineRange(@NotNull Editor editor2, int y) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(55);
        }
        Interval interval = (Interval)EditorThreading.compute(() -> {
            VisualLinesIterator iterator;
            int visualLine = editor2.yToVisualLine(y);
            if (editor2 instanceof EditorImpl && !(iterator = new VisualLinesIterator((EditorImpl)editor2, visualLine)).atEnd()) {
                return new TextRangeInterval(iterator.getStartLogicalLine(), iterator.getEndLogicalLine());
            }
            int startLogicalLine = editor2.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLine, (int)0, (boolean)false)).line;
            int endLogicalLine = editor2.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLine, (int)Integer.MAX_VALUE, (boolean)true)).line;
            return new TextRangeInterval(startLogicalLine, endLogicalLine);
        });
        if (interval == null) {
            EditorUtil.$$$reportNull$$$0(56);
        }
        return interval;
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor2, @NotNull MouseEvent event) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(57);
        }
        if (event == null) {
            EditorUtil.$$$reportNull$$$0(58);
        }
        return EditorUtil.yPositionToLogicalLine(editor2, event.getY());
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor2, @NotNull Point point) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(59);
        }
        if (point == null) {
            EditorUtil.$$$reportNull$$$0(60);
        }
        return EditorUtil.yPositionToLogicalLine(editor2, point.y);
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor2, int y) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(61);
        }
        return (Integer)EditorThreading.compute(() -> {
            int line = editor2 instanceof EditorImpl ? editor2.yToVisualLine(y) : y / editor2.getLineHeight();
            return editor2.visualToLogicalPosition((VisualPosition)new VisualPosition((int)line, (int)0)).line;
        });
    }

    public static int yToLogicalLineNoCustomRenderers(@NotNull Editor editor2, int y) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(62);
        }
        return (Integer)EditorThreading.compute(() -> {
            int visualLine = editor2.yToVisualLine(y);
            int visualLineStartY = editor2.visualLineToY(visualLine);
            if (y < visualLineStartY || y >= visualLineStartY + editor2.getLineHeight()) {
                return -1;
            }
            int line = editor2.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLine, (int)0)).line;
            Document document2 = editor2.getDocument();
            if (line < document2.getLineCount()) {
                int lineStartOffset = document2.getLineStartOffset(line);
                FoldRegion foldRegion = editor2.getFoldingModel().getCollapsedRegionAtOffset(lineStartOffset);
                if (foldRegion instanceof CustomFoldRegion) {
                    return -1;
                }
            }
            return line;
        });
    }

    public static boolean isAtLineEnd(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(63);
        }
        return (Boolean)EditorThreading.compute(() -> {
            Document document2 = editor2.getDocument();
            if (offset < 0 || offset > document2.getTextLength()) {
                return false;
            }
            int line = document2.getLineNumber(offset);
            return offset == document2.getLineEndOffset(line);
        });
    }

    public static void setSelectionExpandingFoldedRegionsIfNeeded(@NotNull Editor editor2, int startOffset, int endOffset) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(64);
        }
        EditorThreading.run(() -> {
            FoldRegion endFoldRegion;
            FoldingModel foldingModel = editor2.getFoldingModel();
            FoldRegion startFoldRegion = foldingModel.getCollapsedRegionAtOffset(startOffset);
            if (startFoldRegion != null && (startFoldRegion.getStartOffset() == startOffset || startFoldRegion.isExpanded())) {
                startFoldRegion = null;
            }
            if ((endFoldRegion = foldingModel.getCollapsedRegionAtOffset(endOffset)) != null && (endFoldRegion.getStartOffset() == endOffset || endFoldRegion.isExpanded())) {
                endFoldRegion = null;
            }
            if (startFoldRegion != null || endFoldRegion != null) {
                FoldRegion finalStartFoldRegion = startFoldRegion;
                FoldRegion finalEndFoldRegion = endFoldRegion;
                foldingModel.runBatchFoldingOperation(() -> {
                    if (finalStartFoldRegion != null) {
                        finalStartFoldRegion.setExpanded(true);
                    }
                    if (finalEndFoldRegion != null) {
                        finalEndFoldRegion.setExpanded(true);
                    }
                });
            }
            editor2.getSelectionModel().setSelection(startOffset, endOffset);
        });
    }

    public static Font getEditorFont() {
        return (Font)EditorThreading.compute(() -> {
            EditorColorsScheme scheme;
            Font editorFont;
            float fontSize = UISettingsUtils.getInstance().getScaledEditorFontSize();
            if (UISettings.getInstance().getPresentationMode()) {
                fontSize -= 4.0f;
            }
            if ((float)(editorFont = (scheme = EditorColorsManager.getInstance().getGlobalScheme()).getFont(EditorFontType.PLAIN)).getSize() != fontSize) {
                editorFont = editorFont.deriveFont(fontSize);
            }
            return UIUtil.getFontWithFallback((Font)editorFont);
        });
    }

    public static Font getEditorFont(int size2) {
        return (Font)EditorThreading.compute(() -> {
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            Font font = scheme.getFont(EditorFontType.PLAIN).deriveFont((float)size2);
            return UIUtil.getFontWithFallback((Font)font);
        });
    }

    public static int getDefaultCaretWidth() {
        return Registry.intValue((String)"editor.caret.width", (int)2);
    }

    public static int getSoftWrapCountAfterLineStart(@NotNull Editor editor2, @NotNull LogicalPosition position) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(65);
        }
        if (position == null) {
            EditorUtil.$$$reportNull$$$0(66);
        }
        return (Integer)EditorThreading.compute(() -> {
            int startOffset = editor2.getDocument().getLineStartOffset(position.line);
            int endOffset = editor2.logicalPositionToOffset(position);
            return editor2.getSoftWrapModel().getSoftWrapsForRange(startOffset, endOffset).size();
        });
    }

    public static boolean attributesImpactFontStyleOrColor(@Nullable TextAttributes attributes) {
        return attributes == TextAttributes.ERASE_MARKER || attributes != null && (attributes.getFontType() != 0 || attributes.getForegroundColor() != null);
    }

    public static boolean attributesImpactFontStyle(@Nullable TextAttributes attributes) {
        return attributes == TextAttributes.ERASE_MARKER || attributes != null && attributes.getFontType() != 0;
    }

    public static boolean attributesImpactForegroundColor(@Nullable TextAttributes attributes) {
        return attributes == TextAttributes.ERASE_MARKER || attributes != null && attributes.getForegroundColor() != null;
    }

    public static boolean isCurrentCaretPrimary(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(67);
        }
        return editor2.getCaretModel().getCurrentCaret() == editor2.getCaretModel().getPrimaryCaret();
    }

    public static void disposeWithEditor(@NotNull Editor editor2, @NotNull Disposable disposable) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(68);
        }
        if (disposable == null) {
            EditorUtil.$$$reportNull$$$0(69);
        }
        EditorThreading.run(() -> {
            if (editor2.isDisposed()) {
                Disposer.dispose((Disposable)disposable);
                return;
            }
            Editor hostEditor = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)editor2);
            if (hostEditor instanceof EditorImpl) {
                Disposer.register((Disposable)((EditorImpl)hostEditor).getDisposable(), (Disposable)disposable);
            } else {
                LOG.warn("Cannot watch for disposal of " + String.valueOf(editor2));
            }
        });
    }

    public static void runBatchFoldingOperationOutsideOfBulkUpdate(final @NotNull Editor editor2, final @NotNull Runnable operation2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(70);
        }
        if (operation2 == null) {
            EditorUtil.$$$reportNull$$$0(71);
        }
        if (editor2.getDocument().isInBulkUpdate()) {
            final Disposable disposable = Disposer.newDisposable();
            EditorUtil.disposeWithEditor(editor2, disposable);
            editor2.getDocument().addDocumentListener(new DocumentListener(){

                public void bulkUpdateFinished(@NotNull Document document2) {
                    if (document2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    editor2.getFoldingModel().runBatchFoldingOperation(operation2);
                    Disposer.dispose((Disposable)disposable);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/ex/util/EditorUtil$1", "bulkUpdateFinished"));
                }
            });
        } else {
            editor2.getFoldingModel().runBatchFoldingOperation(operation2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithAnimationDisabled(@NotNull Editor editor2, @NotNull Runnable taskWithScrolling) {
        ScrollingModel scrollingModel;
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(72);
        }
        if (taskWithScrolling == null) {
            EditorUtil.$$$reportNull$$$0(73);
        }
        if (!((scrollingModel = editor2.getScrollingModel()) instanceof ScrollingModelImpl)) {
            taskWithScrolling.run();
        } else {
            boolean animationWasEnabled = ((ScrollingModelImpl)scrollingModel).isAnimationEnabled();
            scrollingModel.disableAnimation();
            try {
                taskWithScrolling.run();
            }
            finally {
                if (animationWasEnabled) {
                    scrollingModel.enableAnimation();
                }
            }
        }
    }

    @NotNull
    public static String displayCharInEditor(char c, @NotNull TextAttributesKey textAttributesKey, @NotNull String fallback) {
        EditorColorsScheme scheme;
        TextAttributes textAttributes;
        if (textAttributesKey == null) {
            EditorUtil.$$$reportNull$$$0(74);
        }
        if (fallback == null) {
            EditorUtil.$$$reportNull$$$0(75);
        }
        int style = (textAttributes = (scheme = EditorColorsManager.getInstance().getGlobalScheme()).getAttributes(textAttributesKey)) != null ? textAttributes.getFontType() : 0;
        FontInfo fallbackFont = ComplementaryFontsRegistry.getFontAbleToDisplay(c, style, scheme.getFontPreferences(), null);
        String string = fallbackFont.canDisplay(c) ? String.valueOf(c) : fallback;
        if (string == null) {
            EditorUtil.$$$reportNull$$$0(76);
        }
        return string;
    }

    @NotNull
    public static VisualPosition inlayAwareOffsetToVisualPosition(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(77);
        }
        VisualPosition visualPosition = (VisualPosition)EditorThreading.compute(() -> {
            Inlay inlay;
            Editor e = editor2;
            LogicalPosition logicalPosition = e.offsetToLogicalPosition(offset);
            if (e instanceof EditorWindow) {
                logicalPosition = ((EditorWindow)e).injectedToHost(logicalPosition);
                e = ((EditorWindow)e).getDelegate();
            }
            VisualPosition pos = e.logicalToVisualPosition(logicalPosition);
            while ((inlay = e.getInlayModel().getInlineElementAt(pos)) != null && !inlay.isRelatedToPrecedingText()) {
                pos = new VisualPosition(pos.line, pos.column + 1);
            }
            return pos;
        });
        if (visualPosition == null) {
            EditorUtil.$$$reportNull$$$0(78);
        }
        return visualPosition;
    }

    public static int getTotalInlaysHeight(@NotNull List<? extends Inlay> inlays) {
        if (inlays == null) {
            EditorUtil.$$$reportNull$$$0(79);
        }
        int sum = 0;
        for (Inlay inlay : inlays) {
            sum += inlay.getHeightInPixels();
        }
        return sum;
    }

    public static int getInlaysHeight(@NotNull Editor editor2, int visualLine, boolean above) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(80);
        }
        return EditorUtil.getInlaysHeight(editor2.getInlayModel(), visualLine, above);
    }

    @ApiStatus.Internal
    public static int getInlaysHeight(@NotNull InlayModel inlayModel, int visualLine, boolean above) {
        if (inlayModel == null) {
            EditorUtil.$$$reportNull$$$0(81);
        }
        return EditorUtil.getTotalInlaysHeight(inlayModel.getBlockElementsForVisualLine(visualLine, above));
    }

    public static boolean isInlayFolded(@NotNull Inlay inlay) {
        if (inlay == null) {
            EditorUtil.$$$reportNull$$$0(82);
        }
        if (InlayModelImpl.showWhenFolded(inlay)) {
            return false;
        }
        return (Boolean)EditorThreading.compute(() -> {
            Editor editor2 = inlay.getEditor();
            Inlay.Placement placement = inlay.getPlacement();
            int offset = inlay.getOffset();
            if (placement == Inlay.Placement.AFTER_LINE_END) {
                offset = DocumentUtil.getLineEndOffset((int)offset, (Document)editor2.getDocument());
            } else if (!(placement != Inlay.Placement.ABOVE_LINE && placement != Inlay.Placement.BELOW_LINE || inlay.isRelatedToPrecedingText())) {
                --offset;
            }
            FoldingModel foldingModel = editor2.getFoldingModel();
            return foldingModel.isOffsetCollapsed(offset) || (placement == Inlay.Placement.INLINE || placement == Inlay.Placement.AFTER_LINE_END) && foldingModel.getCollapsedRegionAtOffset(offset - 1) instanceof CustomFoldRegion;
        });
    }

    public static int getVisualLineAreaStartY(@NotNull Editor editor2, int visualLine) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(83);
        }
        return (Integer)EditorThreading.compute(() -> editor2.visualLineToY(visualLine) - EditorUtil.getInlaysHeight(editor2, visualLine, true));
    }

    public static int getVisualLineAreaEndY(@NotNull Editor editor2, int visualLine) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(84);
        }
        return (Integer)EditorThreading.compute(() -> editor2.visualLineToYRange(visualLine)[1] + EditorUtil.getInlaysHeight(editor2, visualLine, false));
    }

    public static void addBulkSelectionListener(final @NotNull Editor editor2, final @NotNull SelectionListener listener2, @NotNull Disposable disposable) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(85);
        }
        if (listener2 == null) {
            EditorUtil.$$$reportNull$$$0(86);
        }
        if (disposable == null) {
            EditorUtil.$$$reportNull$$$0(87);
        }
        final Ref selectionBeforeBulkChange = new Ref();
        final Ref selectionChangedDuringBulkChange = new Ref();
        editor2.getSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (selectionBeforeBulkChange.isNull()) {
                    listener2.selectionChanged(e);
                } else {
                    selectionChangedDuringBulkChange.set((Object)Boolean.TRUE);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/ex/util/EditorUtil$2", "selectionChanged"));
            }
        }, disposable);
        editor2.getCaretModel().addCaretActionListener(new CaretActionListener(){

            public void beforeAllCaretsAction() {
                selectionBeforeBulkChange.set(this.getSelectionOffsets());
                selectionChangedDuringBulkChange.set(null);
            }

            public void afterAllCaretsAction() {
                if (!selectionChangedDuringBulkChange.isNull()) {
                    Pair beforeBulk = (Pair)selectionBeforeBulkChange.get();
                    Pair<int[], int[]> afterBulk = this.getSelectionOffsets();
                    listener2.selectionChanged(new SelectionEvent(editor2, (int[])beforeBulk.first, (int[])beforeBulk.second, (int[])afterBulk.first, (int[])afterBulk.second));
                }
                selectionBeforeBulkChange.set(null);
            }

            private Pair<int[], int[]> getSelectionOffsets() {
                return Pair.create((Object)editor2.getSelectionModel().getBlockSelectionStarts(), (Object)editor2.getSelectionModel().getBlockSelectionEnds());
            }
        }, disposable);
    }

    public static void performBeforeCommandEnd(final @NotNull Runnable task) {
        if (task == null) {
            EditorUtil.$$$reportNull$$$0(88);
        }
        if (!CommandProcessor.getInstance().isCommandInProgress()) {
            return;
        }
        final MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(CommandListener.TOPIC, (Object)new CommandListener(){

            public void beforeCommandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                task.run();
            }

            public void commandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(1);
                }
                connection.disconnect();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/EditorUtil$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeCommandFinished";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean isPrimaryCaretVisible(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(89);
        }
        return (Boolean)EditorThreading.compute(() -> {
            Rectangle visibleArea = editor2.getScrollingModel().getVisibleArea();
            Caret caret = editor2.getCaretModel().getPrimaryCaret();
            Point caretPoint = editor2.visualPositionToXY(caret.getVisualPosition());
            return visibleArea.contains(caretPoint);
        });
    }

    public static boolean isPointOverText(@NotNull Editor editor2, @NotNull Point point) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(90);
        }
        if (point == null) {
            EditorUtil.$$$reportNull$$$0(91);
        }
        return (Boolean)EditorThreading.compute(() -> {
            VisualPosition visualPosition = editor2.xyToVisualPosition(point);
            int visualLineStartY = editor2.visualLineToY(visualPosition.line);
            if (point.y < visualLineStartY || point.y >= visualLineStartY + editor2.getLineHeight()) {
                return false;
            }
            if (editor2.getSoftWrapModel().isInsideOrBeforeSoftWrap(visualPosition)) {
                return false;
            }
            LogicalPosition logicalPosition = editor2.visualToLogicalPosition(visualPosition);
            int offset = editor2.logicalPositionToOffset(logicalPosition);
            if (editor2.getFoldingModel().getCollapsedRegionAtOffset(offset) instanceof CustomFoldRegion) {
                return false;
            }
            if (!logicalPosition.equals((Object)editor2.offsetToLogicalPosition(offset))) {
                return false;
            }
            List inlays = editor2.getInlayModel().getInlineElementsInRange(offset, offset);
            if (!inlays.isEmpty()) {
                int relX;
                VisualPosition inlaysStart = editor2.offsetToVisualPosition(offset);
                if (inlaysStart.line == visualPosition.line && (relX = point.x - editor2.visualPositionToXY((VisualPosition)inlaysStart).x) >= 0 && relX < inlays.stream().mapToInt(i2 -> i2.getWidthInPixels()).sum()) {
                    return false;
                }
            }
            return true;
        });
    }

    public static void notifyMaxCarets(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(92);
        }
        Long lastTimeStamp = (Long)editor2.getUserData(EditorNotification.LAST_MAX_CARETS_NOTIFY_TIMESTAMP);
        long currentTimeStamp = System.currentTimeMillis();
        if (lastTimeStamp != null && currentTimeStamp - lastTimeStamp < 10000L) {
            return;
        }
        editor2.putUserData(EditorNotification.LAST_MAX_CARETS_NOTIFY_TIMESTAMP, (Object)currentTimeStamp);
        NotificationGroupManager.getInstance().getNotificationGroup("too.many.carets").createNotification(EditorBundle.message((String)"editor.max.carets.hint", (Object[])new Object[]{editor2.getCaretModel().getMaxCaretCount()}), NotificationType.INFORMATION).notify(editor2.getProject());
    }

    public static boolean checkMaxCarets(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(93);
        }
        return (Boolean)EditorThreading.compute(() -> {
            CaretModel caretModel = editor2.getCaretModel();
            if (caretModel.getCaretCount() >= caretModel.getMaxCaretCount()) {
                EditorUtil.notifyMaxCarets(editor2);
                return true;
            }
            return false;
        });
    }

    public static boolean isCaretInsideSelection(@Nullable Caret caret) {
        return (Boolean)EditorThreading.compute(() -> caret != null && caret.hasSelection() && caret.getOffset() >= caret.getSelectionStart() && caret.getOffset() <= caret.getSelectionEnd());
    }

    public static boolean contextMenuInvokedOutsideOfSelection(@NotNull AnActionEvent e) {
        if (e == null) {
            EditorUtil.$$$reportNull$$$0(94);
        }
        return (Boolean)EditorThreading.compute(() -> {
            if (!"EditorPopup".equals(e.getPlace())) {
                return false;
            }
            Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
            return editor2 != null && editor2.getSelectionModel().hasSelection() && !EditorUtil.isCaretInsideSelection((Caret)e.getData(CommonDataKeys.CARET));
        });
    }

    @NotNull
    public static DataContext getEditorDataContext(@NotNull Editor editor2) {
        DataContext context;
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(95);
        }
        if (CommonDataKeys.PROJECT.getData(context = DataManager.getInstance().getDataContext((Component)editor2.getContentComponent())) == editor2.getProject()) {
            DataContext dataContext2 = context;
            if (dataContext2 == null) {
                EditorUtil.$$$reportNull$$$0(96);
            }
            return dataContext2;
        }
        DataContext dataContext3 = CustomizedDataContext.withSnapshot((DataContext)context, sink -> {
            Project project2 = editor2.getProject();
            if (project2 != null) {
                sink.set(CommonDataKeys.PROJECT, (Object)project2);
            } else {
                sink.setNull(CommonDataKeys.PROJECT);
            }
        });
        if (dataContext3 == null) {
            EditorUtil.$$$reportNull$$$0(97);
        }
        return dataContext3;
    }

    public static boolean isBreakPointsOnLineNumbers() {
        return UISettings.getInstance().getShowBreakpointsOverLineNumbers() && !UISettings.getInstance().getPresentationMode() && !DistractionFreeModeController.isDistractionFreeModeEnabled();
    }

    public static boolean isBlockLikeCaret(@NotNull Caret caret) {
        if (caret == null) {
            EditorUtil.$$$reportNull$$$0(98);
        }
        return switch (caret.getVisualAttributes().getShape()) {
            default -> throw new MatchException(null, null);
            case CaretVisualAttributes.Shape.DEFAULT -> {
                if (caret.getEditor().isInsertMode() == caret.getEditor().getSettings().isBlockCursor()) {
                    yield true;
                }
                yield false;
            }
            case CaretVisualAttributes.Shape.BLOCK, CaretVisualAttributes.Shape.BOX, CaretVisualAttributes.Shape.UNDERSCORE -> true;
            case CaretVisualAttributes.Shape.BAR -> caret.getVisualAttributes().getThickness() > 0.5f;
        };
    }

    @ApiStatus.Internal
    @RequiresEdt
    public static void runWhenViewportReady(@NotNull EditorEx editor2, @NotNull Runnable scrollLambda) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(99);
        }
        if (scrollLambda == null) {
            EditorUtil.$$$reportNull$$$0(100);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorUtil.runWhenViewportReady(editor2, scrollLambda, () -> {
            Disposable disposable = Disposer.newDisposable();
            EditorUtil.disposeWithEditor(editor2, disposable);
            return disposable;
        });
    }

    @ApiStatus.Internal
    @RequiresEdt
    public static void runWhenViewportReady(@NotNull EditorEx editor2, @NotNull CoroutineScope awaitingScope, @NotNull Runnable scrollLambda) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(101);
        }
        if (awaitingScope == null) {
            EditorUtil.$$$reportNull$$$0(102);
        }
        if (scrollLambda == null) {
            EditorUtil.$$$reportNull$$$0(103);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorUtil.runWhenViewportReady(editor2, scrollLambda, () -> CoroutineScopeKt.asDisposable((CoroutineScope)awaitingScope));
    }

    private static void runWhenViewportReady(@NotNull EditorEx editor2, @NotNull Runnable scrollLambda, @NotNull Supplier<Disposable> lazyDisposable) {
        if (editor2 == null) {
            EditorUtil.$$$reportNull$$$0(104);
        }
        if (scrollLambda == null) {
            EditorUtil.$$$reportNull$$$0(105);
        }
        if (lazyDisposable == null) {
            EditorUtil.$$$reportNull$$$0(106);
        }
        ThreadingAssertions.assertEventDispatchThread();
        JViewport viewport = editor2.getScrollPane().getViewport();
        if (EditorUtil.isReady(viewport)) {
            scrollLambda.run();
        } else {
            Disposable disposable = lazyDisposable.get();
            ViewportReadyAwaiter awaiter = new ViewportReadyAwaiter(editor2.getComponent(), viewport, scrollLambda);
            Disposer.register((Disposable)disposable, (Disposable)awaiter);
        }
    }

    private static boolean isReady(@NotNull JViewport viewport) {
        if (viewport == null) {
            EditorUtil.$$$reportNull$$$0(107);
        }
        if (!viewport.isShowing()) {
            return false;
        }
        Dimension extentSize = viewport.getExtentSize();
        return extentSize.getWidth() != 0.0 && extentSize.getHeight() != 0.0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 33, 36, 51, 54, 56, 76, 78, 96, 97 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 10: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 33: 
            case 36: 
            case 51: 
            case 54: 
            case 56: 
            case 76: 
            case 78: 
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/EditorUtil";
                break;
            }
            case 25: 
            case 26: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalPair";
                break;
            }
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingModel";
                break;
            }
            case 47: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalPosition";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 60: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 69: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskWithScrolling";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributesKey";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlays";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlayModel";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 100: 
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollLambda";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "awaitingScope";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyDisposable";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/EditorUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fontForChar";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "calcSurroundingRange";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "logicalPairToTextRange";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionInAnyMode";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "logicalLineToYRange";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "yToLogicalLineRange";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "displayCharInEditor";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "inlayAwareOffsetToVisualPosition";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLastVisualLineColumnNumber";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineEndOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcVerticalScrollProportion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setVerticalScrollProportion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcRelativeCaretPosition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRelativeCaretPosition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillVirtualSpaceUntilCaret";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillVirtualSpaceUntil";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcColumnNumber";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fontForChar";
                break;
            }
            case 12: 
            case 33: 
            case 36: 
            case 51: 
            case 54: 
            case 56: 
            case 76: 
            case 78: 
            case 96: 
            case 97: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "charWidth";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSpaceWidth";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPlainSpaceWidth";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTabSize";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "nextTabStop";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "textWidthInColumns";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "textWidth";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calcCaretLineTextRange";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "calcCaretLineRange";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "calcSurroundingTextRange";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "calcSurroundingRange";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "logicalPairToTextRange";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoldedLineStartOffset";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoldedLineEndOffset";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "scrollToTheEnd";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isChangeFontSize";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isCaretInVirtualSpace";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "inVirtualSpace";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "logicalToVisualLine";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "logicalLineToYRange";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "yToLogicalLineRange";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "yPositionToLogicalLine";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "yToLogicalLineNoCustomRenderers";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isAtLineEnd";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "setSelectionExpandingFoldedRegionsIfNeeded";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getSoftWrapCountAfterLineStart";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isCurrentCaretPrimary";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "disposeWithEditor";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "runBatchFoldingOperationOutsideOfBulkUpdate";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "runWithAnimationDisabled";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "displayCharInEditor";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "inlayAwareOffsetToVisualPosition";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getTotalInlaysHeight";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getInlaysHeight";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isInlayFolded";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineAreaStartY";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineAreaEndY";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "addBulkSelectionListener";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "performBeforeCommandEnd";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "isPrimaryCaretVisible";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isPointOverText";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "notifyMaxCarets";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "checkMaxCarets";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "contextMenuInvokedOutsideOfSelection";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getEditorDataContext";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isBlockLikeCaret";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "runWhenViewportReady";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "isReady";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 33, 36, 51, 54, 56, 76, 78, 96, 97 -> new IllegalStateException(string);
        };
    }

    private static final class EditorNotification {
        private static final Key<Long> LAST_MAX_CARETS_NOTIFY_TIMESTAMP = Key.create((String)"last.max.carets.notify.timestamp");
        private static final long MAX_CARETS_NOTIFY_INTERVAL_MS = 10000L;

        private EditorNotification() {
        }
    }

    private record ViewportReadyAwaiter(JComponent editorComponent, JViewport viewport, Runnable onReady) implements ChangeListener,
    Disposable
    {
        ViewportReadyAwaiter(JComponent editorComponent, JViewport viewport, Runnable onReady) {
            viewport.addChangeListener(this);
            this.editorComponent = editorComponent;
            this.viewport = viewport;
            this.onReady = onReady;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (EditorUtil.isReady(this.viewport)) {
                Disposer.dispose((Disposable)this);
                this.editorComponent.validate();
                this.onReady.run();
            }
        }

        public void dispose() {
            this.viewport.removeChangeListener(this);
        }
    }
}

