/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainerKt;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/fileEditor/impl/TabMouseListener;", "Ljava/awt/event/MouseAdapter;", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "editorTabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/EditorWindow;Lcom/intellij/ui/tabs/impl/JBTabsImpl;)V", "actionClickCount", "", "mouseReleased", "", "e", "Ljava/awt/event/MouseEvent;", "mousePressed", "mouseClicked", "intellij.platform.ide.impl"})
final class TabMouseListener
extends MouseAdapter {
    @NotNull
    private final EditorWindow window;
    @NotNull
    private final JBTabsImpl editorTabs;
    private int actionClickCount;

    public TabMouseListener(@NotNull EditorWindow window, @NotNull JBTabsImpl editorTabs) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)editorTabs, (String)"editorTabs");
        this.window = window;
        this.editorTabs = editorTabs;
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!UIUtil.isCloseClick((MouseEvent)e, (int)502) || e.isConsumed()) {
            return;
        }
        TabInfo tabInfo = this.editorTabs.findInfo(e);
        if (tabInfo == null) {
            return;
        }
        TabInfo info = tabInfo;
        IdeEventQueue.blockNextEvents$default(IdeEventQueue.Companion.getInstance(), e, null, 2, null);
        if (e.isAltDown() && e.getButton() == 1) {
            List allTabInfos = this.editorTabs.getTabs();
            for (TabInfo tabInfo2 : allTabInfos) {
                if (Intrinsics.areEqual((Object)tabInfo2, (Object)info)) continue;
                FileEditorManagerImpl fileEditorManagerImpl = this.window.getManager();
                Object object = tabInfo2.getObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFile");
                fileEditorManagerImpl.closeFile((VirtualFile)object, this.window);
            }
        } else {
            FileEditorManagerImpl fileEditorManagerImpl = this.window.getManager();
            Object object = info.getObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFile");
            fileEditorManagerImpl.closeFile((VirtualFile)object, this.window);
        }
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Component deepestComponent;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!UIUtil.isActionClick((MouseEvent)e) || e.isConsumed()) {
            return;
        }
        if (e.getClickCount() == 1) {
            this.actionClickCount = 0;
        }
        if (!((deepestComponent = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY())) instanceof InplaceButton)) {
            int n = this.actionClickCount;
            this.actionClickCount = n + 1;
        }
        if (this.actionClickCount > 1 && this.actionClickCount % 2 == 0) {
            EditorTabbedContainerKt.access$doProcessDoubleClick(e, this.editorTabs, this.window);
        }
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        Object o;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!UIUtil.isActionClick((MouseEvent)e, (int)500) || !e.isMetaDown() && (SystemInfoRt.isMac || !e.isControlDown()) || e.isConsumed()) {
            return;
        }
        TabInfo tabInfo = this.editorTabs.findInfo(e);
        Object object = o = tabInfo != null ? tabInfo.getObject() : null;
        if (o instanceof VirtualFile) {
            ShowFilePathAction.show((VirtualFile)o, e);
        }
    }
}

