/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.BundledKeymapBean;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.openapi.keymap.impl.DefaultKeymapKt;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.MacOSDefaultKeymap;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ResourceUtil;
import com.intellij.util.system.OS;
import com.intellij.util.ui.UnixDesktopEnv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u0015\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001aJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001dJ\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lcom/intellij/openapi/keymap/impl/DefaultKeymap;", "", "<init>", "()V", "keymaps", "", "Lcom/intellij/openapi/keymap/Keymap;", "getKeymaps$intellij_platform_ide_impl", "()Ljava/util/List;", "nameToScheme", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "loadKeymap", "Lcom/intellij/openapi/keymap/impl/DefaultKeymapImpl;", "keymapName", "dataHolder", "Lcom/intellij/configurationStore/SchemeDataHolder;", "Lcom/intellij/openapi/keymap/impl/KeymapImpl;", "plugin", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "loadKeymap$intellij_platform_ide_impl", "addKeymap", "", "keymap", "removeKeymap", "removeKeymap$intellij_platform_ide_impl", "findScheme", "name", "findScheme$intellij_platform_ide_impl", "defaultKeymapName", "getDefaultKeymapName", "()Ljava/lang/String;", "getKeymapPresentableName", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultKeymap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultKeymap.kt\ncom/intellij/openapi/keymap/impl/DefaultKeymap\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,168:1\n13#2:169\n*S KotlinDebug\n*F\n+ 1 DefaultKeymap.kt\ncom/intellij/openapi/keymap/impl/DefaultKeymap\n*L\n80#1:169\n*E\n"})
public class DefaultKeymap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Keymap> keymaps = new ArrayList();
    @NotNull
    private final HashMap<String, Keymap> nameToScheme = new HashMap();

    public DefaultKeymap() {
        boolean filterKeymaps = !ApplicationManager.getApplication().isHeadlessEnvironment() && Boolean.parseBoolean(System.getProperty("keymap.current.os.only", "true"));
        LinkedHashMap filteredBeans = new LinkedHashMap();
        Ref.BooleanRef macosParentKeymapFound = new Ref.BooleanRef();
        LinkedHashMap macOsBeans = SystemInfoRt.isMac ? null : new LinkedHashMap();
        BundledKeymapBean.EP_NAME.processWithPluginDescriptor((arg_0, arg_1) -> DefaultKeymap._init_$lambda$0(filterKeymaps, macOsBeans, macosParentKeymapFound, filteredBeans, arg_0, arg_1));
        if (macosParentKeymapFound.element && macOsBeans != null) {
            filteredBeans.putAll(macOsBeans);
        }
        for (Map.Entry entry : ((Map)filteredBeans).entrySet()) {
            Object object;
            BundledKeymapBean bean = (BundledKeymapBean)entry.getKey();
            PluginDescriptor pluginDescriptor = (PluginDescriptor)entry.getValue();
            DefaultKeymap defaultKeymap = this;
            try {
                DefaultKeymap $this$_init__u24lambda_u241 = defaultKeymap;
                boolean bl = false;
                object = Result.constructor-impl((Object)((Object)$this$_init__u24lambda_u241.loadKeymap$intellij_platform_ide_impl(DefaultKeymapKt.getKeymapName(bean), (SchemeDataHolder<? super KeymapImpl>)((SchemeDataHolder)new SchemeDataHolder<KeymapImpl>(bean, pluginDescriptor){
                    final /* synthetic */ BundledKeymapBean $bean;
                    final /* synthetic */ PluginDescriptor $pluginDescriptor;
                    {
                        this.$bean = $bean;
                        this.$pluginDescriptor = $pluginDescriptor;
                    }

                    public Element read() {
                        String effectiveFile = DefaultKeymapKt.getEffectiveFile(this.$bean);
                        byte[] data2 = ResourceUtil.getResourceAsBytes((String)effectiveFile, (ClassLoader)this.$pluginDescriptor.getClassLoader(), (boolean)true);
                        if (data2 == null) {
                            throw new PluginException("Cannot find " + effectiveFile, this.$pluginDescriptor.getPluginId());
                        }
                        Element element = JDOMUtil.load((byte[])data2);
                        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
                        return element;
                    }
                }), pluginDescriptor)));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DefaultKeymap.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LoggerKt.getOrLogException((Object)object, (Logger)logger);
        }
    }

    @NotNull
    public final List<Keymap> getKeymaps$intellij_platform_ide_impl() {
        return this.keymaps;
    }

    @NotNull
    public final DefaultKeymapImpl loadKeymap$intellij_platform_ide_impl(@NotNull String keymapName, @NotNull SchemeDataHolder<? super KeymapImpl> dataHolder, @NotNull PluginDescriptor plugin) {
        Intrinsics.checkNotNullParameter((Object)keymapName, (String)"keymapName");
        Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        DefaultKeymapImpl keymap2 = StringsKt.startsWith$default((String)keymapName, (String)"Mac OS X", (boolean)false, (int)2, null) ? (DefaultKeymapImpl)new MacOSDefaultKeymap(dataHolder, this, plugin) : new DefaultKeymapImpl(dataHolder, this, plugin);
        keymap2.setName(keymapName);
        this.addKeymap(keymap2);
        return keymap2;
    }

    private final void addKeymap(DefaultKeymapImpl keymap2) {
        this.keymaps.add(keymap2);
        ((Map)this.nameToScheme).put(keymap2.getName(), keymap2);
    }

    public final void removeKeymap$intellij_platform_ide_impl(@NotNull String keymapName) {
        Intrinsics.checkNotNullParameter((Object)keymapName, (String)"keymapName");
        Keymap removed = this.nameToScheme.remove(keymapName);
        TypeIntrinsics.asMutableCollection((Object)this.keymaps).remove(removed);
    }

    @Nullable
    public final Keymap findScheme$intellij_platform_ide_impl(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.nameToScheme.get(name2);
    }

    @NotNull
    public String getDefaultKeymapName() {
        return OS.CURRENT == OS.macOS ? "Mac OS X 10.5+" : (UnixDesktopEnv.CURRENT == UnixDesktopEnv.GNOME ? "Default for GNOME" : (UnixDesktopEnv.CURRENT == UnixDesktopEnv.KDE ? "Default for KDE" : (OS.isGenericUnix() ? "Default for XWin" : "$default")));
    }

    @NotNull
    public String getKeymapPresentableName(@NotNull KeymapImpl keymap2) {
        Intrinsics.checkNotNullParameter((Object)((Object)keymap2), (String)"keymap");
        return switch (keymap2.getName()) {
            case "Mac OS X 10.5+" -> "macOS";
            case "$default" -> "Windows";
            case "Default for GNOME" -> "GNOME";
            case "Default for KDE" -> "KDE";
            case "Default for XWin" -> "XWin";
            case "Mac OS X" -> "IntelliJ IDEA Classic" + (SystemInfoRt.isMac ? "" : " (macOS)");
            case "NetBeans 6.5" -> "NetBeans";
            default -> {
                String name;
                String newName = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)name, (CharSequence)" (Mac OS X)"), (CharSequence)" OSX");
                yield StringsKt.removePrefix((String)(newName == name ? name : newName + " (macOS)"), (CharSequence)(DefaultKeymapKt.access$osName() + "/"));
            }
        };
    }

    private static final Unit _init_$lambda$0(boolean $filterKeymaps, LinkedHashMap $macOsBeans, Ref.BooleanRef $macosParentKeymapFound, LinkedHashMap $filteredBeans, BundledKeymapBean bean, PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNull((Object)bean);
        String keymapName = DefaultKeymapKt.getKeymapName(bean);
        if (!($filterKeymaps && pluginDescriptor.isBundled() && Companion.isBundledKeymapHidden(keymapName))) {
            LinkedHashMap linkedHashMap;
            boolean isMacOsBean;
            boolean bl = isMacOsBean = $filterKeymaps && !pluginDescriptor.isBundled() && $macOsBeans != null && DefaultKeymapKt.access$isKnownMacOSKeymap(keymapName);
            if (isMacOsBean) {
                boolean bl2 = $macosParentKeymapFound.element = $macosParentKeymapFound.element || Intrinsics.areEqual((Object)keymapName, (Object)"Mac OS X 10.5+");
            }
            if (isMacOsBean) {
                LinkedHashMap linkedHashMap2 = $macOsBeans;
                linkedHashMap = linkedHashMap2;
                Intrinsics.checkNotNull((Object)linkedHashMap2);
            } else {
                linkedHashMap = $filteredBeans;
            }
            linkedHashMap.put(bean, pluginDescriptor);
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final DefaultKeymap getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/keymap/impl/DefaultKeymap$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/keymap/impl/DefaultKeymap;", "isBundledKeymapHidden", "", "keymapName", "", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nDefaultKeymap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultKeymap.kt\ncom/intellij/openapi/keymap/impl/DefaultKeymap$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,168:1\n42#2,3:169\n*S KotlinDebug\n*F\n+ 1 DefaultKeymap.kt\ncom/intellij/openapi/keymap/impl/DefaultKeymap$Companion\n*L\n30#1:169,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DefaultKeymap getInstance() {
            boolean $i$f$service = false;
            Class<DefaultKeymap> serviceClass$iv = DefaultKeymap.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (DefaultKeymap)object;
        }

        public final boolean isBundledKeymapHidden(@Nullable String keymapName) {
            return (SystemInfoRt.isWindows || SystemInfoRt.isMac) && DefaultKeymapKt.access$isKnownLinuxKeymap(keymapName) || !SystemInfoRt.isMac && DefaultKeymapKt.access$isKnownMacOSKeymap(keymapName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

