/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorTreeRendererContextProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurableTreeRenderer;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.options.ex.Weighted;
import com.intellij.openapi.options.newEditor.ConfigurableMarkerProvider;
import com.intellij.openapi.options.newEditor.ConfigurableProjectProvider;
import com.intellij.openapi.options.newEditor.CopySettingsPathAction;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.FilteringTreeModel;
import com.intellij.ui.tree.ui.Control;
import com.intellij.ui.tree.ui.DefaultControl;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class SettingsTreeView
extends JComponent
implements Accessible,
Disposable,
OptionsEditorColleague {
    private static final int ICON_GAP = 5;
    private static final String NODE_ICON = "settings.tree.view.icon";
    private static final Color WRONG_CONTENT = JBColor.namedColor((String)"Tree.errorForeground", (Color)JBColor.RED);
    private static final Color MODIFIED_CONTENT = JBColor.namedColor((String)"Tree.modifiedItemForeground", (Color)JBColor.BLUE);
    private final SimpleTree myTree;
    private final SettingsFilter myFilter;
    private final JScrollPane myScroller;
    private final Map<Configurable, MyNode> myConfigurableToNodeMap;
    private final MergingUpdateQueue myQueue;
    private final MyRoot myRoot;
    private final FilteringTreeModel myModel;
    private Configurable myQueuedConfigurable;
    private MyControl myControl;

    public SettingsTreeView(@NotNull SettingsFilter filter2, @NotNull List<? extends ConfigurableGroup> groups) {
        if (filter2 == null) {
            SettingsTreeView.$$$reportNull$$$0(0);
        }
        if (groups == null) {
            SettingsTreeView.$$$reportNull$$$0(1);
        }
        this.myConfigurableToNodeMap = new IdentityHashMap<Configurable, MyNode>();
        this.myQueue = new MergingUpdateQueue("SettingsTreeView", 150, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this).setRestartTimerOnAdd(true);
        this.myFilter = filter2;
        this.myTree = new MyTree();
        this.myTree.putClientProperty((Object)RenderingUtil.ALWAYS_PAINT_SELECTION_AS_FOCUSED, (Object)true);
        this.myTree.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myTree.getInputMap().clear();
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.setOpaque(true);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new MyRenderer());
        this.myTree.setRootVisible(false);
        this.myTree.setExpandableItemsEnabled(false);
        RelativeFont.BOLD.install((Component)this.myTree);
        SettingsTreeView.setComponentPopupMenuTo((JTree)this.myTree);
        this.myTree.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                return ArrayUtil.contains((Object)DataFlavor.stringFlavor, (Object[])transferFlavors);
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                try {
                    String value = (String)ObjectUtils.tryCast((Object)t.getTransferData(DataFlavor.stringFlavor), String.class);
                    if (value == null) {
                        return false;
                    }
                    SettingsTreeView.this.myFilter.setFilterText(value);
                    return true;
                }
                catch (UnsupportedFlavorException | IOException e) {
                    return false;
                }
            }

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                return SettingsTreeView.createTransferable(SettingsTreeView.this.myTree.getSelectionPath());
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        this.myScroller = ScrollPaneFactory.createScrollPane(null, (boolean)true);
        this.myScroller.setViewport((JViewport)((Object)new GradientViewport((Component)this.myTree, (Insets)JBUI.insetsTop((int)5), true){
            private JLabel myHeader;

            @Override
            protected Component getHeader() {
                if (0 == SettingsTreeView.this.myTree.getY()) {
                    return null;
                }
                if (this.myHeader == null) {
                    this.myHeader = new JLabel();
                    this.myHeader.setForeground(UIUtil.getTreeForeground());
                    this.myHeader.setIconTextGap(JBUIScale.scale((int)5));
                    this.myHeader.setBorder((Border)JBUI.Borders.empty((int)2, (int)(10 + SettingsTreeView.getLeftMargin(0)), (int)0, (int)0));
                }
                this.myHeader.setFont(SettingsTreeView.this.myTree.getFont());
                this.myHeader.setIcon(SettingsTreeView.this.getIcon(null, false));
                int height = this.myHeader.getPreferredSize().height;
                String group2 = SettingsTreeView.this.findGroupNameAt(0, height + 3);
                if (group2 == null || !group2.equals(SettingsTreeView.this.findGroupNameAt(0, 0))) {
                    return null;
                }
                this.myHeader.setText(group2);
                return this.myHeader;
            }
        }));
        this.myScroller.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myScroller.getViewport().setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myScroller.getVerticalScrollBar().setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myScroller.setHorizontalScrollBarPolicy(31);
        this.add(this.myScroller);
        this.myTree.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TreeUtil.invalidateCacheAndRepaint((TreeUI)SettingsTreeView.this.myTree.getUI());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                TreeUtil.invalidateCacheAndRepaint((TreeUI)SettingsTreeView.this.myTree.getUI());
            }

            @Override
            public void componentShown(ComponentEvent e) {
                TreeUtil.invalidateCacheAndRepaint((TreeUI)SettingsTreeView.this.myTree.getUI());
            }
        });
        this.myTree.getSelectionModel().addTreeSelectionListener(event -> {
            MyNode node = SettingsTreeView.extractNode(event.getNewLeadSelectionPath());
            this.fireSelected(node == null ? null : node.myConfigurable);
        });
        this.myRoot = new MyRoot(groups);
        SimpleTreeStructure.Impl structure = new SimpleTreeStructure.Impl((SimpleNode)this.myRoot);
        this.myModel = FilteringTreeModel.createModel((AbstractTreeStructure)structure, this.myFilter, this);
        this.myFilter.addListener((preferredSelection, adjustSelection, now) -> {
            this.myModel.updateTree((JTree)this.myTree, !this.myFilter.isEmptyFilter(), preferredSelection);
            return Promises.resolvedPromise();
        }, this);
        this.myTree.setModel((TreeModel)((Object)new AsyncTreeModel((TreeModel)((Object)this.myModel), this)));
        this.myTree.getAccessibleContext().setAccessibleName(UIBundle.message((String)"settings.tree.settings.categories.accessible.name", (Object[])new Object[0]));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.myControl = null;
    }

    @ApiStatus.Internal
    @NotNull
    public SimpleTree getTree() {
        SimpleTree simpleTree = this.myTree;
        if (simpleTree == null) {
            SettingsTreeView.$$$reportNull$$$0(2);
        }
        return simpleTree;
    }

    private Icon getIcon(@Nullable DefaultMutableTreeNode node, boolean selected) {
        if (this.myControl == null) {
            this.myControl = new MyControl();
        }
        if (node == null || 0 == node.getChildCount()) {
            return this.myControl.empty;
        }
        if (selected && !ColorUtil.isDark((Color)JBUI.CurrentTheme.Tree.BACKGROUND) && !ColorUtil.isDark((Color)RenderingUtil.getSelectionBackground((JTree)this.myTree))) {
            selected = false;
        }
        return this.myTree.isExpanded(new TreePath(node.getPath())) ? this.myControl.expanded.apply(selected) : this.myControl.collapsed.apply(selected);
    }

    private static void setComponentPopupMenuTo(final JTree tree2) {
        tree2.setComponentPopupMenu(new JPopupMenu(){
            @Nullable
            private Collection<String> names;

            @Override
            public void show(Component invoker, int x, int y) {
                this.names = null;
                if (invoker != tree2) {
                    return;
                }
                TreePath path = tree2.getClosestPathForLocation(x, y);
                this.names = SettingsTreeView.getPathNames(SettingsTreeView.extractNode(path));
                if (this.names.isEmpty()) {
                    return;
                }
                Rectangle bounds = tree2.getPathBounds(path);
                if (bounds == null || bounds.y > y) {
                    return;
                }
                bounds.y += bounds.height;
                if (bounds.y < y) {
                    return;
                }
                DefaultActionGroup group2 = new DefaultActionGroup();
                for (Action action2 : CopySettingsPathAction.createSwingActions(() -> this.names)) {
                    group2.add(ActionUtil.createActionFromSwingAction((Action)action2, (boolean)true));
                }
                JPopupMenu popup2 = ActionManager.getInstance().createActionPopupMenu("settings", (ActionGroup)group2).getComponent();
                popup2.show(invoker, x, bounds.y);
            }
        });
    }

    @Nullable
    Transferable createTransferable(@Nullable InputEvent event) {
        if (event instanceof MouseEvent) {
            MouseEvent mouse = (MouseEvent)event;
            Point location = mouse.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(location, (Component)this.myTree);
            return SettingsTreeView.createTransferable(this.myTree.getClosestPathForLocation(location.x, location.y));
        }
        return SettingsTreeView.createTransferable(this.myTree.getSelectionPath());
    }

    @Nullable
    private static Transferable createTransferable(@Nullable TreePath path) {
        return CopySettingsPathAction.createTransferable(SettingsTreeView.getPathNames(SettingsTreeView.extractNode(path)));
    }

    @NotNull Collection<@NlsContexts.ConfigurableName String> getPathNames(Configurable configurable) {
        return SettingsTreeView.getPathNames(this.findNode(configurable));
    }

    private static @NotNull Collection<@NlsContexts.ConfigurableName String> getPathNames(@Nullable MyNode node) {
        if (node == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                SettingsTreeView.$$$reportNull$$$0(3);
            }
            return list2;
        }
        ArrayDeque<String> path = new ArrayDeque<String>();
        while (node != null) {
            path.push(node.myDisplayName);
            SimpleNode parent = node.getParent();
            node = parent instanceof MyNode ? (MyNode)parent : null;
        }
        ArrayDeque<String> arrayDeque = path;
        if (arrayDeque == null) {
            SettingsTreeView.$$$reportNull$$$0(4);
        }
        return arrayDeque;
    }

    @ApiStatus.Internal
    public static Configurable getConfigurable(SimpleNode node) {
        return node instanceof MyNode ? ((MyNode)node).myConfigurable : null;
    }

    @Nullable
    MyNode findNode(Configurable configurable) {
        MyNode result2 = this.myConfigurableToNodeMap.get(configurable);
        if (result2 != null || !(configurable instanceof ConfigurableWrapper)) {
            return result2;
        }
        ConfigurableEP<?> ep = ((ConfigurableWrapper)configurable).getExtensionPoint();
        Configurable confKey = (Configurable)ContainerUtil.find(this.myConfigurableToNodeMap.keySet(), key -> key instanceof ConfigurableWrapper && ((ConfigurableWrapper)key).getExtensionPoint() == ep);
        if (confKey == null) {
            return null;
        }
        return this.myConfigurableToNodeMap.get(confKey);
    }

    @Nullable
    Project findConfigurableProject(@Nullable Configurable configurable) {
        MyNode node = this.findNode(configurable);
        return node == null ? null : SettingsTreeView.findConfigurableProject(node);
    }

    @Nullable
    private static Project findConfigurableProject(@NotNull MyNode node) {
        if (node == null) {
            SettingsTreeView.$$$reportNull$$$0(5);
        }
        Configurable configurable = node.myConfigurable;
        Project project2 = node.getProject();
        Configurable.VariableProjectAppLevel wrapped = ConfigurableWrapper.cast(Configurable.VariableProjectAppLevel.class, (UnnamedConfigurable)configurable);
        if (wrapped != null) {
            return wrapped.isProjectLevel() ? project2 : null;
        }
        if (configurable instanceof ConfigurableWrapper) {
            return project2;
        }
        if (configurable instanceof SortedConfigurableGroup) {
            return project2;
        }
        SimpleNode parent = node.getParent();
        return parent instanceof MyNode ? SettingsTreeView.findConfigurableProject((MyNode)parent) : null;
    }

    @ApiStatus.Internal
    @Nullable
    public static Project prepareProject(@Nullable CachingSimpleNode parent, @Nullable Configurable configurable) {
        SortedConfigurableGroup group2;
        Configurable[] configurables2;
        if (configurable instanceof ConfigurableWrapper) {
            ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable;
            return wrapper2.getExtensionPoint().getProject();
        }
        if (configurable instanceof SortedConfigurableGroup && (configurables2 = (group2 = (SortedConfigurableGroup)configurable).getConfigurables()).length != 0) {
            Project project2 = SettingsTreeView.prepareProject(parent, configurables2[0]);
            if (project2 != null) {
                for (int i2 = 1; i2 < configurables2.length; ++i2) {
                    if (project2 == SettingsTreeView.prepareProject(parent, configurables2[i2])) continue;
                    return null;
                }
            }
            return project2;
        }
        if (configurable instanceof ConfigurableProjectProvider) {
            return ((ConfigurableProjectProvider)configurable).getProject();
        }
        return parent == null ? null : parent.getProject();
    }

    private static int getLeftMargin(int level) {
        return 3 + level * 16;
    }

    @NlsContexts.ConfigurableName
    @Nullable
    private String findGroupNameAt(int x, int y) {
        for (TreePath path = this.myTree.getClosestPathForLocation(x - this.myTree.getX(), y - this.myTree.getY()); path != null; path = path.getParentPath()) {
            MyNode node = SettingsTreeView.extractNode(path);
            if (node == null) {
                return null;
            }
            if (!(node.getParent() instanceof MyRoot)) continue;
            return node.myDisplayName;
        }
        return null;
    }

    @Nullable
    private static MyNode extractNode(@Nullable Object object) {
        DefaultMutableTreeNode node;
        if (object instanceof TreePath) {
            TreePath path = (TreePath)object;
            object = path.getLastPathComponent();
        }
        if (object instanceof DefaultMutableTreeNode) {
            node = (DefaultMutableTreeNode)object;
            object = node.getUserObject();
        }
        if (object instanceof FilteringTreeStructure.FilteringNode) {
            node = (FilteringTreeStructure.FilteringNode)object;
            object = node.getDelegate();
        }
        return object instanceof MyNode ? (MyNode)((Object)object) : null;
    }

    @Override
    public void doLayout() {
        this.myScroller.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    @NotNull
    Promise<? super Object> select(final @Nullable Configurable configurable) {
        final AsyncPromise promise = new AsyncPromise();
        this.myQueuedConfigurable = configurable;
        this.myQueue.queue(new Update(this){

            public void run() {
                if (configurable != SettingsTreeView.this.myQueuedConfigurable) {
                    return;
                }
                Runnable handler = () -> SettingsTreeView.this.fireSelected(configurable).processed((Promise)promise);
                if (configurable == null) {
                    handler.run();
                    return;
                }
                MyNode editorNode = SettingsTreeView.this.findNode(configurable);
                FilteringTreeStructure.FilteringNode editorUiNode = ((FilteringTreeStructure)SettingsTreeView.this.myModel.getTreeStructure()).getVisibleNodeFor((Object)editorNode);
                if (editorUiNode == null) {
                    return;
                }
                SettingsTreeView.this.myModel.select(editorUiNode, (JTree)SettingsTreeView.this.myTree, treePath -> handler.run());
            }

            public void setRejected() {
                super.setRejected();
                promise.cancel();
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            SettingsTreeView.$$$reportNull$$$0(6);
        }
        return asyncPromise;
    }

    @NotNull
    private Promise<?> fireSelected(Configurable configurable) {
        Promise<?> promise = this.myFilter.context.fireSelected(configurable, this);
        if (promise == null) {
            SettingsTreeView.$$$reportNull$$$0(7);
        }
        return promise;
    }

    public void dispose() {
        this.myQueuedConfigurable = null;
        this.myConfigurableToNodeMap.clear();
    }

    @Override
    @NotNull
    public Promise<? super Object> onSelected(@Nullable Configurable configurable, Configurable oldConfigurable) {
        Promise<? super Object> promise = this.select(configurable);
        if (promise == null) {
            SettingsTreeView.$$$reportNull$$$0(8);
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise<? super Object> onModifiedAdded(Configurable configurable) {
        this.myTree.repaint();
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            SettingsTreeView.$$$reportNull$$$0(9);
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise<? super Object> onModifiedRemoved(Configurable configurable) {
        this.myTree.repaint();
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            SettingsTreeView.$$$reportNull$$$0(10);
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise<? super Object> onErrorsChanged() {
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            SettingsTreeView.$$$reportNull$$$0(11);
        }
        return promise;
    }

    private static boolean isBeta(Configurable c) {
        ConfigurableWrapper w;
        return c instanceof Configurable.Beta || c instanceof ConfigurableWrapper && (w = (ConfigurableWrapper)c).getConfigurable() instanceof Configurable.Beta;
    }

    @Nullable
    private static Configurable.Promo asPromo(Configurable c) {
        ConfigurableWrapper w;
        if (c instanceof Configurable.Promo) {
            return (Configurable.Promo)c;
        }
        if (c instanceof ConfigurableWrapper && (w = (ConfigurableWrapper)c).getConfigurable() instanceof Configurable.Promo) {
            return (Configurable.Promo)w.getConfigurable();
        }
        return null;
    }

    protected void setProjectIcon(JLabel projectIcon, Configurable configurable, @Nullable Project project2, boolean selected) {
        if (project2 != null) {
            projectIcon.setIcon(AllIcons.General.ProjectConfigurable);
            projectIcon.setToolTipText(project2.isDefault() ? IdeUICustomization.getInstance().projectMessage("configurable.default.project.tooltip", new Object[0]) : IdeUICustomization.getInstance().projectMessage("configurable.current.project.tooltip", new Object[0]));
            projectIcon.setVisible(true);
        } else {
            projectIcon.setVisible(false);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSettingsTreeView();
        }
        return this.accessibleContext;
    }

    void reloadWithSelection(@Nullable Configurable toSelect) {
        this.myRoot.cleanUpCache();
        this.myQueuedConfigurable = null;
        this.myQueue.cancelAllUpdates();
        this.myConfigurableToNodeMap.clear();
        this.myTree.getSelectionModel().clearSelection();
        this.myTree.collapsePath(new TreePath(this.myTree.getModel().getRoot()));
        ((FilteringTreeStructure)this.myModel.getTreeStructure()).rebuild();
        ((FilteringTreeStructure)this.myModel.getTreeStructure()).refilter();
        this.myModel.invalidateAsync().thenRun(() -> {
            MyNode node = this.findNode(toSelect);
            if (node != null) {
                FilteringTreeStructure.FilteringNode filteringNode = ((FilteringTreeStructure)this.myModel.getTreeStructure()).getVisibleNodeFor((Object)node);
                this.myModel.select(filteringNode, (JTree)this.myTree, treePath -> {});
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/newEditor/SettingsTreeView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsTreeView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fireSelected";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "onSelected";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "onModifiedAdded";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "onModifiedRemoved";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "onErrorsChanged";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurableProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    private final class MyTree
    extends SimpleTree {
        private MyTree() {
        }

        public String getToolTipText(MouseEvent event) {
            String text2;
            JLabel label2;
            Component component2;
            if (event != null && (component2 = this.getDeepestRendererComponentAt(event.getX(), event.getY())) instanceof JLabel && (label2 = (JLabel)component2).getIcon() != null && (text2 = label2.getToolTipText()) != null) {
                return text2;
            }
            return super.getToolTipText(event);
        }

        protected boolean paintNodes() {
            return false;
        }

        public void setUI(TreeUI ui) {
            super.setUI((TreeUI)(ui instanceof MyTreeUi ? ui : new MyTreeUi()));
            this.setRowHeight(UIManager.getInt("SettingsTree.rowHeight"));
        }

        protected void configureUiHelper(TreeUIHelper helper) {
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        protected void processMouseEvent(MouseEvent event) {
            MyTreeUi ui = (MyTreeUi)((Object)SettingsTreeView.this.myTree.getUI());
            if (!ui.processMouseEvent(event)) {
                super.processMouseEvent(event);
            }
        }
    }

    private final class MyRenderer
    extends CellRendererPanel
    implements TreeCellRenderer,
    UiInspectorTreeRendererContextProvider {
        final SimpleColoredComponent myTextLabel = new SimpleColoredComponent();
        final JLabel myNodeIcon = new JLabel();
        final JLabel myProjectIcon = new JLabel();
        Pair<Component, ConfigurableTreeRenderer.Layout> myRenderInfo;

        MyRenderer() {
            this.setLayout(new BorderLayout(JBUIScale.scale((int)4), 0));
            this.myNodeIcon.setName(SettingsTreeView.NODE_ICON);
            this.myTextLabel.setOpaque(false);
            this.myTextLabel.setIpad((Insets)JBInsets.create((int)1, (int)0));
            this.add("Center", (Component)this.myTextLabel);
            this.add("West", this.myNodeIcon);
            this.add("East", this.myProjectIcon);
            this.setBorder((Border)JBUI.Borders.empty((int)2, (int)10));
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new MyAccessibleContext();
            }
            return this.accessibleContext;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean focused) {
            Configurable.Promo promo;
            String label2;
            this.myTextLabel.clear();
            this.myTextLabel.setIconOnTheRight(false);
            this.setPreferredSize(null);
            MyNode node = SettingsTreeView.extractNode(value);
            boolean isGroup = node != null && node.getParent() instanceof MyRoot;
            String name2 = node != null ? node.myDisplayName : String.valueOf(value);
            this.myTextLabel.append(name2, isGroup ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.myTextLabel.setFont(isGroup ? SettingsTreeView.this.myTree.getFont() : StartupUiUtil.getLabelFont());
            this.myTextLabel.setForeground(selected ? UIUtil.getTreeSelectionForeground((boolean)true) : UIUtil.getTreeForeground());
            if (!selected && node != null) {
                Configurable configurable = node.myConfigurable;
                if (SettingsTreeView.this.myFilter.context.getErrors().containsKey(configurable)) {
                    this.myTextLabel.setForeground(WRONG_CONTENT);
                } else if (SettingsTreeView.this.myFilter.context.getModified().contains(configurable)) {
                    this.myTextLabel.setForeground(MODIFIED_CONTENT);
                }
            }
            Project project2 = node != null ? SettingsTreeView.findConfigurableProject(node) : null;
            Configurable configurable = node != null ? node.myConfigurable : null;
            SettingsTreeView.this.setProjectIcon(this.myProjectIcon, configurable, project2, selected);
            this.prepareRenderer(node != null, node, (UnnamedConfigurable)configurable, selected);
            Icon nodeIcon = value instanceof DefaultMutableTreeNode ? SettingsTreeView.this.getIcon((DefaultMutableTreeNode)value, selected) : null;
            this.myNodeIcon.setIcon(nodeIcon);
            if (configurable instanceof ConfigurableMarkerProvider && (label2 = ((ConfigurableMarkerProvider)configurable).getMarkerText()) != null) {
                this.myTextLabel.append("   ", SimpleTextAttributes.REGULAR_ATTRIBUTES, false);
                this.myTextLabel.append(label2, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES, false);
            }
            if (SettingsTreeView.isBeta(configurable)) {
                this.myTextLabel.setIconOnTheRight(true);
                this.myTextLabel.setIconTextGap(JBUIScale.scale((int)8));
                this.myTextLabel.setIcon(AllIcons.General.Beta);
            }
            if ((promo = SettingsTreeView.asPromo(configurable)) != null) {
                this.myTextLabel.setIconOnTheRight(true);
                this.myTextLabel.setIconTextGap(JBUIScale.scale((int)8));
                this.myTextLabel.setIcon(promo.getPromoIcon());
            }
            if (node != null && UISettings.getInstance().getShowInplaceCommentsInternal()) {
                ConfigurableWrapper wrapper2;
                ConfigurableWrapper configurableWrapper = wrapper2 = configurable instanceof ConfigurableWrapper ? (ConfigurableWrapper)configurable : null;
                @NonNls String id2 = wrapper2 != null ? wrapper2.getId() : (configurable instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable).getId() : configurable.getClass().getSimpleName());
                PluginDescriptor plugin = wrapper2 != null ? wrapper2.getExtensionPoint().getPluginDescriptor() : null;
                PluginId pluginId = plugin == null ? null : plugin.getPluginId();
                String pluginName = pluginId == null || PluginManagerCore.CORE_ID.equals((Object)pluginId) ? null : plugin.getName();
                this.myTextLabel.append("   ", SimpleTextAttributes.REGULAR_ATTRIBUTES, false);
                this.myTextLabel.append((String)(pluginName == null ? id2 : id2 + " (" + pluginName + ")"), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES, false);
            }
            if (node != null && tree2.isVisible()) {
                JScrollBar bar2;
                int width = SettingsTreeView.getLeftMargin(node.myLevel) + this.getPreferredSize().width;
                Insets insets = tree2.getInsets();
                if (insets != null) {
                    width += insets.left + insets.right;
                }
                if ((bar2 = SettingsTreeView.this.myScroller.getVerticalScrollBar()) != null && bar2.isVisible()) {
                    width += bar2.getWidth();
                }
                width = Math.min(width, 300);
                SettingsTreeView view2 = SettingsTreeView.this;
                Dimension size2 = view2.getMinimumSize();
                if (size2.width < width) {
                    size2.width = width;
                    view2.setMinimumSize(size2);
                    view2.revalidate();
                    view2.repaint();
                }
            }
            return this;
        }

        private void prepareRenderer(boolean visible, MyNode node, @Nullable UnnamedConfigurable configurable, boolean selected) {
            ConfigurableTreeRenderer renderer2;
            this.myRenderInfo = null;
            if (visible && (renderer2 = node.getRenderer()) != null) {
                if (configurable instanceof ConfigurableWrapper) {
                    configurable = ((ConfigurableWrapper)configurable).getRawConfigurable();
                }
                this.myRenderInfo = renderer2.getDecorator((JComponent)SettingsTreeView.this.myTree, configurable, selected);
            }
        }

        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            if (this.myRenderInfo != null) {
                Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
                Rectangle text2 = this.myTextLabel.getBounds();
                int baseline = this.myTextLabel.getBaseline(text2.width, text2.height);
                if (this.myProjectIcon.getIcon() == null) {
                    this.myProjectIcon.setIcon(AllIcons.General.ProjectConfigurable);
                }
                Dimension icon2 = this.myProjectIcon.getPreferredSize();
                Rectangle right = new Rectangle(bounds.x + bounds.width - icon2.width, bounds.y, icon2.width, icon2.height);
                ((ConfigurableTreeRenderer.Layout)this.myRenderInfo.second).layoutBeforePaint((Component)this.myRenderInfo.first, bounds, text2, right, baseline);
                Rectangle paintBounds = ((Component)this.myRenderInfo.first).getBounds();
                Graphics2D g2 = (Graphics2D)g.create(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                ((Component)this.myRenderInfo.first).paint(g2);
                g2.dispose();
                this.myRenderInfo = null;
            }
        }

        @NotNull
        public List<PropertyBean> getUiInspectorContext(@NotNull JTree tree2, @Nullable Object value, int row2) {
            ConfigurableMarkerProvider markerProvider;
            Weighted weightedConfigurable;
            MyNode node;
            if (tree2 == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if ((node = SettingsTreeView.extractNode(value)) == null) {
                List<PropertyBean> list2 = Collections.emptyList();
                if (list2 == null) {
                    MyRenderer.$$$reportNull$$$0(1);
                }
                return list2;
            }
            Configurable wrapper2 = node.myConfigurable;
            UnnamedConfigurable configurable = ConfigurableWrapper.cast(UnnamedConfigurable.class, (UnnamedConfigurable)wrapper2);
            if (configurable == null) {
                List<PropertyBean> list3 = Collections.emptyList();
                if (list3 == null) {
                    MyRenderer.$$$reportNull$$$0(2);
                }
                return list3;
            }
            ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
            result2.add(new PropertyBean("Configurable class", (Object)UiInspectorUtil.getClassPresentation((Object)configurable), true));
            if (wrapper2 instanceof SearchableConfigurable) {
                SearchableConfigurable searchableConfigurable = (SearchableConfigurable)wrapper2;
                String configurableId = searchableConfigurable.getId();
                result2.add(new PropertyBean("Configurable ID", (Object)configurableId, true));
                if (configurableId.startsWith("configurable.group.")) {
                    String realConfigurableId = configurableId.substring("configurable.group.".length());
                    result2.add(new PropertyBean("Configurable ID (groupId)", (Object)realConfigurableId, true));
                }
            }
            if (wrapper2.getHelpTopic() != null) {
                result2.add(new PropertyBean("Configurable HelpTopic", (Object)wrapper2.getHelpTopic(), true));
            }
            if (wrapper2 instanceof Weighted && (weightedConfigurable = (Weighted)wrapper2).getWeight() != 0) {
                result2.add(new PropertyBean("Configurable Weight", (Object)weightedConfigurable.getWeight(), true));
            }
            if (wrapper2 instanceof ConfigurableMarkerProvider && (markerProvider = (ConfigurableMarkerProvider)wrapper2).getMarkerText() != null) {
                result2.add(new PropertyBean("Configurable Marker", (Object)markerProvider.getMarkerText(), true));
            }
            ArrayList<PropertyBean> arrayList = result2;
            if (arrayList == null) {
                MyRenderer.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/options/newEditor/SettingsTreeView$MyRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsTreeView$MyRenderer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUiInspectorContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getUiInspectorContext";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }

        private final class MyAccessibleContext
        extends JPanel.AccessibleJPanel {
            private MyAccessibleContext() {
                super((JPanel)((Object)MyRenderer.this));
            }

            @Override
            public String getAccessibleName() {
                return MyRenderer.this.myTextLabel.getCharSequence(true).toString();
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }
        }
    }

    private final class MyRoot
    extends CachingSimpleNode {
        private final List<? extends ConfigurableGroup> myGroups;

        private MyRoot(List<? extends ConfigurableGroup> groups) {
            if (groups == null) {
                MyRoot.$$$reportNull$$$0(0);
            }
            super(null);
            this.myGroups = groups;
        }

        protected SimpleNode[] buildChildren() {
            if (this.myGroups == null || this.myGroups.isEmpty()) {
                return NO_CHILDREN;
            }
            ArrayList<MyNode> list2 = new ArrayList<MyNode>();
            for (ConfigurableGroup configurableGroup : this.myGroups) {
                for (Configurable configurable : configurableGroup.getConfigurables()) {
                    list2.add(new MyNode(this, configurable, 0));
                }
            }
            return list2.toArray(new SimpleNode[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/openapi/options/newEditor/SettingsTreeView$MyRoot", "<init>"));
        }
    }

    private static final class MyControl {
        private final Control control = new DefaultControl();
        private final Function<Boolean, Icon> collapsed = selected -> new MyIcon(false, () -> selected);
        private final Function<Boolean, Icon> expanded = selected -> new MyIcon(true, () -> selected);
        private final Icon empty = new MyIcon(null, () -> false);

        private MyControl() {
        }

        private final class MyIcon
        implements Icon {
            private final Boolean expanded;
            private final Supplier<Boolean> selected;

            private MyIcon(Boolean expanded, Supplier<Boolean> selected) {
                this.expanded = expanded;
                this.selected = selected;
            }

            @Override
            public int getIconWidth() {
                return MyControl.this.control.getWidth();
            }

            @Override
            public int getIconHeight() {
                return MyControl.this.control.getHeight();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (this.expanded != null) {
                    MyControl.this.control.paint(c, g, x, y, this.getIconWidth(), this.getIconHeight(), this.expanded, this.selected.get());
                }
            }
        }
    }

    private final class MyNode
    extends CachingSimpleNode {
        @Nullable
        private final Configurable.Composite myComposite;
        @NotNull
        private final Configurable myConfigurable;
        private final @NlsContexts.ConfigurableName String myDisplayName;
        private final int myLevel;
        private ConfigurableTreeRenderer myRenderer;
        private boolean myPrepareRenderer;

        private MyNode(@NotNull CachingSimpleNode parent, Configurable configurable, int level) {
            if (configurable == null) {
                MyNode.$$$reportNull$$$0(0);
            }
            super(SettingsTreeView.prepareProject(parent, configurable), (NodeDescriptor)parent);
            this.myPrepareRenderer = true;
            this.myComposite = configurable instanceof Configurable.Composite ? (Configurable.Composite)configurable : null;
            this.myConfigurable = configurable;
            String name2 = configurable.getDisplayName();
            this.myDisplayName = name2 != null ? name2.replace("\n", " ") : "{ " + configurable.getClass().getSimpleName() + " }";
            this.myLevel = level;
        }

        @Nullable
        public ConfigurableTreeRenderer getRenderer() {
            if (this.myPrepareRenderer) {
                this.myPrepareRenderer = false;
                if (this.myConfigurable instanceof ConfigurableTreeRenderer) {
                    this.myRenderer = (ConfigurableTreeRenderer)this.myConfigurable;
                } else {
                    Configurable configurable = this.myConfigurable;
                    if (configurable instanceof ConfigurableWrapper) {
                        ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable;
                        UnnamedConfigurable configurable2 = wrapper2.getRawConfigurable();
                        this.myRenderer = configurable2 instanceof ConfigurableTreeRenderer ? (ConfigurableTreeRenderer)configurable2 : wrapper2.getExtensionPoint().createTreeRenderer();
                    }
                }
            }
            return this.myRenderer;
        }

        protected SimpleNode[] buildChildren() {
            SettingsTreeView.this.myConfigurableToNodeMap.put(this.myConfigurable, this);
            if (this.myComposite == null) {
                return NO_CHILDREN;
            }
            Configurable[] configurables2 = this.myComposite.getConfigurables();
            if (configurables2.length == 0) {
                return NO_CHILDREN;
            }
            SimpleNode[] result2 = new SimpleNode[configurables2.length];
            for (int i2 = 0; i2 < configurables2.length; ++i2) {
                result2[i2] = new MyNode(this, configurables2[i2], this.myLevel + 1);
                SettingsTreeView.this.myFilter.context.registerKid(this.myConfigurable, configurables2[i2]);
            }
            return result2;
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                MyNode.$$$reportNull$$$0(1);
            }
            super.update(presentation2);
            presentation2.addText(this.myDisplayName, this.getPlainAttributes());
        }

        public boolean isAlwaysLeaf() {
            return this.myComposite == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsTreeView$MyNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected final class AccessibleSettingsTreeView
    extends JComponent.AccessibleJComponent {
        protected AccessibleSettingsTreeView() {
            super(SettingsTreeView.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private static final class MyTreeUi
    extends WideSelectionTreeUI {
        private MyTreeUi() {
        }

        public Rectangle getPathBounds(JTree tree2, TreePath path) {
            Rectangle bounds = super.getPathBounds(tree2, path);
            if (bounds != null) {
                bounds.width = Math.max(bounds.width, tree2.getWidth() - bounds.x);
            }
            return bounds;
        }

        boolean processMouseEvent(MouseEvent event) {
            if (this.tree instanceof SimpleTree) {
                Component component2;
                boolean toggleNow;
                SimpleTree tree2 = (SimpleTree)this.tree;
                boolean bl = toggleNow = 502 == event.getID() && UIUtil.isActionClick((MouseEvent)event, (int)502) && !this.isToggleEvent(event);
                if ((toggleNow || 501 == event.getID()) && (component2 = tree2.getDeepestRendererComponentAt(event.getX(), event.getY())) instanceof JLabel && SettingsTreeView.NODE_ICON.equals(component2.getName())) {
                    MyControl.MyIcon icon2 = (MyControl.MyIcon)ObjectUtils.tryCast((Object)((JLabel)component2).getIcon(), MyControl.MyIcon.class);
                    if (icon2 == null || icon2.expanded == null) {
                        return false;
                    }
                    if (toggleNow) {
                        this.toggleExpandState(tree2.getPathForLocation(event.getX(), event.getY()));
                    }
                    event.consume();
                    return true;
                }
            }
            return false;
        }

        protected boolean shouldPaintExpandControl(TreePath path, int row2, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            return false;
        }

        protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row2, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        }

        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        }

        public void paint(Graphics g, JComponent c) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
            super.paint(g, c);
        }

        protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row2, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            if (this.tree != null) {
                bounds.width = this.tree.getWidth();
                JViewport viewport = ComponentUtil.getViewport((Component)this.tree);
                if (viewport != null) {
                    bounds.width = viewport.getWidth() - viewport.getViewPosition().x - insets.right / 2;
                }
                bounds.width -= bounds.x;
            }
            super.paintRow(g, clipBounds, insets, bounds, path, row2, isExpanded, hasBeenExpanded, isLeaf);
        }

        protected int getRowX(int row2, int depth) {
            return JBUIScale.scale((int)SettingsTreeView.getLeftMargin(depth - 1));
        }
    }
}

