/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.configuration.HeadlessLogging;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/project/configuration/HeadlessLoggingServiceImpl;", "Lcom/intellij/openapi/project/configuration/HeadlessLogging$HeadlessLoggingService;", "<init>", "()V", "flow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/openapi/project/configuration/HeadlessLogging$LogEntry;", "logEntry", "", "emitLogEntry", "entry", "loggingFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHeadlessLoggingServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeadlessLoggingServiceImpl.kt\ncom/intellij/openapi/project/configuration/HeadlessLoggingServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,38:1\n23#2:39\n*S KotlinDebug\n*F\n+ 1 HeadlessLoggingServiceImpl.kt\ncom/intellij/openapi/project/configuration/HeadlessLoggingServiceImpl\n*L\n26#1:39\n*E\n"})
public final class HeadlessLoggingServiceImpl
implements HeadlessLogging.HeadlessLoggingService {
    @NotNull
    private final MutableSharedFlow<HeadlessLogging.LogEntry> flow = SharedFlowKt.MutableSharedFlow((int)0, (int)1024, (BufferOverflow)BufferOverflow.SUSPEND);

    public void logEntry(@NotNull HeadlessLogging.LogEntry logEntry) {
        Intrinsics.checkNotNullParameter((Object)logEntry, (String)"logEntry");
        this.emitLogEntry(logEntry);
    }

    private final void emitLogEntry(HeadlessLogging.LogEntry entry) {
        boolean internalLoggingPerformed = false;
        while (!this.flow.tryEmit((Object)entry)) {
            if (!internalLoggingPerformed) {
                HeadlessLoggingServiceImpl $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(HeadlessLoggingServiceImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cannot log message: " + entry + ". \nHeadless logger has exhausted the buffer of messages. Please speed up the listeners of the Headless logger.");
                internalLoggingPerformed = true;
            }
            Thread.sleep(100L);
        }
    }

    @NotNull
    public SharedFlow<HeadlessLogging.LogEntry> loggingFlow() {
        return (SharedFlow)this.flow;
    }
}

