/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.configurationStore.ProjectStorePathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0002\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a$\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getOrInitializeModule", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/util/Ref;", "project", "Lcom/intellij/openapi/project/Project;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "doCreateFakeModuleForDirectoryProjectConfigurators", "projectVirtualFile", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "projectFile", "Ljava/nio/file/Path;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\ncreateModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 createModule.kt\ncom/intellij/openapi/project/impl/CreateModuleKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n60#2,5:93\n*S KotlinDebug\n*F\n+ 1 createModule.kt\ncom/intellij/openapi/project/impl/CreateModuleKt\n*L\n75#1:93,5\n*E\n"})
public final class CreateModuleKt {
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    @NotNull
    public static final Module getOrInitializeModule(@NotNull Ref<Module> $this$getOrInitializeModule, @NotNull Project project2, @NotNull VirtualFile baseDir) {
        Intrinsics.checkNotNullParameter($this$getOrInitializeModule, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Module module = (Module)$this$getOrInitializeModule.get();
        if (module != null) {
            Module it = module;
            boolean bl = false;
            return it;
        }
        Module module2 = CreateModuleKt.doCreateFakeModuleForDirectoryProjectConfigurators(baseDir, ModuleManager.Companion.getInstance(project2), null);
        $this$getOrInitializeModule.set((Object)module2);
        return module2;
    }

    @NotNull
    public static final Module doCreateFakeModuleForDirectoryProjectConfigurators(@NotNull VirtualFile projectVirtualFile, @NotNull ModuleManager moduleManager, @Nullable Path projectFile) {
        Intrinsics.checkNotNullParameter((Object)projectVirtualFile, (String)"projectVirtualFile");
        Intrinsics.checkNotNullParameter((Object)moduleManager, (String)"moduleManager");
        Module[] modules = moduleManager.getModules();
        if (!(modules.length == 0)) {
            LOG.info("Fake module cannot be created because modules are already configured (module count: " + modules.length + ")");
            return modules[0];
        }
        String string = projectVirtualFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String moduleName = StringsKt.replace$default((String)string, (String)":", (String)"", (boolean)false, (int)4, null);
        Ref.ObjectRef imlPath = new Ref.ObjectRef();
        if (projectFile != null) {
            Path path = ProjectStorePathManager.Companion.getInstance().getStoreDescriptor(projectFile).getDotIdea();
            if (path != null) {
                Path it = path;
                boolean bl = false;
                imlPath.element = PathsKt.getInvariantSeparatorsPathString((Path)it) + "/" + moduleName + ".iml";
            }
        }
        if (imlPath.element == null) {
            imlPath.element = projectVirtualFile.getPath() + "/.idea/" + moduleName + ".iml";
        }
        ModuleTypeManager moduleTypeManager = ModuleTypeManager.getInstance();
        Object object = WriteAction.computeAndWait(() -> CreateModuleKt.doCreateFakeModuleForDirectoryProjectConfigurators$lambda$1(moduleManager, imlPath, moduleTypeManager, projectVirtualFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeAndWait(...)");
        return (Module)object;
    }

    public static /* synthetic */ Module doCreateFakeModuleForDirectoryProjectConfigurators$default(VirtualFile virtualFile, ModuleManager moduleManager, Path path, int n, Object object) {
        if ((n & 4) != 0) {
            path = null;
        }
        return CreateModuleKt.doCreateFakeModuleForDirectoryProjectConfigurators(virtualFile, moduleManager, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Module doCreateFakeModuleForDirectoryProjectConfigurators$lambda$1(ModuleManager $moduleManager, Ref.ObjectRef $imlPath, ModuleTypeManager $moduleTypeManager, VirtualFile $projectVirtualFile) {
        String string = (String)$imlPath.element;
        Object object = $moduleTypeManager;
        if (object == null || (object = object.getDefaultModuleType()) == null || (object = object.getId()) == null) {
            object = "unknown";
        }
        Module module = $moduleManager.newModule(string, (String)object);
        ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"getModifiableModel(...)");
        ModifiableRootModel model2 = modifiableRootModel;
        try {
            VirtualFile[] virtualFileArray = model2.getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            VirtualFile[] contentRoots = virtualFileArray;
            if (contentRoots.length == 0) {
                model2.addContentEntry($projectVirtualFile);
                Logger $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("content root " + $projectVirtualFile + " is added", t$iv);
                }
            } else {
                LOG.info("content root " + $projectVirtualFile + " is not added because content roots are already configured (content root count: " + contentRoots.length + ")");
            }
            model2.inheritSdk();
            model2.commit();
        }
        finally {
            if (!model2.isDisposed()) {
                model2.dispose();
            }
        }
        return module;
    }

    static {
        Logger logger = Logger.getInstance((String)"FakeModule");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

