/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.roots.ui.util.HttpUrlCellAppearance;
import com.intellij.openapi.roots.ui.util.JarSubfileCellAppearance;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.roots.ui.util.ValidFileCellAppearance;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.PlatformIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FileAppearanceServiceImpl
extends FileAppearanceService {
    private static final CellAppearanceEx EMPTY = new CellAppearanceEx(){

        public void customize(@NotNull SimpleColoredComponent component2) {
            if (component2 == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String getText() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl$1", "customize"));
        }
    };

    @NotNull
    public CellAppearanceEx empty() {
        CellAppearanceEx cellAppearanceEx = EMPTY;
        if (cellAppearanceEx == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(0);
        }
        return cellAppearanceEx;
    }

    @NotNull
    public CellAppearanceEx forVirtualFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(1);
        }
        if (!file2.isValid()) {
            CellAppearanceEx cellAppearanceEx = this.forInvalidUrl(file2.getPresentableUrl());
            if (cellAppearanceEx == null) {
                FileAppearanceServiceImpl.$$$reportNull$$$0(2);
            }
            return cellAppearanceEx;
        }
        VirtualFileSystem fileSystem = file2.getFileSystem();
        if (fileSystem.getProtocol().equals("jar")) {
            return new JarSubfileCellAppearance(file2);
        }
        if (fileSystem instanceof HttpFileSystem) {
            return new HttpUrlCellAppearance(file2);
        }
        if (file2.isDirectory()) {
            SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)file2.getPresentableUrl(), (Icon)PlatformIcons.FOLDER_ICON);
            if (simpleTextCellAppearance == null) {
                FileAppearanceServiceImpl.$$$reportNull$$$0(3);
            }
            return simpleTextCellAppearance;
        }
        return new ValidFileCellAppearance(file2);
    }

    @NotNull
    public CellAppearanceEx forIoFile(@NotNull File file2) {
        if (file2 == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(4);
        }
        String absolutePath = file2.getAbsolutePath();
        if (!file2.exists()) {
            CellAppearanceEx cellAppearanceEx = this.forInvalidUrl(absolutePath);
            if (cellAppearanceEx == null) {
                FileAppearanceServiceImpl.$$$reportNull$$$0(5);
            }
            return cellAppearanceEx;
        }
        if (file2.isDirectory()) {
            SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)absolutePath, (Icon)PlatformIcons.FOLDER_ICON);
            if (simpleTextCellAppearance == null) {
                FileAppearanceServiceImpl.$$$reportNull$$$0(6);
            }
            return simpleTextCellAppearance;
        }
        String name2 = file2.getName();
        FileType fileType2 = FileTypeManager.getInstance().getFileTypeByFileName(name2);
        File parent = file2.getParentFile();
        CompositeAppearance appearance = CompositeAppearance.textComment((String)name2, (String)parent.getAbsolutePath());
        appearance.setIcon(fileType2.getIcon());
        CompositeAppearance compositeAppearance = appearance;
        if (compositeAppearance == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(7);
        }
        return compositeAppearance;
    }

    @NotNull
    public CellAppearanceEx forInvalidUrl(@NotNull String text2) {
        if (text2 == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(8);
        }
        SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.invalid((String)text2, (Icon)PlatformIcons.INVALID_ENTRY_ICON);
        if (simpleTextCellAppearance == null) {
            FileAppearanceServiceImpl.$$$reportNull$$$0(9);
        }
        return simpleTextCellAppearance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/FileAppearanceServiceImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forVirtualFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "forIoFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forInvalidUrl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forVirtualFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forIoFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forInvalidUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 8 -> new IllegalArgumentException(string);
        };
    }
}

