/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.mac.touchbar.TouchbarSupport;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WindowWrapperBuilder {
    @NotNull
    private final WindowWrapper.Mode myMode;
    @NotNull
    private final JComponent myComponent;
    @Nullable
    private Project myProject;
    @Nullable
    private Component myParent;
    @NlsContexts.DialogTitle
    @Nullable
    private String title;
    @Nullable
    private Computable<JComponent> myPreferredFocusedComponent;
    @NonNls
    @Nullable
    private String myDimensionServiceKey;
    @Nullable
    private Dimension myInitialSize;
    @Nullable
    private Boolean myMaximizable;
    @Nullable
    private Runnable myOnShowCallback;
    @Nullable
    private BooleanGetter myOnCloseHandler;

    public WindowWrapperBuilder(@NotNull WindowWrapper.Mode mode, @NotNull JComponent component2) {
        if (mode == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(0);
        }
        if (component2 == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(1);
        }
        this.myMode = mode;
        this.myComponent = component2;
    }

    @NotNull
    public WindowWrapperBuilder setProject(@Nullable Project project2) {
        this.myProject = project2;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(2);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setParent(@Nullable Component parent) {
        this.myParent = parent;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(3);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setTitle(@NlsContexts.DialogTitle @Nullable String title2) {
        this.title = title2;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(4);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setPreferredFocusedComponent(@Nullable JComponent preferredFocusedComponent) {
        this.myPreferredFocusedComponent = new Computable.PredefinedValueComputable((Object)preferredFocusedComponent);
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(5);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setPreferredFocusedComponent(@Nullable Computable<JComponent> computable) {
        this.myPreferredFocusedComponent = computable;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(6);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setDimensionServiceKey(@NonNls @Nullable String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(7);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setInitialSize(@NotNull Dimension size2) {
        if (size2 == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(8);
        }
        this.myInitialSize = size2;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(9);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setOnShowCallback(@NotNull Runnable callback) {
        if (callback == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(10);
        }
        this.myOnShowCallback = callback;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(11);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setOnCloseHandler(@NotNull BooleanGetter handler) {
        if (handler == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(12);
        }
        this.myOnCloseHandler = handler;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(13);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapper build() {
        return switch (this.myMode) {
            default -> throw new MatchException(null, null);
            case WindowWrapper.Mode.FRAME -> new FrameWindowWrapper(this);
            case WindowWrapper.Mode.MODAL, WindowWrapper.Mode.NON_MODAL -> new DialogWindowWrapper(this);
        };
    }

    public WindowWrapperBuilder setMaximizable(boolean maximizable) {
        this.myMaximizable = maximizable;
        return this;
    }

    private static void installOnShowCallback(@Nullable Window window, @Nullable Runnable onShowCallback) {
        if (window == null || onShowCallback == null) {
            return;
        }
        UIUtil.runWhenWindowOpened((Window)window, (Runnable)onShowCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 9, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/WindowWrapperBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/WindowWrapperBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setTitle";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setPreferredFocusedComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setDimensionServiceKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setInitialSize";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setOnShowCallback";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "setOnCloseHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setInitialSize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setOnShowCallback";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setOnCloseHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 9, 11, 13 -> new IllegalStateException(string);
        };
    }

    private static final class FrameWindowWrapper
    implements WindowWrapper {
        @Nullable
        private final Project myProject;
        @NotNull
        private final JComponent myComponent;
        @NotNull
        private final WindowWrapper.Mode myMode;
        @Nullable
        private final Runnable myOnShowCallback;
        @NotNull
        private final MyFrameWrapper myFrame;

        FrameWindowWrapper(@NotNull WindowWrapperBuilder builder) {
            if (builder == null) {
                FrameWindowWrapper.$$$reportNull$$$0(0);
            }
            assert (builder.myMode == WindowWrapper.Mode.FRAME);
            this.myProject = builder.myProject;
            this.myComponent = builder.myComponent;
            this.myMode = builder.myMode;
            this.myFrame = new MyFrameWrapper(builder.myProject, builder.myDimensionServiceKey);
            this.myFrame.setParameters(builder.myPreferredFocusedComponent);
            this.myFrame.setOnCloseHandler((BooleanSupplier)builder.myOnCloseHandler);
            this.myOnShowCallback = builder.myOnShowCallback;
            this.myFrame.setComponent(builder.myComponent);
            this.myFrame.setTitle(builder.title == null ? "" : builder.title);
            this.myFrame.closeOnEsc();
            Disposer.register((Disposable)this.myFrame, (Disposable)this);
        }

        public void show() {
            TouchbarSupport.showWindowActions(this.myFrame, this.myComponent);
            this.myFrame.show();
            if (this.myOnShowCallback != null) {
                this.myOnShowCallback.run();
            }
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                FrameWindowWrapper.$$$reportNull$$$0(1);
            }
            return jComponent;
        }

        @NotNull
        public WindowWrapper.Mode getMode() {
            WindowWrapper.Mode mode = this.myMode;
            if (mode == null) {
                FrameWindowWrapper.$$$reportNull$$$0(2);
            }
            return mode;
        }

        @NotNull
        public Window getWindow() {
            Window window = this.myFrame.getFrame();
            if (window == null) {
                FrameWindowWrapper.$$$reportNull$$$0(3);
            }
            return window;
        }

        public boolean isDisposed() {
            return this.myFrame.isDisposed();
        }

        public void setTitle(@Nullable String title2) {
            title2 = StringUtil.notNullize((String)title2);
            this.myFrame.setTitle(title2);
            Window window = this.getWindow();
            if (window instanceof JFrame) {
                ((JFrame)window).setTitle(title2);
            } else if (window instanceof JDialog) {
                ((JDialog)window).setTitle(title2);
            }
        }

        public void setImages(@Nullable List<? extends Image> images) {
            this.myFrame.setImages(images);
        }

        public void close() {
            this.myFrame.close();
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myFrame);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/WindowWrapperBuilder$FrameWindowWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/WindowWrapperBuilder$FrameWindowWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWindow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }

        private static final class MyFrameWrapper
        extends FrameWrapper {
            private Computable<? extends JComponent> myPreferredFocusedComponent;

            MyFrameWrapper(Project project2, @Nullable @NonNls String dimensionServiceKey) {
                super(project2, dimensionServiceKey);
            }

            public void setParameters(@Nullable Computable<? extends JComponent> preferredFocusedComponent) {
                this.myPreferredFocusedComponent = preferredFocusedComponent;
            }

            @Override
            public void dispose() {
                this.myPreferredFocusedComponent = null;
                super.dispose();
            }

            @Override
            public JComponent getPreferredFocusedComponent() {
                if (this.myPreferredFocusedComponent != null) {
                    return (JComponent)this.myPreferredFocusedComponent.compute();
                }
                return super.getPreferredFocusedComponent();
            }
        }
    }

    private static final class DialogWindowWrapper
    implements WindowWrapper {
        @Nullable
        private final Project myProject;
        @NotNull
        private final JComponent myComponent;
        @NotNull
        private final WindowWrapper.Mode myMode;
        @NotNull
        private final MyDialogWrapper myDialog;

        DialogWindowWrapper(@NotNull WindowWrapperBuilder builder) {
            if (builder == null) {
                DialogWindowWrapper.$$$reportNull$$$0(0);
            }
            this.myProject = builder.myProject;
            this.myComponent = builder.myComponent;
            this.myMode = builder.myMode;
            MyDialogWrapper myDialogWrapper = this.myDialog = builder.myParent != null ? new MyDialogWrapper(builder.myParent, builder.myComponent) : new MyDialogWrapper(builder.myProject, builder.myComponent);
            if (builder.myMaximizable != null) {
                this.myDialog.setMaximizable(builder.myMaximizable);
            }
            this.myDialog.setParameters(builder.myDimensionServiceKey, builder.myInitialSize, builder.myPreferredFocusedComponent, builder.myOnCloseHandler);
            WindowWrapperBuilder.installOnShowCallback(this.myDialog.getWindow(), builder.myOnShowCallback);
            this.setTitle(builder.title);
            switch (builder.myMode) {
                case MODAL: {
                    this.myDialog.setModal(true);
                    break;
                }
                case NON_MODAL: {
                    this.myDialog.setModal(false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.myDialog.init();
            Disposer.register((Disposable)this.myDialog.getDisposable(), (Disposable)this);
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myDialog.getDisposable());
        }

        public void show() {
            this.myDialog.show();
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                DialogWindowWrapper.$$$reportNull$$$0(1);
            }
            return jComponent;
        }

        @NotNull
        public WindowWrapper.Mode getMode() {
            WindowWrapper.Mode mode = this.myMode;
            if (mode == null) {
                DialogWindowWrapper.$$$reportNull$$$0(2);
            }
            return mode;
        }

        @NotNull
        public Window getWindow() {
            Window window = this.myDialog.getWindow();
            if (window == null) {
                DialogWindowWrapper.$$$reportNull$$$0(3);
            }
            return window;
        }

        public boolean isDisposed() {
            return this.myDialog.isDisposed();
        }

        public void setTitle(@Nullable String title2) {
            this.myDialog.setTitle(StringUtil.notNullize((String)title2));
        }

        public void setImages(@Nullable List<? extends Image> images) {
        }

        public void close() {
            this.myDialog.close(1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWindow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }

        private static final class MyDialogWrapper
        extends DialogWrapper {
            @NotNull
            private final JComponent myComponent;
            @Nullable
            @NonNls
            private String myDimensionServiceKey;
            @Nullable
            private Dimension myInitialSize;
            @Nullable
            private Computable<? extends JComponent> myPreferredFocusedComponent;
            @Nullable
            private BooleanGetter myOnCloseHandler;

            MyDialogWrapper(@Nullable Project project2, @NotNull JComponent component2) {
                if (component2 == null) {
                    MyDialogWrapper.$$$reportNull$$$0(0);
                }
                super(project2, true);
                this.myComponent = component2;
            }

            MyDialogWrapper(@NotNull Component parent, @NotNull JComponent component2) {
                if (parent == null) {
                    MyDialogWrapper.$$$reportNull$$$0(1);
                }
                if (component2 == null) {
                    MyDialogWrapper.$$$reportNull$$$0(2);
                }
                super(parent, true);
                this.myComponent = component2;
            }

            public void init() {
                super.init();
            }

            public void setParameters(@Nullable @NonNls String dimensionServiceKey, @Nullable Dimension initialSize, @Nullable Computable<? extends JComponent> preferredFocusedComponent, @Nullable BooleanGetter onCloseHandler) {
                this.myDimensionServiceKey = dimensionServiceKey;
                this.myInitialSize = initialSize;
                this.myPreferredFocusedComponent = preferredFocusedComponent;
                this.myOnCloseHandler = onCloseHandler;
            }

            @Nullable
            protected Border createContentPaneBorder() {
                return null;
            }

            protected JComponent createCenterPanel() {
                return this.myComponent;
            }

            protected Action @NotNull [] createActions() {
                return new Action[0];
            }

            @Nullable
            protected JComponent createSouthPanel() {
                return null;
            }

            @Nullable
            protected String getDimensionServiceKey() {
                return this.myDimensionServiceKey;
            }

            @Nullable
            public Dimension getInitialSize() {
                return this.myInitialSize == null ? super.getInitialSize() : this.myInitialSize;
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                if (this.myPreferredFocusedComponent != null) {
                    return (JComponent)this.myPreferredFocusedComponent.compute();
                }
                return super.getPreferredFocusedComponent();
            }

            public void doCancelAction() {
                if (this.myOnCloseHandler != null && !this.myOnCloseHandler.get()) {
                    return;
                }
                super.doCancelAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper$MyDialogWrapper";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

