/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.OpenAnotherToolHandler;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstallationService;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstallationServiceKt;
import com.intellij.openapi.util.registry.Registry;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J.\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/TryUltimateActionHandler;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/OpenAnotherToolHandler;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "suggestedIde", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/SuggestedIde;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "openTool", "", "pathToOpen", "Ljava/nio/file/Path;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nUltimateInstallationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UltimateInstallationService.kt\ncom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/TryUltimateActionHandler\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,261:1\n30#2,2:262\n13#3:264\n*S KotlinDebug\n*F\n+ 1 UltimateInstallationService.kt\ncom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/TryUltimateActionHandler\n*L\n232#1:262,2\n236#1:264\n*E\n"})
public final class TryUltimateActionHandler
implements OpenAnotherToolHandler {
    @Override
    public boolean isApplicable(@Nullable Project project2, @NotNull SuggestedIde suggestedIde, @Nullable PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)suggestedIde, (String)"suggestedIde");
        return Registry.Companion.is("ide.try.ultimate.automatic.installation") && project2 != null && UltimateInstallationServiceKt.access$canBeAutoInstalled(suggestedIde);
    }

    @Override
    public void openTool(@Nullable Project project2, @NotNull SuggestedIde suggestedIde, @Nullable PluginId pluginId, @Nullable Path pathToOpen) {
        Intrinsics.checkNotNullParameter((Object)suggestedIde, (String)"suggestedIde");
        Project project3 = project2;
        Intrinsics.checkNotNull((Object)project3);
        ComponentManager $this$service$iv = (ComponentManager)project3;
        boolean $i$f$service = false;
        Class<UltimateInstallationService> serviceClass$iv = UltimateInstallationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        UltimateInstallationService installationService = (UltimateInstallationService)object;
        try {
            installationService.install(pluginId, suggestedIde);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TryUltimateActionHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to initiate IDE installation.", (Throwable)e);
        }
    }
}

