/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public class DefaultRemoteContentProvider
extends RemoteContentProvider {
    private static final Logger LOG = Logger.getInstance(DefaultRemoteContentProvider.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 60000;

    @NotNull
    public static RequestBuilder addRequestTuner(@NotNull Url url, @NotNull RequestBuilder requestBuilder) {
        BuiltInServerManager builtInServerManager;
        if (url == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(0);
        }
        if (requestBuilder == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(1);
        }
        if ((builtInServerManager = BuiltInServerManager.getInstance()).isOnBuiltInWebServer(url)) {
            requestBuilder.tuner(arg_0 -> ((BuiltInServerManager)builtInServerManager).configureRequestToWebServer(arg_0));
        }
        RequestBuilder requestBuilder2 = requestBuilder;
        if (requestBuilder2 == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(2);
        }
        return requestBuilder2;
    }

    @Override
    public boolean canProvideContent(@NotNull Url url) {
        if (url == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    public void saveContent(@NotNull Url url, @NotNull File file2, @NotNull RemoteContentProvider.DownloadingCallback callback) {
        if (url == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(6);
        }
        Throwable startTrace = ApplicationManager.getApplication().isUnitTestMode() ? new Throwable() : null;
        ProcessIOExecutorService.INSTANCE.execute(() -> this.downloadContent(url, file2, callback, startTrace));
    }

    private void downloadContent(@NotNull Url url, @NotNull File file2, final @NotNull RemoteContentProvider.DownloadingCallback callback, @Nullable Throwable startTrace) {
        if (url == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(9);
        }
        LOG.debug("Downloading started: " + String.valueOf(url));
        String presentableUrl = StringUtil.trimMiddle((String)url.trimParameters().toDecodedForm(), (int)40);
        callback.setProgressText(IdeCoreBundle.message((String)"download.progress.connecting", (Object[])new Object[]{presentableUrl}), true);
        try {
            this.connect(url, HttpRequests.request((String)url.toExternalForm()), request -> {
                FileType fileTypeByFileName;
                int size2 = request.getConnection().getContentLength();
                callback.setProgressText(IdeCoreBundle.message((String)"download.progress.downloading", (Object[])new Object[]{presentableUrl}), size2 == -1);
                request.saveToFile(file2, (ProgressIndicator)new AbstractProgressIndicatorExBase(){

                    public void setFraction(double fraction) {
                        callback.setProgressFraction(0.0);
                    }
                });
                this.saveAdditionalData(request, file2);
                FileType fileType2 = RemoteFileUtil.getFileType(request.getConnection().getContentType());
                if (fileType2 == FileTypes.PLAIN_TEXT && (fileTypeByFileName = FileTypeRegistry.getInstance().getFileTypeByFileName(PathUtilRt.getFileName((String)url.getPath()))) != FileTypes.UNKNOWN) {
                    fileType2 = fileTypeByFileName;
                }
                fileType2 = this.adjustFileType(fileType2, url);
                LOG.debug("Downloading from " + String.valueOf(url) + " finished, " + size2 + " bytes downloaded");
                if (startTrace != null) {
                    LOG.debug("Start trace:", startTrace);
                }
                callback.finished(fileType2);
                return null;
            });
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            callback.errorOccurred(IdeCoreBundle.message((String)"cannot.load.remote.file", (Object[])new Object[]{url, e.getMessage()}), false);
        }
    }

    protected <T> T connect(@NotNull Url url, @NotNull RequestBuilder requestBuilder, @NotNull HttpRequests.RequestProcessor<T> processor2) throws IOException {
        if (url == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(10);
        }
        if (requestBuilder == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(11);
        }
        if (processor2 == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(12);
        }
        return (T)DefaultRemoteContentProvider.addRequestTuner(url, requestBuilder).connectTimeout(this.getDefaultConnectionTimeout()).productNameAsUserAgent().connect(processor2);
    }

    protected int getDefaultConnectionTimeout() {
        return 60000;
    }

    @Nullable
    protected FileType adjustFileType(@Nullable FileType type, @NotNull Url url) {
        if (url == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(13);
        }
        return type;
    }

    protected void saveAdditionalData(@NotNull HttpRequests.Request request, @NotNull File file2) throws IOException {
        if (request == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(15);
        }
    }

    @Override
    public boolean isUpToDate(@NotNull Url url, @NotNull VirtualFile local) {
        if (url == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(16);
        }
        if (local == null) {
            DefaultRemoteContentProvider.$$$reportNull$$$0(17);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider";
                break;
            }
            case 5: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addRequestTuner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRequestTuner";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canProvideContent";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveContent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "downloadContent";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "adjustFileType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

