/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.monitoring.VfsUsageCollector;
import com.intellij.openapi.vfs.newvfs.persistent.BatchingFileSystem;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.MathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.Stack;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class RefreshWorker {
    private static final Logger LOG = Logger.getInstance(RefreshWorker.class);
    private static final int PARALLELISM = MathUtil.clamp((int)Registry.intValue((String)"vfs.refresh.worker.parallelism", (int)6), (int)1, (int)Runtime.getRuntime().availableProcessors());
    private static final Executor executor = ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO().limitedParallelism(PARALLELISM, "RefreshWorkerDispatcher"));
    private static final Object REQUESTOR = VFileEvent.REFRESH_REQUESTOR;
    private final boolean isRecursive;
    private final boolean parallel;
    private final Set<NewVirtualFile> roots;
    private final Queue<NewVirtualFile> refreshQueue;
    private final Semaphore semaphore;
    private final PersistentFS persistentFS = PersistentFS.getInstance();
    private final FSRecordsImpl vfsPeer = ((PersistentFSImpl)this.persistentFS).peer();
    private volatile boolean cancelled;
    private final AtomicInteger fullScans = new AtomicInteger();
    private final AtomicInteger partialScans = new AtomicInteger();
    private final AtomicInteger queryItemsProcessed = new AtomicInteger();
    private final AtomicLong vfsTime = new AtomicLong();
    private final AtomicLong ioTime = new AtomicLong();
    static Consumer<? super VirtualFile> ourTestListener;

    RefreshWorker(Collection<NewVirtualFile> refreshRoots, boolean isRecursive) {
        this.isRecursive = isRecursive;
        this.parallel = isRecursive && PARALLELISM > 1 && !ApplicationManager.getApplication().isWriteIntentLockAcquired();
        this.roots = new HashSet<NewVirtualFile>(refreshRoots);
        this.refreshQueue = new LinkedBlockingQueue<NewVirtualFile>(refreshRoots);
        this.semaphore = new Semaphore(refreshRoots.size());
    }

    void cancel() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<VFileEvent> scan() {
        long t = System.nanoTime();
        try {
            ArrayList<VFileEvent> events = new ArrayList<VFileEvent>();
            if (!this.parallel) {
                this.singleThreadScan(events);
            } else {
                this.parallelScan(events);
            }
            ArrayList<VFileEvent> arrayList = events;
            return arrayList;
        }
        finally {
            t = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
            int retries = this.fullScans.get() + this.partialScans.get() - this.queryItemsProcessed.get();
            VfsUsageCollector.logRefreshScan(this.fullScans.get(), this.partialScans.get(), retries, t, TimeUnit.NANOSECONDS.toMillis(this.vfsTime.get()), TimeUnit.NANOSECONDS.toMillis(this.ioTime.get()));
        }
    }

    private void singleThreadScan(List<VFileEvent> events) {
        try {
            this.processQueue(events);
        }
        catch (RefreshCancelledException e) {
            LOG.trace("refresh cancelled [1T]");
        }
    }

    private void parallelScan(List<VFileEvent> events) {
        ArrayList<CompletableFuture<List>> futures = new ArrayList<CompletableFuture<List>>(PARALLELISM);
        for (int i2 = 0; i2 < PARALLELISM; ++i2) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                ArrayList<VFileEvent> threadEvents = new ArrayList<VFileEvent>();
                try {
                    this.processQueue(threadEvents);
                }
                catch (RefreshCancelledException refreshCancelledException) {
                }
                catch (CancellationException e) {
                    this.cancelled = true;
                }
                catch (Throwable t) {
                    LOG.error(t);
                    this.cancelled = true;
                }
                return threadEvents;
            }, executor));
        }
        for (CompletableFuture completableFuture : futures) {
            try {
                events.addAll((Collection)completableFuture.get());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.cancelled) {
            LOG.trace("refresh cancelled [MT]");
        }
    }

    /*
     * Exception decompiling
     */
    private void processQueue(List<VFileEvent> events) throws RefreshCancelledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean fullDirRefresh(List<VFileEvent> events, NewVirtualFileSystem fs, VirtualDirectoryImpl dir) {
        ObjectOpenCustomHashSet actualNames;
        Map childrenWithAttributes;
        long t = System.nanoTime();
        Pair snapshot2 = (Pair)ReadAction.compute(() -> {
            VirtualFile[] children2 = dir.getChildren();
            return new Pair((Object)children2, RefreshWorker.getNames(children2));
        });
        this.vfsTime.addAndGet(System.nanoTime() - t);
        VirtualFile[] vfsChildren = (VirtualFile[])snapshot2.first;
        List vfsNames = (List)snapshot2.second;
        boolean dirIsCaseSensitive = dir.isCaseSensitive();
        t = System.nanoTime();
        if (fs instanceof BatchingFileSystem) {
            childrenWithAttributes = RefreshWorker.adjustCaseSensitivity(RefreshWorker.computeAllChildrenAttributes((BatchingFileSystem)fs, (VirtualFile)dir, null), dirIsCaseSensitive);
        } else {
            String[] childrenNames = fs.list((VirtualFile)dir);
            childrenWithAttributes = CollectionFactory.createFilePathMap((int)childrenNames.length, (boolean)dirIsCaseSensitive);
            for (String name2 : childrenNames) {
                childrenWithAttributes.put(name2, null);
            }
            if (childrenWithAttributes.size() != childrenNames.length) {
                // empty if block
            }
        }
        this.ioTime.addAndGet(System.nanoTime() - t);
        Set newNames = CollectionFactory.createFilePathSet(childrenWithAttributes.keySet(), (boolean)dirIsCaseSensitive);
        vfsNames.forEach(newNames::remove);
        Set deletedNames = CollectionFactory.createFilePathSet((Collection)vfsNames, (boolean)dirIsCaseSensitive);
        childrenWithAttributes.keySet().forEach(deletedNames::remove);
        ObjectOpenCustomHashSet objectOpenCustomHashSet = actualNames = dirIsCaseSensitive ? null : new ObjectOpenCustomHashSet(childrenWithAttributes.keySet(), FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
        if (LOG.isTraceEnabled()) {
            LOG.trace("current=" + String.valueOf(vfsNames) + " +" + String.valueOf(newNames) + " -" + String.valueOf(deletedNames));
        }
        List<ChildInfo> newKids = newNames.isEmpty() && deletedNames.isEmpty() ? List.of() : new ArrayList(newNames.size());
        for (String newName : newNames) {
            FakeVirtualFile child;
            FileAttributes attributes;
            if (VfsUtil.isBadName((String)newName) || (attributes = this.getAttributes(fs, childrenWithAttributes, (VirtualFile)(child = new FakeVirtualFile((VirtualFile)dir, newName)))) == null) continue;
            newKids.add(this.childRecord(fs, child, attributes, false));
        }
        ArrayList<Pair<VirtualFile, FileAttributes>> existingMap = new ArrayList<Pair<VirtualFile, FileAttributes>>(vfsChildren.length - deletedNames.size());
        for (VirtualFile child : vfsChildren) {
            if (deletedNames.contains(child.getName())) continue;
            existingMap.add(new Pair((Object)child, (Object)this.getAttributes(fs, childrenWithAttributes, child)));
        }
        this.checkCancelled(dir);
        if (this.isDirectoryChanged(dir, vfsChildren, (List<String>)vfsNames)) {
            return false;
        }
        this.generateDeleteEvents(events, dir, deletedNames, (ObjectOpenCustomHashSet<String>)actualNames, newKids);
        this.generateCreateEvents(events, dir, newKids);
        this.generateUpdateEvents(events, fs, dir, (ObjectOpenCustomHashSet<String>)actualNames, existingMap);
        this.checkCancelled(dir);
        return !this.isDirectoryChanged(dir, vfsChildren, (List<String>)vfsNames);
    }

    private static @Unmodifiable List<String> getNames(VirtualFile[] children2) {
        return ContainerUtil.map((Object[])children2, VirtualFile::getName);
    }

    private boolean isDirectoryChanged(VirtualDirectoryImpl dir, VirtualFile[] children2, List<String> names) {
        long t = System.nanoTime();
        Boolean changed = (Boolean)ReadAction.compute(() -> {
            Object[] currentChildren = dir.getChildren();
            return !Arrays.equals(children2, currentChildren) || !names.equals(RefreshWorker.getNames((VirtualFile[])currentChildren));
        });
        this.vfsTime.addAndGet(System.nanoTime() - t);
        return changed;
    }

    private boolean partialDirRefresh(List<VFileEvent> events, NewVirtualFileSystem fs, VirtualDirectoryImpl dir) {
        ObjectOpenCustomHashSet actualNames;
        long t = System.nanoTime();
        Pair snapshot2 = (Pair)ReadAction.compute(() -> new Pair((Object)dir.getCachedChildren(), dir.getSuspiciousNames()));
        this.vfsTime.addAndGet(System.nanoTime() - t);
        List cached = (List)snapshot2.first;
        List wanted = (List)snapshot2.second;
        boolean dirIsCaseSensitive = dir.isCaseSensitive();
        Set namesToRefresh = CollectionFactory.createFilePathSet((Collection)wanted, (boolean)dirIsCaseSensitive);
        for (VirtualFile file2 : cached) {
            namesToRefresh.add(file2.getName());
        }
        Map<String, FileAttributes> childrenWithAttributes = null;
        if (fs instanceof BatchingFileSystem) {
            BatchingFileSystem batchingFileSystem = (BatchingFileSystem)fs;
            t = System.nanoTime();
            childrenWithAttributes = RefreshWorker.adjustCaseSensitivity(RefreshWorker.computeAllChildrenAttributes(batchingFileSystem, (VirtualFile)dir, namesToRefresh), dirIsCaseSensitive);
            this.ioTime.addAndGet(System.nanoTime() - t);
        }
        if (dirIsCaseSensitive || cached.isEmpty()) {
            actualNames = null;
        } else if (childrenWithAttributes != null) {
            actualNames = (ObjectOpenCustomHashSet)CollectionFactory.createFilePathSet(childrenWithAttributes.keySet(), (boolean)false);
        } else {
            t = System.nanoTime();
            String[] childrenNames = fs.list((VirtualFile)dir);
            actualNames = (ObjectOpenCustomHashSet)CollectionFactory.createFilePathSet((String[])childrenNames, (boolean)false);
            this.ioTime.addAndGet(System.nanoTime() - t);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("cached=" + String.valueOf(cached) + " actual=" + String.valueOf(actualNames) + " suspicious=" + String.valueOf(wanted));
        }
        ArrayList<ChildInfo> newKids = wanted.isEmpty() ? List.of() : new ArrayList<ChildInfo>(wanted.size());
        for (String newName : wanted) {
            FakeVirtualFile child;
            FileAttributes attributes;
            if (VfsUtil.isBadName((String)newName) || (attributes = this.getAttributes(fs, childrenWithAttributes, (VirtualFile)(child = new FakeVirtualFile((VirtualFile)dir, newName)))) == null) continue;
            newKids.add(this.childRecord(fs, child, attributes, true));
        }
        ArrayList<Pair<VirtualFile, FileAttributes>> existingMap = cached.isEmpty() ? List.of() : new ArrayList<Pair<VirtualFile, FileAttributes>>(cached.size());
        for (FakeVirtualFile child : cached) {
            existingMap.add(new Pair((Object)child, (Object)this.getAttributes(fs, childrenWithAttributes, (VirtualFile)child)));
        }
        this.checkCancelled(dir);
        if (this.isDirectoryChanged(dir, cached, (List<String>)wanted)) {
            return false;
        }
        this.generateCreateEvents(events, dir, newKids);
        this.generateUpdateEvents(events, fs, dir, (ObjectOpenCustomHashSet<String>)actualNames, existingMap);
        this.checkCancelled(dir);
        return !this.isDirectoryChanged(dir, cached, (List<String>)wanted);
    }

    private boolean isDirectoryChanged(VirtualDirectoryImpl dir, List<VirtualFile> cached, List<String> wanted) {
        long t = System.nanoTime();
        Boolean changed = (Boolean)ReadAction.compute(() -> !cached.equals(dir.getCachedChildren()) || !wanted.equals(dir.getSuspiciousNames()));
        this.vfsTime.addAndGet(System.nanoTime() - t);
        return changed;
    }

    @NotNull
    private static Map<String, FileAttributes> adjustCaseSensitivity(@NotNull Map<String, FileAttributes> childrenWithAttributes, boolean toCaseSensitive) {
        if (childrenWithAttributes == null) {
            RefreshWorker.$$$reportNull$$$0(0);
        }
        if (toCaseSensitive) {
            Map<String, FileAttributes> map2 = childrenWithAttributes;
            if (map2 == null) {
                RefreshWorker.$$$reportNull$$$0(1);
            }
            return map2;
        }
        Map childrenWithAttributesCaseInsensitive = CollectionFactory.createFilePathMap((int)childrenWithAttributes.size(), (boolean)false);
        childrenWithAttributesCaseInsensitive.putAll(childrenWithAttributes);
        if (childrenWithAttributesCaseInsensitive.size() != childrenWithAttributes.size()) {
            // empty if block
        }
        Map map3 = childrenWithAttributesCaseInsensitive;
        if (map3 == null) {
            RefreshWorker.$$$reportNull$$$0(2);
        }
        return map3;
    }

    @Nullable
    private FileAttributes getAttributes(@NotNull NewVirtualFileSystem fs, @Nullable Map<String, FileAttributes> dirList, @NotNull VirtualFile child) {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(3);
        }
        if (child == null) {
            RefreshWorker.$$$reportNull$$$0(4);
        }
        FileAttributes attributes = null;
        if (dirList != null) {
            attributes = dirList.get(child.getName());
        }
        if (attributes == null && !(fs instanceof BatchingFileSystem)) {
            long t = System.nanoTime();
            attributes = RefreshWorker.computeAttributesForFile(fs, child);
            this.ioTime.addAndGet(System.nanoTime() - t);
        }
        return attributes;
    }

    @Nullable
    private static FileAttributes computeAttributesForFile(NewVirtualFileSystem fs, VirtualFile file2) {
        return (FileAttributes)Cancellation.computeInNonCancelableSection(() -> fs.getAttributes(file2));
    }

    private static Map<String, FileAttributes> computeAllChildrenAttributes(@NotNull BatchingFileSystem fs, @NotNull VirtualFile dir, @Nullable Set<String> filter2) {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(5);
        }
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(6);
        }
        return (Map)Cancellation.computeInNonCancelableSection(() -> fs.listWithAttributes(dir, filter2));
    }

    private ChildInfo childRecord(NewVirtualFileSystem fs, FakeVirtualFile child, FileAttributes attributes, boolean canonicalize) {
        long t = System.nanoTime();
        String name2 = canonicalize ? fs.getCanonicallyCasedName((VirtualFile)child) : child.getName();
        boolean isEmptyDir = attributes.isDirectory() && !fs.hasChildren((VirtualFile)child);
        String symlinkTarget = attributes.isSymLink() ? fs.resolveSymLink((VirtualFile)child) : null;
        this.ioTime.addAndGet(System.nanoTime() - t);
        int nameId = this.vfsPeer.getNameId(name2);
        return new ChildInfoImpl(nameId, attributes, (ChildInfo[])(isEmptyDir ? ChildInfo.EMPTY_ARRAY : null), symlinkTarget);
    }

    private void generateDeleteEvents(List<VFileEvent> events, VirtualDirectoryImpl dir, Set<String> deletedNames, ObjectOpenCustomHashSet<String> actualNames, List<ChildInfo> newKids) {
        for (String name2 : deletedNames) {
            VirtualFileSystemEntry child = dir.findChild(name2);
            if (child == null) continue;
            if (this.checkAndScheduleFileNameChange(events, actualNames, (VirtualFile)child)) {
                newKids.removeIf(newKidCandidate -> StringUtilRt.equal((CharSequence)newKidCandidate.getName(), (CharSequence)child.getName(), (boolean)true));
                continue;
            }
            this.scheduleDeletion(events, (VirtualFile)child);
        }
    }

    private void generateCreateEvents(List<VFileEvent> events, VirtualDirectoryImpl dir, List<ChildInfo> newKids) {
        for (ChildInfo record : newKids) {
            this.scheduleCreation(events, dir, record.getName().toString(), record.getFileAttributes(), record.getSymlinkTarget());
        }
    }

    private void generateUpdateEvents(List<VFileEvent> events, NewVirtualFileSystem fs, VirtualDirectoryImpl dir, ObjectOpenCustomHashSet<String> actualNames, List<Pair<VirtualFile, @Nullable FileAttributes>> existingMap) {
        for (Pair<VirtualFile, FileAttributes> pair : existingMap) {
            NewVirtualFile child = (NewVirtualFile)pair.first;
            FileAttributes childAttributes = (FileAttributes)pair.second;
            if (childAttributes != null) {
                this.checkAndScheduleChildRefresh(events, fs, dir, child, childAttributes, true);
                this.checkAndScheduleFileNameChange(events, actualNames, (VirtualFile)child);
                continue;
            }
            this.scheduleDeletion(events, (VirtualFile)child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCancelled(NewVirtualFile stopAt) throws RefreshCancelledException {
        Consumer<? super VirtualFile> testListener = ourTestListener;
        if (testListener != null) {
            testListener.accept((VirtualFile)stopAt);
        }
        if (this.cancelled) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("cancelled at: " + String.valueOf(stopAt));
            }
            RefreshWorker.forceMarkDirty(stopAt);
            RefreshWorker refreshWorker = this;
            synchronized (refreshWorker) {
                NewVirtualFile file2;
                while ((file2 = this.refreshQueue.poll()) != null) {
                    RefreshWorker.forceMarkDirty(file2);
                    this.semaphore.up();
                }
            }
            throw new RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(NewVirtualFile file2) {
        file2.markClean();
        file2.markDirty();
    }

    private void scheduleDeletion(List<VFileEvent> events, VirtualFile file2) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("delete file=" + String.valueOf(file2));
        }
        events.add((VFileEvent)new VFileDeleteEvent(REQUESTOR, file2));
    }

    private void scheduleCreation(List<VFileEvent> events, NewVirtualFile parent, String childName, FileAttributes attributes, @Nullable String symlinkTarget) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("create parent=" + String.valueOf(parent) + " name=" + childName + " attr=" + String.valueOf(attributes));
        }
        ChildInfo[] children2 = null;
        if (attributes.isDirectory() && !attributes.isSymLink() && parent.getFileSystem() instanceof LocalFileSystem) {
            try {
                Path childPath = RefreshWorker.getChildPath(parent.getPath(), childName);
                if (childPath != null && RefreshWorker.shouldScanDirectory((VirtualFile)parent, childPath, childName)) {
                    List relevantExcluded = ContainerUtil.mapNotNull((Collection)ProjectManagerEx.getInstanceEx().getAllExcludedUrls(), url -> {
                        Path path = Path.of(VirtualFileManager.extractPath((String)url), new String[0]);
                        return path.startsWith(childPath) ? path : null;
                    });
                    long t = System.nanoTime();
                    children2 = this.scanChildren(childPath, relevantExcluded, parent);
                    this.ioTime.addAndGet(System.nanoTime() - t);
                }
            }
            catch (InvalidPathException e) {
                LOG.warn("Invalid child name: '" + childName + "'", (Throwable)e);
            }
        }
        events.add((VFileEvent)new VFileCreateEvent(REQUESTOR, (VirtualFile)parent, childName, attributes.isDirectory(), attributes, symlinkTarget, children2));
        VFilePropertyChangeEvent caseSensitivityChangingEvent = ((PersistentFSImpl)this.persistentFS).determineCaseSensitivityAndPrepareUpdate((VirtualFile)parent, childName);
        if (caseSensitivityChangingEvent != null) {
            events.add((VFileEvent)caseSensitivityChangingEvent);
        }
    }

    @Nullable
    private static Path getChildPath(String parentPath, String childName) {
        try {
            return Path.of(parentPath, childName);
        }
        catch (InvalidPathException e) {
            LOG.warn("Invalid child name: '" + childName + "'", (Throwable)e);
            return null;
        }
    }

    private static boolean shouldScanDirectory(VirtualFile parent, Path child, String childName) {
        if (FileTypeManager.getInstance().isFileIgnored(childName)) {
            return false;
        }
        for (Project openProject2 : ProjectManager.getInstance().getOpenProjects()) {
            Path path;
            if (((Boolean)ReadAction.compute(() -> ProjectFileIndex.getInstance((Project)openProject2).isUnderIgnored(parent))).booleanValue()) {
                return false;
            }
            String projectRootPath = openProject2.getBasePath();
            if (projectRootPath == null || !child.startsWith(path = Path.of(projectRootPath, new String[0]))) continue;
            return true;
        }
        return false;
    }

    private ChildInfo @Nullable [] scanChildren(final Path root, final List<Path> excluded, final NewVirtualFile currentDir) {
        final Stack stack = new Stack();
        int nameId = this.vfsPeer.getNameId("");
        ChildInfoImpl fakeRoot = new ChildInfoImpl(nameId, null, null, null);
        stack.push((Object)new SmartList((Object)fakeRoot));
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){
            private int checkCanceledCount;

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (!dir.equals(root)) {
                    this.visitFile(dir, attrs);
                }
                if (SystemInfoRt.isWindows && attrs.isOther()) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (excluded.contains(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                stack.push(new ArrayList());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                if ((++this.checkCanceledCount & 0xF) == 0) {
                    RefreshWorker.this.checkCancelled(currentDir);
                }
                FileAttributes attributes = FileAttributes.fromNio((Path)file2, (BasicFileAttributes)attrs);
                String symLinkTarget = attrs.isSymbolicLink() ? FileUtilRt.toSystemIndependentName((String)file2.toRealPath(new LinkOption[0]).toString()) : null;
                int nameId = RefreshWorker.this.vfsPeer.getNameId(file2.getFileName().toString());
                ChildInfoImpl info = new ChildInfoImpl(nameId, attributes, null, symLinkTarget);
                ((List)stack.peek()).add(info);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                List childInfos = (List)stack.pop();
                List parentInfos = (List)stack.peek();
                ChildInfo parentInfo = (ChildInfo)ContainerUtil.getLastItem((List)parentInfos);
                ChildInfo[] children2 = childInfos.toArray(ChildInfo.EMPTY_ARRAY);
                ChildInfo newInfo = ((ChildInfoImpl)parentInfo).withChildren(children2);
                parentInfos.set(parentInfos.size() - 1, newInfo);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file2, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
        return ((ChildInfo)((List)stack.pop()).get(0)).getChildren();
    }

    private void checkAndScheduleChildRefresh(List<VFileEvent> events, NewVirtualFileSystem fs, @Nullable NewVirtualFile parent, NewVirtualFile child, FileAttributes childAttributes, boolean enqueue) {
        boolean fileDirty = child.isDirty();
        if (LOG.isTraceEnabled()) {
            LOG.trace("file=" + String.valueOf(child) + " dirty=" + fileDirty);
        }
        if (!fileDirty) {
            return;
        }
        if (this.checkAndScheduleFileTypeChange(events, fs, parent, child, childAttributes)) {
            child.markClean();
            return;
        }
        this.checkWritableAttributeChange(events, (VirtualFile)child, this.persistentFS.isWritable((VirtualFile)child), childAttributes.isWritable());
        if (SystemInfoRt.isWindows) {
            this.checkHiddenAttributeChange(events, (VirtualFile)child, child.is(VFileProperty.HIDDEN), childAttributes.isHidden());
        }
        if (childAttributes.isSymLink()) {
            long t = System.nanoTime();
            String target = fs.resolveSymLink((VirtualFile)child);
            this.ioTime.addAndGet(System.nanoTime() - t);
            this.checkSymbolicLinkChange(events, (VirtualFile)child, child.getCanonicalPath(), target);
        }
        if (!childAttributes.isDirectory()) {
            long oldTimestamp = this.persistentFS.getTimeStamp((VirtualFile)child);
            long newTimestamp = childAttributes.lastModified;
            long oldLength = this.persistentFS.getLastRecordedLength((VirtualFile)child);
            long newLength = childAttributes.length;
            if (oldTimestamp != newTimestamp || oldLength != newLength) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("update file=" + String.valueOf(child) + (String)(oldTimestamp != newTimestamp ? " TS=" + oldTimestamp + "->" + newTimestamp : "") + (String)(oldLength != newLength ? " len=" + oldLength + "->" + newLength : ""));
                }
                events.add((VFileEvent)new VFileContentChangeEvent(REQUESTOR, (VirtualFile)child, child.getModificationStamp(), -1L, oldTimestamp, newTimestamp, oldLength, newLength));
            }
            child.markClean();
        } else if (enqueue && this.isRecursive) {
            if (child instanceof VirtualDirectoryImpl) {
                this.semaphore.down();
                this.refreshQueue.add(child);
            } else {
                LOG.error("not a directory: " + String.valueOf(child) + " (" + String.valueOf(child.getClass()) + ")");
            }
        }
    }

    private boolean checkAndScheduleFileTypeChange(List<VFileEvent> events, NewVirtualFileSystem fs, @Nullable NewVirtualFile parent, NewVirtualFile child, FileAttributes childAttributes) {
        boolean isFileTypeChanged;
        boolean currentIsDirectory = child.isDirectory();
        boolean upToDateIsDirectory = childAttributes.isDirectory();
        boolean currentIsSymlink = child.is(VFileProperty.SYMLINK);
        boolean upToDateIsSymlink = childAttributes.isSymLink();
        boolean currentIsSpecial = child.is(VFileProperty.SPECIAL);
        boolean upToDateIsSpecial = childAttributes.isSpecial();
        boolean bl = isFileTypeChanged = currentIsSymlink != upToDateIsSymlink || currentIsSpecial != upToDateIsSpecial;
        if (currentIsDirectory != upToDateIsDirectory || isFileTypeChanged && !Boolean.getBoolean("refresh.ignore.file.type.changes")) {
            this.scheduleDeletion(events, (VirtualFile)child);
            if (parent != null) {
                long t = System.nanoTime();
                String symlinkTarget = upToDateIsSymlink ? fs.resolveSymLink((VirtualFile)child) : null;
                this.ioTime.addAndGet(System.nanoTime() - t);
                this.scheduleCreation(events, parent, child.getName(), childAttributes, symlinkTarget);
            } else {
                LOG.error("transgender orphan: " + String.valueOf(child) + " " + String.valueOf(childAttributes));
            }
            return true;
        }
        return false;
    }

    private boolean checkAndScheduleFileNameChange(List<VFileEvent> events, @Nullable ObjectOpenCustomHashSet<String> actualNames, VirtualFile child) {
        String currentName;
        String actualName;
        if (actualNames != null && (actualName = (String)actualNames.get((Object)(currentName = child.getName()))) != null && !currentName.equals(actualName)) {
            this.scheduleAttributeChange(events, child, "name", currentName, actualName);
            return true;
        }
        return false;
    }

    private void checkWritableAttributeChange(List<VFileEvent> events, VirtualFile file2, boolean oldWritable, boolean newWritable) {
        if (oldWritable != newWritable) {
            this.scheduleAttributeChange(events, file2, "writable", oldWritable, newWritable);
        }
    }

    private void checkHiddenAttributeChange(List<VFileEvent> events, VirtualFile child, boolean oldHidden, boolean newHidden) {
        if (oldHidden != newHidden) {
            this.scheduleAttributeChange(events, child, "HIDDEN", oldHidden, newHidden);
        }
    }

    private void checkSymbolicLinkChange(List<VFileEvent> events, VirtualFile child, String oldTarget, String currentTarget) {
        String currentVfsTarget;
        String string = currentVfsTarget = currentTarget != null ? FileUtilRt.toSystemIndependentName((String)currentTarget) : null;
        if (!Objects.equals(oldTarget, currentVfsTarget)) {
            this.scheduleAttributeChange(events, child, "symlink", oldTarget, currentVfsTarget);
        }
    }

    private void scheduleAttributeChange(List<VFileEvent> events, VirtualFile file2, @VirtualFile.PropName String property, Object current, Object upToDate) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("update file=" + String.valueOf(file2) + " " + property + "=" + String.valueOf(current) + "->" + String.valueOf(upToDate));
        }
        events.add((VFileEvent)new VFilePropertyChangeEvent(REQUESTOR, file2, property, current, upToDate));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenWithAttributes";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/RefreshWorker";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/RefreshWorker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustCaseSensitivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustCaseSensitivity";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeAllChildrenAttributes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static final class RefreshCancelledException
    extends RuntimeException {
        private RefreshCancelledException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

