/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.keyFMap.KeyFMap;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class VfsData
implements Closeable {
    private static final Logger LOG = Logger.getInstance(VfsData.class);
    private static final boolean USE_SOFT_REFERENCES = SystemProperties.getBooleanProperty((String)"platform.vfs.cache.use-soft-references", (boolean)true);
    private static final int SEGMENT_BITS = 9;
    private static final int SEGMENT_SIZE = 512;
    private static final int OFFSET_MASK = 511;
    private final Application app;
    private final PersistentFSImpl owningPersistentFS;
    private final Object deadMarker;
    private final ConcurrentIntObjectMap<Segment> segments;
    private final ConcurrentBitSet invalidatedFileIds;
    private IntSet queueOfFileIdsToBeInvalidated;
    private final IntObjectMap<VirtualDirectoryImpl> changedParents;
    private final Disposable writeActionListenerDisposer;
    private final AtomicInteger segmentsCreated;
    private final AtomicInteger directoriesCreated;
    private final AtomicInteger filesCreated;
    private final BatchCallback otelHandle;

    public VfsData(final @NotNull Application app, @NotNull PersistentFSImpl pfs) {
        if (app == null) {
            VfsData.$$$reportNull$$$0(0);
        }
        if (pfs == null) {
            VfsData.$$$reportNull$$$0(1);
        }
        this.deadMarker = ObjectUtils.sentinel((String)"dead file");
        this.segments = USE_SOFT_REFERENCES ? ConcurrentCollectionFactory.createConcurrentIntObjectSoftValueMap() : ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.invalidatedFileIds = ConcurrentBitSet.create();
        this.queueOfFileIdsToBeInvalidated = new IntOpenHashSet();
        this.changedParents = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.writeActionListenerDisposer = Disposer.newDisposable();
        this.segmentsCreated = new AtomicInteger();
        this.directoriesCreated = new AtomicInteger();
        this.filesCreated = new AtomicInteger();
        this.app = app;
        this.owningPersistentFS = pfs;
        LOG.info("Use SoftReference in VFS cache: " + USE_SOFT_REFERENCES);
        app.addApplicationListener(new ApplicationListener(){

            public void writeActionFinished(@NotNull Object action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!app.isWriteAccessAllowed()) {
                    VfsData.this.killInvalidatedFiles();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/vfs/newvfs/impl/VfsData$1", "writeActionFinished"));
            }
        }, this.writeActionListenerDisposer);
        this.otelHandle = this.setupOTelMonitoring();
    }

    private BatchCallback setupOTelMonitoring() {
        Meter vfsMeter = TelemetryManager.getInstance().getMeter(PlatformScopesKt.VFS);
        ObservableDoubleMeasurement cacheSegmentsCount = vfsMeter.gaugeBuilder("VFS.cache.segments").buildObserver();
        ObservableLongMeasurement cacheSegmentsCreated = vfsMeter.counterBuilder("VFS.cache.segmentsCreated").buildObserver();
        ObservableLongMeasurement cacheDirectoriesCreated = vfsMeter.counterBuilder("VFS.cache.directoriesCreated").buildObserver();
        ObservableLongMeasurement cacheFilesCreated = vfsMeter.counterBuilder("VFS.cache.filesCreated").buildObserver();
        return vfsMeter.batchCallback(() -> {
            cacheSegmentsCount.record((double)this.segments.size());
            cacheSegmentsCreated.record((long)this.segmentsCreated.get());
            cacheDirectoriesCreated.record((long)this.directoriesCreated.get());
            cacheFilesCreated.record((long)this.filesCreated.get());
        }, (ObservableMeasurement)cacheSegmentsCount, new ObservableMeasurement[]{cacheSegmentsCreated, cacheDirectoriesCreated, cacheFilesCreated});
    }

    @Override
    public void close() {
        this.otelHandle.close();
        Disposer.dispose((Disposable)this.writeActionListenerDisposer);
    }

    @NotNull
    PersistentFSImpl owningPersistentFS() {
        PersistentFSImpl persistentFSImpl = this.owningPersistentFS;
        if (persistentFSImpl == null) {
            VfsData.$$$reportNull$$$0(2);
        }
        return persistentFSImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killInvalidatedFiles() {
        Object object = this.deadMarker;
        synchronized (object) {
            if (!this.queueOfFileIdsToBeInvalidated.isEmpty()) {
                IntIterator iterator = this.queueOfFileIdsToBeInvalidated.iterator();
                while (iterator.hasNext()) {
                    int id2 = iterator.nextInt();
                    Segment segment = Objects.requireNonNull(this.segmentForFileId(id2, false));
                    segment.killFileData(id2, this.deadMarker);
                    this.changedParents.remove(id2);
                }
                this.queueOfFileIdsToBeInvalidated = new IntOpenHashSet();
            }
        }
    }

    @Nullable
    VirtualFileSystemEntry cachedFileById(int id2, @NotNull VirtualDirectoryImpl parent) {
        Segment segment;
        if (parent == null) {
            VfsData.$$$reportNull$$$0(3);
        }
        if ((segment = this.segmentForFileId(id2, false)) == null) {
            return null;
        }
        Object entryData = segment.fileDataById(id2);
        if (entryData == null) {
            return null;
        }
        if (entryData == this.deadMarker) {
            throw VfsData.reportDeadFileAccess(new VirtualFileImpl(id2, segment, parent));
        }
        if (entryData instanceof DirectoryData) {
            DirectoryData directoryData = (DirectoryData)entryData;
            VirtualDirectoryImpl directory = directoryData.directory;
            if (directory == null) {
                throw new AssertionError((Object)("Bug: " + String.valueOf(directoryData) + " must have .directory != null set at initialization!"));
            }
            if (directory.getId() != id2) {
                throw new AssertionError((Object)("Bug: cachedFileById(" + id2 + ") returns " + String.valueOf((Object)directory) + " with different id(=" + directory.getId() + ")"));
            }
            return directory;
        }
        this.filesCreated.incrementAndGet();
        return new VirtualFileImpl(id2, segment, parent);
    }

    @Nullable
    public VirtualDirectoryImpl cachedDir(int id2) {
        Segment segment = this.segmentForFileId(id2, false);
        if (segment == null) {
            return null;
        }
        Object entryData = segment.fileDataById(id2);
        if (entryData == null) {
            return null;
        }
        if (entryData == this.deadMarker) {
            return null;
        }
        if (entryData instanceof DirectoryData) {
            DirectoryData directoryData = (DirectoryData)entryData;
            VirtualDirectoryImpl dir = directoryData.directory;
            if (dir != null && !dir.isValid()) {
                return null;
            }
            return dir;
        }
        return null;
    }

    @NotNull
    public Iterable<? extends VirtualFileSystemEntry> getCachedDirs() {
        ArrayList<VirtualDirectoryImpl> cachedDirs = new ArrayList<VirtualDirectoryImpl>();
        for (Segment segment : this.segments.values()) {
            Object[] fileDataEntries = segment.objectFieldsArray;
            int length = fileDataEntries.length;
            for (int i2 = 0; i2 < length; ++i2) {
                Object entry = Segment.OBJECT_FIELDS_HANDLE.getVolatile(fileDataEntries, i2);
                if (!(entry instanceof DirectoryData)) continue;
                DirectoryData directoryData = (DirectoryData)entry;
                VirtualDirectoryImpl directory = directoryData.directory;
                if (directory == null || !directory.isValid()) continue;
                cachedDirs.add(directory);
            }
        }
        ArrayList<VirtualDirectoryImpl> arrayList = cachedDirs;
        if (arrayList == null) {
            VfsData.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static InvalidVirtualFileAccessException reportDeadFileAccess(@NotNull VirtualFileSystemEntry file2) {
        if (file2 == null) {
            VfsData.$$$reportNull$$$0(5);
        }
        return new InvalidVirtualFileAccessException("Accessing dead virtual file: " + file2.getUrl());
    }

    @Contract(value="_,true->!null")
    public Segment segmentForFileId(int fileId, boolean create2) {
        int segmentIndex = VfsData.segmentIndex(fileId);
        Segment segment = (Segment)this.segments.get(segmentIndex);
        if (segment != null || !create2) {
            return segment;
        }
        return (Segment)this.segments.cacheOrGet(segmentIndex, (Object)new Segment(segmentIndex, this));
    }

    @NotNull
    String getNameByFileId(int fileId) {
        String string = this.owningPersistentFS.peer().getName(fileId);
        if (string == null) {
            VfsData.$$$reportNull$$$0(6);
        }
        return string;
    }

    boolean isFileValid(int id2) {
        return !this.invalidatedFileIds.get(id2);
    }

    @Nullable
    VirtualDirectoryImpl getChangedParent(int id2) {
        return (VirtualDirectoryImpl)((Object)this.changedParents.get(id2));
    }

    private void changeParent(int id2, @NotNull VirtualDirectoryImpl parent) {
        if (parent == null) {
            VfsData.$$$reportNull$$$0(7);
        }
        this.app.assertWriteAccessAllowed();
        this.changedParents.put(id2, (Object)parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateFile(int id2) {
        this.invalidatedFileIds.set(id2);
        Object object = this.deadMarker;
        synchronized (object) {
            this.queueOfFileIdsToBeInvalidated.add(id2);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{segments: " + this.segments.size() + ", connected: " + this.owningPersistentFS.isConnected() + "}";
    }

    private static int objectOffsetInSegment(int fileId) {
        if (fileId <= 0) {
            throw new IllegalArgumentException("invalid argument id: " + fileId);
        }
        return fileId & 0x1FF;
    }

    private static int segmentIndex(int fileId) {
        return fileId >>> 9;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pfs";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VfsData";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "owningPersistentFS";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedDirs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameByFileId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cachedFileById";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportDeadFileAccess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "changeParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class Segment {
        private static final int INT_FIELDS_COUNT = 1;
        private static final int FLAGS_AND_MOD_COUNT_FIELD_NO = 0;
        private static final VarHandle OBJECT_FIELDS_HANDLE;
        private static final VarHandle INT_FIELDS_HANDLE;
        private final int segmentIndex;
        private final VfsData owningVfsData;
        private final Object[] objectFieldsArray;
        private final int[] intFieldsArray;
        @Nullable
        Segment replacement;

        @VisibleForTesting
        public Segment(int segmentIndex, @NotNull VfsData owningVfsData) {
            if (owningVfsData == null) {
                Segment.$$$reportNull$$$0(0);
            }
            this(segmentIndex, owningVfsData, new Object[512], new int[512]);
        }

        private Segment(int segmentIndex, @NotNull VfsData owningVfsData, Object @NotNull [] objectFieldsArray, int @NotNull [] intFieldsArray) {
            if (owningVfsData == null) {
                Segment.$$$reportNull$$$0(1);
            }
            if (objectFieldsArray == null) {
                Segment.$$$reportNull$$$0(2);
            }
            if (intFieldsArray == null) {
                Segment.$$$reportNull$$$0(3);
            }
            this.segmentIndex = segmentIndex;
            this.objectFieldsArray = objectFieldsArray;
            this.intFieldsArray = intFieldsArray;
            this.owningVfsData = owningVfsData;
            owningVfsData.segmentsCreated.incrementAndGet();
        }

        @NotNull
        VfsData owningVfsData() {
            VfsData vfsData = this.owningVfsData;
            if (vfsData == null) {
                Segment.$$$reportNull$$$0(4);
            }
            return vfsData;
        }

        void setUserMap(int fileId, @NotNull KeyFMap map2) {
            int index;
            Object oldMap;
            if (map2 == null) {
                Segment.$$$reportNull$$$0(5);
            }
            if ((oldMap = OBJECT_FIELDS_HANDLE.getAndSet(this.objectFieldsArray, index = VfsData.objectOffsetInSegment(fileId), map2)) == null) {
                throw new IllegalStateException("file[#" + fileId + "]: cache record wasn't initialized yet, but already used (set " + String.valueOf(map2) + ")");
            }
        }

        @NotNull
        KeyFMap getUserMap(@NotNull VirtualFileSystemEntry file2, int id2) {
            Object o;
            if (file2 == null) {
                Segment.$$$reportNull$$$0(6);
            }
            if (!((o = this.fileDataById(id2)) instanceof KeyFMap)) {
                throw VfsData.reportDeadFileAccess(file2);
            }
            KeyFMap keyFMap = (KeyFMap)o;
            if (keyFMap == null) {
                Segment.$$$reportNull$$$0(7);
            }
            return keyFMap;
        }

        boolean changeUserMap(int fileId, KeyFMap oldMap, KeyFMap newMap) {
            if (oldMap == null) {
                throw new IllegalStateException("file[#" + fileId + "]: cache record wasn't initialized yet, but already used (change -> " + String.valueOf(newMap) + ")");
            }
            int offset = VfsData.objectOffsetInSegment(fileId);
            return OBJECT_FIELDS_HANDLE.compareAndSet(this.objectFieldsArray, offset, oldMap, newMap);
        }

        boolean getFlag(int fileId, @VirtualFileSystemEntry.Flags int mask) {
            BitUtil.assertOneBitMask((int)mask);
            assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
            int offset = Segment.fieldOffset(fileId, 0);
            int flags = INT_FIELDS_HANDLE.getVolatile(this.intFieldsArray, offset);
            return (flags & mask) != 0;
        }

        void setFlag(int fileId, @VirtualFileSystemEntry.Flags int mask, boolean value) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set flag " + Integer.toHexString(mask) + "=" + value + " for id=" + fileId);
            }
            assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
            int offset = Segment.fieldOffset(fileId, 0);
            this.updateFlagsAtomically(offset, oldFlags -> BitUtil.set((int)oldFlags, (int)mask, (boolean)value));
        }

        private void updateFlagsAtomically(int offset, @NotNull IntUnaryOperator op) {
            int newFlags;
            int oldFlags;
            if (op == null) {
                Segment.$$$reportNull$$$0(8);
            }
            while (!INT_FIELDS_HANDLE.compareAndSet(this.intFieldsArray, offset, oldFlags = INT_FIELDS_HANDLE.getVolatile(this.intFieldsArray, offset), newFlags = op.applyAsInt(oldFlags))) {
            }
        }

        void setFlags(int fileId, @VirtualFileSystemEntry.Flags int combinedMask, @VirtualFileSystemEntry.Flags int combinedValue) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set flags " + Integer.toHexString(combinedMask) + "=" + combinedValue + " for id=" + fileId);
            }
            assert ((combinedMask & 0xFFFFFF) == 0) : "Unexpected flag";
            assert ((~combinedMask & combinedValue) == 0) : "Value (" + Integer.toHexString(combinedValue) + ") set bits outside mask (" + Integer.toHexString(combinedMask) + ")";
            int offset = Segment.fieldOffset(fileId, 0);
            this.updateFlagsAtomically(offset, oldFlags -> oldFlags & ~combinedMask | combinedValue);
        }

        long getModificationStamp(int fileId) {
            int offset = Segment.fieldOffset(fileId, 0);
            int flags = INT_FIELDS_HANDLE.getVolatile(this.intFieldsArray, offset);
            return flags & 0xFFFFFF;
        }

        void setModificationStamp(int fileId, long stamp) {
            int offset = Segment.fieldOffset(fileId, 0);
            this.updateFlagsAtomically(offset, oldFlags -> oldFlags & 0xFF000000 | (int)stamp & 0xFFFFFF);
        }

        void changeParent(int fileId, VirtualDirectoryImpl directory) {
            int segmentIndex = VfsData.segmentIndex(fileId);
            assert (this.replacement == null);
            this.replacement = new Segment(this.segmentIndex, this.owningVfsData, this.objectFieldsArray, this.intFieldsArray);
            boolean replaced = this.owningVfsData.segments.replace(segmentIndex, (Object)this, (Object)this.replacement);
            assert (replaced);
            this.owningVfsData.changeParent(fileId, directory);
        }

        void initFileData(int fileId, @NotNull Object fileData, @Nullable VirtualDirectoryImpl parent) throws FileAlreadyCreatedException {
            Object existingData;
            if (fileData == null) {
                Segment.$$$reportNull$$$0(9);
            }
            int offset = VfsData.objectOffsetInSegment(fileId);
            if (fileData instanceof DirectoryData) {
                this.owningVfsData.directoriesCreated.incrementAndGet();
            }
            if ((existingData = OBJECT_FIELDS_HANDLE.compareAndExchange(this.objectFieldsArray, offset, null, fileData)) != null) {
                DirectoryData parentData;
                FSRecordsImpl vfsPeer = this.owningVfsData.owningPersistentFS.peer();
                int parentId = vfsPeer.getParent(fileId);
                if (parentId == 0) {
                    parentData = null;
                } else {
                    Segment parentSegment = this.owningVfsData.segmentForFileId(parentId, false);
                    parentData = (DirectoryData)parentSegment.fileDataById(parentId);
                }
                throw new FileAlreadyCreatedException(this.describeAlreadyCreatedFile(fileId) + " data: " + String.valueOf(fileData) + ", alreadyExistingData: " + String.valueOf(existingData) + ", parentData: " + String.valueOf(parentData) + (String)(parent != null ? ", parent.data: " + String.valueOf(parent.directoryData) + " equals: " + (parentData == parent.directoryData) : ", parent = null") + ", synchronized(parentData): " + String.valueOf(parentData != null ? Boolean.valueOf(Thread.holdsLock(parentData)) : "..."));
            }
        }

        Object fileDataById(int fileId) {
            int offset = VfsData.objectOffsetInSegment(fileId);
            return OBJECT_FIELDS_HANDLE.getVolatile(this.objectFieldsArray, offset);
        }

        void killFileData(int fileId, Object deadMarker) {
            OBJECT_FIELDS_HANDLE.setVolatile(this.objectFieldsArray, VfsData.objectOffsetInSegment(fileId), deadMarker);
        }

        public String toString() {
            return "Segment[#" + this.segmentIndex + "][replacement: " + String.valueOf(this.replacement) + "]";
        }

        private static int fieldOffset(int fileId, int fieldNo) {
            if (fileId <= 0) {
                throw new IllegalArgumentException("invalid fileId: " + fileId);
            }
            assert (0 <= fieldNo && fieldNo < 1) : "fieldNo(=" + fieldNo + ") must be in [0,1)";
            return (fileId & 0x1FF) * 1 + fieldNo;
        }

        @NotNull
        private String describeAlreadyCreatedFile(int fileId) {
            FSRecordsImpl vfsPeer = this.owningVfsData.owningPersistentFS.peer();
            int parentId = vfsPeer.getParent(fileId);
            int nameId = vfsPeer.getNameIdByFileId(fileId);
            String fileName = vfsPeer.getNameByNameId(nameId);
            String description = "fileId=" + fileId + "; nameId=" + nameId + "(" + fileName + "); parentId=" + parentId;
            if (parentId > 0) {
                description = description + "; parent.name=" + vfsPeer.getName(parentId) + "; parent.children=" + String.valueOf(vfsPeer.list(parentId)) + "; ";
            }
            String string = description;
            if (string == null) {
                Segment.$$$reportNull$$$0(10);
            }
            return string;
        }

        static {
            try {
                OBJECT_FIELDS_HANDLE = MethodHandles.arrayElementVarHandle(Object[].class).withInvokeExactBehavior();
                INT_FIELDS_HANDLE = MethodHandles.arrayElementVarHandle(int[].class).withInvokeExactBehavior();
            }
            catch (Throwable t) {
                throw new ExceptionInInitializerError(t);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 7, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owningVfsData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objectFieldsArray";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intFieldsArray";
                    break;
                }
                case 4: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$Segment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "op";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$Segment";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "owningVfsData";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserMap";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "describeAlreadyCreatedFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 7: 
                case 10: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setUserMap";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserMap";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFlagsAtomically";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "initFileData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 7, 10 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static final class DirectoryData {
        private static final AtomicFieldUpdater<DirectoryData, KeyFMap> USER_MAP_UPDATER = AtomicFieldUpdater.forFieldOfType(DirectoryData.class, KeyFMap.class);
        @NotNull
        volatile KeyFMap userMap = KeyFMap.EMPTY_MAP;
        @NotNull
        volatile ChildrenIds children = ChildrenIds.EMPTY;
        private volatile Set<CharSequence> adoptedNames;
        private VirtualDirectoryImpl directory = null;

        public void assignDirectory(@NotNull VirtualDirectoryImpl directory) {
            if (directory == null) {
                DirectoryData.$$$reportNull$$$0(0);
            }
            if (this.directory != null) {
                throw new IllegalStateException(".directory(=" + String.valueOf((Object)this.directory) + ") must not be re-assigned, but: " + String.valueOf((Object)directory));
            }
            this.directory = directory;
        }

        boolean changeUserMap(@NotNull KeyFMap oldMap, @NotNull KeyFMap newMap) {
            if (oldMap == null) {
                DirectoryData.$$$reportNull$$$0(1);
            }
            if (newMap == null) {
                DirectoryData.$$$reportNull$$$0(2);
            }
            return USER_MAP_UPDATER.compareAndSet((Object)this, (Object)oldMap, (Object)newMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAdoptedName(@NotNull CharSequence name2) {
            Set<CharSequence> adopted;
            if (name2 == null) {
                DirectoryData.$$$reportNull$$$0(3);
            }
            if ((adopted = this.adoptedNames) == null) {
                return false;
            }
            Set<CharSequence> set = adopted;
            synchronized (set) {
                return adopted.contains(name2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeAdoptedName(@NotNull CharSequence name2) {
            Set<CharSequence> adopted;
            if (name2 == null) {
                DirectoryData.$$$reportNull$$$0(4);
            }
            if ((adopted = this.adoptedNames) == null) {
                return;
            }
            Set<CharSequence> set = adopted;
            synchronized (set) {
                boolean removed = adopted.remove(name2);
                if (removed && adopted.isEmpty()) {
                    this.adoptedNames = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addAdoptedName(@NotNull String name2, boolean caseSensitive) {
            Set<CharSequence> adopted;
            if (name2 == null) {
                DirectoryData.$$$reportNull$$$0(5);
            }
            Set<CharSequence> set = adopted = this.getOrCreateAdoptedNames(caseSensitive);
            synchronized (set) {
                adopted.add(name2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addAdoptedNames(@NotNull Collection<? extends CharSequence> names, boolean caseSensitive) {
            Set<CharSequence> adopted;
            if (names == null) {
                DirectoryData.$$$reportNull$$$0(6);
            }
            Set<CharSequence> set = adopted = this.getOrCreateAdoptedNames(caseSensitive);
            synchronized (set) {
                adopted.addAll(names);
            }
        }

        @NotNull
        private Set<CharSequence> getOrCreateAdoptedNames(boolean caseSensitive) {
            Set adopted = this.adoptedNames;
            if (adopted == null) {
                this.adoptedNames = adopted = CollectionFactory.createCharSequenceSet((boolean)caseSensitive);
            }
            Set set = adopted;
            if (set == null) {
                DirectoryData.$$$reportNull$$$0(7);
            }
            return set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Unmodifiable @NotNull List<String> getAdoptedNames() {
            Set<CharSequence> adopted = this.adoptedNames;
            if (adopted == null) {
                List<String> list2 = Collections.emptyList();
                if (list2 != null) return list2;
                DirectoryData.$$$reportNull$$$0(8);
                return list2;
            }
            Set<CharSequence> set = adopted;
            // MONITORENTER : set
            List list3 = ContainerUtil.map(adopted, (Function)Functions.TO_STRING());
            // MONITOREXIT : set
            if (list3 != null) return list3;
            DirectoryData.$$$reportNull$$$0(9);
            return list3;
        }

        void clearAdoptedNames() {
            this.adoptedNames = null;
        }

        @NonNls
        public String toString() {
            return "DirectoryData{userMap=" + String.valueOf(this.userMap) + ", children=" + String.valueOf(this.children) + ", adoptedNames=" + String.valueOf(this.adoptedNames) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldMap";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newMap";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$DirectoryData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$DirectoryData";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateAdoptedNames";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdoptedNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "assignDirectory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "changeUserMap";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAdoptedName";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAdoptedName";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addAdoptedName";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addAdoptedNames";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static final class ChildrenIds {
        public static final ChildrenIds EMPTY = new ChildrenIds(ArrayUtilRt.EMPTY_INT_ARRAY, true, false);
        private static final byte SORTED_BY_NAME_MASK = 1;
        private static final byte ALL_CHILDREN_LOADED_MASK = 2;
        private final int[] ids;
        private final int flags;

        public ChildrenIds(int[] ids, boolean sortedByName, boolean allChildrenLoaded) {
            this(ids, (sortedByName ? 1 : 0) | (allChildrenLoaded ? 2 : 0));
        }

        private ChildrenIds(int[] ids, int flags) {
            this.ids = ids;
            this.flags = flags;
        }

        public int size() {
            return this.ids.length;
        }

        public int id(int index) {
            return this.ids[index];
        }

        public boolean isSorted() {
            return (this.flags & 1) != 0;
        }

        public boolean areAllChildrenLoaded() {
            return (this.flags & 2) != 0;
        }

        public IntOpenHashSet toIntSet() {
            return new IntOpenHashSet(this.ids);
        }

        public VirtualFileSystemEntry @NotNull [] asFiles(@NotNull @NotNull IntFunction<? extends @NotNull VirtualFileSystemEntry> fileLoader) {
            if (fileLoader == null) {
                ChildrenIds.$$$reportNull$$$0(0);
            }
            VirtualFileSystemEntry[] children2 = new VirtualFileSystemEntry[this.ids.length];
            for (int i2 = 0; i2 < this.ids.length; ++i2) {
                VirtualFileSystemEntry child;
                int id2 = this.ids[i2];
                children2[i2] = child = fileLoader.apply(id2);
            }
            if (children2 == null) {
                ChildrenIds.$$$reportNull$$$0(1);
            }
            return children2;
        }

        @NotNull
        public ChildrenIds withAllChildrenLoaded(boolean allChildrenLoaded) {
            if (this.areAllChildrenLoaded() == allChildrenLoaded) {
                ChildrenIds childrenIds = this;
                if (childrenIds == null) {
                    ChildrenIds.$$$reportNull$$$0(2);
                }
                return childrenIds;
            }
            return new ChildrenIds(this.ids, this.isSorted(), allChildrenLoaded);
        }

        @NotNull
        public ChildrenIds withIds(int[] updatedIds) {
            return new ChildrenIds(updatedIds, this.flags);
        }

        public ChildrenIds sorted(@NotNull @NotNull IntFunction<? extends @NotNull VirtualFileSystemEntry> fileLoader, @NotNull Comparator<? super VirtualFileSystemEntry> comparator) {
            if (fileLoader == null) {
                ChildrenIds.$$$reportNull$$$0(3);
            }
            if (comparator == null) {
                ChildrenIds.$$$reportNull$$$0(4);
            }
            if (this.ids.length <= 1) {
                return new ChildrenIds(this.ids, true, this.areAllChildrenLoaded());
            }
            VirtualFileSystemEntry[] files2 = this.asFiles(fileLoader);
            ContainerUtil.sort((Object[])files2, comparator);
            int[] sortedIds = new int[this.ids.length];
            for (int i2 = 0; i2 < files2.length; ++i2) {
                sortedIds[i2] = files2[i2].getId();
            }
            return new ChildrenIds(sortedIds, true, this.areAllChildrenLoaded());
        }

        public int indexOfId(int id2) {
            return ArrayUtil.indexOf((int[])this.ids, (int)id2);
        }

        public int findIndexByName(@NotNull CharSequence name2, @NotNull Comparator<? super CharSequence> namesComparator, @NotNull @NotNull IntFunction<? extends @NotNull CharSequence> nameLoader) {
            if (name2 == null) {
                ChildrenIds.$$$reportNull$$$0(5);
            }
            if (namesComparator == null) {
                ChildrenIds.$$$reportNull$$$0(6);
            }
            if (nameLoader == null) {
                ChildrenIds.$$$reportNull$$$0(7);
            }
            if (!this.isSorted()) {
                throw new IllegalStateException("Children must be sorted for binary search");
            }
            return ObjectUtils.binarySearch((int)0, (int)this.ids.length, mid -> namesComparator.compare((CharSequence)nameLoader.apply(this.ids[mid]), name2));
        }

        @NotNull
        public ChildrenIds insertAt(int index, int id2) {
            int[] updatedIds = ArrayUtil.insert((int[])this.ids, (int)index, (int)id2);
            ChildrenIds childrenIds = this.withIds(updatedIds);
            if (childrenIds == null) {
                ChildrenIds.$$$reportNull$$$0(8);
            }
            return childrenIds;
        }

        @NotNull
        public ChildrenIds appendId(int id2) {
            ChildrenIds childrenIds = this.appendId(id2, false);
            if (childrenIds == null) {
                ChildrenIds.$$$reportNull$$$0(9);
            }
            return childrenIds;
        }

        @NotNull
        public ChildrenIds appendId(int id2, boolean stillSorted) {
            int[] updatedIds = ArrayUtil.append((int[])this.ids, (int)id2);
            return new ChildrenIds(updatedIds, stillSorted, this.areAllChildrenLoaded());
        }

        @NotNull
        public ChildrenIds removeAt(int index) {
            int[] updatedIds = ArrayUtil.remove((int[])this.ids, (int)index);
            ChildrenIds childrenIds = this.withIds(updatedIds);
            if (childrenIds == null) {
                ChildrenIds.$$$reportNull$$$0(10);
            }
            return childrenIds;
        }

        @NotNull
        public ChildrenIds removeIds(@NotNull IntSet idsToRemove) {
            if (idsToRemove == null) {
                ChildrenIds.$$$reportNull$$$0(11);
            }
            int[] newIds = new int[this.ids.length];
            int newIdsCount = 0;
            for (int id2 : this.ids) {
                if (idsToRemove.contains(id2)) continue;
                newIds[newIdsCount++] = id2;
            }
            if (newIdsCount == newIds.length) {
                ChildrenIds childrenIds = this;
                if (childrenIds == null) {
                    ChildrenIds.$$$reportNull$$$0(12);
                }
                return childrenIds;
            }
            newIds = newIdsCount == 0 ? ArrayUtil.EMPTY_INT_ARRAY : Arrays.copyOf(newIds, newIdsCount);
            ChildrenIds childrenIds = this.withIds(newIds);
            if (childrenIds == null) {
                ChildrenIds.$$$reportNull$$$0(13);
            }
            return childrenIds;
        }

        public String toString() {
            return "Children[ids: " + Arrays.toString(this.ids) + ", sortedByName: " + this.isSorted() + ", allLoaded: " + this.areAllChildrenLoaded() + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 8, 9, 10, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileLoader";
                    break;
                }
                case 1: 
                case 2: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$ChildrenIds";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comparator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namesComparator";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameLoader";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idsToRemove";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$ChildrenIds";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAllChildrenLoaded";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insertAt";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendId";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "removeAt";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "removeIds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "asFiles";
                    break;
                }
                case 1: 
                case 2: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "sorted";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findIndexByName";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "removeIds";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 8, 9, 10, 12, 13 -> new IllegalStateException(string);
            };
        }
    }

    public static final class FileAlreadyCreatedException
    extends RuntimeException {
        private FileAlreadyCreatedException(@NotNull String message) {
            if (message == null) {
                FileAlreadyCreatedException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vfs/newvfs/impl/VfsData$FileAlreadyCreatedException", "<init>"));
        }
    }
}

