/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.menu;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItemKt;
import com.intellij.openapi.actionSystem.impl.ActionPresentationDecorator;
import com.intellij.openapi.actionSystem.impl.PoppedIcon;
import com.intellij.openapi.actionSystem.impl.UtilsKt;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRef;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRefKt;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.IconLoader;
import com.intellij.platform.ide.menu.MacNativeActionMenuItemKt;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.mac.screenmenu.MenuItem;
import java.awt.EventQueue;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011J8\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J,\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00168\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/ide/menu/MacNativeActionMenuItem;", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "place", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "isMnemonicEnabled", "", "insideCheckedGroup", "useDarkIcons", "<init>", "(Lcom/intellij/openapi/actionSystem/AnAction;Ljava/lang/String;Lcom/intellij/openapi/actionSystem/DataContext;ZZZ)V", "actionRef", "Lcom/intellij/openapi/actionSystem/impl/actionholder/ActionRef;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "Lorg/jetbrains/annotations/NotNull;", "isToggleable", "isToggled", "menuItemPeer", "Lcom/intellij/ui/mac/screenmenu/MenuItem;", "updateFromPresentation", "", "updateIcon", "adjustIcon", "Ljavax/swing/Icon;", "icon", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nMacNativeActionMenuItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacNativeActionMenuItem.kt\ncom/intellij/platform/ide/menu/MacNativeActionMenuItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class MacNativeActionMenuItem {
    @NotNull
    private final String place;
    @NotNull
    private final DataContext context;
    private final boolean isMnemonicEnabled;
    private final boolean insideCheckedGroup;
    private final boolean useDarkIcons;
    @NotNull
    private final ActionRef<AnAction> actionRef;
    @NotNull
    private final Presentation presentation;
    private final boolean isToggleable;
    private boolean isToggled;
    @JvmField
    @NotNull
    public final MenuItem menuItemPeer;

    /*
     * WARNING - void declaration
     */
    public MacNativeActionMenuItem(@NotNull AnAction action2, @NotNull String place, @NotNull DataContext context, boolean isMnemonicEnabled, boolean insideCheckedGroup, boolean useDarkIcons) {
        void $this$menuItemPeer_u24lambda_u240;
        MenuItem menuItem;
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.place = place;
        this.context = context;
        this.isMnemonicEnabled = isMnemonicEnabled;
        this.insideCheckedGroup = insideCheckedGroup;
        this.useDarkIcons = useDarkIcons;
        this.actionRef = ActionRefKt.createActionRef(action2);
        Presentation presentation2 = Presentation.newTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"newTemplatePresentation(...)");
        this.presentation = presentation2;
        this.isToggleable = action2 instanceof Toggleable;
        this.isToggled = action2 instanceof Toggleable;
        MenuItem menuItem2 = menuItem = new MenuItem();
        MacNativeActionMenuItem macNativeActionMenuItem = this;
        boolean bl = false;
        $this$menuItemPeer_u24lambda_u240.setActionDelegate(() -> MacNativeActionMenuItem.menuItemPeer$lambda$0$0(this, (MenuItem)$this$menuItemPeer_u24lambda_u240));
        macNativeActionMenuItem.menuItemPeer = menuItem;
    }

    public final void updateFromPresentation(@NotNull Presentation presentation2) {
        String id2;
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        this.presentation.copyFrom(presentation2, null, true);
        AnAction action2 = this.actionRef.getAction();
        this.isToggled = this.isToggleable && Toggleable.isSelected((Presentation)presentation2);
        this.updateIcon(presentation2, action2, this.useDarkIcons, this.isToggleable, this.isToggled, this.insideCheckedGroup);
        String string = id2 = ActionManager.getInstance().getId(action2);
        Shortcut[] shortcutArray = string == null ? action2.getShortcutSet().getShortcuts() : KeymapUtil.getActiveKeymapShortcuts((String)string).getShortcuts();
        Intrinsics.checkNotNull((Object)shortcutArray);
        Shortcut[] shortcuts = shortcutArray;
        KeyStroke accelerator = null;
        int n = shortcuts.length;
        for (int j = 0; j < n; ++j) {
            Shortcut shortcut = shortcuts[j];
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyStroke keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getFirstKeyStroke(...)");
            KeyStroke firstKeyStroke = keyStroke;
            if (ActionMenuItemKt.isEnterKeyStroke(firstKeyStroke)) break;
            accelerator = firstKeyStroke;
            if (!KeymapUtil.isSimplifiedMacShortcuts()) break;
            this.menuItemPeer.setAcceleratorText(KeymapUtil.getPreferredShortcutText((Shortcut[])shortcuts));
            break;
        }
        String text2 = ActionPresentationDecorator.decorateTextIfNeeded(action2, presentation2.getText(this.isMnemonicEnabled));
        this.menuItemPeer.setLabel(text2, accelerator);
        this.menuItemPeer.setEnabled(presentation2.isEnabled());
    }

    /*
     * WARNING - void declaration
     */
    private final void updateIcon(Presentation presentation2, AnAction action2, boolean useDarkIcons, boolean isToggleable, boolean isToggled, boolean insideCheckedGroup) {
        if (isToggleable && (insideCheckedGroup || !UISettings.Companion.getInstance().getShowIconsInMenus()) || presentation2.getIcon() == null) {
            this.menuItemPeer.setState(isToggled);
            this.menuItemPeer.setIcon(this.adjustIcon(presentation2.getIcon(), useDarkIcons, action2, presentation2));
        } else if (UISettings.Companion.getInstance().getShowIconsInMenus()) {
            Icon icon2;
            Icon icon3 = presentation2.getIcon();
            if (isToggleable && isToggled) {
                PoppedIcon poppedIcon;
                Icon icon4 = icon3;
                if (icon4 != null) {
                    Icon it = icon4;
                    boolean bl = false;
                    poppedIcon = new PoppedIcon(it, 16, 16);
                } else {
                    poppedIcon = null;
                }
                icon3 = poppedIcon;
            }
            MenuItem menuItem = this.menuItemPeer;
            MacNativeActionMenuItem macNativeActionMenuItem = this;
            if (presentation2.isEnabled()) {
                icon2 = icon3;
            } else {
                icon2 = presentation2.getDisabledIcon();
                if (icon2 == null) {
                    Icon icon5 = icon3;
                    if (icon5 != null) {
                        void it;
                        Icon bl = icon5;
                        MacNativeActionMenuItem macNativeActionMenuItem2 = macNativeActionMenuItem;
                        MenuItem menuItem2 = menuItem;
                        boolean bl2 = false;
                        Icon icon6 = IconLoader.getDisabledIcon((Icon)it);
                        menuItem = menuItem2;
                        macNativeActionMenuItem = macNativeActionMenuItem2;
                        icon2 = icon6;
                    } else {
                        icon2 = null;
                    }
                }
            }
            menuItem.setIcon(macNativeActionMenuItem.adjustIcon(icon2, useDarkIcons, action2, presentation2));
        }
    }

    private final Icon adjustIcon(Icon icon2, boolean useDarkIcons, AnAction action2, Presentation presentation2) {
        Icon icon3;
        if (ActionMenu.Companion.isShowNoIcons(action2, presentation2)) {
            icon3 = null;
        } else if (!ActionMenu.Companion.isAligned() || !ActionMenu.Companion.isAlignedInGroup()) {
            Icon icon4 = icon2;
            if (icon4 != null) {
                Icon it = icon4;
                boolean bl = false;
                icon3 = IconUtilKt.getMenuBarIcon((Icon)it, (boolean)useDarkIcons);
            } else {
                icon3 = null;
            }
        } else {
            icon3 = icon2;
            if (icon3 == null) {
                icon3 = IconUtilKt.getMenuBarIcon((Icon)UtilsKt.getEMPTY_MENU_ACTION_ICON(), (boolean)useDarkIcons);
            }
        }
        return icon3;
    }

    private static final void menuItemPeer$lambda$0$0$0$0$0(MacNativeActionMenuItem this$0) {
        AnAction anAction = this$0.actionRef.getAction();
        String string = this$0.place;
        Presentation presentation2 = this$0.presentation.clone();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"clone(...)");
        MacNativeActionMenuItemKt.access$performAction(anAction, string, presentation2, this$0.context);
    }

    private static final void menuItemPeer$lambda$0$0$0$0(MacNativeActionMenuItem this$0) {
        WriteIntentReadAction.run(() -> MacNativeActionMenuItem.menuItemPeer$lambda$0$0$0$0$0(this$0));
    }

    private static final void menuItemPeer$lambda$0$0$0(MacNativeActionMenuItem this$0) {
        if (this$0.presentation.isEnabledInModalContext() || !Intrinsics.areEqual((Object)this$0.context.getData(PlatformCoreDataKeys.IS_MODAL_CONTEXT), (Object)true)) {
            TransactionGuard transactionGuard = TransactionGuard.getInstance();
            Intrinsics.checkNotNull((Object)transactionGuard, (String)"null cannot be cast to non-null type com.intellij.openapi.application.TransactionGuardImpl");
            ((TransactionGuardImpl)transactionGuard).performUserActivity(() -> MacNativeActionMenuItem.menuItemPeer$lambda$0$0$0$0(this$0));
        }
    }

    private static final void menuItemPeer$lambda$0$0(MacNativeActionMenuItem this$0, MenuItem $this_apply) {
        if (this$0.isToggleable) {
            this$0.isToggled = !this$0.isToggled;
            $this_apply.setState(this$0.isToggled);
        }
        EventQueue.invokeLater(() -> MacNativeActionMenuItem.menuItemPeer$lambda$0$0$0(this$0));
    }
}

