/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.presentation.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.presentation.FilePresentationService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/presentation/impl/FilePresentationServiceImpl;", "Lcom/intellij/presentation/FilePresentationService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getFileBackgroundColor", "Ljava/awt/Color;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.platform.ide.impl"})
public final class FilePresentationServiceImpl
implements FilePresentationService {
    @NotNull
    private final Project project;

    public FilePresentationServiceImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public Color getFileBackgroundColor(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!file2.isValid()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return VfsPresentationUtil.getFileBackgroundColor(this.project, file2);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public Color getFileBackgroundColor(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiUtilCore.ensureValid((PsiElement)element);
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file2 != null) {
            return this.getFileBackgroundColor(file2);
        }
        if (element instanceof PsiDirectory) {
            VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            return this.getFileBackgroundColor(virtualFile);
        }
        if (element instanceof PsiDirectoryContainer) {
            Color result2 = null;
            PsiDirectory[] psiDirectoryArray = ((PsiDirectoryContainer)element).getDirectories();
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
            for (PsiDirectory dir : psiDirectoryArray) {
                Color color;
                VirtualFile virtualFile = dir.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                if (this.getFileBackgroundColor(virtualFile) == null) continue;
                if (result2 == null) {
                    result2 = color;
                    continue;
                }
                if (Intrinsics.areEqual((Object)result2, (Object)color)) continue;
                return null;
            }
            return result2;
        }
        return null;
    }
}

