/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PrevNextActionsDescriptor;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTabsPaneImpl
implements TabbedPane {
    private final JBEditorTabs tabs;
    private final CopyOnWriteArraySet<ChangeListener> listeners;

    public JBTabsPaneImpl(@Nullable Project project2, int tabPlacement, @NotNull Disposable parent) {
        if (parent == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(0);
        }
        this.listeners = new CopyOnWriteArraySet();
        this.tabs = new JBEditorTabs(project2, parent);
        this.tabs.getPresentation().setAlphabeticalMode(false).setPaintFocus(true).setFirstTabOffset(10);
        this.tabs.addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                JBTabsPaneImpl.this.fireChanged(new ChangeEvent(JBTabsPaneImpl.this.tabs));
            }
        });
        this.setTabPlacement(tabPlacement);
    }

    private void fireChanged(ChangeEvent event) {
        for (ChangeListener each : this.listeners) {
            each.stateChanged(event);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.tabs.getComponent();
    }

    @Override
    public void putClientProperty(@NotNull Object key, Object value) {
        if (key == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(1);
        }
        this.tabs.getComponent().putClientProperty(key, value);
    }

    @Override
    public void setKeyboardNavigation(@NotNull PrevNextActionsDescriptor installKeyboardNavigation) {
        if (installKeyboardNavigation == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(2);
        }
        this.tabs.setNavigationActionBinding(installKeyboardNavigation.getPrevActionId(), installKeyboardNavigation.getNextActionId());
    }

    @Override
    public void addChangeListener(@NotNull ChangeListener listener2) {
        if (listener2 == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(3);
        }
        this.listeners.add(listener2);
    }

    @Override
    public int getTabCount() {
        return this.tabs.getTabCount();
    }

    @Override
    public void insertTab(@NotNull String title2, Icon icon2, @NotNull Component c, String tip, int index) {
        if (title2 == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(4);
        }
        if (c == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(5);
        }
        assert (c instanceof JComponent);
        this.tabs.addTab(new TabInfo((JComponent)c).setText(title2).setTooltipText(tip).setIcon(icon2), index);
    }

    @Override
    public void setTabPlacement(int tabPlacement) {
        JBTabsPosition position = JBTabsPaneImpl.swingConstantToEnum(tabPlacement);
        this.tabs.setTabsPosition(position);
    }

    @ApiStatus.Internal
    @NotNull
    public static JBTabsPosition swingConstantToEnum(int tabPlacement) {
        JBTabsPosition jBTabsPosition = switch (tabPlacement) {
            case 1 -> JBTabsPosition.top;
            case 3 -> JBTabsPosition.bottom;
            case 2 -> JBTabsPosition.left;
            case 4 -> JBTabsPosition.right;
            default -> throw new IllegalArgumentException("Invalid tab placement code=" + tabPlacement);
        };
        if (jBTabsPosition == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(6);
        }
        return jBTabsPosition;
    }

    @Override
    public void addMouseListener(@NotNull MouseListener listener2) {
        if (listener2 == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(7);
        }
        this.tabs.getComponent().addMouseListener(listener2);
    }

    @Override
    public int getSelectedIndex() {
        TabInfo tab = this.tabs.getSelectedInfo();
        return tab == null ? -1 : this.tabs.getIndexOf(tab);
    }

    @Override
    public Component getSelectedComponent() {
        TabInfo selected = this.tabs.getSelectedInfo();
        return selected == null ? null : selected.getComponent();
    }

    @Override
    public void setSelectedIndex(int index) {
        this.tabs.select(this.getTabAt(index), false);
    }

    @Override
    public Component getTabComponentAt(int index) {
        TabInfo tabInfo = this.tabs.getTabAt(index);
        return this.tabs.getTabLabel(tabInfo);
    }

    @Override
    public void removeTabAt(int index) {
        this.tabs.removeTab(this.getTabAt(index));
    }

    private TabInfo getTabAt(int index) {
        this.checkIndex(index);
        return this.tabs.getTabAt(index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            throw new ArrayIndexOutOfBoundsException("tabCount=" + this.getTabCount() + " index=" + index);
        }
    }

    @Override
    public void revalidate() {
        this.tabs.getComponent().revalidate();
    }

    @Override
    public Color getForegroundAt(int index) {
        return this.getTabAt(index).getDefaultForeground();
    }

    @Override
    public void setForegroundAt(int index, Color color) {
        this.getTabAt(index).setDefaultForeground(color);
    }

    @Override
    public Component getComponentAt(int i2) {
        return this.getTabAt(i2).getComponent();
    }

    @Override
    public void setTitleAt(int index, @NotNull String title2) {
        if (title2 == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(8);
        }
        this.getTabAt(index).setText(title2);
    }

    @Override
    public void setToolTipTextAt(int index, String toolTipText) {
        this.getTabAt(index).setTooltipText(toolTipText);
    }

    @Override
    public void setComponentAt(int index, Component c) {
        this.getTabAt(index).setComponent(c);
    }

    @Override
    public void setIconAt(int index, Icon icon2) {
        this.getTabAt(index).setIcon(icon2);
    }

    @Override
    public void setEnabledAt(int index, boolean enabled2) {
        this.getTabAt(index).setEnabled(enabled2);
    }

    @Override
    public int getTabLayoutPolicy() {
        return this.tabs.isSingleRow() ? 1 : 0;
    }

    @Override
    public void setTabLayoutPolicy(int policy) {
        boolean singleRow = switch (policy) {
            case 1 -> true;
            case 0 -> false;
            default -> throw new IllegalArgumentException("Unsupported tab layout policy: " + policy);
        };
        this.tabs.getPresentation().setSingleRow(singleRow);
    }

    @Override
    public void scrollTabToVisible(int index) {
    }

    @Override
    @Nls
    public String getTitleAt(int i2) {
        return this.getTabAt(i2).getText();
    }

    @Override
    public void removeAll() {
        this.tabs.removeAllTabs();
    }

    @Override
    public void updateUI() {
        this.tabs.getComponent().updateUI();
    }

    @Override
    public void removeChangeListener(ChangeListener listener2) {
        this.listeners.remove(listener2);
    }

    @NotNull
    public JBTabs getTabs() {
        JBEditorTabs jBEditorTabs = this.tabs;
        if (jBEditorTabs == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(9);
        }
        return jBEditorTabs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installKeyboardNavigation";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/JBTabsPaneImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/JBTabsPaneImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "swingConstantToEnum";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setKeyboardNavigation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertTab";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMouseListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTitleAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9 -> new IllegalStateException(string);
        };
    }
}

