/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.WindowMouseListenerSource;
import com.intellij.ui.WindowMouseListenerSupport;
import com.intellij.ui.WindowMouseListenerSupportKt;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.wayland.WaylandUtilKt;
import com.jetbrains.JBR;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J0\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J \u0010#\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020!H\u0002J\u0018\u0010%\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020!2\u0006\u0010&\u001a\u00020!H\u0002J\b\u0010'\u001a\u00020\u0007H\u0002J\b\u0010(\u001a\u00020\u0007H\u0014J\u0012\u0010)\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010\u0012H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/ui/WaylandWindowMouseListenerSupport;", "Lcom/intellij/ui/WindowMouseListenerSupport;", "source", "Lcom/intellij/ui/WindowMouseListenerSource;", "<init>", "(Lcom/intellij/ui/WindowMouseListenerSource;)V", "isTruePopup", "", "dx", "", "dy", "grabPoint", "Ljava/awt/Point;", "beforeUpdate", "", "event", "Ljava/awt/event/MouseEvent;", "view", "Ljava/awt/Component;", "onStarted", "onDraggingStarted", "session", "Lcom/intellij/ui/WindowMouseListenerSupport$WindowListenerSession;", "getResizeCursor", "top", "left", "bottom", "right", "resizeArea", "Ljava/awt/Insets;", "computeOffsetFromInitialLocation", "makeChangeValid", "oldBounds", "Ljava/awt/Rectangle;", "newBounds", "fitPopupBounds", "windowBounds", "fitGrabPoint", "validBounds", "isRelativeMovementMode", "moveAfterMouseRelease", "jbrMoveSupported", "component", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nWindowMouseListenerSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowMouseListenerSupport.kt\ncom/intellij/ui/WaylandWindowMouseListenerSupport\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,406:1\n60#2,5:407\n60#2,5:412\n60#2,5:417\n60#2,5:422\n60#2,5:427\n60#2,5:432\n*S KotlinDebug\n*F\n+ 1 WindowMouseListenerSupport.kt\ncom/intellij/ui/WaylandWindowMouseListenerSupport\n*L\n311#1:407,5\n344#1:412,5\n355#1:417,5\n371#1:422,5\n376#1:427,5\n392#1:432,5\n*E\n"})
final class WaylandWindowMouseListenerSupport
extends WindowMouseListenerSupport {
    private boolean isTruePopup;
    private int dx;
    private int dy;
    @NotNull
    private Point grabPoint;

    public WaylandWindowMouseListenerSupport(@NotNull WindowMouseListenerSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super(source, null);
        this.grabPoint = new Point();
    }

    @Override
    protected void beforeUpdate(@NotNull MouseEvent event, @NotNull Component view2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        this.isTruePopup = view2 instanceof Window && ((Window)view2).getType() == Window.Type.POPUP;
    }

    @Override
    protected void onStarted(@NotNull MouseEvent event, @NotNull Component view2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        this.dx = 0;
        this.dy = 0;
        if (this.isRelativeMovementMode()) {
            ClientProperty.put((Window)((Window)view2), (Object)"wlawt.popup_position_unconstrained", (Object)true);
            Point point = new RelativePoint(event).getPoint(view2);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            this.grabPoint = point;
            JBR.getRelativePointerMovement().getAccumulatedMouseDeltaAndReset();
        }
    }

    @Override
    protected void onDraggingStarted(@NotNull WindowMouseListenerSupport.WindowListenerSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
    }

    @Override
    public int getResizeCursor(int top, int left, int bottom, int right, @NotNull Insets resizeArea) {
        Intrinsics.checkNotNullParameter((Object)resizeArea, (String)"resizeArea");
        if (this.isRelativeMovementMode()) {
            return super.getResizeCursor(top, left, bottom, right, resizeArea);
        }
        if (bottom < resizeArea.bottom) {
            if (right < resizeArea.right * 2) {
                return 5;
            }
            return 9;
        }
        if (right < resizeArea.right) {
            if (bottom < resizeArea.bottom * 2) {
                return 5;
            }
            return 11;
        }
        return -1;
    }

    @Override
    @NotNull
    protected Point computeOffsetFromInitialLocation(@NotNull WindowMouseListenerSupport.WindowListenerSession session, @NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isRelativeMovementMode()) {
            Point delta = JBR.getRelativePointerMovement().getAccumulatedMouseDeltaAndReset();
            this.dx += delta.x;
            this.dy += delta.y;
            Point offset = new Point(this.dx, this.dy);
            Logger $this$debug_u24default$iv = WindowMouseListenerSupportKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Relative mouse movement from the protocol: " + delta + ", new offset is " + offset, t$iv);
            }
            return offset;
        }
        return super.computeOffsetFromInitialLocation(session, event);
    }

    @Override
    protected void makeChangeValid(@NotNull Rectangle oldBounds, @NotNull Rectangle newBounds, @NotNull Component view2) {
        Intrinsics.checkNotNullParameter((Object)oldBounds, (String)"oldBounds");
        Intrinsics.checkNotNullParameter((Object)newBounds, (String)"newBounds");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        if (!this.isRelativeMovementMode()) {
            return;
        }
        Rectangle rectangle = WaylandUtilKt.getValidBoundsForPopup((Component)view2);
        if (rectangle == null) {
            return;
        }
        Rectangle windowBounds = rectangle;
        Rectangle newBoundsBeforeFit = new Rectangle(newBounds);
        this.fitPopupBounds(oldBounds, newBounds, windowBounds);
        if (newBounds.x != oldBounds.x || newBounds.y != oldBounds.y) {
            this.fitGrabPoint(newBounds, windowBounds);
        }
        this.dx += newBounds.x - newBoundsBeforeFit.x;
        this.dy += newBounds.y - newBoundsBeforeFit.y;
    }

    private final void fitPopupBounds(Rectangle oldBounds, Rectangle newBounds, Rectangle windowBounds) {
        Logger logger;
        Logger $this$debug_u24default$iv = WindowMouseListenerSupportKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Trying to fit the popup into " + windowBounds + " after change " + oldBounds + " -> " + newBounds, t$iv);
        }
        Rectangle newBoundsBeforeFit = WindowMouseListenerSupportKt.access$getLOG$p().isDebugEnabled() ? new Rectangle(newBounds) : null;
        int minX = windowBounds.x - (newBounds.width - 1);
        int maxX = windowBounds.x + (windowBounds.width - 1);
        int minWidth = windowBounds.x - newBounds.x + 1;
        int minY = windowBounds.y - (newBounds.height - 1);
        int maxY = windowBounds.y + (windowBounds.height - 1);
        int minHeight = windowBounds.y - newBounds.y + 1;
        Logger $this$debug_u24default$iv2 = WindowMouseListenerSupportKt.access$getLOG$p();
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("The allowed value by parent bounds are: x=" + minX + ".." + maxX + ", width>=" + minWidth + ", y=" + minY + ".." + maxY + ", height>=" + minHeight, t$iv2);
        }
        if (newBounds.x != oldBounds.x) {
            newBounds.x = RangesKt.coerceIn((int)newBounds.x, (ClosedRange)((ClosedRange)new IntRange(minX, maxX)));
        } else if (newBounds.width != oldBounds.width) {
            newBounds.width = RangesKt.coerceAtLeast((int)newBounds.width, (int)minWidth);
        }
        if (newBounds.y != oldBounds.y) {
            newBounds.y = RangesKt.coerceIn((int)newBounds.y, (ClosedRange)((ClosedRange)new IntRange(minY, maxY)));
        } else if (newBounds.height != oldBounds.height) {
            newBounds.height = RangesKt.coerceAtLeast((int)newBounds.height, (int)minHeight);
        }
        if (newBoundsBeforeFit != null && !Intrinsics.areEqual((Object)newBounds, (Object)newBoundsBeforeFit)) {
            $this$debug_u24default$iv2 = WindowMouseListenerSupportKt.access$getLOG$p();
            t$iv2 = null;
            $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("New bounds after fitting: " + newBoundsBeforeFit + " -> " + newBounds, t$iv2);
            }
        }
    }

    private final void fitGrabPoint(Rectangle newBounds, Rectangle validBounds) {
        Logger logger;
        Logger $this$debug_u24default$iv = WindowMouseListenerSupportKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Trying to fit the grab point " + this.grabPoint + " (relative to " + newBounds + ") into " + validBounds, t$iv);
        }
        Rectangle newBoundsBeforeFit = WindowMouseListenerSupportKt.access$getLOG$p().isDebugEnabled() ? new Rectangle(newBounds) : null;
        int minX = validBounds.x;
        int maxX = validBounds.x + validBounds.width - 1;
        int grabX = newBounds.x + this.grabPoint.x;
        int fitGrabX = RangesKt.coerceIn((int)grabX, (int)minX, (int)maxX);
        newBounds.x += fitGrabX - grabX;
        int minY = validBounds.y;
        int maxY = validBounds.y + validBounds.height - 1;
        int grabY = newBounds.y + this.grabPoint.y;
        int fitGrabY = RangesKt.coerceIn((int)grabY, (int)minY, (int)maxY);
        newBounds.y += fitGrabY - grabY;
        if (newBoundsBeforeFit != null && !Intrinsics.areEqual((Object)newBounds, (Object)newBoundsBeforeFit)) {
            Logger $this$debug_u24default$iv2 = WindowMouseListenerSupportKt.access$getLOG$p();
            Throwable t$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("New bounds after fitting the grab point: " + newBoundsBeforeFit + " -> " + newBounds, t$iv2);
            }
        }
    }

    private final boolean isRelativeMovementMode() {
        return this.isTruePopup && JBR.isRelativePointerMovementSupported();
    }

    @Override
    protected boolean moveAfterMouseRelease() {
        return !this.isRelativeMovementMode();
    }

    @Override
    protected boolean jbrMoveSupported(@Nullable Component component2) {
        return component2 instanceof Window && ((Window)component2).getType() != Window.Type.POPUP;
    }
}

