/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.render;

import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class RenderingHelper {
    public static final Key<Boolean> SHRINK_LONG_RENDERER = Key.create((String)"SHRINK_LONG_RENDERER");
    public static final Key<Boolean> SHRINK_LONG_SELECTION = Key.create((String)"SHRINK_LONG_SELECTION");
    public static final Key<Boolean> RESIZE_EDITOR_TO_RENDERER_SIZE = Key.create((String)"RESIZE_EDITOR_TO_RENDERER_SIZE");
    private final Rectangle myViewBounds;
    private final int myHintIndex;
    private int myRightMargin;
    private boolean myShrinkingDisabled;
    private boolean myShrinkingSelectionDisabled;

    @ApiStatus.Internal
    public RenderingHelper(@NotNull JComponent component2) {
        if (component2 == null) {
            RenderingHelper.$$$reportNull$$$0(0);
        }
        this.myShrinkingDisabled = false;
        this.myShrinkingSelectionDisabled = true;
        this.myViewBounds = new Rectangle(component2.getWidth(), component2.getHeight());
        this.myHintIndex = RenderingHelper.getExpandableHintIndex(component2);
        JViewport viewport = ComponentUtil.getViewport((Component)component2);
        if (viewport != null) {
            this.myViewBounds.setBounds(-component2.getX(), -component2.getY(), viewport.getWidth(), viewport.getHeight());
            JScrollPane pane2 = ComponentUtil.getScrollPane((JViewport)viewport);
            if (pane2 != null) {
                JScrollBar vsb;
                JScrollBar hsb = pane2.getHorizontalScrollBar();
                if (hsb != null && hsb.isVisible()) {
                    this.myShrinkingDisabled = !ClientProperty.isTrue((Component)component2, SHRINK_LONG_RENDERER);
                    boolean bl = this.myShrinkingSelectionDisabled = !ClientProperty.isTrue((Component)component2, SHRINK_LONG_SELECTION);
                }
                if (pane2.getHorizontalScrollBarPolicy() == 31) {
                    this.myShrinkingDisabled = ClientProperty.isFalse((Component)component2, SHRINK_LONG_RENDERER);
                    boolean bl = this.myShrinkingSelectionDisabled = !ClientProperty.isTrue((Component)component2, SHRINK_LONG_SELECTION);
                }
                if ((vsb = pane2.getVerticalScrollBar()) != null && vsb.isVisible() && !vsb.isOpaque() && ClientProperty.isFalse((Component)vsb, (Object)JBScrollPane.IGNORE_SCROLLBAR_IN_INSETS)) {
                    this.myRightMargin = vsb.getWidth();
                }
            }
        }
    }

    public int getX() {
        return this.myViewBounds.x;
    }

    public int getY() {
        return this.myViewBounds.y;
    }

    public int getWidth() {
        return this.myViewBounds.width;
    }

    public int getHeight() {
        return this.myViewBounds.height;
    }

    public int getRightMargin() {
        return this.myRightMargin;
    }

    public boolean isRendererShrinkingDisabled(int index) {
        return this.myShrinkingDisabled || this.isExpandableHintShown(index);
    }

    public boolean isShrinkingSelectionDisabled(int index) {
        return this.myShrinkingSelectionDisabled || this.isExpandableHintShown(index);
    }

    public boolean isExpandableHintShown(int index) {
        return this.myHintIndex == index;
    }

    private static int getExpandableHintIndex(@NotNull JComponent component2) {
        if (component2 == null) {
            RenderingHelper.$$$reportNull$$$0(1);
        }
        if (component2 instanceof ComponentWithExpandableItems) {
            Object item;
            ComponentWithExpandableItems c = (ComponentWithExpandableItems)component2;
            Collection items2 = c.getExpandableItemsHandler().getExpandedItems();
            Object v0 = item = items2.isEmpty() ? null : items2.iterator().next();
            if (item instanceof Integer) {
                return item;
            }
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "component";
        objectArray2[1] = "com/intellij/ui/render/RenderingHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpandableHintIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

