/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.IconManager;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ChangesTrackingTableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ValidatingTableEditor<Item>
implements ComponentWithEmptyText {
    private static final Icon WARNING_ICON = UIUtil.getBalloonWarningIcon();
    private static final Icon EMPTY_ICON = IconManager.getInstance().createEmptyIcon(WARNING_ICON);
    @NonNls
    private static final String REMOVE_KEY = "REMOVE_SELECTED";
    private JPanel myContentPane;
    private TableView<Item> myTable;
    private final AnAction myRemoveButton;
    private JLabel myMessageLabel;
    private HoverHyperlinkLabel myFixLink;
    private JPanel myTablePanel;
    private final List<String> myWarnings;
    private Fix myFixRunnable;

    protected abstract Item cloneOf(Item var1);

    @Nullable
    protected Pair<String, Fix> validate(List<? extends Item> current, List<? super String> warnings) {
        String error = null;
        for (int i2 = 0; i2 < current.size(); ++i2) {
            Item item = current.get(i2);
            String s = this.validate(item);
            warnings.set(i2, s);
            if (error != null) continue;
            error = s;
        }
        return error != null ? Pair.create(error, (Object)null) : null;
    }

    @Nullable
    protected String validate(Item item) {
        return null;
    }

    @Nullable
    protected abstract Item createItem();

    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myTable.getEmptyText();
        if (statusText == null) {
            ValidatingTableEditor.$$$reportNull$$$0(0);
        }
        return statusText;
    }

    public void setShowGrid(boolean v) {
        this.myTable.setShowGrid(v);
    }

    private void createUIComponents() {
        this.myTable = new ChangesTrackingTableView<Item>(){

            @Override
            protected void onCellValueChanged(int row2, int column, Object value) {
                Object original = this.getItems().get(row2);
                Object override = ValidatingTableEditor.this.cloneOf(original);
                ColumnInfo columnInfo = ValidatingTableEditor.this.getTableModel().getColumnInfos()[column];
                columnInfo.setValue(override, value);
                ValidatingTableEditor.this.updateMessage(row2, override);
            }

            @Override
            protected void onEditingStopped() {
                ValidatingTableEditor.this.updateMessage(-1, null);
            }
        };
        this.myFixLink = new HoverHyperlinkLabel(null);
    }

    protected ValidatingTableEditor(AnAction ... extraButtons) {
        this.$$$setupUI$$$();
        this.myWarnings = new ArrayList<String>();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTable).disableRemoveAction().disableUpAction().disableDownAction();
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                ValidatingTableEditor.this.addItem();
            }
        });
        this.myRemoveButton = new DumbAwareAction(ApplicationBundle.message((String)"button.remove", (Object[])new Object[0]), null, IconUtil.getRemoveIcon()){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(ValidatingTableEditor.this.myTable.getSelectedRow() != -1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                ValidatingTableEditor.this.removeSelected();
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/ui/ValidatingTableEditor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/ui/ValidatingTableEditor$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        this.myRemoveButton.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"alt DELETE"}));
        decorator.addExtraAction(this.myRemoveButton);
        if (extraButtons != null) {
            for (AnAction extraButton : extraButtons) {
                decorator.addExtraAction(extraButton);
            }
        }
        this.myTablePanel.add((Component)decorator.createPanel(), "Center");
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), REMOVE_KEY);
        this.myTable.getActionMap().put(REMOVE_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidatingTableEditor.this.removeSelected();
            }
        });
        this.myFixLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && ValidatingTableEditor.this.myFixRunnable != null) {
                    ValidatingTableEditor.this.myFixRunnable.run();
                }
            }
        });
    }

    protected ValidatingTableEditor() {
        this(null);
    }

    @Nullable
    public List<Item> getSelectedItems() {
        return this.myTable.getSelectedObjects();
    }

    private void removeSelected() {
        this.myTable.stopEditing();
        ArrayList<Item> items2 = new ArrayList<Item>(this.doGetItems());
        int[] rows = this.myTable.getSelectedRows();
        for (int i2 = rows.length - 1; i2 >= 0; --i2) {
            items2.remove(rows[i2]);
        }
        this.setItems(items2);
        this.updateMessage(-1, null);
        if (!items2.isEmpty()) {
            int index = Math.min(rows[0], items2.size() - 1);
            this.myTable.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    protected void addItem() {
        Item newItem = this.createItem();
        if (newItem == null) {
            return;
        }
        ArrayList<Item> items2 = new ArrayList<Item>(this.doGetItems());
        items2.add(newItem);
        this.setItems(items2);
        int row2 = items2.size() - 1;
        this.myTable.getSelectionModel().setSelectionInterval(row2, row2);
        this.myTable.scrollRectToVisible(this.myTable.getCellRect(row2, 0, true));
        if (this.getTableModel().getColumnInfos()[1].isCellEditable(items2.get(row2))) {
            this.myTable.editCellAt(row2, 1);
            IdeFocusManager.findInstanceByComponent((Component)this.myContentPane).requestFocus(this.myTable.getEditorComponent(), true);
        }
        this.updateMessage(-1, null);
    }

    private ListTableModel<Item> getTableModel() {
        return (ListTableModel)this.myTable.getModel();
    }

    public void setModel(ColumnInfo<Item, Object>[] valueColumns, List<? extends Item> items2) {
        ColumnInfo[] columns = new ColumnInfo[valueColumns.length + 1];
        IconColumn iconColumn = new IconColumn();
        int maxHeight = iconColumn.getRowHeight();
        columns[0] = iconColumn;
        for (int i2 = 0; i2 < valueColumns.length; ++i2) {
            columns[i2 + 1] = new ColumnInfoWrapper(valueColumns[i2]);
            if (!(valueColumns[i2] instanceof RowHeightProvider)) continue;
            maxHeight = Math.max(maxHeight, ((RowHeightProvider)valueColumns[i2]).getRowHeight());
        }
        this.myTable.stopEditing();
        this.myTable.setModelAndUpdateColumns(new ListTableModel(columns));
        if (maxHeight > 0) {
            this.myTable.setRowHeight(maxHeight);
        }
        this.setItems(items2);
        this.updateMessage(-1, null);
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.doGetItems());
    }

    private List<Item> doGetItems() {
        ArrayList items2 = new ArrayList(this.getTableModel().getItems());
        if (this.myTable.isEditing()) {
            Object value = ChangesTrackingTableView.getValue(this.myTable.getEditorComponent());
            ColumnInfo column = ((ListTableModel)this.myTable.getModel()).getColumnInfos()[this.myTable.getEditingColumn()];
            ((ColumnInfoWrapper)column).myDelegate.setValue(items2.get(this.myTable.getEditingRow()), value);
        }
        return items2;
    }

    private void setItems(List<? extends Item> items2) {
        if (items2.isEmpty()) {
            this.getTableModel().setItems(new ArrayList());
            this.myWarnings.clear();
        } else {
            this.myWarnings.clear();
            for (Item item : items2) {
                this.myWarnings.add(null);
            }
            this.getTableModel().setItems(new ArrayList<Item>(items2));
        }
    }

    public void setTableHeader(JTableHeader header) {
        this.myTable.setTableHeader(header);
    }

    public void updateMessage(int index, @Nullable Item override) {
        ArrayList<Item> current = new ArrayList<Item>(this.doGetItems());
        if (override != null) {
            current.set(index, override);
        }
        this.displayMessageAndFix(this.validate(current, this.myWarnings));
        this.myTable.repaint();
    }

    protected void displayMessageAndFix(@Nullable Pair<@NlsContexts.DialogMessage String, Fix> messageAndFix) {
        if (messageAndFix != null) {
            this.myMessageLabel.setText((String)messageAndFix.first);
            this.myMessageLabel.setIcon(WARNING_ICON);
            this.myMessageLabel.setVisible(true);
            this.myFixRunnable = (Fix)messageAndFix.second;
            this.myFixLink.setVisible(this.myFixRunnable != null);
            this.myFixLink.setText(this.myFixRunnable != null ? this.myFixRunnable.getTitle() : null);
        } else {
            this.myMessageLabel.setText(" ");
            this.myMessageLabel.setIcon(EMPTY_ICON);
            this.myFixLink.setVisible(false);
            this.myFixRunnable = null;
        }
    }

    public void hideMessageLabel() {
        this.myMessageLabel.setVisible(false);
        this.myFixLink.setVisible(false);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    public Component getContentPane() {
        return this.myContentPane;
    }

    public void setColumnReorderingAllowed(boolean value) {
        JTableHeader header = this.myTable.getTableHeader();
        if (header != null) {
            header.setReorderingAllowed(value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ValidatingTableEditor", "getEmptyText"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myFixLink;
        ((JLabel)hoverHyperlinkLabel).setText("Fix");
        jPanel3.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static interface Fix
    extends Runnable {
        @NlsContexts.LinkLabel
        public String getTitle();
    }

    private final class IconColumn
    extends ColumnInfo<Item, Object>
    implements RowHeightProvider {
        IconColumn() {
            super(" ");
        }

        public String valueOf(Item item) {
            return null;
        }

        public int getWidth(JTable table2) {
            return WARNING_ICON.getIconWidth() + 2;
        }

        @Override
        public int getRowHeight() {
            return WARNING_ICON.getIconHeight();
        }

        public TableCellRenderer getRenderer(Item item) {
            return new WarningIconCellRenderer(() -> ValidatingTableEditor.this.myWarnings.get(ValidatingTableEditor.this.doGetItems().indexOf(item)));
        }
    }

    private final class ColumnInfoWrapper
    extends ColumnInfo<Item, Object> {
        private final ColumnInfo<Item, Object> myDelegate;

        ColumnInfoWrapper(ColumnInfo<Item, Object> delegate) {
            super(delegate.getName());
            this.myDelegate = delegate;
        }

        public Object valueOf(Item item) {
            return this.myDelegate.valueOf(item);
        }

        public boolean isCellEditable(Item item) {
            return this.myDelegate.isCellEditable(item);
        }

        public void setValue(Item item, Object value) {
            this.myDelegate.setValue(item, value);
            ValidatingTableEditor.this.updateMessage(-1, null);
        }

        public TableCellEditor getEditor(Item item) {
            return this.myDelegate.getEditor(item);
        }

        public int getWidth(JTable table2) {
            return this.myDelegate.getWidth(table2);
        }

        public Class getColumnClass() {
            return this.myDelegate.getColumnClass();
        }

        public TableCellRenderer getRenderer(Item item) {
            return this.myDelegate.getRenderer(item);
        }
    }

    public static interface RowHeightProvider {
        public int getRowHeight();
    }

    private static final class WarningIconCellRenderer
    extends DefaultTableCellRenderer {
        private final Supplier<@NlsContexts.HintText @Nullable String> warningProvider;

        WarningIconCellRenderer(Supplier<@NlsContexts.HintText @Nullable String> warningProvider) {
            this.warningProvider = warningProvider;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
            JLabel label2 = (JLabel)super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row2, column);
            String message = this.warningProvider.get();
            label2.setIcon(message != null ? WARNING_ICON : null);
            label2.setToolTipText(message);
            label2.setHorizontalAlignment(0);
            label2.setVerticalAlignment(0);
            return label2;
        }
    }
}

