// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.platform.ide.diagnostic.startUpPerformanceReporter

import com.intellij.diagnostic.StartUpPerformanceService
import com.intellij.openapi.application.ApplicationManager
import com.intellij.openapi.extensions.ExtensionNotApplicableException
import com.intellij.openapi.project.Project
import com.intellij.openapi.startup.ProjectActivity
import it.unimi.dsi.fastutil.objects.Object2IntMaps
import kotlinx.coroutines.flow.firstOrNull
import java.util.concurrent.atomic.AtomicBoolean

// todo `com.intellij.internal.statistic` package should be moved out of platform-impl module to own,
// and then this will be class moved to corresponding `intellij.platform.diagnostic` module
internal class StartupMetricCollector : ProjectActivity {
  private var wasReported = AtomicBoolean(false)

  init {
    val app = ApplicationManager.getApplication()
    if (app.isUnitTestMode || app.isHeadlessEnvironment) {
      throw ExtensionNotApplicableException.create()
    }
  }

  override suspend fun execute(project: Project) {
    if (!wasReported.compareAndSet(false, true)) {
      return
    }

    val metrics = StartUpPerformanceService.getInstance().getMetrics().firstOrNull()
    for (entry in Object2IntMaps.fastIterable(metrics)) {
      StartupPerformanceCollector.logStartupPerformanceEvent(project = project, eventId = entry.key, duration = entry.intValue)
    }
  }
}