/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ColorSchemeImporter
implements SchemeImporter<EditorColorsScheme> {
    private static final String[] FILE_EXTENSIONS = new String[]{EditorColorsManager.getColorSchemeFileExtension().substring(1), "jar"};

    public String @NotNull [] getSourceExtensions() {
        if (FILE_EXTENSIONS == null) {
            ColorSchemeImporter.$$$reportNull$$$0(0);
        }
        return FILE_EXTENSIONS;
    }

    @Nullable
    public EditorColorsScheme importScheme(@NotNull Project project2, @NotNull VirtualFile selectedFile, @NotNull EditorColorsScheme currentScheme, @NotNull SchemeFactory<? extends EditorColorsScheme> schemeFactory) throws SchemeImportException {
        if (project2 == null) {
            ColorSchemeImporter.$$$reportNull$$$0(1);
        }
        if (selectedFile == null) {
            ColorSchemeImporter.$$$reportNull$$$0(2);
        }
        if (currentScheme == null) {
            ColorSchemeImporter.$$$reportNull$$$0(3);
        }
        if (schemeFactory == null) {
            ColorSchemeImporter.$$$reportNull$$$0(4);
        }
        Element root = SchemeImportUtil.loadSchemeDom(selectedFile);
        String name2 = ColorSchemeImporter.getSchemeName(root);
        EditorColorsScheme scheme = (EditorColorsScheme)schemeFactory.createNewScheme(name2);
        String preferredName = scheme.getName();
        scheme.readExternal(root);
        scheme.setName(preferredName);
        try {
            EditorColorsManager.getInstance().resolveSchemeParent(scheme);
        }
        catch (InvalidDataException e) {
            throw new SchemeImportException("Required " + e.getMessage() + " base scheme is missing or is not a bundled (read-only) scheme.");
        }
        return scheme;
    }

    static String getSchemeName(@NotNull Element root) throws SchemeImportException {
        String name2;
        if (root == null) {
            ColorSchemeImporter.$$$reportNull$$$0(5);
        }
        if ((name2 = root.getAttributeValue("name")) == null) {
            throw new SchemeImportException("Scheme 'name' attribute is missing.");
        }
        return name2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/ColorSchemeImporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentScheme";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceExtensions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/ColorSchemeImporter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSchemeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

