/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.filtering;

import com.intellij.codeInsight.hints.filtering.AnyParamMatcher;
import com.intellij.codeInsight.hints.filtering.Matcher;
import com.intellij.codeInsight.hints.filtering.ParamMatcher;
import com.intellij.codeInsight.hints.filtering.StringMatcher;
import com.intellij.codeInsight.hints.filtering.StringMatcherBuilder;
import com.intellij.codeInsight.hints.filtering.StringParamMatcher;
import com.intellij.openapi.util.Couple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0006J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/hints/filtering/MatcherConstructor;", "", "<init>", "()V", "extract", "Lcom/intellij/openapi/util/Couple;", "", "matcher", "getParamsMatcher", "createParametersMatcher", "Lcom/intellij/codeInsight/hints/filtering/ParamMatcher;", "paramsMatcher", "createMatcher", "Lcom/intellij/codeInsight/hints/filtering/Matcher;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nMethodMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodMatcher.kt\ncom/intellij/codeInsight/hints/filtering/MatcherConstructor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1586#2:110\n1661#2,3:111\n1642#2,10:115\n1915#2:125\n1916#2:127\n1652#2:128\n1#3:114\n1#3:126\n*S KotlinDebug\n*F\n+ 1 MethodMatcher.kt\ncom/intellij/codeInsight/hints/filtering/MatcherConstructor\n*L\n89#1:110\n89#1:111,3\n92#1:115,10\n92#1:125\n92#1:127\n92#1:128\n92#1:126\n*E\n"})
public final class MatcherConstructor {
    @NotNull
    public static final MatcherConstructor INSTANCE = new MatcherConstructor();

    private MatcherConstructor() {
    }

    @Nullable
    public final Couple<String> extract(@NotNull String matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String trimmedMatcher = ((Object)StringsKt.trim((CharSequence)matcher)).toString();
        if (((CharSequence)trimmedMatcher).length() == 0) {
            return null;
        }
        int openParenthIndex = StringsKt.lastIndexOf$default((CharSequence)trimmedMatcher, (char)'(', (int)0, (boolean)false, (int)6, null);
        if (openParenthIndex < 0) {
            return new Couple((Object)trimmedMatcher, (Object)"");
        }
        if (openParenthIndex == 0) {
            String string = this.getParamsMatcher(trimmedMatcher);
            if (string == null) {
                return null;
            }
            String paramsMatcher = string;
            return new Couple((Object)"", (Object)paramsMatcher);
        }
        String string = trimmedMatcher.substring(0, openParenthIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String methodMatcher = string;
        String string2 = this.getParamsMatcher(trimmedMatcher);
        if (string2 == null) {
            return null;
        }
        String paramsMatcher = string2;
        return new Couple((Object)((Object)StringsKt.trim((CharSequence)methodMatcher)).toString(), (Object)((Object)StringsKt.trim((CharSequence)paramsMatcher)).toString());
    }

    private final String getParamsMatcher(String matcher) {
        int openBraceIndex = StringsKt.lastIndexOf$default((CharSequence)matcher, (String)"(", (int)0, (boolean)false, (int)6, null);
        int closeBraceIndex = StringsKt.lastIndexOf$default((CharSequence)matcher, (String)")", (int)0, (boolean)false, (int)6, null);
        if (openBraceIndex >= 0 && closeBraceIndex > 0) {
            String string = matcher.substring(openBraceIndex, closeBraceIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return ((Object)StringsKt.trim((CharSequence)string)).toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final ParamMatcher createParametersMatcher(String paramsMatcher) {
        void $this$mapNotNullTo$iv$iv;
        Iterable<Object> iterable;
        List params;
        Iterable<Object> destination$iv$iv2;
        block5: {
            Iterator $this$mapTo$iv$iv;
            if (paramsMatcher.length() <= 2) {
                return null;
            }
            String string = paramsMatcher.substring(1, paramsMatcher.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String paramsString = string;
            char[] cArray = new char[]{','};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)paramsString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map22 = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void p0;
                Object item$iv$iv = iterator.next();
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)p0))).toString());
            }
            params = (List)destination$iv$iv2;
            Iterable $i$f$map22 = params;
            for (Iterable<Object> destination$iv$iv2 : $i$f$map22) {
                String p0 = (String)((Object)destination$iv$iv2);
                boolean bl = false;
                boolean bl2 = ((CharSequence)p0).length() == 0;
                if (!bl2) continue;
                iterable = destination$iv$iv2;
                break block5;
            }
            iterable = null;
        }
        if (iterable != null) {
            return null;
        }
        Iterable $this$mapNotNull$iv = params;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            StringMatcher it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (StringMatcherBuilder.INSTANCE.create(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List matchers = (List)destination$iv$iv3;
        return matchers.size() == params.size() ? (ParamMatcher)new StringParamMatcher(matchers) : null;
    }

    @Nullable
    public final Matcher createMatcher(@NotNull String matcher) {
        ParamMatcher paramMatcher;
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Couple<String> couple = this.extract(matcher);
        if (couple == null) {
            return null;
        }
        Couple<String> pair = couple;
        Object object = pair.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
        StringMatcher stringMatcher = StringMatcherBuilder.INSTANCE.create((String)object);
        if (stringMatcher == null) {
            return null;
        }
        StringMatcher methodNameMatcher = stringMatcher;
        Object object2 = pair.second;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
        if (((CharSequence)object2).length() == 0) {
            paramMatcher = AnyParamMatcher.INSTANCE;
        } else {
            Object object3 = pair.second;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"second");
            paramMatcher = this.createParametersMatcher((String)object3);
        }
        ParamMatcher paramMatcher2 = paramMatcher;
        return paramMatcher2 != null ? new Matcher(methodNameMatcher, paramMatcher2) : null;
    }
}

