/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ijent.nio;

import com.intellij.execution.ijent.nio.IjentEphemeralRootAwareFileSystemProvider;
import com.intellij.execution.ijent.nio.IjentNioFsRegistryKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.core.nio.fs.DelegatingFileSystem;
import com.intellij.platform.core.nio.fs.DelegatingFileSystemProvider;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.impl.fs.telemetry.TracingFileSystemProvider;
import com.intellij.platform.eel.provider.EelProvider;
import com.intellij.platform.eel.provider.MultiRoutingFileSystemBackend;
import com.intellij.platform.ijent.IjentApi;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystem;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemProvider;
import com.intellij.util.CoroutinesKt;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aD\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u001e\b\u0002\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b\u0018\u00010\tH\u0007\u00a8\u0006\f"}, d2={"registerIjentNioFs", "Ljava/nio/file/Path;", "Lkotlinx/coroutines/CoroutineScope;", "ijent", "Lcom/intellij/platform/ijent/IjentApi;", "root", "", "authority", "wrapFileSystemProvider", "Lkotlin/Function1;", "Ljava/nio/file/spi/FileSystemProvider;", "Lcom/intellij/platform/core/nio/fs/DelegatingFileSystemProvider;", "intellij.platform.ide.impl"})
public final class IjentNioFsRegistryKt {
    @ApiStatus.Internal
    @TestOnly
    @NotNull
    public static final Path registerIjentNioFs(@NotNull CoroutineScope $this$registerIjentNioFs, @NotNull IjentApi ijent, @NotNull String root, @NotNull String authority, @Nullable Function1<? super FileSystemProvider, ? extends DelegatingFileSystemProvider<?, ?>> wrapFileSystemProvider) {
        IjentNioFileSystem ijentNioFileSystem;
        Intrinsics.checkNotNullParameter((Object)$this$registerIjentNioFs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ijent, (String)"ijent");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        String root2 = StringsKt.replace$default((String)root, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        Path path = Paths.get(root2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path nioRoot = path;
        URI uri = new URI("ijent", authority, root2, null, null);
        try {
            ijentNioFileSystem = IjentNioFileSystemProvider.Companion.getInstance().newFileSystem(uri, IjentNioFileSystemProvider.Companion.newFileSystemMap(ijent.getFs()));
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            ijentNioFileSystem = IjentNioFileSystemProvider.Companion.getInstance().getFileSystem(uri);
        }
        IjentNioFileSystem ijentFs = ijentNioFileSystem;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        AtomicReference<Object> fs = new AtomicReference<Object>(null);
        MultiRoutingFileSystemBackend.EP_NAME.getPoint().registerExtension((Object)new MultiRoutingFileSystemBackend(root2, fs, nioRoot, uri, wrapFileSystemProvider, ijentFs){
            final /* synthetic */ String $root;
            final /* synthetic */ AtomicReference<FileSystem> $fs;
            final /* synthetic */ Path $nioRoot;
            final /* synthetic */ URI $uri;
            final /* synthetic */ Function1<FileSystemProvider, DelegatingFileSystemProvider<?, ?>> $wrapFileSystemProvider;
            final /* synthetic */ IjentNioFileSystem $ijentFs;
            {
                this.$root = $root;
                this.$fs = $fs;
                this.$nioRoot = $nioRoot;
                this.$uri = $uri;
                this.$wrapFileSystemProvider = $wrapFileSystemProvider;
                this.$ijentFs = $ijentFs;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public FileSystem compute(FileSystem localFS, String sanitizedPath) {
                Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
                Intrinsics.checkNotNullParameter((Object)sanitizedPath, (String)"sanitizedPath");
                if (!StringsKt.startsWith$default((String)sanitizedPath, (String)this.$root, (boolean)false, (int)2, null)) return null;
                Character it = StringsKt.getOrNull((CharSequence)sanitizedPath, (int)this.$root.length());
                boolean bl = false;
                if (it != null) {
                    char c = '/';
                    if (it.charValue() != c) return null;
                }
                boolean bl2 = true;
                if (!bl2) return null;
                FileSystem fileSystem = this.$fs.updateAndGet(arg_0 -> registerIjentNioFs.1.compute$lambda$1(this.$nioRoot, localFS, this.$uri, this.$wrapFileSystemProvider, arg_0));
                return fileSystem;
            }

            public Collection<String> getCustomRoots() {
                return CollectionsKt.listOf((Object)this.$root);
            }

            public Collection<FileStore> getCustomFileStores(FileSystem localFS) {
                Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
                return CollectionsKt.toList((Iterable)this.$ijentFs.getFileStores());
            }

            private static final FileSystem compute$lambda$1(Path $nioRoot, FileSystem $localFS, URI $uri, Function1 $wrapFileSystemProvider, FileSystem oldFs) {
                FileSystem fileSystem = oldFs;
                if (fileSystem == null) {
                    FileSystemProvider fileSystemProvider = (FileSystemProvider)new TracingFileSystemProvider((FileSystemProvider)IjentNioFileSystemProvider.Companion.getInstance(), null, 2, null);
                    FileSystemProvider fileSystemProvider2 = $localFS.provider();
                    Intrinsics.checkNotNullExpressionValue((Object)fileSystemProvider2, (String)"provider(...)");
                    IjentEphemeralRootAwareFileSystemProvider it = new IjentEphemeralRootAwareFileSystemProvider($nioRoot, fileSystemProvider, (FileSystemProvider)new TracingFileSystemProvider(fileSystemProvider2, null, 2, null), false);
                    boolean bl = false;
                    Function1 function1 = $wrapFileSystemProvider;
                    if (function1 == null || (function1 = (DelegatingFileSystemProvider)function1.invoke((Object)((Object)it))) == null) {
                        function1 = it;
                    }
                    DelegatingFileSystem delegatingFileSystem = function1.getFileSystem($uri);
                    Intrinsics.checkNotNullExpressionValue((Object)delegatingFileSystem, (String)"getFileSystem(...)");
                    fileSystem = (FileSystem)delegatingFileSystem;
                }
                return fileSystem;
            }
        }, disposable2);
        EelProvider.Companion.getEP_NAME().getPoint().registerExtension((Object)new EelProvider(nioRoot, ijent, root2){
            final /* synthetic */ Path $nioRoot;
            final /* synthetic */ IjentApi $ijent;
            final /* synthetic */ String $root;
            {
                this.$nioRoot = $nioRoot;
                this.$ijent = $ijent;
                this.$root = $root;
            }

            public Object tryInitialize(String path, Continuation<? super EelMachine> $completion) {
                return null;
            }

            public EelDescriptor getEelDescriptor(Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return path.startsWith(this.$nioRoot) ? this.$ijent.getDescriptor() : null;
            }

            public Collection<String> getCustomRoots(EelDescriptor eelDescriptor) {
                Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
                return Intrinsics.areEqual((Object)eelDescriptor, (Object)this.$ijent.getDescriptor()) ? (Collection)CollectionsKt.listOf((Object)this.$root) : null;
            }
        }, disposable2);
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)$this$registerIjentNioFs, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(disposable2, null){
            int label;
            final /* synthetic */ Disposable $disposable;
            {
                this.$disposable = $disposable;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Disposer.dispose((Disposable)this.$disposable);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        Path path2 = Paths.get(root2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return path2;
    }

    public static /* synthetic */ Path registerIjentNioFs$default(CoroutineScope coroutineScope, IjentApi ijentApi, String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = null;
        }
        return IjentNioFsRegistryKt.registerIjentNioFs(coroutineScope, ijentApi, string, string2, function1);
    }
}

