/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.AsyncFilterRunner;
import com.intellij.execution.impl.FilterApplyResult;
import com.intellij.execution.impl.FilterApplyResultImpl;
import com.intellij.execution.impl.HypertextInput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tH\u0007\u001a\u001e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"applyToLineRange", "", "Lcom/intellij/execution/filters/Filter;", "input", "Lcom/intellij/execution/impl/HypertextInput;", "startLineInclusive", "", "endLineInclusive", "onEach", "Lkotlin/Function1;", "Lcom/intellij/execution/impl/FilterApplyResult;", "applyToLine", "Lcom/intellij/execution/filters/Filter$Result;", "lineText", "", "lineEnd", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nHyperlinks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Hyperlinks.kt\ncom/intellij/execution/impl/HyperlinksKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,80:1\n1#2:81\n125#3,4:82\n57#3:86\n35#3,2:87\n*S KotlinDebug\n*F\n+ 1 Hyperlinks.kt\ncom/intellij/execution/impl/HyperlinksKt\n*L\n57#1:82,4\n79#1:86\n79#1:87,2\n*E\n"})
public final class HyperlinksKt {
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Experimental
    public static final void applyToLineRange(@NotNull Filter $this$applyToLineRange, @NotNull HypertextInput input, int startLineInclusive, int endLineInclusive, @NotNull Function1<? super FilterApplyResult, Unit> onEach) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToLineRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(onEach, (String)"onEach");
        int lineCount = input.getLineCount();
        if (!(0 <= startLineInclusive ? startLineInclusive < lineCount : false)) {
            boolean $i$a$-require-HyperlinksKt$applyToLineRange$32 = false;
            String $i$a$-require-HyperlinksKt$applyToLineRange$32 = "Invalid startLine=" + startLineInclusive + ", lineCount=" + lineCount;
            throw new IllegalArgumentException($i$a$-require-HyperlinksKt$applyToLineRange$32.toString());
        }
        if (!(0 <= endLineInclusive ? endLineInclusive < lineCount : false)) {
            boolean $i$a$-require-HyperlinksKt$applyToLineRange$42 = false;
            String $i$a$-require-HyperlinksKt$applyToLineRange$42 = "Invalid endLine=" + endLineInclusive + ", lineCount=" + lineCount;
            throw new IllegalArgumentException($i$a$-require-HyperlinksKt$applyToLineRange$42.toString());
        }
        IntProgression range = startLineInclusive <= endLineInclusive ? (IntProgression)new IntRange(startLineInclusive, endLineInclusive) : RangesKt.downTo((int)startLineInclusive, (int)endLineInclusive);
        int lineNumber = range.getFirst();
        int n = range.getLast();
        int n2 = range.getStep();
        if (n2 > 0 && lineNumber <= n || n2 < 0 && n <= lineNumber) {
            while (true) {
                int lineStart = input.getLineStartOffset(lineNumber);
                String lineText = input.getLineText(lineNumber);
                int lineEnd = lineStart + lineText.length();
                Filter.Result result2 = HyperlinksKt.applyToLine($this$applyToLineRange, lineText, lineEnd);
                onEach.invoke((Object)new FilterApplyResultImpl(lineNumber, result2));
                if (lineNumber == n) break;
                lineNumber += n2;
            }
        }
    }

    private static final Filter.Result applyToLine(Filter $this$applyToLine, String lineText, int lineEnd) {
        Object $this$applyToLine_u24lambda_u240;
        Filter filter2 = $this$applyToLine;
        try {
            Filter.Result result2;
            $this$applyToLine_u24lambda_u240 = filter2;
            boolean bl = false;
            Filter.Result result3 = $this$applyToLine_u24lambda_u240.applyFilter(lineText, lineEnd);
            if (result3 != null) {
                Filter.Result it = result3;
                boolean bl2 = false;
                result2 = AsyncFilterRunner.checkRange($this$applyToLine_u24lambda_u240, lineEnd, it);
            } else {
                result2 = null;
            }
            $this$applyToLine_u24lambda_u240 = Result.constructor-impl(result2);
        }
        catch (Throwable throwable) {
            $this$applyToLine_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Filter $this$getOrHandleException$iv = $this$applyToLine_u24lambda_u240;
        boolean $i$f$getOrHandleException = false;
        Filter filter3 = $this$getOrHandleException$iv;
        Throwable throwable = Result.exceptionOrNull-impl((Object)filter3);
        if (throwable != null) {
            Throwable e$iv = throwable;
            boolean bl = false;
            LoggerKt.rethrowControlFlowException((Throwable)e$iv);
            Throwable exception = e$iv;
            boolean bl3 = false;
            LOG.error("Filter threw an exception, filter = " + $this$applyToLine, exception);
        }
        return (Filter.Result)(Result.isFailure-impl((Object)filter3) ? null : filter3);
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

