/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.FormatConstants;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class LineWrappingUtil {
    private static final String WRAP_LINE_COMMAND_NAME = "AutoWrapLongLine";
    public static final Key<Boolean> WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY = new Key("WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wrapLongLinesIfNecessary(@NotNull PsiFile file2, @NotNull Document document2, int startOffset, int endOffset, List<? extends TextRange> enabledRanges, int rightMargin) {
        VirtualFile vFile;
        if (file2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(0);
        }
        if (document2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(1);
        }
        if (((vFile = FileDocumentManager.getInstance().getFile(document2)) == null || vFile instanceof LightVirtualFile) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Editor editor2 = PsiEditorUtil.findEditor((PsiElement)file2);
        EditorFactory editorFactory = null;
        if (editor2 == null) {
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            editorFactory = EditorFactory.getInstance();
            editor2 = editorFactory.createEditor(document2, file2.getProject(), file2.getVirtualFile(), false);
        }
        try {
            Editor editorToUse = editor2;
            ApplicationManager.getApplication().runWriteAction(() -> {
                CaretModel caretModel = editorToUse.getCaretModel();
                int caretOffset = caretModel.getOffset();
                RangeMarker caretMarker = editorToUse.getDocument().createRangeMarker(caretOffset, caretOffset);
                LineWrappingUtil.doWrapLongLinesIfNecessary(editorToUse, file2.getProject(), editorToUse.getDocument(), startOffset, endOffset, enabledRanges, rightMargin);
                if (caretMarker.isValid() && caretModel.getOffset() != caretMarker.getStartOffset()) {
                    caretModel.moveToOffset(caretMarker.getStartOffset());
                }
            });
        }
        finally {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
            if (documentManager.isUncommited(document2)) {
                documentManager.commitDocument(document2);
            }
            if (editorFactory != null) {
                editorFactory.releaseEditor(editor2);
            }
        }
    }

    public static void doWrapLongLinesIfNecessary(@NotNull Editor editor2, @NotNull Project project2, @NotNull Document document2, int startOffset, int endOffset, List<? extends TextRange> enabledRanges, int rightMargin) {
        if (editor2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(3);
        }
        if (document2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(4);
        }
        int startOffsetToUse = Math.clamp((long)startOffset, 0, document2.getTextLength());
        int endOffsetToUse = Math.clamp((long)endOffset, 0, document2.getTextLength());
        LineWrapPositionStrategy strategy = LanguageLineWrapPositionStrategy.INSTANCE.forEditor(editor2);
        CharSequence text2 = document2.getCharsSequence();
        int startLine = document2.getLineNumber(startOffsetToUse);
        int endLine = document2.getLineNumber(Math.max(0, endOffsetToUse - 1));
        int maxLine = Math.min(document2.getLineCount(), endLine + 1);
        int tabSize2 = EditorUtil.getTabSize(editor2);
        if (tabSize2 <= 0) {
            tabSize2 = 1;
        }
        int spaceSize = EditorUtil.getSpaceWidth(0, editor2);
        int[] shifts = new int[2];
        int cumulativeShift = 0;
        for (int line = startLine; line < maxLine; ++line) {
            int preferredWrapPosition;
            int startLineOffset = document2.getLineStartOffset(line);
            int endLineOffset = document2.getLineEndOffset(line);
            if (!LineWrappingUtil.canWrapLine(Math.max(startOffsetToUse, startLineOffset), Math.min(endOffsetToUse, endLineOffset), cumulativeShift, enabledRanges) || (preferredWrapPosition = LineWrappingUtil.calculatePreferredWrapPosition(editor2, text2, tabSize2, spaceSize, startLineOffset, endLineOffset, endOffsetToUse, rightMargin)) < 0 || preferredWrapPosition >= endLineOffset) continue;
            if (preferredWrapPosition >= endOffsetToUse) {
                return;
            }
            int wrapOffset = strategy.calculateWrapPosition(document2, project2, Math.max(startLineOffset, startOffsetToUse), Math.min(endLineOffset, endOffsetToUse), preferredWrapPosition, false, false);
            if (wrapOffset < 0 || CharArrayUtil.shiftBackward((CharSequence)text2, (int)startLineOffset, (int)(wrapOffset - 1), (String)" \t") < startLineOffset || wrapOffset <= startLineOffset || wrapOffset >= endLineOffset) continue;
            editor2.getCaretModel().moveToOffset(wrapOffset);
            LineWrappingUtil.emulateEnter(editor2, project2, shifts);
            if (shifts[1] - 1 >= wrapOffset - startLineOffset) {
                document2.deleteString(wrapOffset, wrapOffset + shifts[1]);
                continue;
            }
            maxLine += shifts[0];
            endOffsetToUse += shifts[1];
            cumulativeShift += shifts[1];
        }
    }

    private static boolean canWrapLine(int startOffset, int endOffset, int offsetShift, @NotNull List<? extends TextRange> enabledRanges) {
        if (enabledRanges == null) {
            LineWrappingUtil.$$$reportNull$$$0(5);
        }
        for (TextRange textRange : enabledRanges) {
            if (!textRange.containsOffset(startOffset - offsetShift) || !textRange.containsOffset(endOffset - offsetShift)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void emulateEnter(@NotNull Editor editor2, @NotNull Project project2, int[] shifts) {
        if (editor2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(7);
        }
        DataContext dataContext2 = LineWrappingUtil.prepareContext(project2, editor2);
        int caretOffset = editor2.getCaretModel().getOffset();
        Document document2 = editor2.getDocument();
        SelectionModel selectionModel = editor2.getSelectionModel();
        int startSelectionOffset = 0;
        int endSelectionOffset = 0;
        boolean restoreSelection = selectionModel.hasSelection();
        if (restoreSelection) {
            startSelectionOffset = selectionModel.getSelectionStart();
            endSelectionOffset = selectionModel.getSelectionEnd();
            selectionModel.removeSelection();
        }
        int textLengthBeforeWrap = document2.getTextLength();
        int lineCountBeforeWrap = document2.getLineCount();
        DataManager.getInstance().saveInDataContext(dataContext2, WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY, (Object)true);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            Runnable command = () -> EditorActionManager.getInstance().getActionHandler("EditorEnter").execute(editor2, editor2.getCaretModel().getCurrentCaret(), dataContext2);
            if (!commandProcessor.isCommandInProgress()) {
                commandProcessor.executeCommand(project2, command, WRAP_LINE_COMMAND_NAME, null);
            } else {
                command.run();
            }
        }
        finally {
            DataManager.getInstance().saveInDataContext(dataContext2, WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY, null);
        }
        int symbolsDiff = document2.getTextLength() - textLengthBeforeWrap;
        if (restoreSelection) {
            int newSelectionStart = startSelectionOffset;
            int newSelectionEnd = endSelectionOffset;
            if (startSelectionOffset >= caretOffset) {
                newSelectionStart += symbolsDiff;
            }
            if (endSelectionOffset >= caretOffset) {
                newSelectionEnd += symbolsDiff;
            }
            selectionModel.setSelection(newSelectionStart, newSelectionEnd);
        }
        shifts[0] = document2.getLineCount() - lineCountBeforeWrap;
        shifts[1] = symbolsDiff;
    }

    private static int calculatePreferredWrapPosition(@NotNull Editor editor2, @NotNull CharSequence text2, int tabSize2, int spaceSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset, int rightMargin) {
        if (editor2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(9);
        }
        boolean hasTabs = false;
        boolean canOptimize = true;
        boolean hasNonSpaceSymbols = false;
        block4: for (int i2 = startLineOffset; i2 < Math.min(endLineOffset, targetRangeEndOffset); ++i2) {
            char c = text2.charAt(i2);
            switch (c) {
                case '\t': {
                    hasTabs = true;
                    if (hasNonSpaceSymbols) {
                        canOptimize = false;
                        break block4;
                    }
                }
                case ' ': {
                    continue block4;
                }
                default: {
                    hasNonSpaceSymbols = true;
                }
            }
        }
        int reservedWidthInColumns = FormatConstants.getReservedLineWrapWidthInColumns(editor2);
        if (!hasTabs) {
            return LineWrappingUtil.wrapPositionForTextWithoutTabs(startLineOffset, endLineOffset, targetRangeEndOffset, reservedWidthInColumns, rightMargin);
        }
        if (canOptimize) {
            return LineWrappingUtil.wrapPositionForTabbedTextWithOptimization(text2, tabSize2, startLineOffset, endLineOffset, targetRangeEndOffset, reservedWidthInColumns, rightMargin);
        }
        return LineWrappingUtil.wrapPositionForTabbedTextWithoutOptimization(editor2, text2, spaceSize, startLineOffset, endLineOffset, targetRangeEndOffset, reservedWidthInColumns, rightMargin);
    }

    private static int wrapPositionForTextWithoutTabs(int startLineOffset, int endLineOffset, int targetRangeEndOffset, int reservedWidthInColumns, int rightMargin) {
        if (Math.min(endLineOffset, targetRangeEndOffset) - startLineOffset > rightMargin) {
            return startLineOffset + rightMargin - reservedWidthInColumns;
        }
        return -1;
    }

    private static int wrapPositionForTabbedTextWithOptimization(@NotNull CharSequence text2, int tabSize2, int startLineOffset, int endLineOffset, int targetRangeEndOffset, int reservedWidthInColumns, int rightMargin) {
        if (text2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(10);
        }
        int width = 0;
        int result2 = Integer.MAX_VALUE;
        boolean wrapLine = false;
        for (int i2 = startLineOffset; i2 < Math.min(endLineOffset, targetRangeEndOffset); ++i2) {
            int symbolWidth;
            char c = text2.charAt(i2);
            int n = symbolWidth = c == '\t' ? tabSize2 - width % tabSize2 : 1;
            if (width + symbolWidth + reservedWidthInColumns >= rightMargin && Math.min(endLineOffset, targetRangeEndOffset) - i2 >= reservedWidthInColumns) {
                result2 = i2 - 1;
            }
            if (width + symbolWidth >= rightMargin) {
                wrapLine = true;
                break;
            }
            width += symbolWidth;
        }
        return wrapLine ? result2 : -1;
    }

    private static int wrapPositionForTabbedTextWithoutOptimization(@NotNull Editor editor2, @NotNull CharSequence text2, int spaceSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset, int reservedWidthInColumns, int rightMargin) {
        if (editor2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(12);
        }
        int width = 0;
        int x = 0;
        int result2 = Integer.MAX_VALUE;
        boolean wrapLine = false;
        for (int i2 = startLineOffset; i2 < Math.min(endLineOffset, targetRangeEndOffset); ++i2) {
            int symbolWidth;
            int newX;
            char c = text2.charAt(i2);
            if (c == '\t') {
                newX = EditorUtil.nextTabStop(x, editor2);
                int diffInPixels = newX - x;
                symbolWidth = diffInPixels / spaceSize;
                if (diffInPixels % spaceSize > 0) {
                    ++symbolWidth;
                }
            } else {
                newX = x + EditorUtil.charWidth(c, 0, editor2);
                symbolWidth = 1;
            }
            if (width + symbolWidth + reservedWidthInColumns >= rightMargin && Math.min(endLineOffset, targetRangeEndOffset) - i2 >= reservedWidthInColumns) {
                result2 = i2 - 1;
            }
            if (width + symbolWidth >= rightMargin) {
                wrapLine = true;
                break;
            }
            x = newX;
            width += symbolWidth;
        }
        return wrapLine ? result2 : -1;
    }

    @NotNull
    private static DataContext prepareContext(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(13);
        }
        if (editor2 == null) {
            LineWrappingUtil.$$$reportNull$$$0(14);
        }
        Project editorProject = editor2.getProject();
        DataContext context = EditorUtil.getEditorDataContext(editor2);
        if (editorProject != null) {
            DataContext dataContext2 = context;
            if (dataContext2 == null) {
                LineWrappingUtil.$$$reportNull$$$0(15);
            }
            return dataContext2;
        }
        DataContext dataContext3 = SimpleDataContext.getSimpleContext((DataKey)CommonDataKeys.PROJECT, (Object)project2, (DataContext)context);
        if (dataContext3 == null) {
            LineWrappingUtil.$$$reportNull$$$0(16);
        }
        return dataContext3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledRanges";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/LineWrappingUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/LineWrappingUtil";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapLongLinesIfNecessary";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doWrapLongLinesIfNecessary";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canWrapLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "emulateEnter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculatePreferredWrapPosition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wrapPositionForTabbedTextWithOptimization";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapPositionForTabbedTextWithoutOptimization";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareContext";
                break;
            }
            case 15: 
            case 16: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16 -> new IllegalStateException(string);
        };
    }
}

