/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ClientCopyPasteManager;
import com.intellij.ide.CopyPasteManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ide.KillRingTransferable;
import com.intellij.openapi.ide.Sizeable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.LinkedListWithSum;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.EventListener;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class CopyPasteManagerWithHistory
implements ClientCopyPasteManager {
    private static final Logger LOG = Logger.getInstance(CopyPasteManagerWithHistory.class);
    private final EventDispatcher<CopyPasteManager.ContentChangedListener> myDispatcher = EventDispatcher.create(CopyPasteManager.ContentChangedListener.class);
    protected final LinkedListWithSum<Transferable> myData = new LinkedListWithSum(CopyPasteManagerWithHistory::getSize);
    private boolean myOwnContent;

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.myOwnContent = false;
        this.fireContentChanged(contents, null);
    }

    @Override
    public void setContents(@NotNull Transferable content2) {
        if (content2 == null) {
            CopyPasteManagerWithHistory.$$$reportNull$$$0(0);
        }
        Transferable oldContent = this.myOwnContent && !this.myData.isEmpty() ? (Transferable)this.myData.get(0) : null;
        Transferable contentToUse = this.addNewContentToStack(content2);
        this.setSystemClipboardContent(contentToUse);
        this.fireContentChanged(oldContent, contentToUse);
    }

    @Override
    public void stopKillRings() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Kill ring reset");
        }
        this.doStopKillRings();
    }

    @Override
    public void stopKillRings(@NotNull Document document2) {
        Transferable top;
        if (document2 == null) {
            CopyPasteManagerWithHistory.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Kill ring reset for " + String.valueOf(document2));
        }
        if (!this.myData.isEmpty() && (top = (Transferable)this.myData.get(0)) instanceof KillRingTransferable && document2 == ((KillRingTransferable)top).getDocument()) {
            this.doStopKillRings();
        }
    }

    private void doStopKillRings() {
        for (Transferable data2 : this.myData) {
            if (!(data2 instanceof KillRingTransferable)) continue;
            ((KillRingTransferable)data2).setReadyToCombine(false);
        }
    }

    private void setSystemClipboardContent(Transferable content2) {
        this.myOwnContent = true;
        this.doSetSystemClipboardContent(content2);
    }

    protected abstract void doSetSystemClipboardContent(Transferable var1);

    /*
     * Exception decompiling
     */
    @NotNull
    private Transferable addNewContentToStack(@NotNull Transferable content) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addToTheTopOfTheStack(@NotNull Transferable content2) {
        if (content2 == null) {
            CopyPasteManagerWithHistory.$$$reportNull$$$0(8);
        }
        this.myData.add(0, (Object)content2);
        this.deleteAfterAllowedMaximum();
    }

    @Nullable
    private static Transferable merge(@NotNull KillRingTransferable newData, @NotNull KillRingTransferable oldData) throws IOException, UnsupportedFlavorException {
        if (newData == null) {
            CopyPasteManagerWithHistory.$$$reportNull$$$0(9);
        }
        if (oldData == null) {
            CopyPasteManagerWithHistory.$$$reportNull$$$0(10);
        }
        if (!oldData.isReadyToCombine() || !newData.isReadyToCombine()) {
            return null;
        }
        Document document2 = newData.getDocument();
        if (document2 == null || document2 != oldData.getDocument()) {
            return null;
        }
        Object newDataText = newData.getTransferData(DataFlavor.stringFlavor);
        Object oldDataText = oldData.getTransferData(DataFlavor.stringFlavor);
        if (oldData.isCut() && newData.getStartOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(oldDataText.toString() + String.valueOf(newDataText), document2, oldData.getStartOffset(), newData.getEndOffset(), newData.isCut());
        }
        if (newData.getStartOffset() == oldData.getEndOffset()) {
            return new KillRingTransferable(oldDataText.toString() + String.valueOf(newDataText), document2, oldData.getStartOffset(), newData.getEndOffset(), false);
        }
        if (newData.getEndOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(newDataText.toString() + String.valueOf(oldDataText), document2, newData.getStartOffset(), oldData.getEndOffset(), false);
        }
        return null;
    }

    protected static String getStringContent(Transferable content2) {
        if (content2 != null) {
            try {
                return (String)content2.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void deleteAfterAllowedMaximum() {
        int maxCount = Math.max(1, Registry.intValue((String)"clipboard.history.max.items"));
        int maxMemory = Math.max(0, Registry.intValue((String)"clipboard.history.max.memory"));
        CopyPasteManagerEx.deleteAfterAllowedMaximum(this.myData, maxCount, maxMemory, item -> CopyPasteManagerWithHistory.createPurgedItem());
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super Transferable> predicate) {
        if (predicate == null) {
            CopyPasteManagerWithHistory.$$$reportNull$$$0(11);
        }
        return this.myData.removeIf(predicate);
    }

    @Override
    public Transferable @NotNull [] getAllContents() {
        String clipString = (String)this.getContents(DataFlavor.stringFlavor);
        if (clipString != null && (this.myData.isEmpty() || !Objects.equals(clipString, CopyPasteManagerWithHistory.getStringContent((Transferable)this.myData.get(0))))) {
            this.addToTheTopOfTheStack(new StringSelection(clipString));
        }
        Transferable[] transferableArray = (Transferable[])this.myData.toArray((Object[])new Transferable[0]);
        if (transferableArray == null) {
            CopyPasteManagerWithHistory.$$$reportNull$$$0(12);
        }
        return transferableArray;
    }

    @Override
    public void removeContent(Transferable t) {
        Transferable current = this.myData.isEmpty() ? null : (Transferable)this.myData.get(0);
        this.myData.remove((Object)t);
        if (Comparing.equal((Object)t, (Object)current)) {
            Transferable newContent = !this.myData.isEmpty() ? (Transferable)this.myData.get(0) : new StringSelection("");
            this.setSystemClipboardContent(newContent);
            this.fireContentChanged(current, newContent);
        }
    }

    @Override
    public void moveContentToStackTop(Transferable t) {
        Transferable current;
        Transferable transferable = current = this.myData.isEmpty() ? null : (Transferable)this.myData.get(0);
        if (!Comparing.equal((Object)t, (Object)current)) {
            this.myData.remove((Object)t);
            this.myData.add(0, (Object)t);
            this.setSystemClipboardContent(t);
            this.fireContentChanged(current, t);
        } else {
            this.setSystemClipboardContent(t);
        }
    }

    private static Transferable createPurgedItem() {
        return new StringSelection(UIBundle.message((String)"clipboard.history.purged.item", (Object[])new Object[0]));
    }

    protected void fireContentChanged(@Nullable Transferable oldContent, @Nullable Transferable newContent) {
        ((CopyPasteManager.ContentChangedListener)this.myDispatcher.getMulticaster()).contentChanged(oldContent, newContent);
    }

    @Override
    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2) {
        if (listener2 == null) {
            CopyPasteManagerWithHistory.$$$reportNull$$$0(13);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            CopyPasteManagerWithHistory.$$$reportNull$$$0(14);
        }
        if (parentDisposable == null) {
            CopyPasteManagerWithHistory.$$$reportNull$$$0(15);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    public void removeContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2) {
        if (listener2 == null) {
            CopyPasteManagerWithHistory.$$$reportNull$$$0(16);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    private static int getSize(Transferable t) {
        if (t instanceof StringSelection) {
            try {
                return StringUtil.length((CharSequence)((String)t.getTransferData(DataFlavor.stringFlavor)));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        } else if (t instanceof Sizeable) {
            int size2 = ((Sizeable)t).getSize();
            if (size2 >= 0) {
                return size2;
            }
            LOG.error("Got negative size (" + size2 + ") from " + String.valueOf(t));
        }
        return 1000;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/CopyPasteManagerWithHistory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldData";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/CopyPasteManagerWithHistory";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addNewContentToStack";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setContents";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "stopKillRings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addNewContentToStack";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addToTheTopOfTheStack";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeIf";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addContentChangedListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeContentChangedListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 12 -> new IllegalStateException(string);
        };
    }
}

