/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ClientIdAwareEvent;
import com.intellij.ide.IdeEventQueueKt;
import com.intellij.ide.IdeKeyboardFocusManagerKt;
import com.intellij.ide.ui.ShowingContainer;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ThreadingRuntimeFlagsKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.locking.impl.IntelliJLockingUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.util.List;
import javax.swing.DefaultFocusManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0015H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/IdeKeyboardFocusManager;", "Ljavax/swing/DefaultFocusManager;", "original", "Ljava/awt/KeyboardFocusManager;", "<init>", "(Ljava/awt/KeyboardFocusManager;)V", "getOriginal$intellij_platform_ide_impl", "()Ljava/awt/KeyboardFocusManager;", "parentConstructorExecuted", "", "dispatchEvent", "e", "Ljava/awt/AWTEvent;", "getAssociatedClientId", "Lcom/intellij/openapi/application/AccessToken;", "setDefaultFocusTraversalPolicy", "", "defaultPolicy", "Ljava/awt/FocusTraversalPolicy;", "setGlobalFocusOwner", "focusOwner", "Ljava/awt/Component;", "isRecursivelyVisibleViaShowingContainer", "component", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeKeyboardFocusManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeKeyboardFocusManager.kt\ncom/intellij/ide/IdeKeyboardFocusManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n60#2,5:160\n60#2,5:165\n1#3:170\n*S KotlinDebug\n*F\n+ 1 IdeKeyboardFocusManager.kt\ncom/intellij/ide/IdeKeyboardFocusManager\n*L\n76#1:160,5\n80#1:165,5\n*E\n"})
public final class IdeKeyboardFocusManager
extends DefaultFocusManager {
    @NotNull
    private final KeyboardFocusManager original;
    private final boolean parentConstructorExecuted;

    public IdeKeyboardFocusManager(@NotNull KeyboardFocusManager original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.original = original;
        this.parentConstructorExecuted = true;
    }

    @NotNull
    public final KeyboardFocusManager getOriginal$intellij_platform_ide_impl() {
        return this.original;
    }

    @Override
    public boolean dispatchEvent(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getID() == 1400 && e instanceof HierarchyEvent && ((int)((HierarchyEvent)e).getChangeFlags() & 6) == 2) {
            Component component2 = ((HierarchyEvent)e).getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getComponent(...)");
            if (this.isRecursivelyVisibleViaShowingContainer(component2)) {
                HierarchyEvent patchedEvent = new HierarchyEvent(((HierarchyEvent)e).getComponent(), ((HierarchyEvent)e).getID(), ((HierarchyEvent)e).getChanged(), ((HierarchyEvent)e).getChangedParent(), ((HierarchyEvent)e).getChangeFlags() | 4L);
                ((HierarchyEvent)e).getComponent().dispatchEvent(patchedEvent);
                return true;
            }
        }
        Function0 dispatch = () -> IdeKeyboardFocusManager.dispatchEvent$lambda$0(this, e);
        if (EventQueue.isDispatchThread()) {
            Ref.BooleanRef result2 = new Ref.BooleanRef();
            Application app = ApplicationManager.getApplication();
            if (app == null || app.isReadAccessAllowed() || !ThreadingRuntimeFlagsKt.getWrapHighLevelFunctionsInWriteIntent()) {
                IdeEventQueueKt.performActivity(e, (Function0<Unit>)((Function0)() -> IdeKeyboardFocusManager.dispatchEvent$lambda$1(result2, dispatch)));
            } else {
                IdeEventQueueKt.performActivity(e, (Function0<Unit>)((Function0)() -> IdeKeyboardFocusManager.dispatchEvent$lambda$2(result2, dispatch)));
            }
            return result2.element;
        }
        return (Boolean)dispatch.invoke();
    }

    private final AccessToken getAssociatedClientId(AWTEvent e) {
        if (!AppMode.isRemoteDevHost()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
            return accessToken;
        }
        int id2 = e.getID();
        switch (id2) {
            case 207: 
            case 208: 
            case 1004: 
            case 1005: {
                if (e instanceof ClientIdAwareEvent) {
                    Logger $this$debug_u24default$iv = IdeKeyboardFocusManagerKt.access$getLogger$p();
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug(e + " is " + Reflection.getOrCreateKotlinClass(ClientIdAwareEvent.class).getSimpleName() + ". Wrapping with " + ((ClientIdAwareEvent)((Object)e)).getClientId(), t$iv);
                    }
                    return ClientId.Companion.withClientId(((ClientIdAwareEvent)((Object)e)).getClientId());
                }
                Logger $this$debug_u24default$iv = IdeKeyboardFocusManagerKt.access$getLogger$p();
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug(e + " is not " + Reflection.getOrCreateKotlinClass(ClientIdAwareEvent.class).getSimpleName() + ". Falling back to wrapping with a controller's ClientId", t$iv);
                }
                ClientAppSession clientAppSession = (ClientAppSession)CollectionsKt.firstOrNull((List)ClientSessionsManager.Companion.getAppSessions(ClientKind.CONTROLLER));
                if (clientAppSession == null) break;
                ClientAppSession it = clientAppSession;
                boolean bl = false;
                return ClientId.Companion.withClientId(it.getClientId());
            }
        }
        AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
        Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
        return accessToken;
    }

    @Override
    public void setDefaultFocusTraversalPolicy(@NotNull FocusTraversalPolicy defaultPolicy) {
        Intrinsics.checkNotNullParameter((Object)defaultPolicy, (String)"defaultPolicy");
        if (this.parentConstructorExecuted) {
            if (IdeKeyboardFocusManagerKt.access$getLogger$p().isDebugEnabled()) {
                IdeKeyboardFocusManagerKt.access$getLogger$p().debug("setDefaultFocusTraversalPolicy: " + defaultPolicy, new Throwable());
            }
            super.setDefaultFocusTraversalPolicy(defaultPolicy);
        }
    }

    @Override
    protected void setGlobalFocusOwner(@Nullable Component focusOwner) {
        for (Component c = focusOwner; c != null && !(c instanceof Window); c = (Component)c.getParent()) {
            if (c.isVisible()) continue;
            return;
        }
        super.setGlobalFocusOwner(focusOwner);
    }

    private final boolean isRecursivelyVisibleViaShowingContainer(Component component2) {
        Component c = component2;
        while (!(c instanceof ShowingContainer)) {
            if (!c.isVisible() || c instanceof Window) {
                return false;
            }
            Container container = c.getParent();
            if (container == null) {
                return false;
            }
            c = container;
        }
        return true;
    }

    private static final Unit dispatchEvent$lambda$2$0(Ref.BooleanRef $result, Function0 $dispatch) {
        $result.element = (Boolean)$dispatch.invoke();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean dispatchEvent$lambda$0(IdeKeyboardFocusManager this$0, AWTEvent $e) {
        boolean bl;
        AutoCloseable autoCloseable = (AutoCloseable)this$0.getAssociatedClientId($e);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl2 = false;
            bl = super.dispatchEvent($e);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return bl;
    }

    private static final Unit dispatchEvent$lambda$1(Ref.BooleanRef $result, Function0 $dispatch) {
        $result.element = (Boolean)$dispatch.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit dispatchEvent$lambda$2(Ref.BooleanRef $result, Function0 $dispatch) {
        IntelliJLockingUtil.getGlobalThreadingSupport().runWriteIntentReadAction(() -> IdeKeyboardFocusManager.dispatchEvent$lambda$2$0($result, $dispatch));
        return Unit.INSTANCE;
    }
}

