/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.actions.InvalidateCachesDialog;
import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public final class InvalidateCacheService {
    private static final Logger LOG = Logger.getInstance(InvalidateCacheService.class);

    public static void invalidateCachesAndRestart(@Nullable Project project2) {
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        boolean canRestart = app.isRestartCapable();
        InvalidateCachesDialog dialog2 = new InvalidateCachesDialog(project2, canRestart, CachesInvalidator.EP_NAME.getExtensionList().stream().filter(CachesInvalidator::isVisible).toList());
        dialog2.show();
        List<CachesInvalidator> invalidators = dialog2.getSelectedInvalidators();
        if (dialog2.isOK()) {
            InvalidateCacheService.invalidateCaches(invalidators::contains);
        }
        if (dialog2.isOK() || dialog2.isRestartOnly()) {
            app.restart(true);
        }
    }

    public static void invalidateCaches(Predicate<? super CachesInvalidator> isAllowedInvalidator) {
        for (CachesInvalidator invalidator : CachesInvalidator.EP_NAME.getExtensionList()) {
            if (!isAllowedInvalidator.test((CachesInvalidator)invalidator)) continue;
            try {
                invalidator.invalidateCaches();
            }
            catch (Throwable t) {
                LOG.warn("Failed to invalidate caches with " + invalidator.getClass().getName() + ". " + t.getMessage(), t);
            }
        }
    }
}

