/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.DynamicBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Url;
import com.intellij.util.io.URLUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StartBrowserPanel {
    private JCheckBox myStartBrowserCheckBox;
    private ComboboxWithBrowseButton myBrowserComboBox;
    private JCheckBox myStartJavaScriptDebuggerCheckBox;
    private TextFieldWithBrowseButton myUrlField;
    private BrowserSelector myBrowserSelector;
    private JPanel myRoot;

    public StartBrowserPanel() {
        this.$$$setupUI$$$();
        this.myStartJavaScriptDebuggerCheckBox.setVisible(JavaScriptDebuggerStarter.Util.hasStarters());
        this.myRoot.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                StartBrowserPanel.this.myRoot.removeAncestorListener((AncestorListener)((Object)this));
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)StartBrowserPanel.this.myRoot));
                if (project2 == null) {
                    DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
                        Project project1 = (Project)CommonDataKeys.PROJECT.getData(context);
                        if (project1 == null) {
                            project1 = ProjectManager.getInstance().getDefaultProject();
                        }
                        StartBrowserPanel.setupUrlField(StartBrowserPanel.this.myUrlField, project1);
                    });
                } else {
                    StartBrowserPanel.setupUrlField(StartBrowserPanel.this.myUrlField, project2);
                }
            }
        });
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myRoot;
        if (jPanel == null) {
            StartBrowserPanel.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Nullable
    public String getNormalizedUrl() {
        String url = StringUtil.nullize((String)this.myUrlField.getText(), (boolean)true);
        if (url != null && !URLUtil.containsScheme((String)(url = url.trim()))) {
            return VirtualFileManager.constructUrl((String)"http", (String)url);
        }
        return url;
    }

    public void setUrl(@NlsSafe @Nullable String url) {
        this.myUrlField.setText(url);
    }

    public boolean isSelected() {
        return this.myStartBrowserCheckBox.isSelected();
    }

    public void setSelected(boolean value) {
        this.myStartBrowserCheckBox.setSelected(value);
    }

    public JCheckBox getStartJavaScriptDebuggerCheckBox() {
        return this.myStartJavaScriptDebuggerCheckBox;
    }

    public BrowserSelector getBrowserSelector() {
        return this.myBrowserSelector;
    }

    private void createUIComponents() {
        this.myBrowserSelector = new BrowserSelector();
        this.myBrowserComboBox = (ComboboxWithBrowseButton)this.myBrowserSelector.getMainComponent();
        this.myBrowserComboBox.getComboBox().addActionListener(e -> this.myStartJavaScriptDebuggerCheckBox.setEnabled(StartBrowserPanel.isDebugAllowed(this.myBrowserSelector.getSelected())));
    }

    @Nullable
    private static Url virtualFileToUrl(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            StartBrowserPanel.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            StartBrowserPanel.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project2).findFile(file2));
        return WebBrowserServiceImpl.getDebuggableUrl((PsiElement)psiFile);
    }

    @NotNull
    public StartBrowserSettings createSettings() {
        StartBrowserSettings browserSettings = new StartBrowserSettings();
        browserSettings.setSelected(this.isSelected());
        browserSettings.setBrowser(this.myBrowserSelector.getSelected());
        boolean isDebugEnabled = this.myStartJavaScriptDebuggerCheckBox.isSelected() && StartBrowserPanel.isDebugAllowed(this.myBrowserSelector.getSelected());
        browserSettings.setStartJavaScriptDebugger(isDebugEnabled);
        browserSettings.setUrl(this.getNormalizedUrl());
        StartBrowserSettings startBrowserSettings = browserSettings;
        if (startBrowserSettings == null) {
            StartBrowserPanel.$$$reportNull$$$0(3);
        }
        return startBrowserSettings;
    }

    public void setFromSettings(StartBrowserSettings settings) {
        this.setSelected(settings.isSelected());
        this.setUrl(settings.getUrl());
        this.myStartJavaScriptDebuggerCheckBox.setSelected(settings.isStartJavaScriptDebugger());
        this.myBrowserSelector.setSelected(settings.getBrowser());
    }

    private static boolean isDebugAllowed(@Nullable WebBrowser browser) {
        return browser != null && browser.getFamily().equals((Object)BrowserFamily.CHROME);
    }

    public static void setupUrlField(@NotNull TextFieldWithBrowseButton field, final @NotNull Project project2) {
        if (field == null) {
            StartBrowserPanel.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            StartBrowserPanel.$$$reportNull$$$0(5);
        }
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(@Nullable VirtualFile file2) {
                if (file2 == null) {
                    return false;
                }
                return WebBrowserXmlService.getInstance().isHtmlFile(file2) || StartBrowserPanel.virtualFileToUrl(file2, project2) != null;
            }
        };
        descriptor2.setTitle(IdeBundle.message((String)"javascript.debugger.settings.choose.file.title", (Object[])new Object[0]));
        descriptor2.setDescription(IdeBundle.message((String)"javascript.debugger.settings.choose.file.subtitle", (Object[])new Object[0]));
        descriptor2.setRoots(ProjectRootManager.getInstance((Project)project2).getContentRoots());
        field.addBrowseFolderListener(new TextBrowseFolderListener(descriptor2, project2){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (chosenFile.isDirectory()) {
                    String string = chosenFile.getPath();
                    if (string == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                Url url = StartBrowserPanel.virtualFileToUrl(chosenFile, project2);
                String string = url == null ? chosenFile.getUrl() : url.toDecodedForm();
                if (string == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/browsers/StartBrowserPanel$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/browsers/StartBrowserPanel$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/StartBrowserPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/StartBrowserPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "virtualFileToUrl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupUrlField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/IdeBundle", StartBrowserPanel.class).getString("start.browser.border.label.open.browser"), (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        this.myStartBrowserCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/IdeBundle", StartBrowserPanel.class).getString("start.browser.checkbox.start.browser"));
        jCheckBox2.setVerticalTextPosition(0);
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myBrowserComboBox;
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myStartJavaScriptDebuggerCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/IdeBundle", StartBrowserPanel.class).getString("start.browser.with.js.debugger"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myUrlField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", StartBrowserPanel.class).getString("start.browser.panel.url.label"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

