/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.certificates;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.certificates.PluginCertificateStore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.net.ssl.CertificateConfigurable;
import com.intellij.util.net.ssl.CertificateInfoPanel;
import com.intellij.util.net.ssl.CertificateListener;
import com.intellij.util.net.ssl.CertificateTreeBuilder;
import com.intellij.util.net.ssl.CertificateUtil;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0019\u001a\u00020\fH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020\u001bH\u0002J\b\u0010$\u001a\u00020\u001bH\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010&\u001a\u00020\u001bH\u0002J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u0011H\u0002J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ide/plugins/certificates/PluginCertificateManager;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "Lcom/intellij/util/net/ssl/CertificateListener;", "Lcom/intellij/openapi/options/Configurable$SingleEditorConfiguration;", "<init>", "()V", "myTree", "Lcom/intellij/ui/treeStructure/Tree;", "myDetailsPanel", "Ljavax/swing/JPanel;", "myRootPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getMyRootPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "myEmptyPanel", "EMPTY_PANEL", "", "myTrustManager", "Lcom/intellij/util/net/ssl/ConfirmingTrustManager$MutableTrustManager;", "myTreeBuilder", "Lcom/intellij/util/net/ssl/CertificateTreeBuilder;", "myCertificates", "", "Ljava/security/cert/X509Certificate;", "createPanel", "certificateAdded", "", "certificate", "certificateRemoved", "isModified", "", "apply", "reset", "disposeUIResources", "init", "chooseFileAndAdd", "addCertificate", "removeSelectedCertificates", "showCard", "cardName", "getCardName", "addCertificatePanel", "getDialogInitialSize", "Ljava/awt/Dimension;", "intellij.platform.ide.impl"})
public final class PluginCertificateManager
extends BoundConfigurable
implements Configurable.NoScroll,
CertificateListener,
Configurable.SingleEditorConfiguration {
    @NotNull
    private final Tree myTree;
    @NotNull
    private final JPanel myDetailsPanel;
    @NotNull
    private final DialogPanel myRootPanel;
    @NotNull
    private final DialogPanel myEmptyPanel;
    @NotNull
    private final String EMPTY_PANEL;
    @NotNull
    private final ConfirmingTrustManager.MutableTrustManager myTrustManager;
    @NotNull
    private final CertificateTreeBuilder myTreeBuilder;
    @NotNull
    private final Set<X509Certificate> myCertificates;

    public PluginCertificateManager() {
        String string = IdeBundle.message((String)"plugin.manager.custom.certificates", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "plugin.certificates");
        this.myTree = new Tree();
        this.myDetailsPanel = new JPanel(new CardLayout());
        this.myRootPanel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> PluginCertificateManager.myRootPanel$lambda$0(this, arg_0)));
        this.myEmptyPanel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)PluginCertificateManager::myEmptyPanel$lambda$0));
        this.EMPTY_PANEL = "empty.panel";
        this.myTrustManager = PluginCertificateStore.INSTANCE.getCustomTrustManager();
        this.myTreeBuilder = new CertificateTreeBuilder(this.myTree);
        this.myCertificates = new LinkedHashSet();
    }

    @NotNull
    public final DialogPanel getMyRootPanel() {
        return this.myRootPanel;
    }

    @NotNull
    public DialogPanel createPanel() {
        this.init();
        return this.myRootPanel;
    }

    public void certificateAdded(@NotNull X509Certificate certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        UIUtil.invokeLaterIfNeeded(() -> PluginCertificateManager.certificateAdded$lambda$0(this, certificate));
    }

    public void certificateRemoved(@NotNull X509Certificate certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        UIUtil.invokeLaterIfNeeded(() -> PluginCertificateManager.certificateRemoved$lambda$0(this, certificate));
    }

    public boolean isModified() {
        return !Intrinsics.areEqual(this.myCertificates, new HashSet(this.myTrustManager.getCertificates()));
    }

    public void apply() throws ConfigurationException {
        List existing = this.myTrustManager.getCertificates();
        Intrinsics.checkNotNull((Object)existing);
        Set added = SetsKt.minus(this.myCertificates, (Iterable)existing);
        List removed = CollectionsKt.minus((Iterable)existing, (Iterable)this.myCertificates);
        for (X509Certificate certificate : added) {
            if (this.myTrustManager.addCertificate(certificate)) continue;
            Object[] objectArray = new Object[]{CertificateUtil.getCommonName((X509Certificate)certificate)};
            throw new ConfigurationException(IdeBundle.message((String)"settings.certificate.cannot.add.certificate.for", (Object[])objectArray), IdeBundle.message((String)"settings.certificate.cannot.add.certificate", (Object[])new Object[0]));
        }
        for (X509Certificate certificate : removed) {
            if (this.myTrustManager.removeCertificate(certificate)) continue;
            Object[] objectArray = new Object[]{CertificateUtil.getCommonName((X509Certificate)certificate)};
            throw new ConfigurationException(IdeBundle.message((String)"settings.certificate.cannot.remove.certificate.for", (Object[])objectArray), IdeBundle.message((String)"settings.certificate.cannot.remove.certificate", (Object[])new Object[0]));
        }
    }

    public void reset() {
        List original = this.myTrustManager.getCertificates();
        this.myTreeBuilder.reset(original);
        this.myCertificates.clear();
        Intrinsics.checkNotNull((Object)original);
        this.myCertificates.addAll(original);
        this.myDetailsPanel.removeAll();
        this.myDetailsPanel.add((Component)this.myEmptyPanel, "empty.panel");
        Iterator iterator = original.iterator();
        while (iterator.hasNext()) {
            X509Certificate certificate;
            X509Certificate x509Certificate = certificate = (X509Certificate)iterator.next();
            Intrinsics.checkNotNull((Object)x509Certificate);
            this.addCertificatePanel(x509Certificate);
        }
        if (!((Collection)this.myCertificates).isEmpty()) {
            this.myTreeBuilder.selectFirstCertificate();
        }
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        Disposer.dispose((Disposable)this.myTreeBuilder);
        this.myTrustManager.removeListener((CertificateListener)this);
    }

    private final void init() {
        this.myTrustManager.addListener((CertificateListener)this);
        this.myTree.getEmptyText().setText(IdeBundle.message((String)"settings.certificate.no.certificates", (Object[])new Object[0]));
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setRootVisible(false);
        this.myTree.setVisibleRowCount(10);
        this.myTree.addTreeSelectionListener(arg_0 -> PluginCertificateManager.init$lambda$0(this, arg_0));
    }

    private final void chooseFileAndAdd() {
        FileChooser.chooseFile((FileChooserDescriptor)CertificateConfigurable.CERTIFICATE_DESCRIPTOR, null, null, arg_0 -> PluginCertificateManager.chooseFileAndAdd$lambda$1(arg_0 -> PluginCertificateManager.chooseFileAndAdd$lambda$0(this, arg_0), arg_0));
    }

    private final void addCertificate(X509Certificate certificate) {
        this.myCertificates.add(certificate);
        this.myTreeBuilder.addCertificate(certificate);
        this.addCertificatePanel(certificate);
        this.myTreeBuilder.selectCertificate(certificate);
    }

    private final void removeSelectedCertificates() {
        for (X509Certificate certificate : this.myTreeBuilder.getSelectedCertificates(true)) {
            this.myCertificates.remove(certificate);
            this.myTreeBuilder.removeCertificate(certificate);
        }
        if (this.myCertificates.isEmpty()) {
            this.showCard(this.EMPTY_PANEL);
        } else {
            this.myTreeBuilder.selectFirstCertificate();
        }
    }

    private final void showCard(String cardName) {
        LayoutManager layoutManager = this.myDetailsPanel.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
        ((CardLayout)layoutManager).show(this.myDetailsPanel, cardName);
    }

    private final String getCardName(X509Certificate certificate) {
        String string = certificate.getSubjectX500Principal().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private final void addCertificatePanel(X509Certificate certificate) {
        String uniqueName = this.getCardName(certificate);
        CertificateInfoPanel infoPanel = new CertificateInfoPanel(certificate);
        UIUtil.addInsets((JComponent)((JComponent)infoPanel), (Insets)UIUtil.PANEL_REGULAR_INSETS);
        JBScrollPane scrollPane = new JBScrollPane((Component)infoPanel);
        scrollPane.setPreferredSize((Dimension)new JBDimension(300, 100));
        this.myDetailsPanel.add((Component)scrollPane, uniqueName);
    }

    @NotNull
    public Dimension getDialogInitialSize() {
        Dimension dimension = JBUI.DialogSizes.medium();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"medium(...)");
        return dimension;
    }

    private static final void myRootPanel$lambda$0$0$0(PluginCertificateManager this$0, AnActionButton it) {
        this$0.chooseFileAndAdd();
    }

    private static final void myRootPanel$lambda$0$0$1(PluginCertificateManager this$0, AnActionButton it) {
        this$0.removeSelectedCertificates();
    }

    private static final Unit myRootPanel$lambda$0$0(PluginCertificateManager this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JPanel jPanel = ToolbarDecorator.createDecorator((JTree)((JTree)this$0.myTree)).disableUpDownActions().setAddAction(arg_0 -> PluginCertificateManager.myRootPanel$lambda$0$0$0(this$0, arg_0)).setRemoveAction(arg_0 -> PluginCertificateManager.myRootPanel$lambda$0$0$1(this$0, arg_0)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel decorator = jPanel;
        Cell<JComponent> cell = $this$row.cell((JComponent)decorator);
        String string = IdeBundle.message((String)"settings.trusted.certificates", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        cell.label(string, LabelPosition.TOP).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit myRootPanel$lambda$0$1(PluginCertificateManager this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.myDetailsPanel).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit myRootPanel$lambda$0(PluginCertificateManager this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, arg_0 -> PluginCertificateManager.myRootPanel$lambda$0$0(this$0, arg_0), 1, null).resizableRow();
        Panel.row$default($this$panel, null, arg_0 -> PluginCertificateManager.myRootPanel$lambda$0$1(this$0, arg_0), 1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit myEmptyPanel$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"settings.certificate.no.certificate.selected", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit myEmptyPanel$lambda$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, PluginCertificateManager::myEmptyPanel$lambda$0$0, 1, null);
        return Unit.INSTANCE;
    }

    private static final void certificateAdded$lambda$0(PluginCertificateManager this$0, X509Certificate $certificate) {
        if (!this$0.myCertificates.contains($certificate)) {
            this$0.myCertificates.add($certificate);
            this$0.myTreeBuilder.addCertificate($certificate);
            this$0.addCertificatePanel($certificate);
        }
    }

    private static final void certificateRemoved$lambda$0(PluginCertificateManager this$0, X509Certificate $certificate) {
        if (this$0.myCertificates.contains($certificate)) {
            this$0.myCertificates.remove($certificate);
            this$0.myTreeBuilder.removeCertificate($certificate);
        }
    }

    private static final void init$lambda$0(PluginCertificateManager this$0, TreeSelectionEvent it) {
        X509Certificate certificate = this$0.myTreeBuilder.getFirstSelectedCertificate(true);
        if (certificate != null) {
            this$0.showCard(this$0.getCardName(certificate));
        }
    }

    private static final Unit chooseFileAndAdd$lambda$0(PluginCertificateManager this$0, VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        X509Certificate certificate = CertificateUtil.loadX509Certificate((String)path);
        if (certificate == null) {
            Messages.showErrorDialog((Component)((Component)this$0.myRootPanel), (String)IdeBundle.message((String)"settings.certificate.malformed.x509.server.certificate", (Object[])new Object[0]), (String)IdeBundle.message((String)"settings.certificate.not.imported", (Object[])new Object[0]));
        } else if (this$0.myCertificates.contains(certificate)) {
            Messages.showWarningDialog((Component)((Component)this$0.myRootPanel), (String)IdeBundle.message((String)"settings.certificate.certificate.already.exists", (Object[])new Object[0]), (String)IdeBundle.message((String)"settings.certificate.not.imported", (Object[])new Object[0]));
        } else {
            this$0.addCertificate(certificate);
        }
        return Unit.INSTANCE;
    }

    private static final void chooseFileAndAdd$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

