/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.PluginSearchTextField;
import com.intellij.ide.plugins.newui.SearchPopup;
import com.intellij.ide.plugins.newui.SearchPopupCallback;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class SearchPopupController {
    protected final PluginSearchTextField myTextField;
    @ApiStatus.Internal
    protected SearchPopup myPopup;
    private final JBPopupListener mySearchPopupListener;

    public SearchPopupController(@NotNull PluginSearchTextField searchTextField) {
        if (searchTextField == null) {
            SearchPopupController.$$$reportNull$$$0(0);
        }
        this.mySearchPopupListener = new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SearchPopupController.this.myPopup = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/newui/SearchPopupController$1", "onClosed"));
            }
        };
        this.myTextField = searchTextField;
    }

    public void handleShowPopup() {
        String query = this.myTextField.getText();
        int length = query.length();
        int position = this.getCaretPosition();
        if (position < length) {
            if (query.charAt(position) != ' ') {
                this.handleShowPopupForQuery();
                return;
            }
        } else if (query.charAt(position - 1) == ' ') {
            this.handleShowPopupForQuery();
            return;
        }
        Ref startPosition = new Ref();
        Pair<String, String> attribute = SearchPopupController.parseAttributeInQuery(query, position, (Ref<? super Integer>)startPosition);
        if (attribute.second == null) {
            this.showAttributesPopup((String)attribute.first, (Integer)startPosition.get());
        } else {
            this.handleShowAttributeValuesPopup((String)attribute.first, (String)attribute.second, (Integer)startPosition.get());
        }
    }

    private int getCaretPosition() {
        return this.myTextField.getTextEditor().getCaretPosition();
    }

    @NotNull
    private static Pair<String, String> parseAttributeInQuery(@NotNull String query, int end, @NotNull Ref<? super Integer> startPosition) {
        int index;
        if (query == null) {
            SearchPopupController.$$$reportNull$$$0(1);
        }
        if (startPosition == null) {
            SearchPopupController.$$$reportNull$$$0(2);
        }
        String value = null;
        for (index = end - 1; index >= 0; --index) {
            char ch = query.charAt(index);
            if (ch == ':') {
                value = query.substring(index + 1, end);
                startPosition.set((Object)(index + 1));
                end = index + 1;
                --index;
                while (index >= 0 && query.charAt(index) != ' ') {
                    --index;
                }
                break;
            }
            if (ch == ' ') break;
        }
        if (startPosition.isNull()) {
            startPosition.set((Object)(index + 1));
        }
        Pair pair = Pair.create((Object)query.substring(index + 1, end), value);
        if (pair == null) {
            SearchPopupController.$$$reportNull$$$0(3);
        }
        return pair;
    }

    public void showAttributesPopup(@Nullable String namePrefix, int caretPosition) {
        boolean async2;
        CollectionListModel model2 = new CollectionListModel(this.getAttributes());
        if (this.noPrefixSearchValues((CollectionListModel<Object>)model2, namePrefix)) {
            return;
        }
        boolean bl = async2 = this.myPopup != null;
        if (this.updatePopupOrCreate(SearchPopup.Type.AttributeName, (CollectionListModel<Object>)model2, namePrefix, caretPosition)) {
            return;
        }
        this.createAndShow(async2, new SearchPopupCallback(namePrefix){

            public void consume(String value) {
                SearchPopupController.this.appendSearchText(value, this.prefix);
                SearchPopupController.this.handleShowAttributeValuesPopup(value, null, SearchPopupController.this.getCaretPosition());
            }
        });
    }

    private void handleShowAttributeValuesPopup(@NotNull String name2, @Nullable String valuePrefix, int caretPosition) {
        Collection<String> values;
        if (name2 == null) {
            SearchPopupController.$$$reportNull$$$0(4);
        }
        if (ContainerUtil.isEmpty(values = this.getValues(name2))) {
            this.handleShowPopupForQuery();
            return;
        }
        CollectionListModel model2 = new CollectionListModel(values);
        if (this.noPrefixSearchValues((CollectionListModel<Object>)model2, valuePrefix)) {
            return;
        }
        if (this.updatePopupOrCreate(SearchPopup.Type.AttributeValue, (CollectionListModel<Object>)model2, valuePrefix, caretPosition)) {
            return;
        }
        this.createAndShow(true, new SearchPopupCallback(valuePrefix){

            public void consume(String value) {
                SearchPopupController.this.appendSearchText(SearchQueryParser.wrapAttribute(value), this.prefix);
                SearchPopupController.this.handleShowPopupForQuery();
            }
        });
    }

    private boolean updatePopupOrCreate(@NotNull SearchPopup.Type type, @NotNull CollectionListModel<Object> model2, @Nullable String prefix, int caretPosition) {
        if (type == null) {
            SearchPopupController.$$$reportNull$$$0(5);
        }
        if (model2 == null) {
            SearchPopupController.$$$reportNull$$$0(6);
        }
        if (this.myPopup != null && this.myPopup.type == type && this.myPopup.isValid()) {
            this.myPopup.model.replaceAll(model2.getItems());
            this.myPopup.callback.prefix = prefix;
            this.myPopup.caretPosition = caretPosition;
            this.myPopup.update();
            return true;
        }
        this.createPopup(type, model2, caretPosition);
        return false;
    }

    @ApiStatus.Internal
    protected void createPopup(@NotNull SearchPopup.Type type, @NotNull CollectionListModel<Object> model2, int caretPosition) {
        if (type == null) {
            SearchPopupController.$$$reportNull$$$0(7);
        }
        if (model2 == null) {
            SearchPopupController.$$$reportNull$$$0(8);
        }
        this.hidePopup();
        this.myPopup = new SearchPopup(this.myTextField, this.mySearchPopupListener, type, model2, caretPosition);
    }

    private void createAndShow(boolean async2, @NotNull SearchPopupCallback callback) {
        if (callback == null) {
            SearchPopupController.$$$reportNull$$$0(9);
        }
        ColoredListCellRenderer renderer2 = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.append((String)value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/plugins/newui/SearchPopupController$4", "customizeCellRenderer"));
            }
        };
        this.myPopup.createAndShow(callback, renderer2, async2);
    }

    private boolean noPrefixSearchValues(@NotNull CollectionListModel<Object> model2, @Nullable String prefix) {
        if (model2 == null) {
            SearchPopupController.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmptyOrSpaces((String)prefix)) {
            return false;
        }
        int index = 0;
        while (index < model2.getSize()) {
            String attribute = (String)model2.getElementAt(index);
            if (attribute.equals(prefix)) {
                this.hidePopup();
                return true;
            }
            if (StringUtil.startsWithIgnoreCase((String)attribute, (String)prefix)) {
                ++index;
                continue;
            }
            model2.remove(index);
        }
        if (model2.isEmpty()) {
            this.handleShowPopupForQuery();
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract List<String> getAttributes();

    @Nullable
    protected abstract Collection<String> getValues(@NotNull String var1);

    private void handleShowPopupForQuery() {
        this.hidePopup();
        this.showPopupForQuery();
    }

    protected abstract void showPopupForQuery();

    public boolean isPopupShow() {
        return this.myPopup != null && this.myPopup.isValid();
    }

    public void hidePopup() {
        if (this.myPopup != null) {
            this.myPopup.hide();
            this.myPopup = null;
        }
    }

    private void appendSearchText(@NotNull String value, @Nullable String prefix) {
        if (value == null) {
            SearchPopupController.$$$reportNull$$$0(11);
        }
        String text2 = this.myTextField.getText();
        String suffix = "";
        int position = this.getCaretPosition();
        if (this.myPopup != null) {
            this.myPopup.skipCaretEvent = true;
        }
        if (position < text2.length()) {
            suffix = text2.substring(position);
            text2 = text2.substring(0, position);
        }
        if (prefix == null) {
            this.myTextField.setTextIgnoreEvents(text2 + value + suffix);
        } else if (StringUtil.startsWithIgnoreCase((String)value, (String)prefix) || StringUtil.startsWithIgnoreCase((String)value, (String)("\"" + prefix))) {
            this.myTextField.setTextIgnoreEvents(text2.substring(0, text2.length() - prefix.length()) + value + suffix);
        } else {
            this.myTextField.setTextIgnoreEvents(text2 + value + suffix);
        }
        this.myTextField.getTextEditor().setCaretPosition(this.myTextField.getText().length() - suffix.length());
    }

    public boolean handleEnter(@NotNull KeyEvent event) {
        if (event == null) {
            SearchPopupController.$$$reportNull$$$0(12);
        }
        if (this.myPopup != null && this.myPopup.list != null && this.myPopup.list.getSelectedIndex() != -1) {
            this.myPopup.list.dispatchEvent(event);
            return true;
        }
        this.handleEnter();
        return false;
    }

    protected void handleEnter() {
    }

    public boolean handleUpDown(@NotNull KeyEvent event) {
        if (event == null) {
            SearchPopupController.$$$reportNull$$$0(13);
        }
        if (this.myPopup != null && this.myPopup.list != null) {
            if (event.getKeyCode() == 40 && this.myPopup.list.getSelectedIndex() == -1) {
                this.myPopup.list.setSelectedIndex(0);
                this.handlePopupListFirstSelection();
            } else {
                this.myPopup.list.dispatchEvent(event);
            }
        }
        return false;
    }

    protected void handlePopupListFirstSelection() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTextField";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPosition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/SearchPopupController";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/SearchPopupController";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAttributeInQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseAttributeInQuery";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleShowAttributeValuesPopup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updatePopupOrCreate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAndShow";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "noPrefixSearchValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendSearchText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleEnter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleUpDown";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

