/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.InProductNotificationDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.JBColor;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.WindowRoundedCornersManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ImageLoader;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u0005H\u0004J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000eH\u0014J\b\u0010\u0011\u001a\u00020\u000eH\u0014J\b\u0010\u0012\u001a\u00020\u000eH$J\b\u0010\u0013\u001a\u00020\tH\u0004J\r\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0015H$J\r\u0010\u0016\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0015H$J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/ui/LicenseExpirationDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "imagePath", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "initDialog", "", "title", "createContentPaneBorder", "Ljavax/swing/border/Border;", "createCenterPanel", "Ljavax/swing/JComponent;", "configureHeader", "header", "createAndConfigurePanel", "createPanel", "updateOKActionText", "getOKActionText", "Lorg/jetbrains/annotations/Nls;", "getCancelActionText", "loadImage", "Ljava/awt/Image;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLicenseExpirationDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseExpirationDialog.kt\ncom/intellij/ide/ui/LicenseExpirationDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,178:1\n1915#2,2:179\n1#3:181\n13#4:182\n*S KotlinDebug\n*F\n+ 1 LicenseExpirationDialog.kt\ncom/intellij/ide/ui/LicenseExpirationDialog\n*L\n51#1:179,2\n174#1:182\n*E\n"})
public abstract class LicenseExpirationDialog
extends DialogWrapper {
    @NotNull
    private final String imagePath;

    public LicenseExpirationDialog(@Nullable Project project2, @NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        super(project2, null, false, DialogWrapper.IdeModalityType.IDE, false);
        this.imagePath = imagePath;
    }

    protected final void initDialog(@NlsContexts.DialogTitle @NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this.setTitle(title2);
        this.setInitialLocationCallback(() -> LicenseExpirationDialog.initDialog$lambda$0(this));
        this.setUndecorated(true);
        this.init();
        Container container = this.getContentPane();
        Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent pane2 = (JComponent)container;
        pane2.setOpaque(true);
        pane2.setBackground((Color)JBColor.white);
        JBIterable jBIterable = UIUtil.uiChildren((Component)pane2);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"uiChildren(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            ((JComponent)it).setOpaque(false);
        }
        this.getRootPane().setWindowDecorationStyle(0);
        this.getRootPane().setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
        Disposable disposable = this.myDisposable;
        new MouseDragHelper<JComponent>(pane2, this, disposable){
            private Point myLocation;
            final /* synthetic */ LicenseExpirationDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $pane);
            }

            public final Point getMyLocation() {
                return this.myLocation;
            }

            public final void setMyLocation(Point point) {
                this.myLocation = point;
            }

            protected boolean canStartDragging(JComponent dragComponent, Point dragComponentPoint) {
                Intrinsics.checkNotNullParameter((Object)dragComponent, (String)"dragComponent");
                Intrinsics.checkNotNullParameter((Object)dragComponentPoint, (String)"dragComponentPoint");
                Component target = dragComponent.findComponentAt(dragComponentPoint);
                return target == null || Intrinsics.areEqual((Object)target, (Object)dragComponent) || target instanceof JPanel || target instanceof JBLabel;
            }

            protected void processDrag(MouseEvent event, Point dragToScreenPoint, Point startScreenPoint) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
                Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
                if (this.myLocation == null) {
                    this.myLocation = this.this$0.getWindow().getLocation();
                }
                Window window = this.this$0.getWindow();
                Point point = this.myLocation;
                Intrinsics.checkNotNull((Object)point);
                int n = point.x + dragToScreenPoint.x - startScreenPoint.x;
                Point point2 = this.myLocation;
                Intrinsics.checkNotNull((Object)point2);
                window.setLocation(new Point(n, point2.y + dragToScreenPoint.y - startScreenPoint.y));
            }

            protected void processDragCancel() {
                this.myLocation = null;
            }

            protected void processDragFinish(MouseEvent event, boolean willDragOutStart) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.myLocation = null;
            }

            protected void processDragOutFinish(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.myLocation = null;
            }

            protected void processDragOutCancel() {
                this.myLocation = null;
            }

            protected void processDragOut(MouseEvent event, Point dragToScreenPoint, Point startScreenPoint, boolean justStarted) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
                Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
                super.processDragOut(event, dragToScreenPoint, startScreenPoint, justStarted);
                this.myLocation = null;
            }
        }.start();
        WindowRoundedCornersManager.configure(this);
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return (Border)JBUI.Borders.empty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        void it;
        JButton jButton;
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setOpaque(false);
        panel2.add(this.createAndConfigurePanel());
        JPanel buttons = new JPanel((LayoutManager)new HorizontalLayout(17, 0));
        buttons.setOpaque(false);
        buttons.setBorder((Border)JBUI.Borders.empty((int)0, (int)32, (int)16, (int)32));
        this.updateOKActionText();
        JButton jButton2 = jButton = this.createJButtonForAction(this.myOKAction);
        JPanel jPanel = buttons;
        boolean bl = false;
        it.setOpaque(false);
        jPanel.add(jButton);
        LinkListener listener2 = (arg_0, arg_1) -> LicenseExpirationDialog.createCenterPanel$lambda$1(this, arg_0, arg_1);
        buttons.add((Component)new LinkLabel(this.getCancelActionText(), null, listener2));
        panel2.add((Component)buttons, "South");
        JBLabel label2 = new JBLabel(this){
            private final Image image;
            private Image scaleImage;
            private int imageWidth;
            private int imageHeight;
            {
                Image image2 = LicenseExpirationDialog.access$loadImage($receiver);
                Intrinsics.checkNotNull((Object)image2);
                this.image = image2;
            }

            public final Image getImage() {
                return this.image;
            }

            public final Image getScaleImage() {
                return this.scaleImage;
            }

            public final void setScaleImage(Image image2) {
                this.scaleImage = image2;
            }

            public final int getImageWidth() {
                return this.imageWidth;
            }

            public final void setImageWidth(int n) {
                this.imageWidth = n;
            }

            public final int getImageHeight() {
                return this.imageHeight;
            }

            public final void setImageHeight(int n) {
                this.imageHeight = n;
            }

            protected void paintComponent(Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                int newWidth = this.getWidth();
                int newHeight = this.getHeight();
                if (this.scaleImage == null || this.imageWidth != newWidth || this.imageHeight != newHeight) {
                    this.imageWidth = newWidth;
                    this.imageHeight = newHeight;
                    this.scaleImage = ImageLoader.scaleImage((Image)this.image, (int)newWidth, (int)newHeight);
                }
                Image image2 = this.scaleImage;
                Intrinsics.checkNotNull((Object)image2);
                StartupUiUtil.drawImage((Graphics)g, (Image)image2, (Rectangle)new Rectangle(0, 0, newWidth, newHeight), (ImageObserver)((ImageObserver)((Object)this)));
            }
        };
        this.configureHeader((JComponent)label2);
        int contentWidth = panel2.getPreferredSize().width;
        Dimension contentSize = new Dimension(contentWidth, (int)((double)contentWidth / 1.8));
        label2.setOpaque(false);
        label2.setPreferredSize(contentSize);
        panel2.add((Component)label2, "North");
        return panel2;
    }

    protected void configureHeader(@NotNull JComponent header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
    }

    @NotNull
    protected JComponent createAndConfigurePanel() {
        JComponent panel2 = this.createPanel();
        panel2.setOpaque(false);
        panel2.setBorder((Border)JBUI.Borders.empty((int)28, (int)32, (int)16, (int)32));
        return panel2;
    }

    @NotNull
    protected abstract JComponent createPanel();

    protected final void updateOKActionText() {
        this.myOKAction.putValue("Name", this.getOKActionText());
    }

    @NotNull
    protected abstract String getOKActionText();

    @NotNull
    protected abstract String getCancelActionText();

    private final Image loadImage() {
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(this.imagePath);
            Intrinsics.checkNotNull((Object)inputStream);
            return ImageLoader.loadFromStream((InputStream)inputStream);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(InProductNotificationDialog.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Image " + this.imagePath + " is not loaded: " + e);
            return null;
        }
    }

    private static final Point initDialog$lambda$0(LicenseExpirationDialog this$0) {
        JRootPane rootPane;
        JRootPane jRootPane = SwingUtilities.getRootPane(this$0.getWindow().getParent());
        if (jRootPane == null) {
            jRootPane = SwingUtilities.getRootPane(this$0.getWindow().getOwner());
        }
        if ((rootPane = jRootPane) == null || !rootPane.isShowing()) {
            return null;
        }
        Point location = rootPane.getLocationOnScreen();
        return new Point(location.x + (rootPane.getWidth() - this$0.getWindow().getWidth()) / 2, (int)((double)location.y + (double)rootPane.getHeight() * 0.25));
    }

    private static final void createCenterPanel$lambda$1(LicenseExpirationDialog this$0, LinkLabel linkLabel, Object object) {
        this$0.doCancelAction();
    }

    public static final /* synthetic */ Image access$loadImage(LicenseExpirationDialog $this) {
        return $this.loadImage();
    }
}

