/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ScreenUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JDialog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0003\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\n\u001a\u00020\b*\u00020\u0003\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\f\u001a\u00020\b*\u00020\u0003\u001a\f\u0010\u0013\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0002\"(\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0002\u0010\u0004\"\u0004\b\u0005\u0010\u0006\",\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\u00032\b\u0010\u0000\u001a\u0004\u0018\u00010\r8G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\"!\u0010\u0018\u001a\u0015\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\r0\r0\u0019\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"!\u0010\u001c\u001a\u0015\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\r0\r0\u0019\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"value", "", "isMaximizeButtonShown", "Ljavax/swing/JDialog;", "(Ljavax/swing/JDialog;)Z", "setMaximizeButtonShown", "(Ljavax/swing/JDialog;Z)V", "toggleMaximized", "", "canBeMaximized", "maximize", "canBeNormalized", "normalize", "Ljava/awt/Rectangle;", "normalBounds", "getNormalBounds", "(Ljavax/swing/JDialog;)Ljava/awt/Rectangle;", "setNormalBounds", "(Ljavax/swing/JDialog;Ljava/awt/Rectangle;)V", "commonResizingConditionsAreMet", "almostEquals", "r1", "r2", "almostHaveTheSameSize", "NORMAL_BOUNDS", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "MAXIMIZABLE", "intellij.platform.ide.impl"})
public final class MaximizeDialogKt {
    @NotNull
    private static final Key<Rectangle> NORMAL_BOUNDS;
    @NotNull
    private static final Key<Rectangle> MAXIMIZABLE;

    public static final boolean isMaximizeButtonShown(@NotNull JDialog $this$isMaximizeButtonShown) {
        Intrinsics.checkNotNullParameter((Object)$this$isMaximizeButtonShown, (String)"<this>");
        return ClientProperty.isTrue((Component)$this$isMaximizeButtonShown, MAXIMIZABLE);
    }

    public static final void setMaximizeButtonShown(@NotNull JDialog $this$isMaximizeButtonShown, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$isMaximizeButtonShown, (String)"<this>");
        ClientProperty.put((Window)$this$isMaximizeButtonShown, MAXIMIZABLE, (Object)(value ? Boolean.valueOf(true) : null));
    }

    public static final void toggleMaximized(@NotNull JDialog $this$toggleMaximized) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleMaximized, (String)"<this>");
        if (MaximizeDialogKt.canBeMaximized($this$toggleMaximized)) {
            MaximizeDialogKt.maximize($this$toggleMaximized);
        } else if (MaximizeDialogKt.canBeNormalized($this$toggleMaximized)) {
            MaximizeDialogKt.normalize($this$toggleMaximized);
        }
    }

    public static final boolean canBeMaximized(@NotNull JDialog $this$canBeMaximized) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeMaximized, (String)"<this>");
        if (!MaximizeDialogKt.commonResizingConditionsAreMet($this$canBeMaximized)) {
            return false;
        }
        Rectangle rectangle = ScreenUtil.getScreenRectangle((Component)$this$canBeMaximized);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getScreenRectangle(...)");
        Rectangle rectangle2 = $this$canBeMaximized.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2, (String)"getBounds(...)");
        return !MaximizeDialogKt.almostEquals(rectangle, rectangle2);
    }

    public static final void maximize(@NotNull JDialog $this$maximize) {
        Intrinsics.checkNotNullParameter((Object)$this$maximize, (String)"<this>");
        if (!MaximizeDialogKt.canBeMaximized($this$maximize)) {
            return;
        }
        Rectangle rectangle = ScreenUtil.getScreenRectangle((Component)$this$maximize);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getScreenRectangle(...)");
        Rectangle screenRectangle = rectangle;
        Rectangle bounds = $this$maximize.getBounds();
        Intrinsics.checkNotNull((Object)bounds);
        if (!MaximizeDialogKt.almostHaveTheSameSize(bounds, screenRectangle)) {
            MaximizeDialogKt.setNormalBounds($this$maximize, bounds);
        }
        $this$maximize.setBounds(screenRectangle);
    }

    public static final boolean canBeNormalized(@NotNull JDialog $this$canBeNormalized) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeNormalized, (String)"<this>");
        if (!MaximizeDialogKt.commonResizingConditionsAreMet($this$canBeNormalized)) {
            return false;
        }
        Rectangle rectangle = ScreenUtil.getScreenRectangle((Component)$this$canBeNormalized);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getScreenRectangle(...)");
        Rectangle screenRectangle = rectangle;
        Rectangle rectangle2 = $this$canBeNormalized.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2, (String)"getBounds(...)");
        return MaximizeDialogKt.almostEquals(rectangle2, screenRectangle) && MaximizeDialogKt.getNormalBounds($this$canBeNormalized) != null;
    }

    public static final void normalize(@NotNull JDialog $this$normalize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        if (!MaximizeDialogKt.canBeNormalized($this$normalize)) {
            return;
        }
        Rectangle normalBounds = MaximizeDialogKt.getNormalBounds($this$normalize);
        if (normalBounds != null) {
            ScreenUtil.fitToScreen((Rectangle)normalBounds);
            $this$normalize.setBounds(normalBounds);
            MaximizeDialogKt.setNormalBounds($this$normalize, null);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static final Rectangle getNormalBounds(@NotNull JDialog $this$normalBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$normalBounds, (String)"<this>");
        return (Rectangle)ClientProperty.get((Component)$this$normalBounds, NORMAL_BOUNDS);
    }

    @ApiStatus.Internal
    public static final void setNormalBounds(@NotNull JDialog $this$normalBounds, @Nullable Rectangle value) {
        Intrinsics.checkNotNullParameter((Object)$this$normalBounds, (String)"<this>");
        ClientProperty.put((Window)$this$normalBounds, NORMAL_BOUNDS, (Object)value);
    }

    private static final boolean commonResizingConditionsAreMet(JDialog $this$commonResizingConditionsAreMet) {
        return $this$commonResizingConditionsAreMet.isShowing() && $this$commonResizingConditionsAreMet.isResizable() && $this$commonResizingConditionsAreMet.getRootPane() != null;
    }

    private static final boolean almostEquals(Rectangle r1, Rectangle r2) {
        int tolerance = Registry.Companion.intValue("ide.dialog.maximize.tolerance", 10);
        return Math.abs(r1.x - r2.x) <= tolerance && Math.abs(r1.y - r2.y) <= tolerance && Math.abs(r1.width - r2.width) <= tolerance && Math.abs(r1.height - r2.height) <= tolerance;
    }

    private static final boolean almostHaveTheSameSize(Rectangle r1, Rectangle r2) {
        int tolerance = Registry.Companion.intValue("ide.dialog.maximize.tolerance", 10);
        return Math.abs(r1.width - r2.width) <= tolerance && Math.abs(r1.height - r2.height) <= tolerance;
    }

    static {
        Key key = Key.create((String)"NORMAL_BOUNDS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        NORMAL_BOUNDS = key;
        Key key2 = Key.create((String)"MAXIMIZABLE");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        MAXIMIZABLE = key2;
    }
}

