/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class DarculaButtonPainter
implements Border,
UIResource {
    private static final int myOffset = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        InternalUICustomization service = InternalUICustomization.getInstance();
        Graphics2D g2 = (Graphics2D)(service != null ? service.transformButtonGraphics(g.create()) : g.create());
        try {
            boolean paintComboFocus;
            Object avoidExtendingObject = ClientProperty.get((Component)c, DarculaButtonUI.AVOID_EXTENDING_BORDER_GRAPHICS);
            g2.setRenderingHint(IdeBackgroundUtil.NO_BACKGROUND_HINT, avoidExtendingObject != null && avoidExtendingObject.equals(Boolean.TRUE));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            boolean isSmallComboButton = DarculaButtonUI.isSmallVariant(c);
            boolean isDefaultButton = DarculaButtonUI.isDefaultButton((JComponent)c);
            boolean isGotItButton = DarculaButtonUI.isGotItButton(c);
            int diam = DarculaButtonUI.HELP_BUTTON_DIAMETER.get();
            float lw = DarculaUIUtil.LW.getFloat();
            float bw = isSmallComboButton || isGotItButton ? 0.0f : DarculaUIUtil.BW.getFloat();
            float arc = DarculaButtonUI.isTag(c) ? (float)height - bw * 2.0f - lw * 2.0f : DarculaUIUtil.BUTTON_ARC.getFloat();
            Rectangle r = new Rectangle(x, y, width, height);
            boolean bl = paintComboFocus = isSmallComboButton && c.isFocusable() && c.hasFocus();
            if (paintComboFocus) {
                g2.setColor(JBUI.CurrentTheme.Focus.focusColor());
                Path2D.Float border = new Path2D.Float(0);
                border.append(new RoundRectangle2D.Float(r.x, r.y, r.width, r.height, arc + lw, arc + lw), false);
                border.append(new RoundRectangle2D.Float((float)r.x + lw * 2.0f, (float)r.y + lw * 2.0f, (float)r.width - lw * 4.0f, (float)r.height - lw * 4.0f, arc, arc), false);
                g2.fill(border);
            }
            if (!isGotItButton) {
                JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
            }
            g2.translate(r.x, r.y);
            boolean newUiBorderPainted = false;
            if (!isSmallComboButton && !isGotItButton) {
                if (c.hasFocus()) {
                    if (UIUtil.isHelpButton((Component)c)) {
                        DarculaUIUtil.paintFocusOval(g2, (float)(r.width - diam) / 2.0f, (float)(r.height - diam) / 2.0f, diam, diam);
                    } else if (DarculaButtonUI.isTag(c)) {
                        DarculaUIUtil.paintTag(g2, r.width, r.height, c.hasFocus(), DarculaUIUtil.computeOutlineFor(c));
                    } else {
                        newUiBorderPainted = this.paintNormalFocusBorder((Graphics2D)g, (JComponent)c, new Rectangle(x, y, width, height));
                        if (!newUiBorderPainted) {
                            DarculaUIUtil.Outline type = isDefaultButton ? DarculaUIUtil.Outline.defaultButton : DarculaUIUtil.Outline.focus;
                            DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, arc, true, true, type);
                        }
                    }
                } else if (DarculaButtonUI.isTag(c)) {
                    DarculaUIUtil.paintTag(g2, r.width, r.height, c.hasFocus(), DarculaUIUtil.computeOutlineFor(c));
                }
            }
            g2.setPaint(this.getBorderPaint(c));
            if (UIUtil.isHelpButton((Component)c)) {
                g2.draw(new Ellipse2D.Float((float)(r.width - diam) / 2.0f, (float)(r.height - diam) / 2.0f, diam, diam));
            } else if (!paintComboFocus && !newUiBorderPainted) {
                Path2D.Float border = new Path2D.Float(0);
                border.append(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc), false);
                if (!isGotItButton) {
                    arc = arc > lw ? arc - lw : 0.0f;
                }
                border.append(new RoundRectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f, arc, arc), false);
                g2.fill(border);
            }
        }
        finally {
            g2.dispose();
        }
    }

    public Paint getBorderPaint(Component button2) {
        return this.getBorderPaint(button2, button2.hasFocus());
    }

    @ApiStatus.Internal
    protected boolean paintNormalFocusBorder(@NotNull Graphics2D g, @NotNull JComponent c, @NotNull Rectangle r) {
        if (g == null) {
            DarculaButtonPainter.$$$reportNull$$$0(0);
        }
        if (c == null) {
            DarculaButtonPainter.$$$reportNull$$$0(1);
        }
        if (r == null) {
            DarculaButtonPainter.$$$reportNull$$$0(2);
        }
        return false;
    }

    Paint getBorderPaint(Component button2, boolean hasFocus) {
        AbstractButton b = (AbstractButton)button2;
        Color borderColor = (Color)b.getClientProperty("JButton.borderColor");
        Rectangle r = new Rectangle(b.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)b.getInsets());
        boolean defButton = DarculaButtonUI.isDefaultButton(b);
        if (button2.isEnabled()) {
            if (borderColor != null) {
                return borderColor;
            }
            if (DarculaButtonUI.isGotItButton(button2)) {
                return new GradientPaint(0.0f, 0.0f, DarculaButtonPainter.getGotItBorderColorStart(b), 0.0f, r.height, DarculaButtonPainter.getGotItBorderColorEnd(b));
            }
            if (hasFocus) {
                return JBUI.CurrentTheme.Button.focusBorderColor((boolean)defButton);
            }
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)defButton), 0.0f, r.height, JBUI.CurrentTheme.Button.buttonOutlineColorEnd((boolean)defButton));
            InternalUICustomization instance = InternalUICustomization.getInstance();
            if (instance == null) {
                return paint;
            }
            return instance.getAiComponentMarker().getCustomButtonBorderPaint(b, r, paint);
        }
        return JBUI.CurrentTheme.Button.disabledOutlineColor();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (DarculaButtonUI.isGotItButton(c)) {
            return JBInsets.emptyInsets().asUIResource();
        }
        Insets customInsets = DarculaButtonUI.getCustomButtonInsets(c);
        if (customInsets != null) {
            return customInsets;
        }
        return DarculaButtonUI.isSmallVariant(c) ? JBInsets.create((int)1, (int)2).asUIResource() : new JBInsets(3).asUIResource();
    }

    protected int getOffset() {
        return 4;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    private static Color getGotItBorderColorStart(JComponent c) {
        if (DarculaButtonUI.isDefaultButton(c)) {
            return JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)true);
        }
        if (DarculaButtonUI.isContrastGotIt(c)) {
            return JBUI.CurrentTheme.GotItTooltip.buttonBackgroundContrast();
        }
        if (DarculaButtonUI.isContrastGotItOnlyButton(c)) {
            return JBUI.CurrentTheme.GotItTooltip.buttonBackgroundContrastOnlyButton();
        }
        return JBColor.namedColor((String)"GotItTooltip.Button.startBorderColor", (Color)JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false));
    }

    private static Color getGotItBorderColorEnd(JComponent c) {
        if (DarculaButtonUI.isDefaultButton(c)) {
            return JBUI.CurrentTheme.Button.buttonOutlineColorEnd((boolean)true);
        }
        if (DarculaButtonUI.isContrastGotIt(c)) {
            return JBUI.CurrentTheme.GotItTooltip.buttonBackgroundContrast();
        }
        if (DarculaButtonUI.isContrastGotItOnlyButton(c)) {
            return JBUI.CurrentTheme.GotItTooltip.buttonBackgroundContrastOnlyButton();
        }
        return JBColor.namedColor((String)"GotItTooltip.Button.endBorderColor", (Color)JBUI.CurrentTheme.Button.buttonOutlineColorEnd((boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "g";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "c";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "r";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/ui/laf/darcula/ui/DarculaButtonPainter";
        objectArray[2] = "paintNormalFocusBorder";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

