/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.wizard;

import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.AbstractNewProjectWizardBuilder;
import com.intellij.ide.wizard.NewProjectWizardStep;
import com.intellij.ide.wizard.UIWizardUtil$setMinimumWidthForAllRowLabels$;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.UIBundle;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.GridLayout;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u0007*\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\u000b\u001a3\u0010\u0010\u001a\u00020\u0006*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u000b\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0087\b\u00f8\u0001\u0000\u001a(\u0010\u0018\u001a\u00020\u0006*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u001aH\u0007\u001a\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"projectOrDefault", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "getProjectOrDefault", "(Lcom/intellij/ide/util/projectWizard/WizardContext;)Lcom/intellij/openapi/project/Project;", "setMinimumWidthForAllRowLabels", "", "Lcom/intellij/openapi/ui/DialogPanel;", "width", "", "isRowLabel", "", "label", "Ljavax/swing/JLabel;", "withVisualPadding", "topField", "setupProjectSafe", "Lcom/intellij/ide/wizard/NewProjectWizardStep;", "project", "errorMessage", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "execution", "Lkotlin/Function0;", "runAfterOpened", "callback", "Lkotlin/Function1;", "setupProjectFromBuilder", "Lcom/intellij/openapi/module/Module;", "builder", "Lcom/intellij/ide/util/projectWizard/ProjectBuilder;", "intellij.platform.ide.impl"})
@JvmName(name="UIWizardUtil")
@SourceDebugExtension(value={"SMAP\nUIWizardUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UIWizardUtil.kt\ncom/intellij/ide/wizard/UIWizardUtil\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n479#2:119\n1342#2,2:120\n13#3:122\n1#4:123\n*S KotlinDebug\n*F\n+ 1 UIWizardUtil.kt\ncom/intellij/ide/wizard/UIWizardUtil\n*L\n42#1:119\n44#1:120,2\n78#1:122\n*E\n"})
public final class UIWizardUtil {
    @ApiStatus.Internal
    @NotNull
    public static final Project getProjectOrDefault(@NotNull WizardContext $this$projectOrDefault) {
        Intrinsics.checkNotNullParameter((Object)$this$projectOrDefault, (String)"<this>");
        Project project2 = $this$projectOrDefault.getProject();
        if (project2 == null) {
            Project project3 = ProjectManager.getInstance().getDefaultProject();
            project2 = project3;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getDefaultProject(...)");
        }
        return project2;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public static final void setMinimumWidthForAllRowLabels(@NotNull DialogPanel $this$setMinimumWidthForAllRowLabels, int width) {
        Intrinsics.checkNotNullParameter((Object)$this$setMinimumWidthForAllRowLabels, (String)"<this>");
        JBTreeTraverser jBTreeTraverser = UIUtil.uiTraverser((Component)((Component)$this$setMinimumWidthForAllRowLabels));
        Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"uiTraverser(...)");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)((Iterable)jBTreeTraverser));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)setMinimumWidthForAllRowLabels$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)sequence, UIWizardUtil::setMinimumWidthForAllRowLabels$lambda$0);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JLabel it = (JLabel)element$iv;
            boolean bl = false;
            UiSizeUtilKt.setMinimumWidth((JComponent)it, (int)width);
        }
    }

    private static final boolean isRowLabel(JLabel label2) {
        GridLayout layout2;
        Container container = label2.getParent();
        DialogPanel dialogPanel = container instanceof DialogPanel ? (DialogPanel)container : null;
        LayoutManager layoutManager = dialogPanel != null ? dialogPanel.getLayout() : null;
        GridLayout gridLayout = layout2 = layoutManager instanceof GridLayout ? (GridLayout)layoutManager : null;
        if (layout2 == null) {
            return false;
        }
        Constraints constraints = layout2.getConstraints((JComponent)label2);
        return Intrinsics.areEqual((Object)label2.getClientProperty(DslComponentProperty.ROW_LABEL), (Object)true) && constraints != null && constraints.getGaps().getLeft() == 0;
    }

    @NotNull
    public static final DialogPanel withVisualPadding(@NotNull DialogPanel $this$withVisualPadding, boolean topField) {
        Intrinsics.checkNotNullParameter((Object)$this$withVisualPadding, (String)"<this>");
        int top = topField ? 20 : 15;
        $this$withVisualPadding.setBorder(IdeBorderFactory.createEmptyBorder((Insets)((Insets)new JBInsets(top, 20, 20, 20))));
        return $this$withVisualPadding;
    }

    public static /* synthetic */ DialogPanel withVisualPadding$default(DialogPanel dialogPanel, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return UIWizardUtil.withVisualPadding(dialogPanel, bl);
    }

    @ApiStatus.Experimental
    public static final void setupProjectSafe(@NotNull NewProjectWizardStep $this$setupProjectSafe, @NotNull Project project2, @NotNull String errorMessage, @NotNull Function0<Unit> execution) {
        Intrinsics.checkNotNullParameter((Object)$this$setupProjectSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter(execution, (String)"execution");
        boolean $i$f$setupProjectSafe = false;
        try {
            execution.invoke();
        }
        catch (CancellationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(NewProjectWizardStep.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(errorMessage, (Throwable)ex);
            ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(project2, errorMessage, ex, $this$setupProjectSafe){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $errorMessage;
                final /* synthetic */ Exception $ex;
                final /* synthetic */ NewProjectWizardStep $this_setupProjectSafe;
                {
                    this.$project = $project;
                    this.$errorMessage = $errorMessage;
                    this.$ex = $ex;
                    this.$this_setupProjectSafe = $receiver;
                }

                public final void invoke() {
                    Object[] objectArray = new Object[]{this.$this_setupProjectSafe.getContext().isCreatingNewProjectInt()};
                    Messages.showErrorDialog((Project)this.$project, (String)(this.$errorMessage + "\n" + this.$ex.getMessage()), (String)UIBundle.message((String)"error.project.wizard.new.project.title", (Object[])objectArray));
                }
            }), (int)1, null);
        }
    }

    @ApiStatus.Experimental
    public static final void runAfterOpened(@NotNull NewProjectWizardStep $this$runAfterOpened, @NotNull Project project2, @NotNull Function1<? super Project, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)$this$runAfterOpened, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        AbstractNewProjectWizardBuilder.Companion.addPostCommitAction($this$runAfterOpened, callback);
        StartupManager.getInstance((Project)project2).runAfterOpened(() -> UIWizardUtil.runAfterOpened$lambda$0(callback, project2));
    }

    @ApiStatus.Internal
    @ApiStatus.Obsolete
    @Nullable
    public static final Module setupProjectFromBuilder(@NotNull NewProjectWizardStep $this$setupProjectFromBuilder, @NotNull Project project2, @NotNull ProjectBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)$this$setupProjectFromBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Object object = CollectionsKt.firstOrNull(AbstractNewProjectWizardBuilder.Companion.commitByBuilder($this$setupProjectFromBuilder, builder, project2));
        Module it = (Module)object;
        boolean bl = false;
        AbstractNewProjectWizardBuilder.Companion.postCommitByBuilder($this$setupProjectFromBuilder, builder);
        return (Module)object;
    }

    private static final boolean setMinimumWidthForAllRowLabels$lambda$0(JLabel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UIWizardUtil.isRowLabel(it);
    }

    private static final void runAfterOpened$lambda$0(Function1 $callback, Project $project) {
        $callback.invoke((Object)$project);
    }
}

