/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.diagnostic.DefaultIdeaErrorLogger;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.VMOptions;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.PluginUtilImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.JulLogger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.diagnostic.UnhandledException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class IdeaLogger
extends JulLogger {
    public static String ourLastActionId = "";
    public static Exception ourErrorsOccurred;
    private static final int EXPIRE_FREQUENT_EXCEPTIONS_AFTER_MINUTES;
    private static final Supplier<String> ourApplicationInfoProvider;

    public static void dropFrequentExceptionsCaches() {
        MyCache.cache.invalidateAll();
        MyCache.cache.cleanUp();
    }

    private boolean isTooFrequentException(@Nullable Throwable t) {
        if (t == null || !IdeaLogger.isMutingFrequentExceptionsEnabled() || !LoadingState.COMPONENTS_LOADED.isOccurred() || this.isDebugEnabled() || this.isTraceEnabled()) {
            return false;
        }
        int hash = ThrowableInterner.computeAccurateTraceHashCode((Throwable)t);
        AtomicInteger counter = MyCache.getOrCreate(hash, t);
        int occurrences = counter.incrementAndGet();
        if (IdeaLogger.isFascinatingNumber(occurrences)) {
            this.warn("Suppressed a frequent exception logged for the " + occurrences + (occurrences == 2 ? "nd" : "th") + " time: " + IdeaLogger.shortenErrorMessage(t.getMessage()));
        }
        return occurrences != 1;
    }

    private static boolean isFascinatingNumber(int number) {
        if (number <= 1) {
            return false;
        }
        while (number % 10 == 0) {
            number /= 10;
        }
        return number == 1 || number == 2 || number == 5;
    }

    @NotNull
    private static String shortenErrorMessage(@Nullable String message) {
        if (message == null) {
            return "null";
        }
        int newLine = message.indexOf(10);
        message = message.substring(0, newLine != -1 ? newLine : message.length());
        String string = StringUtil.shortenTextWithEllipsis((String)message, (int)300, (int)0);
        if (string == null) {
            IdeaLogger.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static void reportToFus(@NotNull Throwable t) {
        PluginUtil pluginUtil;
        if (t == null) {
            IdeaLogger.$$$reportNull$$$0(1);
        }
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode() || app.isDisposed()) {
            return;
        }
        try {
            pluginUtil = PluginUtil.getInstance();
        }
        catch (CancellationException e) {
            return;
        }
        if (pluginUtil != null) {
            PluginId pluginId = pluginUtil.findPluginId(t);
            VMOptions.MemoryKind kind = DefaultIdeaErrorLogger.getOOMErrorKind(t);
            LifecycleUsageTriggerCollector.onError(pluginId, t, kind);
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static boolean isMutingFrequentExceptionsEnabled() {
        return EXPIRE_FREQUENT_EXCEPTIONS_AFTER_MINUTES > 0;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public IdeaLogger(@NotNull Logger logger) {
        if (logger == null) {
            IdeaLogger.$$$reportNull$$$0(2);
        }
        super(logger);
    }

    public void info(String message, @Nullable Throwable t) {
        if (this.isTooFrequentException(t)) {
            return;
        }
        super.info(message, IdeaLogger.ensureNotControlFlow((Throwable)t));
    }

    public void warn(String message, @Nullable Throwable t) {
        if (this.isTooFrequentException(t)) {
            return;
        }
        super.warn(message, IdeaLogger.ensureNotControlFlow((Throwable)t));
    }

    public void error(String message, @Nullable Throwable t, Attachment ... attachments) {
        if (attachments == null) {
            IdeaLogger.$$$reportNull$$$0(3);
        }
        if (this.isTooFrequentException(t)) {
            return;
        }
        Throwable errorWithAttachment = attachments.length == 0 ? t : (t != null ? new RuntimeExceptionWithAttachments(IdeaLogger.ensureNotControlFlow((Throwable)t), attachments) : new RuntimeExceptionWithAttachments(new Throwable(), attachments));
        this.error(message, errorWithAttachment);
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        UnhandledException uh;
        if (details == null) {
            IdeaLogger.$$$reportNull$$$0(4);
        }
        if (this.isTooFrequentException(t)) {
            return;
        }
        Object detailString = String.join((CharSequence)"\n", details);
        if (!((String)detailString).isEmpty()) {
            detailString = "\nDetails: " + (String)detailString;
        }
        if (ourErrorsOccurred == null) {
            String mess = "Logger errors occurred. See IDEA logs for details. " + (String)(message == null || message.isEmpty() ? "" : "Error message is '" + message + "'");
            ourErrorsOccurred = new Exception(mess + (String)detailString, t);
        }
        this.logSevere(message + (String)detailString, IdeaLogger.ensureNotControlFlow((Throwable)t));
        this.logErrorHeader(t);
        if (t != null && IdeaLogger.shouldRethrow((Throwable)t)) {
            ExceptionUtil.rethrow((Throwable)t);
        }
        if (t instanceof UnhandledException && IdeaLogger.shouldRethrow((Throwable)(uh = (UnhandledException)t).getCause())) {
            ExceptionUtil.rethrow((Throwable)uh.getCause());
        }
        if (t != null) {
            IdeaLogger.reportToFus(t);
        }
    }

    private void logErrorHeader(@Nullable Throwable t) {
        ApplicationEx application;
        IdeaPluginDescriptor plugin;
        this.logSevere(ourApplicationInfoProvider.get());
        Properties properties = System.getProperties();
        this.logSevere("JDK: " + properties.getProperty("java.version", "unknown") + "; VM: " + properties.getProperty("java.vm.name", "unknown") + "; Vendor: " + properties.getProperty("java.vendor", "unknown"));
        this.logSevere("OS: " + properties.getProperty("os.name", "unknown"));
        if (t != null && PluginManagerCore.arePluginsInitialized() && (plugin = PluginManagerCore.getPlugin((PluginId)PluginUtilImpl.doFindPluginId((Throwable)t))) != null && (!plugin.isBundled() || plugin.allowBundledUpdate())) {
            this.logSevere("Plugin to blame: " + plugin.getName() + " version: " + plugin.getVersion());
        }
        if ((application = ApplicationManagerEx.getApplicationEx()) != null && application.isComponentCreated() && !application.isDisposed()) {
            String currentCommandName;
            CommandProcessor commandProcessor;
            String lastPreformedActionId = ourLastActionId;
            if (lastPreformedActionId != null) {
                this.logSevere("Last Action: " + lastPreformedActionId);
            }
            if ((commandProcessor = (CommandProcessor)application.getServiceIfCreated(CommandProcessor.class)) != null && (currentCommandName = commandProcessor.getCurrentCommandName()) != null) {
                this.logSevere("Current Command: " + currentCommandName);
            }
        }
    }

    static {
        EXPIRE_FREQUENT_EXCEPTIONS_AFTER_MINUTES = Integer.getInteger("idea.logger.exception.expiration.minutes", 480);
        ourApplicationInfoProvider = () -> {
            ApplicationInfoEx info = ApplicationInfoImpl.getShadowInstance();
            return info.getFullApplicationName() + "  Build #" + info.getBuild().asString();
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/IdeaLogger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenErrorMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/IdeaLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reportToFus";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyCache {
        private static final Cache<@NotNull String, @NotNull AtomicInteger> cache = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess((long)Math.max(EXPIRE_FREQUENT_EXCEPTIONS_AFTER_MINUTES, 0), TimeUnit.MINUTES).build();

        private MyCache() {
        }

        @NotNull
        private static AtomicInteger getOrCreate(int hash, @NotNull Throwable t) {
            if (t == null) {
                MyCache.$$$reportNull$$$0(0);
            }
            AtomicInteger atomicInteger = (AtomicInteger)cache.get((Object)(hash + ":" + String.valueOf(t)), __ -> new AtomicInteger());
            if (atomicInteger == null) {
                MyCache.$$$reportNull$$$0(1);
            }
            return atomicInteger;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "t";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/idea/IdeaLogger$MyCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/idea/IdeaLogger$MyCache";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreate";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

