/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.impl.ApplicationNotificationsModelKt;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.ProjectCallback;
import com.intellij.notification.impl.ProjectNotificationsModel;
import com.intellij.notification.impl.ProjectNotificationsModelListener;
import com.intellij.notification.impl.StatusMessage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\bH\u0007J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0007J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u0015\u001a\u00020\fH\u0007J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0015\u001a\u00020\fH\u0007J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\fJ\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\bH\u0007J\u0010\u0010$\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\fJ\u000e\u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fJ\u0006\u0010&\u001a\u00020\u0014J\u000e\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fJ\u0016\u0010(\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fJ\u0010\u0010,\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/notification/impl/ApplicationNotificationsModel;", "", "<init>", "()V", "EVENT_REQUESTOR", "", "notifications", "Ljava/util/ArrayList;", "Lcom/intellij/notification/Notification;", "Lkotlin/collections/ArrayList;", "projectToModel", "Ljava/util/HashMap;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/notification/impl/ProjectNotificationsModel;", "Lkotlin/collections/HashMap;", "dataGuard", "STATE_CHANGED", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/notification/impl/ApplicationNotificationsModel$StateEventListener;", "addNotification", "", "project", "notification", "addApplicationNotification", "addProjectNotification", "getNotifications", "", "getApplicationNotifications", "getProjectNotifications", "getStateNotifications", "markAllRead", "getStatusMessage", "Lcom/intellij/notification/impl/StatusMessage;", "isEmptyContent", "", "remove", "clearAll", "clearTimeline", "expireAll", "fireNotificationsPanelVisible", "register", "listener", "Lcom/intellij/notification/impl/ProjectNotificationsModelListener;", "unregister", "newProjectModel", "StateEventListener", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nApplicationNotificationsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationNotificationsModel.kt\ncom/intellij/notification/impl/ApplicationNotificationsModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,378:1\n1915#2,2:379\n1480#2,5:388\n1915#2,2:393\n1915#2,2:402\n383#3,7:381\n383#3,7:395\n*S KotlinDebug\n*F\n+ 1 ApplicationNotificationsModel.kt\ncom/intellij/notification/impl/ApplicationNotificationsModel\n*L\n59#1:379,2\n85#1:388,5\n134#1:393,2\n174#1:402,2\n65#1:381,7\n193#1:395,7\n*E\n"})
public final class ApplicationNotificationsModel {
    @NotNull
    public static final ApplicationNotificationsModel INSTANCE = new ApplicationNotificationsModel();
    @NotNull
    public static final String EVENT_REQUESTOR = "Internal notification event requestor";
    @NotNull
    private static final ArrayList<Notification> notifications = new ArrayList();
    @NotNull
    private static final HashMap<Project, ProjectNotificationsModel> projectToModel = new HashMap();
    @NotNull
    private static final Object dataGuard = new Object();
    @JvmField
    @Topic.AppLevel
    @NotNull
    public static final Topic<StateEventListener> STATE_CHANGED = new Topic("NOTIFICATION_MODEL_CHANGED", StateEventListener.class, Topic.BroadcastDirection.NONE);

    private ApplicationNotificationsModel() {
    }

    @JvmStatic
    public static final void addNotification(@Nullable Project project2, @NotNull Notification notification2) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        if (!notification2.canShowFor(project2) || !NotificationsConfigurationImpl.getSettings(notification2.getGroupId()).isShouldLog()) {
            return;
        }
        if (project2 == null) {
            INSTANCE.addApplicationNotification(notification2);
        } else {
            INSTANCE.addProjectNotification(project2, notification2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addApplicationNotification(Notification notification2) {
        if (projectToModel.isEmpty()) {
            Object object = dataGuard;
            synchronized (object) {
                boolean $i$a$-synchronized-ApplicationNotificationsModel$addApplicationNotification$32 = false;
                Boolean $i$a$-synchronized-ApplicationNotificationsModel$addApplicationNotification$32 = notifications.add(notification2);
            }
        }
        List callbacks = new ArrayList();
        Object $i$a$-synchronized-ApplicationNotificationsModel$addApplicationNotification$32 = dataGuard;
        synchronized ($i$a$-synchronized-ApplicationNotificationsModel$addApplicationNotification$32) {
            boolean bl = false;
            Iterator<Map.Entry<Project, ProjectNotificationsModel>> iterator = projectToModel.entrySet().iterator();
            while (iterator.hasNext()) {
                Project project2;
                ProjectNotificationsModel model2;
                Map.Entry<Project, ProjectNotificationsModel> entry;
                Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
                Intrinsics.checkNotNullExpressionValue((Object)entry.getKey(), (String)"component1(...)");
                Intrinsics.checkNotNullExpressionValue((Object)entry.getValue(), (String)"component2(...)");
                Runnable callback = model2.addNotification(project2, notification2);
                callbacks.add(ApplicationNotificationsModelKt.access$inProject(callback, project2));
            }
            Unit unit = Unit.INSTANCE;
        }
        Iterable $this$forEach$iv = callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectCallback p0 = (ProjectCallback)element$iv;
            boolean bl = false;
            p0.invokeLaterIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void addProjectNotification(Project project2, Notification notification2) {
        Runnable runnable2;
        Object object = dataGuard;
        synchronized (object) {
            Object object2;
            void $this$getOrPut$iv;
            boolean bl = false;
            Map map2 = projectToModel;
            Project key$iv = project2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                ProjectNotificationsModel answer$iv = INSTANCE.newProjectModel(project2);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ProjectNotificationsModel model2 = (ProjectNotificationsModel)object2;
            runnable2 = model2.addNotification(project2, notification2);
        }
        Runnable callback = runnable2;
        ApplicationNotificationsModelKt.access$inProject(callback, project2).invokeLaterIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final List<Notification> getNotifications(@Nullable Project project2) {
        Object object = dataGuard;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (project2 != null) break block4;
                List<Notification> list2 = INSTANCE.getApplicationNotifications();
                return list2;
            }
            List<Notification> list3 = INSTANCE.getProjectNotifications(project2);
            return list3;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Notification> getApplicationNotifications() {
        void $this$flatMapTo$iv;
        List allNotifications = CollectionsKt.toMutableList((Collection)notifications);
        Collection<ProjectNotificationsModel> collection = projectToModel.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        Collection destination$iv = allNotifications;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            ProjectNotificationsModel model2 = (ProjectNotificationsModel)element$iv;
            boolean bl = false;
            Iterable list$iv = model2.getNotifications(CollectionsKt.emptyList());
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return allNotifications;
    }

    private final List<Notification> getProjectNotifications(Project project2) {
        Object object = projectToModel.get(project2);
        if (object == null || (object = ((ProjectNotificationsModel)object).getNotifications((List<? extends Notification>)notifications)) == null) {
            object = CollectionsKt.toList((Iterable)notifications);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final List<Notification> getStateNotifications(@NotNull Project project2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object2 = dataGuard;
        synchronized (object2) {
            boolean bl = false;
            Object object3 = projectToModel.get(project2);
            if (object3 == null || (object3 = ((ProjectNotificationsModel)object3).getUnreadNotifications()) == null) {
                object3 = notifications;
            }
            object = object3;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markAllRead(@NotNull Project project2) {
        Runnable runnable2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = dataGuard;
        synchronized (object) {
            boolean bl = false;
            ProjectNotificationsModel projectNotificationsModel = projectToModel.get(project2);
            Runnable runnable3 = projectNotificationsModel != null ? projectNotificationsModel.markAllRead() : null;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var3_2
            runnable2 = runnable3;
        }
        if (runnable2 == null) {
            return;
        }
        Runnable callback = runnable2;
        ApplicationNotificationsModelKt.access$inProject(callback, project2).invokeLaterIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final StatusMessage getStatusMessage(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = dataGuard;
        synchronized (object) {
            boolean bl = false;
            ProjectNotificationsModel projectNotificationsModel = projectToModel.get(project2);
            StatusMessage statusMessage = projectNotificationsModel != null ? projectNotificationsModel.getStatusMessage() : null;
            return statusMessage;
        }
    }

    public final boolean isEmptyContent(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ProjectNotificationsModel projectNotificationsModel = projectToModel.get(project2);
        return projectNotificationsModel != null ? projectNotificationsModel.isEmptyContent() : true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void remove(@NotNull Notification notification2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        Object object = dataGuard;
        synchronized (object) {
            boolean bl = false;
            notifications.remove(notification2);
            List callbacks = new ArrayList();
            for (Map.Entry entry : ((Map)projectToModel).entrySet()) {
                Project project2 = (Project)entry.getKey();
                ProjectNotificationsModel model2 = (ProjectNotificationsModel)entry.getValue();
                Runnable callback = model2.remove(project2, notification2);
                callbacks.add(ApplicationNotificationsModelKt.access$inProject(callback, project2));
            }
            list2 = callbacks;
        }
        List callbacks = list2;
        Iterable $this$forEach$iv = callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectCallback p0 = (ProjectCallback)element$iv;
            boolean bl = false;
            p0.invokeLaterIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearAll(@Nullable Project project2) {
        Runnable runnable2;
        if (project2 == null) {
            Object object = dataGuard;
            synchronized (object) {
                boolean bl = false;
                notifications.clear();
                Unit unit = Unit.INSTANCE;
            }
            return;
        }
        Object object = dataGuard;
        synchronized (object) {
            boolean bl = false;
            notifications.clear();
            ProjectNotificationsModel projectNotificationsModel = projectToModel.get(project2);
            Runnable runnable3 = projectNotificationsModel != null ? projectNotificationsModel.clearAll(project2) : null;
            // MONITOREXIT @DISABLED, blocks:[1, 3] lbl24 : MonitorExitStatement: MONITOREXIT : var5_6
            runnable2 = runnable3;
        }
        if (runnable2 == null) {
            return;
        }
        Runnable callback = runnable2;
        ApplicationNotificationsModelKt.access$inProject(callback, project2).invokeLaterIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearTimeline(@NotNull Project project2) {
        Runnable runnable2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = dataGuard;
        synchronized (object) {
            boolean bl = false;
            CollectionsKt.removeAll((List)notifications, ApplicationNotificationsModel::clearTimeline$lambda$0$0);
            ProjectNotificationsModel projectNotificationsModel = projectToModel.get(project2);
            Runnable runnable3 = projectNotificationsModel != null ? projectNotificationsModel.clearTimeline(project2) : null;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var3_2
            runnable2 = runnable3;
        }
        if (runnable2 == null) {
            return;
        }
        Runnable callback = runnable2;
        ApplicationNotificationsModelKt.access$inProject(callback, project2).invokeLaterIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expireAll() {
        Runnable runnable2;
        Object object = dataGuard;
        synchronized (object) {
            boolean bl = false;
            List allNotifications = CollectionsKt.toMutableList((Collection)notifications);
            notifications.clear();
            List callbacks = new ArrayList();
            for (Map.Entry entry : ((Map)projectToModel).entrySet()) {
                Project project2 = (Project)entry.getKey();
                ProjectNotificationsModel model2 = (ProjectNotificationsModel)entry.getValue();
                Pair<List<Notification>, Runnable> pair = model2.expireAll(project2);
                List projectNotifications = (List)pair.component1();
                Runnable callback = (Runnable)pair.component2();
                allNotifications.addAll(projectNotifications);
                callbacks.add(ApplicationNotificationsModelKt.access$inProject(callback, project2));
            }
            runnable2 = () -> ApplicationNotificationsModel.expireAll$lambda$0$0(callbacks, allNotifications);
        }
        Runnable callback = runnable2;
        callback.run();
    }

    public final void fireNotificationsPanelVisible(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ApplicationNotificationsModelKt.access$closeAllBalloons(project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void register(@NotNull Project project2, @NotNull ProjectNotificationsModelListener listener2) {
        Runnable runnable2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object object = dataGuard;
        synchronized (object) {
            Object object2;
            void $this$getOrPut$iv;
            boolean bl = false;
            List initNotifications = CollectionsKt.toMutableList((Collection)notifications);
            notifications.clear();
            Map map2 = projectToModel;
            Project key$iv = project2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                ProjectNotificationsModel answer$iv = INSTANCE.newProjectModel(project2);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            runnable2 = ((ProjectNotificationsModel)object2).register(project2, listener2, initNotifications);
        }
        Runnable callback = runnable2;
        ApplicationNotificationsModelKt.access$inProject(callback, project2).invokeLaterIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregister(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = dataGuard;
        synchronized (object) {
            boolean bl = false;
            ProjectNotificationsModel projectNotificationsModel = projectToModel.remove(project2);
        }
    }

    private final ProjectNotificationsModel newProjectModel(Project project2) {
        Disposer.register((Disposable)((Disposable)project2), () -> ApplicationNotificationsModel.newProjectModel$lambda$0(project2));
        return new ProjectNotificationsModel();
    }

    private static final boolean clearTimeline$lambda$0$0(Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isSuggestionType();
    }

    private static final void expireAll$lambda$0$0(List $callbacks, List $allNotifications) {
        Iterable $this$forEach$iv = $callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectCallback p0 = (ProjectCallback)element$iv;
            boolean bl = false;
            p0.invokeLaterIfNeeded();
        }
        for (Notification notification2 : $allNotifications) {
            notification2.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void newProjectModel$lambda$0(Project $project) {
        Object object = dataGuard;
        synchronized (object) {
            boolean bl = false;
            projectToModel.remove($project);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/notification/impl/ApplicationNotificationsModel$StateEventListener;", "", "stateChanged", "", "intellij.platform.ide.impl"})
    public static interface StateEventListener {
        public void stateChanged();
    }
}

