/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.BasePropertyService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.impl.ui.DoNotAskInfo;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\b0\nj\b\u0012\u0004\u0012\u00020\b`\u000b2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0012J\u0006\u0010\u001c\u001a\u00020\u0012J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\b0\nj\b\u0012\u0004\u0012\u00020\b`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/notification/impl/ui/DoNotAskConfigurableUi;", "", "<init>", "()V", "myCreated", "", "myList", "Lcom/intellij/ui/components/JBList;", "Lcom/intellij/notification/impl/ui/DoNotAskInfo;", "myRemoveList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "createDoNotAskList", "getDoNotAskValues", "", "getProject", "Lcom/intellij/openapi/project/Project;", "getValues", "", "manager", "Lcom/intellij/ide/util/PropertiesComponent;", "list", "forProject", "createComponent", "Ljavax/swing/JComponent;", "removeSelectedItems", "isModified", "reset", "apply", "removeKey", "id", "", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nDoNotAskConfigurableUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoNotAskConfigurableUi.kt\ncom/intellij/notification/impl/ui/DoNotAskConfigurableUi\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,128:1\n37#2,2:129\n*S KotlinDebug\n*F\n+ 1 DoNotAskConfigurableUi.kt\ncom/intellij/notification/impl/ui/DoNotAskConfigurableUi\n*L\n27#1:129,2\n*E\n"})
public final class DoNotAskConfigurableUi {
    private boolean myCreated;
    private JBList<DoNotAskInfo> myList;
    @NotNull
    private final ArrayList<DoNotAskInfo> myRemoveList = new ArrayList();

    private final JBList<DoNotAskInfo> createDoNotAskList() {
        Collection $this$toTypedArray$iv = this.getDoNotAskValues();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DoNotAskInfo[] doNotAskInfoArray = thisCollection$iv.toArray(new DoNotAskInfo[0]);
        JBList result2 = new JBList((Object[])Arrays.copyOf(doNotAskInfoArray, doNotAskInfoArray.length));
        result2.getEmptyText().clear();
        String string = IdeBundle.message((String)"notifications.configurable.do.not.ask.project.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String projectTitle = string;
        result2.setCellRenderer(BuilderKt.textListCellRenderer((String)"", arg_0 -> DoNotAskConfigurableUi.createDoNotAskList$lambda$0(projectTitle, arg_0)));
        result2.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"notifications.configurable.do.not.ask.list.accessible.name", (Object[])new Object[0]));
        return result2;
    }

    private final List<DoNotAskInfo> getDoNotAskValues() {
        ArrayList<DoNotAskInfo> list2 = new ArrayList<DoNotAskInfo>();
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
        this.getValues(propertiesComponent, list2, false);
        Project project2 = this.getProject();
        if (project2 != null) {
            PropertiesComponent propertiesComponent2 = PropertiesComponent.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent2, (String)"getInstance(...)");
            this.getValues(propertiesComponent2, list2, true);
        }
        CollectionsKt.sortWith((List)list2, DoNotAskConfigurableUi::getDoNotAskValues$lambda$0);
        return list2;
    }

    private final Project getProject() {
        DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)WindowManager.getInstance().getMostRecentFocusedWindow());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        return (Project)CommonDataKeys.PROJECT.getData(dataContext2);
    }

    private final void getValues(PropertiesComponent manager2, ArrayList<DoNotAskInfo> list2, boolean forProject) {
        if (manager2 instanceof BasePropertyService) {
            ((BasePropertyService)manager2).forEachPrimitiveValue((arg_0, arg_1) -> DoNotAskConfigurableUi.getValues$lambda$0(manager2, list2, forProject, arg_0, arg_1));
        }
    }

    @NotNull
    public final JComponent createComponent() {
        this.myList = this.createDoNotAskList();
        this.myCreated = true;
        JBList<DoNotAskInfo> jBList = this.myList;
        if (jBList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myList");
            jBList = null;
        }
        JPanel jPanel = ToolbarDecorator.createDecorator((JList)((JList)jBList)).disableUpDownActions().setRemoveAction(arg_0 -> DoNotAskConfigurableUi.createComponent$lambda$0(this, arg_0)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        return jPanel;
    }

    private final void removeSelectedItems() {
        JBList<DoNotAskInfo> jBList = this.myList;
        if (jBList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myList");
            jBList = null;
        }
        int[] indices = jBList.getSelectedIndices();
        JBList<DoNotAskInfo> jBList2 = this.myList;
        if (jBList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myList");
            jBList2 = null;
        }
        ListModel listModel = jBList2.getModel();
        Intrinsics.checkNotNull((Object)listModel, (String)"null cannot be cast to non-null type javax.swing.DefaultListModel<com.intellij.notification.impl.ui.DoNotAskInfo>");
        DefaultListModel model2 = (DefaultListModel)listModel;
        Intrinsics.checkNotNull((Object)indices);
        List list2 = ArraysKt.reversed((int[])indices);
        int n = list2.size();
        for (int j = 0; j < n; ++j) {
            int index = ((Number)list2.get(j)).intValue();
            this.myRemoveList.add((DoNotAskInfo)model2.getElementAt(index));
            model2.remove(index);
        }
        int size2 = model2.size();
        if (size2 > 0) {
            JBList<DoNotAskInfo> jBList3 = this.myList;
            if (jBList3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myList");
                jBList3 = null;
            }
            jBList3.setSelectedIndex(Math.min(size2 - 1, ArraysKt.last((int[])indices)));
        }
    }

    public final boolean isModified() {
        return this.myCreated && !((Collection)this.myRemoveList).isEmpty();
    }

    public final void reset() {
        if (this.myCreated) {
            this.myRemoveList.clear();
            JBList<DoNotAskInfo> jBList = this.myList;
            if (jBList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myList");
                jBList = null;
            }
            int[] selectedIndices = jBList.getSelectedIndices();
            JBList<DoNotAskInfo> jBList2 = this.myList;
            if (jBList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myList");
                jBList2 = null;
            }
            jBList2.setModel(this.createDoNotAskList().getModel());
            JBList<DoNotAskInfo> jBList3 = this.myList;
            if (jBList3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myList");
                jBList3 = null;
            }
            jBList3.setSelectedIndices(selectedIndices);
        }
    }

    public final void apply() {
        Project project2;
        PropertiesComponent manager2 = PropertiesComponent.getInstance();
        Project project3 = project2 = this.getProject();
        PropertiesComponent projectManager = project3 == null ? null : PropertiesComponent.getInstance((Project)project3);
        Iterator<DoNotAskInfo> iterator = this.myRemoveList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<DoNotAskInfo> iterator2 = iterator;
        while (iterator2.hasNext()) {
            DoNotAskInfo info;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (info.getForProject()) {
                if (projectManager == null) continue;
                this.removeKey(projectManager, info.getId());
                continue;
            }
            Intrinsics.checkNotNull((Object)manager2);
            this.removeKey(manager2, info.getId());
        }
    }

    private final void removeKey(PropertiesComponent manager2, String id2) {
        manager2.unsetValue("Notification.DoNotAsk-" + id2);
        manager2.unsetValue("Notification.DisplayName-DoNotAsk-" + id2);
    }

    private static final String createDoNotAskList$lambda$0(String $projectTitle, DoNotAskInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getForProject() ? it.getName() + " (" + $projectTitle + ")" : it.getName();
    }

    private static final int getDoNotAskValues$lambda$0(DoNotAskInfo o1, DoNotAskInfo o2) {
        return o1.getId().compareTo(o2.getId());
    }

    private static final void getValues$lambda$0(PropertiesComponent $manager, ArrayList $list, boolean $forProject, String key, String string) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        if (StringsKt.startsWith$default((String)key, (String)"Notification.DoNotAsk-", (boolean)false, (int)2, null)) {
            String string2 = key.substring(22);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String id2 = string2;
            String string3 = $manager.getValue("Notification.DisplayName-DoNotAsk-" + id2, id2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
            String name2 = string3;
            $list.add(new DoNotAskInfo(id2, name2, $forProject));
        }
    }

    private static final void createComponent$lambda$0(DoNotAskConfigurableUi this$0, AnActionButton it) {
        this$0.removeSelectedItems();
    }
}

