/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.collectors.fus.ui.persistence.ToolbarClicksCollector;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionClassMetaData;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.ex.TooltipLinkProvider;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.codeFloatingToolbar.CodeFloatingToolbar;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.PopupState;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionButton
extends JComponent
implements ActionButtonComponent,
AnActionHolder,
Accessible {
    private static final Logger LOG = Logger.getInstance(ActionButton.class);
    @NonNls
    private static final Set<String> WHITE_LIST = Set.of("ExternalSystem.ProjectRefreshAction", "LoadConfigurationAction");
    @Deprecated(forRemoval=true)
    public static final Key<Boolean> HIDE_DROPDOWN_ICON = ActionUtil.HIDE_DROPDOWN_ICON;
    public static final Key<HelpTooltip> CUSTOM_HELP_TOOLTIP = Key.create((String)"CUSTOM_HELP_TOOLTIP");
    private JBDimension myMinimumButtonSize;
    private Supplier<? extends @NotNull Dimension> myMinimumButtonSizeFunction;
    private Icon myDisabledIcon;
    private Icon myIcon;
    protected final Presentation myPresentation;
    protected final AnAction myAction;
    protected final String myPlace;
    protected final PopupState<JPopupMenu> myPopupState;
    private ActionButtonLook myLook;
    private boolean myMouseDown;
    protected boolean myRollover;
    private static boolean ourGlobalMouseDown;
    private boolean myNoIconsInPopup;
    private Insets myInsets;
    private boolean myUpdateThreadOnDirectUpdateChecked;

    public ActionButton(@NotNull AnAction action2, @Nullable Presentation presentation2, @NotNull String place, @NotNull Dimension minimumSize) {
        if (action2 == null) {
            ActionButton.$$$reportNull$$$0(0);
        }
        if (place == null) {
            ActionButton.$$$reportNull$$$0(1);
        }
        if (minimumSize == null) {
            ActionButton.$$$reportNull$$$0(2);
        }
        this(action2, presentation2, place, () -> minimumSize);
    }

    public ActionButton(@NotNull AnAction action2, @Nullable Presentation presentation2, @NotNull String place, @NotNull @NotNull Supplier<? extends @NotNull Dimension> minimumSize) {
        boolean isTemplatePresentation;
        if (action2 == null) {
            ActionButton.$$$reportNull$$$0(3);
        }
        if (place == null) {
            ActionButton.$$$reportNull$$$0(4);
        }
        if (minimumSize == null) {
            ActionButton.$$$reportNull$$$0(5);
        }
        this.myPopupState = PopupState.forPopupMenu();
        this.myLook = ActionButtonLook.SYSTEM_LOOK;
        boolean bl = isTemplatePresentation = presentation2 == action2.getTemplatePresentation();
        if (isTemplatePresentation) {
            LOG.warn(new Throwable("Template presentations must not be used directly"));
        }
        this.myMinimumButtonSizeFunction = minimumSize;
        this.updateMinimumSize();
        this.setIconInsets(null);
        this.myRollover = false;
        this.myMouseDown = false;
        this.myAction = action2;
        this.myPresentation = presentation2 != null && !isTemplatePresentation ? presentation2 : action2.getTemplatePresentation().clone();
        this.myPresentation.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newValue;
                Boolean bl = newValue = evt.getNewValue() instanceof Boolean ? (Boolean)evt.getNewValue() : null;
                if (Objects.equals(evt.getPropertyName(), "selected") && newValue != null) {
                    if (newValue.booleanValue()) {
                        ActionButton.this.getAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                    } else {
                        ActionButton.this.getAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                    }
                }
                ActionButton.this.presentationPropertyChanged(evt);
            }
        });
        this.myPlace = place;
        this.setFocusable(ScreenReader.isActive());
        this.enableEvents(16L);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                    ActionButton.this.click();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ActionButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ActionButton.this.repaint();
            }
        });
        this.putClientProperty("ToCenterTooltip", Boolean.TRUE);
    }

    private void updateMinimumSize() {
        this.myMinimumButtonSize = JBDimension.create((Dimension)this.myMinimumButtonSizeFunction.get());
    }

    public void setNoIconsInPopup(boolean noIconsInPopup) {
        this.myNoIconsInPopup = noIconsInPopup;
    }

    public void setMinimumButtonSize(Supplier<? extends @NotNull Dimension> size2) {
        this.myMinimumButtonSizeFunction = size2;
        this.updateMinimumSize();
    }

    public void setMinimumButtonSize(@NotNull Dimension size2) {
        if (size2 == null) {
            ActionButton.$$$reportNull$$$0(6);
        }
        this.myMinimumButtonSizeFunction = () -> size2;
        this.updateMinimumSize();
    }

    @Override
    public void paintChildren(Graphics g) {
    }

    public int getPopState() {
        return this.getPopState(this.isSelected());
    }

    @NotNull
    public Presentation getPresentation() {
        Presentation presentation2 = this.myPresentation;
        if (presentation2 == null) {
            ActionButton.$$$reportNull$$$0(7);
        }
        return presentation2;
    }

    public final boolean isRollover() {
        return this.myRollover;
    }

    public final boolean isMouseDown() {
        return this.myMouseDown;
    }

    public final boolean isSelected() {
        Boolean isSelectedComponent = Toggleable.isSelected((JComponent)this);
        if (isSelectedComponent != null) {
            return isSelectedComponent;
        }
        return Toggleable.isSelected((Presentation)this.myPresentation);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled(super.isEnabled());
    }

    protected boolean isEnabled(boolean componentEnabled) {
        return componentEnabled && this.myPresentation.isEnabled();
    }

    private void onMousePresenceChanged(boolean setInfo) {
        ActionMenu.showDescriptionInStatusBar(setInfo, this, this.myPresentation.getDescription());
    }

    public void click() {
        this.performAction(this.makeClickMouseEvent());
    }

    @NotNull
    private MouseEvent makeClickMouseEvent() {
        return new MouseEvent(this, 500, System.currentTimeMillis(), 0, 0, 0, 1, false);
    }

    protected void performAction(MouseEvent e) {
        ActionUiKind.Toolbar toolbar2;
        ActionToolbar toolbar3 = ActionToolbar.findToolbarBy((Component)this);
        if (toolbar3 instanceof ActionUiKind) {
            ActionUiKind o = (ActionUiKind)toolbar3;
            toolbar2 = o;
        } else {
            toolbar2 = ActionUiKind.TOOLBAR;
        }
        ActionUiKind.Toolbar uiKind = toolbar2;
        AnActionEvent event = AnActionEvent.createEvent((DataContext)this.getDataContext(), (Presentation)this.myPresentation, (String)this.myPlace, (ActionUiKind)uiKind, (InputEvent)e);
        if (!this.isEnabled()) {
            return;
        }
        ActionManagerEx actionManager = (ActionManagerEx)event.getActionManager();
        AnActionResult result2 = actionManager.performWithActionCallbacks(this.myAction, event, () -> this.actionPerformed(event));
        if (result2.isPerformed()) {
            if (event.getInputEvent() instanceof MouseEvent) {
                ToolbarClicksCollector.record(this.myAction, this.myPlace, e, event.getDataContext());
            }
            if (toolbar3 != null) {
                toolbar3.updateActionsAsync();
            }
        }
    }

    protected DataContext getDataContext() {
        return ActionToolbar.getDataContextFor((Component)this);
    }

    protected void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            ActionButton.$$$reportNull$$$0(8);
        }
        HelpTooltip.hide((Component)this);
        if (this.isPopupMenuAction(event)) {
            this.showActionGroupPopup((ActionGroup)this.myAction, event);
        } else {
            this.myAction.actionPerformed(event);
        }
    }

    @Nullable
    private static WizardPopup getPopupContainer(Component c) {
        JBPopup popup2 = PopupUtil.getPopupContainerFor((Component)c);
        return popup2 instanceof WizardPopup ? (WizardPopup)popup2 : null;
    }

    protected void showActionGroupPopup(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent event) {
        if (actionGroup == null) {
            ActionButton.$$$reportNull$$$0(9);
        }
        if (event == null) {
            ActionButton.$$$reportNull$$$0(10);
        }
        this.createAndShowActionGroupPopup(actionGroup, event);
    }

    @NotNull
    protected JBPopup createAndShowActionGroupPopup(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent event) {
        Editor editor2;
        CodeFloatingToolbar floatingToolbar;
        if (actionGroup == null) {
            ActionButton.$$$reportNull$$$0(11);
        }
        if (event == null) {
            ActionButton.$$$reportNull$$$0(12);
        }
        PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, null, actionGroup, event.getDataContext(), ActionPlaces.getActionGroupPopupPlace((String)event.getPlace()), this.createPresentationFactory(), ActionPopupOptions.showDisabled(), null);
        popup2.setShowSubmenuOnHover(true);
        popup2.setAlignByParentBounds(false);
        popup2.setActiveRoot(ActionButton.getPopupContainer(this) == null);
        if ("EditorFloatingToolbar".equals(event.getPlace()) && (floatingToolbar = CodeFloatingToolbar.getToolbar(editor2 = (Editor)event.getData(CommonDataKeys.EDITOR))) != null) {
            floatingToolbar.attachPopupToButton(this, popup2);
        }
        popup2.showUnderneathOf(this);
        PopupFactoryImpl.ActionGroupPopup actionGroupPopup = popup2;
        if (actionGroupPopup == null) {
            ActionButton.$$$reportNull$$$0(13);
        }
        return actionGroupPopup;
    }

    @NotNull
    private MenuItemPresentationFactory createPresentationFactory() {
        return new MenuItemPresentationFactory(){

            @Override
            protected void processPresentation(@NotNull AnAction action2, @NotNull Presentation presentation2) {
                if (action2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (presentation2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                super.processPresentation(action2, presentation2);
                if (ActionButton.this.myNoIconsInPopup) {
                    presentation2.setIcon(null);
                    presentation2.setHoveredIcon(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/actionSystem/impl/ActionButton$4";
                objectArray[2] = "processPresentation";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private boolean isPopupMenuAction(@NotNull AnActionEvent event) {
        if (event == null) {
            ActionButton.$$$reportNull$$$0(14);
        }
        if (!(this.myAction instanceof ActionGroup)) {
            return false;
        }
        if (!event.getPresentation().isPopupGroup()) {
            return false;
        }
        return !event.getPresentation().isPerformGroup();
    }

    @Override
    public void removeNotify() {
        if (this.myRollover) {
            this.onMousePresenceChanged(false);
        }
        if (this.myMouseDown) {
            ourGlobalMouseDown = false;
        }
        this.myRollover = false;
        this.myMouseDown = false;
        HelpTooltip.dispose((Component)this);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (ActionToolbar.findToolbarBy((Component)this) == null) {
            ActionManagerEx.withLazyActionManager(null, __ -> {
                this.update();
                return Unit.INSTANCE;
            });
        } else {
            this.updateToolTipText();
            this.updateIcon();
        }
    }

    public void update() {
        ActionUiKind.Toolbar toolbar2;
        ActionToolbar toolbar3;
        if (!this.myUpdateThreadOnDirectUpdateChecked) {
            this.myUpdateThreadOnDirectUpdateChecked = true;
            if (this.myAction.getActionUpdateThread() == ActionUpdateThread.BGT && !ActionClassMetaData.isDefaultUpdate((AnAction)this.myAction)) {
                ActionManager actionManager = ActionManager.getInstance();
                LOG.error((Throwable)PluginException.createByClass((String)("BGT operation " + Utils.operationName(this.myAction, "update", this.myPlace, (Function1<Object, String>)((Function1)o -> {
                    String string;
                    if (o instanceof AnAction) {
                        AnAction a = (AnAction)o;
                        string = actionManager.getId(a);
                    } else {
                        string = null;
                    }
                    return string;
                })) + " is not allowed on EDT"), null, this.myAction.getClass()));
            }
        }
        if ((toolbar3 = ActionToolbar.findToolbarBy((Component)this)) instanceof ActionUiKind) {
            ActionUiKind o2 = (ActionUiKind)toolbar3;
            toolbar2 = o2;
        } else {
            toolbar2 = ActionUiKind.TOOLBAR;
        }
        ActionUiKind.Toolbar uiKind = toolbar2;
        AnActionEvent e = AnActionEvent.createEvent((DataContext)this.getDataContext(), (Presentation)this.myPresentation, (String)this.myPlace, (ActionUiKind)uiKind, null);
        ActionUtil.updateAction((AnAction)this.myAction, (AnActionEvent)e);
        this.updateToolTipText();
        this.updateIcon();
    }

    @Override
    public void setToolTipText(@NlsContexts.Tooltip String toolTipText) {
        if (!UISettings.isIdeHelpTooltipEnabled()) {
            while (StringUtil.endsWithChar((CharSequence)toolTipText, (char)'.')) {
                toolTipText = ((String)toolTipText).substring(0, ((String)toolTipText).length() - 1);
            }
            String shortcutsText = this.getShortcutText();
            if (Strings.isNotEmpty((String)shortcutsText)) {
                toolTipText = (String)toolTipText + " (" + shortcutsText + ")";
            }
            super.setToolTipText((String)(Strings.isNotEmpty((String)toolTipText) ? toolTipText : null));
        }
    }

    protected void setCustomToolTipText(@NlsContexts.Tooltip String toolTipText) {
        super.setToolTipText(Strings.isNotEmpty((String)toolTipText) ? toolTipText : null);
    }

    @Override
    public void updateUI() {
        if (this.myLook != null) {
            this.myLook.updateUI();
        }
        this.updateToolTipText();
        this.updateMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Icon icon2;
        if (this.myMinimumButtonSize != null) {
            this.myMinimumButtonSize.update();
        }
        Dimension size2 = (icon2 = this.getIcon()).getIconWidth() < this.myMinimumButtonSize.width && icon2.getIconHeight() < this.myMinimumButtonSize.height ? new Dimension((Dimension)this.myMinimumButtonSize) : new Dimension(Math.max(this.myMinimumButtonSize.width, icon2.getIconWidth() + this.myInsets.left + this.myInsets.right), Math.max(this.myMinimumButtonSize.height, icon2.getIconHeight() + this.myInsets.top + this.myInsets.bottom));
        JBInsets.addTo((Dimension)size2, (Insets)this.getInsets());
        return size2;
    }

    @NotNull
    public Insets getIconInsets() {
        Insets insets = this.myInsets;
        if (insets == null) {
            ActionButton.$$$reportNull$$$0(15);
        }
        return insets;
    }

    public void setIconInsets(@Nullable Insets insets) {
        this.myInsets = insets != null ? JBInsets.create((Insets)insets) : JBInsets.emptyInsets();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Icon getIcon() {
        Icon hoveredIcon;
        boolean enabled2 = this.isEnabled();
        int popState = this.getPopState();
        Icon icon2 = hoveredIcon = popState == 1 || popState == -1 ? this.myPresentation.getHoveredIcon() : null;
        Icon icon3 = enabled2 ? (hoveredIcon == null ? this.myIcon : hoveredIcon) : this.myDisabledIcon;
        return icon3 == null ? this.getFallbackIcon(enabled2) : icon3;
    }

    public void setIcon(Icon icon2) {
        this.myIcon = icon2;
    }

    @NotNull
    protected Icon getFallbackIcon(boolean enabled2) {
        Presentation p = this.getAction().getTemplatePresentation();
        Icon icon2 = Objects.requireNonNullElse(p.getIcon(), AllIcons.Toolbar.Unknown);
        if (enabled2) {
            Icon icon3 = icon2;
            if (icon3 == null) {
                ActionButton.$$$reportNull$$$0(16);
            }
            return icon3;
        }
        if (p.getDisabledIcon() != null) {
            Icon icon4 = p.getDisabledIcon();
            if (icon4 == null) {
                ActionButton.$$$reportNull$$$0(17);
            }
            return icon4;
        }
        Icon icon5 = IconLoader.getDisabledIcon((Icon)icon2);
        if (icon5 == null) {
            ActionButton.$$$reportNull$$$0(18);
        }
        return icon5;
    }

    public void updateIcon() {
        this.myIcon = this.myPresentation.getIcon();
        if (this.myPresentation.getDisabledIcon() != null) {
            this.myDisabledIcon = this.myPresentation.getDisabledIcon();
        } else if (this.myIcon == null) {
            this.myDisabledIcon = null;
        } else if (IconLoader.isGoodSize((Icon)this.myIcon)) {
            this.myDisabledIcon = this.myLook.getDisabledIcon(this.myIcon);
        } else {
            this.myDisabledIcon = null;
            Logger.getInstance(ActionButton.class).error("invalid icon (" + String.valueOf(this.myIcon) + ") for action " + String.valueOf(this.myAction.getClass()));
        }
    }

    protected void updateToolTipText() {
        String text2 = this.myPresentation.getText();
        String description = this.myPresentation.getDescription();
        if (UISettings.isIdeHelpTooltipEnabled()) {
            HelpTooltip ht = (HelpTooltip)this.myPresentation.getClientProperty(CUSTOM_HELP_TOOLTIP);
            if ((Strings.isNotEmpty((String)text2) || Strings.isNotEmpty((String)description)) && ht == null) {
                TooltipLinkProvider.TooltipLink link;
                ht = new HelpTooltip().setTitle(text2).setShortcut(this.getShortcutText());
                if (this.myAction instanceof TooltipLinkProvider && (link = ((TooltipLinkProvider)this.myAction).getTooltipLink((JComponent)this)) != null) {
                    ht.setLink(link.tooltip, link.action);
                }
                String id2 = ActionManager.getInstance().getId(this.myAction);
                if (!Objects.equals(text2, description) && (id2 != null && WHITE_LIST.contains(id2) || this.myAction instanceof TooltipDescriptionProvider)) {
                    ht.setDescription(description);
                }
            }
            if (ht != null) {
                ht.installOn((JComponent)this);
            }
        } else {
            HelpTooltip.dispose((Component)this);
            this.setToolTipText(text2 == null ? description : text2);
        }
    }

    @Nullable
    @NlsSafe
    protected String getShortcutText() {
        return KeymapUtil.getFirstKeyboardShortcutText((AnAction)this.myAction);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.jComponentPaint(g);
        this.paintButtonLook(g);
    }

    @ApiStatus.Internal
    protected void jComponentPaint(Graphics g) {
        super.paintComponent(g);
    }

    protected boolean shallPaintDownArrow() {
        if (!(this.myAction instanceof ActionGroup)) {
            return false;
        }
        if (!this.myPresentation.isPopupGroup()) {
            return false;
        }
        if (Boolean.TRUE == this.myAction.getTemplatePresentation().getClientProperty(HIDE_DROPDOWN_ICON)) {
            return false;
        }
        return Boolean.TRUE != this.myPresentation.getClientProperty(HIDE_DROPDOWN_ICON);
    }

    @NotNull
    protected final Icon getEnableOrDisable(@NotNull Icon icon2) {
        if (icon2 == null) {
            ActionButton.$$$reportNull$$$0(19);
        }
        Icon icon3 = this.isEnabled() ? icon2 : this.myLook.getDisabledIcon(icon2);
        if (icon3 == null) {
            ActionButton.$$$reportNull$$$0(20);
        }
        return icon3;
    }

    protected void paintButtonLook(Graphics g) {
        ActionButtonLook look = this.getButtonLook();
        if (this.isEnabled() || !StartupUiUtil.isUnderDarcula() || ExperimentalUI.isNewUI()) {
            look.paintBackground(g, this);
        }
        look.paintIcon(g, this, this.getIcon());
        look.paintBorder(g, this);
        if (this.shallPaintDownArrow()) {
            Icon arrowIcon = this.getEnableOrDisable(AllIcons.General.Dropdown);
            look.paintDownArrow(g, this, this.getIcon(), arrowIcon);
        }
    }

    protected ActionButtonLook getButtonLook() {
        return this.myLook;
    }

    public void setLook(ActionButtonLook look) {
        this.myLook = look == null ? ActionButtonLook.SYSTEM_LOOK : look;
        this.repaint();
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        IdeMouseEventDispatcher.requestFocusInNonFocusedWindow(e);
        super.processMouseEvent(e);
        if (e.isConsumed()) {
            return;
        }
        boolean skipPress = this.checkSkipPressForEvent(e);
        switch (e.getID()) {
            case 501: {
                if (skipPress || !this.isEnabled()) {
                    return;
                }
                this.myMouseDown = true;
                this.myRollover = true;
                this.onMousePressed(e);
                ourGlobalMouseDown = true;
                this.repaint();
                break;
            }
            case 502: {
                if (skipPress || !this.isEnabled()) {
                    return;
                }
                this.onMouseReleased(e);
                if (this.myRollover) {
                    this.performAction(e);
                }
                this.repaint();
                break;
            }
            case 504: {
                if (!this.myMouseDown && ourGlobalMouseDown) break;
                this.myRollover = true;
                this.repaint();
                this.onMousePresenceChanged(true);
                break;
            }
            case 505: {
                this.myRollover = false;
                if (!this.myMouseDown && ourGlobalMouseDown) break;
                this.repaint();
                this.onMousePresenceChanged(false);
            }
        }
    }

    @ApiStatus.Internal
    protected void resetMouseState() {
        this.myMouseDown = false;
        ourGlobalMouseDown = false;
    }

    protected void onMouseReleased(@NotNull MouseEvent e) {
        if (e == null) {
            ActionButton.$$$reportNull$$$0(21);
        }
        this.resetMouseState();
    }

    protected void onMousePressed(@NotNull MouseEvent e) {
        if (e == null) {
            ActionButton.$$$reportNull$$$0(22);
        }
    }

    @ApiStatus.Internal
    protected boolean checkSkipPressForEvent(@NotNull MouseEvent e) {
        if (e == null) {
            ActionButton.$$$reportNull$$$0(23);
        }
        return e.isMetaDown() || e.getButton() != 1;
    }

    private int getPopState(boolean isPushed) {
        if (isPushed || this.myRollover && this.myMouseDown && this.isEnabled()) {
            return -1;
        }
        if (this.myRollover && this.isEnabled()) {
            return 1;
        }
        if (this.isFocusOwner()) {
            return 2;
        }
        return 0;
    }

    @NotNull
    public AnAction getAction() {
        AnAction anAction = this.myAction;
        if (anAction == null) {
            ActionButton.$$$reportNull$$$0(24);
        }
        return anAction;
    }

    protected void presentationPropertyChanged(@NotNull PropertyChangeEvent e) {
        String propertyName;
        if (e == null) {
            ActionButton.$$$reportNull$$$0(25);
        }
        if ("text".equals(propertyName = e.getPropertyName()) || "description".equals(propertyName)) {
            this.updateToolTipText();
        } else if ("enabled".equals(propertyName) || "icon".equals(propertyName)) {
            this.updateIcon();
            this.repaint();
        } else if ("disabledIcon".equals(propertyName)) {
            this.myDisabledIcon = this.myPresentation.getDisabledIcon();
            this.repaint();
        } else if ("selected".equals(propertyName)) {
            this.repaint();
        } else if (HIDE_DROPDOWN_ICON.toString().equals(propertyName)) {
            this.repaint();
        } else if (CUSTOM_HELP_TOOLTIP.toString().equals(propertyName)) {
            this.updateToolTipText();
        } else if (ActionUtil.COMPONENT_PROVIDER.toString().equals(propertyName)) {
            LOG.debug("existing button was replaced with a CustomComponentAction: " + String.valueOf(e.getNewValue()));
        }
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        AccessibleContext context = this.accessibleContext;
        if (context == null) {
            this.accessibleContext = context = new AccessibleActionButton();
        }
        AccessibleContext accessibleContext = context;
        if (accessibleContext == null) {
            ActionButton.$$$reportNull$$$0(26);
        }
        return accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 13, 15, 16, 17, 18, 20, 24, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimumSize";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionButton";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionButton";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndShowActionGroupPopup";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconInsets";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFallbackIcon";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnableOrDisable";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAction";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setMinimumButtonSize";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 26: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showActionGroupPopup";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createAndShowActionGroupPopup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPopupMenuAction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getEnableOrDisable";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onMouseReleased";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "onMousePressed";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkSkipPressForEvent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "presentationPropertyChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 13, 15, 16, 17, 18, 20, 24, 26 -> new IllegalStateException(string);
        };
    }

    protected class AccessibleActionButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleValue {
        protected AccessibleActionButton() {
            super(ActionButton.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        @Override
        public String getAccessibleName() {
            String name2 = this.accessibleName;
            if (name2 == null && (name2 = (String)ActionButton.this.getClientProperty("AccessibleName")) == null && (name2 = ActionButton.this.getToolTipText()) == null && (name2 = ActionButton.this.myPresentation.getText()) == null) {
                name2 = super.getAccessibleName();
            }
            return name2;
        }

        @Override
        public String getAccessibleDescription() {
            return AccessibleContextUtil.getUniqueDescription((AccessibleContext)this, (String)super.getAccessibleDescription());
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            AccessibleContext context;
            Icon icon2 = ActionButton.this.getIcon();
            if (icon2 instanceof Accessible && (context = ((Accessible)((Object)icon2)).getAccessibleContext()) instanceof AccessibleIcon) {
                return new AccessibleIcon[]{(AccessibleIcon)((Object)context)};
            }
            return null;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet var1 = super.getAccessibleStateSet();
            this.setCustomAccessibleStateSet(var1);
            return var1;
        }

        private void setCustomAccessibleStateSet(@NotNull AccessibleStateSet accessibleStateSet) {
            int state2;
            if (accessibleStateSet == null) {
                AccessibleActionButton.$$$reportNull$$$0(0);
            }
            if ((state2 = ActionButton.this.getPopState()) == -1) {
                accessibleStateSet.add(AccessibleState.PRESSED);
            }
            if (ActionButton.this.isSelected()) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            if (ActionButton.this.isFocusOwner()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int index) {
            return index == 0 ? UIManager.getString("AbstractButton.clickText") : null;
        }

        @Override
        public boolean doAccessibleAction(int index) {
            if (index == 0) {
                ActionButton.this.click();
                return true;
            }
            return false;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            if (ActionButton.this.isSelected()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean setCurrentAccessibleValue(Number n) {
            if (n == null) {
                return false;
            }
            int i2 = n.intValue();
            if (i2 == 0) {
                Toggleable.setSelected((JComponent)ActionButton.this, (Boolean)false);
            } else {
                Toggleable.setSelected((JComponent)ActionButton.this, (Boolean)true);
            }
            return true;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return 0;
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessibleStateSet", "com/intellij/openapi/actionSystem/impl/ActionButton$AccessibleActionButton", "setCustomAccessibleStateSet"));
        }
    }
}

