/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.idea.AppMode;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/actionSystem/impl/PopupShowingTimeTracker;", "", "<init>", "()V", "MARKER_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "showElapsedMillisIfConfigured", "", "startNanos", "", "component", "Ljava/awt/Component;", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "isTrackedPopup", "isTrackedPopupWindow", "window", "Ljava/awt/Window;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class PopupShowingTimeTracker {
    @NotNull
    public static final PopupShowingTimeTracker INSTANCE = new PopupShowingTimeTracker();
    @NotNull
    private static final Key<Boolean> MARKER_KEY;

    private PopupShowingTimeTracker() {
    }

    @JvmStatic
    public static final void showElapsedMillisIfConfigured(long startNanos, @NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (startNanos <= 0L || !Registry.Companion.is("ide.diagnostics.show.context.menu.invocation.time") || AppMode.isRemoteDevHost()) {
            return;
        }
        UiNotifyConnector.Companion.doWhenFirstShown(component2, false, () -> PopupShowingTimeTracker.showElapsedMillisIfConfigured$lambda$0(component2, startNanos));
    }

    public final void showElapsedMillisIfConfigured(long startNanos, @NotNull JBPopup popup2) {
        Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
        if (!Registry.Companion.is("ide.diagnostics.show.context.menu.invocation.time")) {
            return;
        }
        if (AppMode.isRemoteDevHost()) {
            AbstractPopup abstractPopup = popup2 instanceof AbstractPopup ? (AbstractPopup)popup2 : null;
            if (abstractPopup != null) {
                abstractPopup.putUserData(MARKER_KEY, true);
            }
            return;
        }
        JComponent jComponent = popup2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContent(...)");
        PopupShowingTimeTracker.showElapsedMillisIfConfigured(startNanos, jComponent);
    }

    public final boolean isTrackedPopup(@NotNull JBPopup popup2) {
        Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
        Object object = popup2 instanceof AbstractPopup ? (AbstractPopup)popup2 : null;
        return object != null && (object = ((AbstractPopup)object).getUserData(MARKER_KEY)) != null ? (Boolean)object : false;
    }

    public final boolean isTrackedPopupWindow(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        JBPopup popup2 = PopupUtil.getPopupFor((Window)window);
        return popup2 != null && this.isTrackedPopup(popup2);
    }

    private static final Unit showElapsedMillisIfConfigured$lambda$0(Component $component, long $startNanos) {
        block0: {
            Window window = UIUtil.getWindow((Component)$component);
            if (window == null) break block0;
            window.addWindowListener(new WindowAdapter($startNanos){
                final /* synthetic */ long $startNanos;
                {
                    this.$startNanos = $startNanos;
                }

                public void windowOpened(WindowEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    long time = TimeoutUtil.getDurationMillis((long)this.$startNanos);
                    String string = System.getProperty("perf.test.popup.name");
                    if (string != null) {
                        String string2 = string;
                        long l = this.$startNanos;
                        String popupName = string2;
                        boolean bl = false;
                        long startTimeUnixNano = l + StartUpMeasurer.getStartTimeUnixNanoDiff();
                        Utils.INSTANCE.getTracer$intellij_platform_ide_impl(false).spanBuilder("popupShown#" + popupName).setStartTimestamp(startTimeUnixNano, TimeUnit.NANOSECONDS).startSpan().end(startTimeUnixNano + TimeUnit.MILLISECONDS.toNanos(time), TimeUnit.NANOSECONDS);
                    }
                    e.getWindow().removeWindowListener(this);
                    new Notification("System Messages", "Popup invocation took " + time + " ms", NotificationType.INFORMATION).notify(null);
                }
            });
        }
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"PopupShowingTimeMarker");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MARKER_KEY = key;
    }
}

