/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.Dumpable;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.actions.DistractionFreeModeController;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDManagerImpl;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.ide.ui.laf.MouseDragSelectionEventHandler;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorHostedComponent;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler;
import com.intellij.openapi.editor.actionSystem.LatencyListener;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actions.ChangeEditorFontSizeStrategy;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorModel;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.impl.AccessibleGutterLine;
import com.intellij.openapi.editor.impl.BasicScrollBarUiButtonHolder;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorActionPlan;
import com.intellij.openapi.editor.impl.EditorCaretMoveService;
import com.intellij.openapi.editor.impl.EditorCaretRepaintService;
import com.intellij.openapi.editor.impl.EditorColorSchemeDelegate;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorCopyPastProvider;
import com.intellij.openapi.editor.impl.EditorFilteringMarkupModelEx;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorHeaderPanel;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.editor.impl.EditorHighlightingPredicate;
import com.intellij.openapi.editor.impl.EditorHighlightingPredicateWrapper;
import com.intellij.openapi.editor.impl.EditorInputMethodSupport;
import com.intellij.openapi.editor.impl.EditorLocation;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.EditorModelImpl;
import com.intellij.openapi.editor.impl.EditorMousePopupActionGroup;
import com.intellij.openapi.editor.impl.EditorSizeAdjustmentStrategy;
import com.intellij.openapi.editor.impl.EditorState;
import com.intellij.openapi.editor.impl.EditorTablessBorder;
import com.intellij.openapi.editor.impl.EditorTextDrawingCallback;
import com.intellij.openapi.editor.impl.EditorTransferHandler;
import com.intellij.openapi.editor.impl.FocusModeModel;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.FoldingPopupManager;
import com.intellij.openapi.editor.impl.GutterIconDropAnimator;
import com.intellij.openapi.editor.impl.HighlighterFilter;
import com.intellij.openapi.editor.impl.HighlighterListener;
import com.intellij.openapi.editor.impl.ImmediatePainter;
import com.intellij.openapi.editor.impl.IndentsModelCaretListener;
import com.intellij.openapi.editor.impl.IndentsModelImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.InputMethodInlayRenderer;
import com.intellij.openapi.editor.impl.NullEditorHighlighter;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.ad.AdTheManager;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.impl.stickyLines.StickyLinesManager;
import com.intellij.openapi.editor.impl.stickyLines.StickyLinesModel;
import com.intellij.openapi.editor.impl.stickyLines.VisualStickyLines;
import com.intellij.openapi.editor.impl.stickyLines.ui.StickyLineColors;
import com.intellij.openapi.editor.impl.stickyLines.ui.StickyLineShadowBorder;
import com.intellij.openapi.editor.impl.stickyLines.ui.StickyLineShadowPainter;
import com.intellij.openapi.editor.impl.stickyLines.ui.StickyLinesPanel;
import com.intellij.openapi.editor.impl.view.CharacterGrid;
import com.intellij.openapi.editor.impl.view.CharacterGridImpl;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.rd.LocalEditorSupportUtil;
import com.intellij.openapi.editor.state.ObservableStateListener;
import com.intellij.openapi.editor.toolbar.floating.EditorFloatingToolbar;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.NewUI;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.mac.MacGestureSupportInstaller;
import com.intellij.ui.mac.touchbar.TouchbarSupport;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.font.TextHitInfo;
import java.awt.geom.Point2D;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TooManyListenersException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.Job;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class EditorImpl
extends UserDataHolderBase
implements EditorEx,
HighlighterClient,
Queryable,
Dumpable,
CodeStyleSettingsListener,
FocusListener {
    public static final int TEXT_ALIGNMENT_LEFT = 0;
    public static final int TEXT_ALIGNMENT_RIGHT = 1;
    private static final Object CUSTOM_LAYER_MARKER = new Object();
    static final float MIN_FONT_SIZE = 4.0f;
    private static final Logger LOG = Logger.getInstance(EditorImpl.class);
    static final Logger EVENT_LOG = Logger.getInstance((String)"editor.input.events");
    static final Object DND_COMMAND_GROUP = ObjectUtils.sentinel((String)"DndCommand");
    private static final Object MOUSE_DRAGGED_COMMAND_GROUP = ObjectUtils.sentinel((String)"MouseDraggedGroup");
    private static final Key<JComponent> PERMANENT_HEADER = Key.create((String)"PERMANENT_HEADER");
    static final Key<Boolean> CONTAINS_BIDI_TEXT = Key.create((String)"contains.bidi.text");
    public static final Key<Boolean> FORCED_SOFT_WRAPS = Key.create((String)"forced.soft.wraps");
    public static final Key<Boolean> SOFT_WRAPS_EXIST = Key.create((String)"soft.wraps.exist");
    public static final Key<Boolean> DISABLE_CARET_POSITION_KEEPING = Key.create((String)"editor.disable.caret.position.keeping");
    public static final Key<Boolean> DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION = Key.create((String)"editor.disable.caret.shift.on.whitespace.insertion");
    public static final Key<Boolean> DISABLE_REMOVE_ON_DROP = Key.create((String)"editor.disable.remove.on.drop");
    private static final boolean HONOR_CAMEL_HUMPS_ON_TRIPLE_CLICK = Boolean.parseBoolean(System.getProperty("idea.honor.camel.humps.on.triple.click"));
    private static final Key<BufferedImage> BUFFER = Key.create((String)"buffer");
    @ApiStatus.Internal
    public static final Key<CodeStyleSettings> CODE_STYLE_SETTINGS = Key.create((String)"editor.code.style.settings");
    @NotNull
    private final DocumentEx myDocument;
    private final JPanel myPanel;
    @NotNull
    private final MyScrollPane myScrollPane;
    @NotNull
    private final EditorComponentImpl myEditorComponent;
    @NotNull
    private final EditorGutterComponentImpl myGutterComponent;
    @Nullable
    private final StickyLinesManager myStickyLinesManager;
    private final TraceableDisposable myTraceableDisposable;
    private final FocusModeModel myFocusModeModel;
    private volatile long myLastTypedActionTimestamp;
    private String myLastTypedAction;
    private LatencyListener myLatencyPublisher;
    private static final Cursor EMPTY_CURSOR;
    private final Map<Object, Cursor> myCustomCursors;
    private Cursor myDefaultCursor;
    boolean myCursorSetExternally;
    @NotNull
    private final EditorCaretRepaintService caretRepaintService;
    private static final Integer SCROLL_PANE_LAYER;
    private static final Integer STICKY_PANEL_LAYER;
    private static final Integer VERTICAL_SCROLLBAR_LAYER;
    private static final Integer FLOATING_TOOLBAR_LAYER;
    private static final Integer STATUS_COMPONENT_LAYER;
    private final CommandProcessor myCommandProcessor;
    @NotNull
    private final MyScrollBar myVerticalScrollBar;
    private final List<EditorMouseListener> myMouseListeners;
    @NotNull
    private final List<EditorMouseMotionListener> myMouseMotionListeners;
    @NotNull
    final CaretCursor myCaretCursor;
    private final ScrollingTimer myScrollingTimer;
    @NotNull
    private final SettingsImpl mySettings;
    @NotNull
    private final EditorState myState;
    private boolean isReleased;
    private boolean mySuppressPainting;
    private boolean mySuppressDisposedPainting;
    @Nullable
    private MouseEvent myMousePressedEvent;
    @Nullable
    private MouseEvent myMouseMovedEvent;
    private final MouseListener myMouseListener;
    private final MouseMotionListener myMouseMotionListener;
    @Nullable
    private EditorMouseEventArea myMousePressArea;
    private int mySavedSelectionStart;
    private int mySavedSelectionEnd;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final EditorCopyPastProvider myEditable;
    @NotNull
    private EditorColorSchemeDelegate myScheme;
    @NotNull
    private final SelectionModelImpl mySelectionModel;
    @NotNull
    private final EditorMarkupModelImpl myMarkupModel;
    @NotNull
    private final EditorFilteringMarkupModelEx myEditorFilteringMarkupModel;
    @NotNull
    private final MarkupModelListener myMarkupModelListener;
    @NotNull
    private final List<HighlighterListener> myHighlighterListeners;
    @NotNull
    private final FoldingModelImpl myFoldingModel;
    @NotNull
    private final ScrollingModelImpl myScrollingModel;
    @NotNull
    private final CaretModelImpl myCaretModel;
    @NotNull
    private final SoftWrapModelImpl mySoftWrapModel;
    @NotNull
    private final InlayModelImpl myInlayModel;
    @MouseSelectionState
    private int myMouseSelectionState;
    @Nullable
    private FoldRegion myMouseSelectedRegion;
    private PanelWithFloatingToolbar myLayeredPane;
    private EditorFloatingToolbar editorFloatingToolbar;
    private static final int MOUSE_SELECTION_STATE_NONE = 0;
    private static final int MOUSE_SELECTION_STATE_WORD_SELECTED = 1;
    private static final int MOUSE_SELECTION_STATE_LINE_SELECTED = 2;
    private volatile EditorHighlighter myHighlighter;
    private Disposable myHighlighterDisposable;
    private boolean myKeepSelectionOnMousePress;
    private boolean myUpdateCursor;
    private final EditorScrollingPositionKeeper myScrollingPositionKeeper;
    private boolean myRestoreScrollingPosition;
    private int myRangeToRepaintStart;
    private int myRangeToRepaintEnd;
    @Nullable
    private final Project myProject;
    private long myMouseSelectionChangeTimestamp;
    private int mySavedCaretOffsetForDNDUndoHack;
    private final List<FocusChangeListener> myFocusListeners;
    private EditorInputMethodSupport myInputMethodSupport;
    private final MouseDragSelectionEventHandler mouseDragHandler;
    private VirtualFile myVirtualFile;
    @Nullable
    private Dimension myPreferredSize;
    private final SingleEdtTaskScheduler mouseSelectionStateAlarm;
    private Runnable mouseSelectionStateResetRunnable;
    private final SingleEdtTaskScheduler errorStripeDelayedRepaintAlarm;
    private int myDragOnGutterSelectionStartLine;
    private RangeMarker myDraggedRange;
    private boolean myMouseDragStarted;
    private boolean myDragStarted;
    private boolean myDragSelectionStarted;
    @NotNull
    private final JPanel myHeaderPanel;
    @Nullable
    private MouseEvent myInitialMouseEvent;
    private boolean myIgnoreMouseEventsConsecutiveToInitial;
    private EditorDropHandler myDropHandler;
    private final HighlighterFilter myHighlightingFilter;
    @NotNull
    private final IndentsModel myIndentsModel;
    private int myStickySelectionStart;
    private boolean myPurePaintingMode;
    private final EditorSizeAdjustmentStrategy mySizeAdjustmentStrategy;
    private final Disposable myDisposable;
    private List<CaretState> myCaretStateBeforeLastPress;
    LogicalPosition myLastMousePressedLocation;
    private Point myLastMousePressedPoint;
    private boolean myLastPressedOnGutter;
    private boolean myLastPressedOnGutterIcon;
    private VisualPosition myTargetMultiSelectionPosition;
    private boolean myMultiSelectionInProgress;
    private boolean myRectangularSelectionInProgress;
    private boolean myLastPressCreatedCaret;
    private boolean myLastPressWasAtBlockInlay;
    private boolean myCurrentDragIsSubstantial;
    private boolean myForcePushHappened;
    @Nullable
    private VisualPosition mySuppressedByBreakpointsLastPressPosition;
    private CaretImpl myPrimaryCaret;
    public final boolean myDisableRtl;
    @Deprecated(forRemoval=true)
    public Object myFractionalMetricsHintValue;
    private final EditorModel myEditorModel;
    @Nullable
    private final EditorModel myAdEditorModel;
    final EditorView myView;
    @Nullable
    final EditorView myAdView;
    private final TextDrawingCallback myTextDrawingCallback;
    @Nullable
    private CharacterGridImpl myCharacterGrid;
    private boolean myCharKeyPressed;
    private boolean myNeedToSelectPreviousChar;
    boolean myDocumentChangeInProgress;
    private volatile long myErrorStripeNeedsRepaintRange;
    private final List<EditorPopupHandler> myPopupHandlers;
    private final ImmediatePainter myImmediatePainter;
    private final List<IntFunction<? extends @NotNull Collection<? extends LineExtensionInfo>>> myLineExtensionPainters;
    private volatile int myExpectedCaretOffset;
    private boolean myBackgroundImageSet;
    private final EditorKind myKind;
    private boolean myScrollingToCaret;
    private boolean myIsStickyLinePainting;
    private final AtomicBoolean gainedFocus;
    private final AtomicReference<HighlighterChange> myCompositeHighlighterChange;
    private final Object NON_RELEASABLE_BLOCK_GUARD;
    private boolean updatingSize;
    @ApiStatus.Internal
    final ConcurrentHashMap<Caret, Pair<Point2D, @Nullable LogicalPosition>> lastPosMap;
    @ApiStatus.Internal
    @Nullable
    Job caretAnimationJob;
    @NotNull
    private final EditorCaretMoveService caretMoveService;

    EditorImpl(@NotNull Document document2, boolean viewer, @Nullable Project project2, @NotNull EditorKind kind, @Nullable VirtualFile file2, @Nullable EditorHighlighter highlighter) {
        if (document2 == null) {
            EditorImpl.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            EditorImpl.$$$reportNull$$$0(1);
        }
        this.myTraceableDisposable = new TraceableDisposable(true);
        this.myLastTypedActionTimestamp = -1L;
        this.myCustomCursors = new LinkedHashMap<Object, Cursor>();
        this.caretRepaintService = EditorCaretRepaintService.getInstance();
        this.myMouseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMouseMotionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myScrollingTimer = new ScrollingTimer();
        this.myMouseListener = new MyMouseAdapter();
        this.myMouseMotionListener = new MyMouseMotionListener();
        this.mySavedSelectionStart = -1;
        this.mySavedSelectionEnd = -1;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myEditable = new EditorCopyPastProvider(this);
        this.myHighlighterListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myHighlighterDisposable = Disposer.newDisposable();
        this.myFocusListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.mouseDragHandler = new MouseDragSelectionEventHandler((Function1<? super MouseEvent, Unit>)((Function1)e -> {
            this.processMouseDragged((MouseEvent)e);
            return Unit.INSTANCE;
        }));
        this.mouseSelectionStateAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
        this.errorStripeDelayedRepaintAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
        this.myDragOnGutterSelectionStartLine = -1;
        this.myHighlightingFilter = new HighlighterFilter();
        this.mySizeAdjustmentStrategy = new EditorSizeAdjustmentStrategy();
        this.myDisposable = Disposer.newDisposable();
        this.myDisableRtl = Registry.is((String)"editor.disable.rtl");
        this.myFractionalMetricsHintValue = UISettings.getEditorFractionalMetricsHint();
        this.myErrorStripeNeedsRepaintRange = -1L;
        this.myPopupHandlers = new ArrayList<EditorPopupHandler>();
        this.myLineExtensionPainters = new SmartList();
        this.myExpectedCaretOffset = -1;
        this.gainedFocus = new AtomicBoolean(false);
        this.myCompositeHighlighterChange = new AtomicReference();
        this.NON_RELEASABLE_BLOCK_GUARD = ObjectUtils.sentinel((String)"NON_RELEASABLE_BLOCK_GUARD");
        this.lastPosMap = new ConcurrentHashMap();
        this.caretAnimationJob = null;
        this.caretMoveService = EditorCaretMoveService.getInstance();
        EditorImpl.assertIsDispatchThread();
        this.myProject = project2;
        this.myDocument = (DocumentEx)document2;
        this.myVirtualFile = file2;
        this.myState = new EditorState();
        this.myState.refreshAll();
        EditorColorsScheme boundColorScheme = this.createBoundColorSchemeDelegate(null);
        if (boundColorScheme instanceof EditorColorSchemeDelegate) {
            this.myScheme = (EditorColorSchemeDelegate)boundColorScheme;
        } else {
            LOG.warn("createBoundColorSchemeDelegate created delegate of type '%s'. Will wrap it with MyColorSchemeDelegate".formatted(boundColorScheme.getClass()), new Throwable());
            this.myScheme = new EditorColorSchemeDelegate(this, boundColorScheme);
        }
        this.myScrollPane = new MyScrollPane();
        this.myScrollPane.setBackground((Color)JBColor.lazy(this::getBackgroundColor));
        this.myState.setViewer(viewer);
        this.myKind = kind;
        this.mySettings = new SettingsImpl(this, kind, project2);
        MarkupModelEx documentMarkup = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)this.myDocument, (Project)this.myProject, (boolean)true);
        this.mySelectionModel = new SelectionModelImpl(this);
        this.myMarkupModel = new EditorMarkupModelImpl(this);
        this.myEditorFilteringMarkupModel = new EditorFilteringMarkupModelEx(this, documentMarkup);
        this.myFoldingModel = new FoldingModelImpl(this);
        this.myCaretModel = new CaretModelImpl(this);
        this.myScrollingModel = new ScrollingModelImpl(this);
        this.myInlayModel = new InlayModelImpl(this);
        Disposer.register((Disposable)this.myCaretModel, (Disposable)this.myInlayModel);
        this.mySoftWrapModel = new SoftWrapModelImpl(this);
        this.myCommandProcessor = CommandProcessor.getInstance();
        this.myImmediatePainter = new ImmediatePainter(this);
        this.myMarkupModelListener = new MarkupModelListener(){

            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(0);
                }
                TextAttributes attributes = highlighter.getTextAttributes(EditorImpl.this.getColorsScheme());
                EditorImpl.this.onHighlighterChanged(highlighter, EditorImpl.this.myGutterComponent.canImpactSize(highlighter), EditorUtil.attributesImpactFontStyle(attributes), EditorUtil.attributesImpactForegroundColor(attributes));
            }

            public void afterRemoved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(1);
                }
                TextAttributes attributes = highlighter.getTextAttributes(EditorImpl.this.getColorsScheme());
                EditorImpl.this.onHighlighterChanged(highlighter, EditorImpl.this.myGutterComponent.canImpactSize(highlighter), EditorUtil.attributesImpactFontStyle(attributes), EditorUtil.attributesImpactForegroundColor(attributes));
            }

            public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(2);
                }
                EditorImpl.this.onHighlighterChanged(highlighter, renderersChanged, fontStyleChanged, foregroundColorChanged);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "highlighter";
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "attributesChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myIndentsModel = new IndentsModelImpl(this);
        this.myCaretCursor = new CaretCursor();
        this.myState.setVerticalScrollBarOrientation(1);
        this.setHighlighter((EditorHighlighter)(highlighter == null ? new NullEditorHighlighter() : highlighter));
        new FoldingPopupManager(this);
        this.myEditorComponent = new EditorComponentImpl(this);
        this.myVerticalScrollBar = (MyScrollBar)((Object)this.myScrollPane.getVerticalScrollBar());
        if (this.shouldScrollBarBeOpaque()) {
            this.myVerticalScrollBar.setOpaque(true);
        }
        this.myPanel = new JPanel();
        this.myPanel.putClientProperty(UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> {
            JComponent component2 = this.getPermanentHeaderComponent();
            if (component2 != null && component2.getParent() == null) {
                return Collections.singleton(component2).iterator();
            }
            return Collections.emptyIterator();
        });
        this.myPanel.putClientProperty(DslComponentProperty.VERTICAL_COMPONENT_GAP, VerticalComponentGap.BOTH);
        this.myHeaderPanel = new EditorHeaderPanel(this);
        this.myGutterComponent = new EditorGutterComponentImpl(this);
        this.myGutterComponent.putClientProperty(ColorKey.FUNCTION_KEY, key -> this.getColorsScheme().getColor(key));
        this.initComponent();
        this.myStickyLinesManager = this.createStickyLinesPanel();
        if (this.myStickyLinesManager != null) {
            this.myScrollPane.placeStatusOnTopOfStickyPanel();
        }
        this.myFocusModeModel = new FocusModeModel(this);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myFocusModeModel);
        this.myEditorModel = new EditorModelImpl(this);
        this.myAdEditorModel = AdTheManager.getInstance().getEditorModel(this);
        this.myView = new EditorView(this, this.myEditorModel);
        this.myAdView = this.myAdEditorModel == null ? null : new EditorView(this, this.myAdEditorModel);
        this.myTextDrawingCallback = new EditorTextDrawingCallback(this.myView);
        this.myView.reinitSettings();
        if (this.myAdView != null) {
            this.myAdView.reinitSettings();
        }
        if (LOG.isDebugEnabled()) {
            float scaledEditorFontSize = UISettingsUtils.getInstance().getScaledEditorFontSize();
            int currentFontSize = this.myScheme.getEditorFontSize();
            LOG.debug(String.format("Creating editor view of type %s.\nCurrent font size: %d\nScaled font size: %f", kind, currentFontSize, Float.valueOf(scaledEditorFontSize)));
        }
        this.myScheme.setEditorFontSize(UISettingsUtils.getInstance().getScaledEditorFontSize());
        this.myGutterComponent.updateSize();
        this.myEditorComponent.setSize(this.getPreferredSize());
        this.updateCaretCursor();
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && SystemInfoRt.isMac && SystemInfo.isJetBrainsJvm) {
            MacGestureSupportInstaller.installOnComponent(this.getComponent(), e -> {
                this.myForcePushHappened = true;
            });
        }
        this.myPopupHandlers.add(new DefaultPopupHandler());
        this.myScrollingPositionKeeper = new EditorScrollingPositionKeeper(this);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScrollingPositionKeeper);
        this.addListeners();
        if (this.myAdEditorModel != null) {
            AdTheManager.getInstance().bindEditor(this);
        }
    }

    private void addListeners() {
        this.myMarkupModel.addErrorMarkerListener(new ErrorStripeListener(){

            @Override
            public void errorMarkerChanged(@NotNull ErrorStripeEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                EditorImpl.this.errorStripeMarkerChanged((RangeHighlighterEx)e.getHighlighter());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$2", "errorMarkerChanged"));
            }
        }, this.myCaretModel);
        this.myEditorFilteringMarkupModel.addMarkupModelListener(this.myCaretModel, this.myMarkupModelListener);
        this.myMarkupModel.addMarkupModelListener(this.myCaretModel, this.myMarkupModelListener);
        this.myDocument.addDocumentListener((DocumentListener)this.myFoldingModel, (Disposable)this.myCaretModel);
        this.myDocument.addDocumentListener((DocumentListener)this.myCaretModel, (Disposable)this.myCaretModel);
        this.myDocument.addDocumentListener((DocumentListener)new EditorDocumentAdapter(), (Disposable)this.myCaretModel);
        this.myDocument.addDocumentListener((DocumentListener)this.mySoftWrapModel, (Disposable)this.myCaretModel);
        this.myDocument.addDocumentListener((DocumentListener)this.myMarkupModel, (Disposable)this.myCaretModel);
        this.myFoldingModel.addListener(this.mySoftWrapModel, this.myCaretModel);
        this.myInlayModel.addListener((InlayModel.Listener)this.myFoldingModel, this.myCaretModel);
        this.myInlayModel.addListener(this.myCaretModel, this.myCaretModel);
        this.myCaretModel.addCaretListener(new IndentsModelCaretListener(this));
        this.myCaretModel.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (EditorImpl.this.myState.isStickySelection()) {
                    int selectionStart = Math.min(EditorImpl.this.myStickySelectionStart, EditorImpl.this.getDocument().getTextLength());
                    EditorImpl.this.mySelectionModel.setSelection(selectionStart, EditorImpl.this.myCaretModel.getVisualPosition(), EditorImpl.this.myCaretModel.getOffset());
                }
            }

            public void caretAdded(@NotNull CaretEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (EditorImpl.this.myPrimaryCaret != null) {
                    EditorImpl.this.myPrimaryCaret.updateVisualPosition();
                }
                EditorImpl.this.repaintCaretRegion(e);
                EditorImpl.this.myPrimaryCaret = EditorImpl.this.myCaretModel.getPrimaryCaret();
            }

            public void caretRemoved(@NotNull CaretEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                EditorImpl.this.repaintCaretRegion(e);
                EditorImpl.this.myPrimaryCaret = EditorImpl.this.myCaretModel.getPrimaryCaret();
                EditorImpl.this.myPrimaryCaret.updateVisualPosition();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretPositionChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretAdded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myCaretModel.addCaretListener(this.myMarkupModel, this.myCaretModel);
        this.mySoftWrapModel.addSoftWrapChangeListener(new SoftWrapChangeListener(){

            @Override
            public void recalculationEnds() {
                if (EditorImpl.this.myCaretModel.isUpToDate()) {
                    EditorImpl.this.myCaretModel.updateVisualPosition();
                }
            }

            @Override
            public void softWrapsChanged() {
                EditorImpl.this.myGutterComponent.clearLineToGutterRenderersCache();
            }
        });
        this.myInlayModel.addListener((InlayModel.Listener)new InlayModel.SimpleAdapter(){

            public void onUpdated(@NotNull Inlay<?> inlay, int changeFlags) {
                if (inlay == null) {
                    5.$$$reportNull$$$0(0);
                }
                EditorImpl.this.onInlayUpdated(inlay, changeFlags);
            }

            public void onBatchModeFinish(@NotNull Editor editor2) {
                if (editor2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                EditorImpl.this.onInlayBatchModeFinish();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inlay";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onUpdated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBatchModeFinish";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.myCaretModel);
        this.myScrollingModel.addVisibleAreaListener(this::moveCaretIntoViewIfCoveredByToolWindowBelow);
        this.myScrollingModel.addVisibleAreaListener(this.myMarkupModel);
        PropertyChangeListener propertyChangeListener = e -> {
            if ("writable".equals(e.getPropertyName())) {
                this.myEditorComponent.repaint();
            }
        };
        this.myDocument.addPropertyChangeListener(propertyChangeListener);
        Disposer.register((Disposable)this.myDisposable, () -> this.myDocument.removePropertyChangeListener(propertyChangeListener));
        CodeStyleSettingsManager.getInstance((Project)this.myProject).subscribe((CodeStyleSettingsListener)this, this.myDisposable);
        this.myState.addPropertyChangeListener((ObservableStateListener.PropertyChangeEvent event) -> {
            switch (event.getPropertyName()) {
                case "isInsertMode": {
                    this.isInsertModeChanged(event);
                    break;
                }
                case "isColumnMode": {
                    this.isColumnModeChanged(event);
                    break;
                }
                case "isOneLineMode": {
                    this.isOneLineModeChanged(event);
                    break;
                }
                case "isEmbeddedIntoDialogWrapper": {
                    this.isEmbeddedIntoDialogWrapperChanged(event);
                    break;
                }
                case "verticalScrollBarOrientation": {
                    this.verticalScrollBarOrientationChanged(event);
                    break;
                }
                case "isStickySelection": {
                    this.isStickySelectionChanged(event);
                    break;
                }
                case "myBorder": {
                    this.borderChanged();
                }
            }
        }, this.myDisposable);
        ApplicationManager.getApplication().getMessageBus().connect(this.myDisposable).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            private void clearCachedCodeStyleSettings() {
                EditorImpl.this.putUserData(CODE_STYLE_SETTINGS, null);
            }

            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    6.$$$reportNull$$$0(0);
                }
                this.clearCachedCodeStyleSettings();
            }

            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    6.$$$reportNull$$$0(1);
                }
                this.clearCachedCodeStyleSettings();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void applyFocusMode() {
        this.myFocusModeModel.applyFocusMode(this.myCaretModel.getPrimaryCaret());
    }

    public boolean isInFocusMode(@NotNull FoldRegion region) {
        if (region == null) {
            EditorImpl.$$$reportNull$$$0(2);
        }
        return this.myFocusModeModel.isInFocusMode((RangeMarker)region);
    }

    public Segment getFocusModeRange() {
        return this.myFocusModeModel.getFocusModeRange();
    }

    @NotNull
    public FocusModeModel getFocusModeModel() {
        FocusModeModel focusModeModel = this.myFocusModeModel;
        if (focusModeModel == null) {
            EditorImpl.$$$reportNull$$$0(3);
        }
        return focusModeModel;
    }

    @Override
    public void focusGained(@NotNull FocusEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(4);
        }
        this.myCaretCursor.activate();
        this.gainedFocus.set(true);
        for (Caret caret : this.myCaretModel.getAllCarets()) {
            int caretLine = caret.getLogicalPosition().line;
            this.repaintLines(caretLine, caretLine);
        }
        this.fireFocusGained(e);
    }

    @Override
    public void focusLost(@NotNull FocusEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(5);
        }
        this.clearCaretThread();
        for (Caret caret : this.myCaretModel.getAllCarets()) {
            int caretLine = caret.getLogicalPosition().line;
            this.repaintLines(caretLine, caretLine);
        }
        this.fireFocusLost(e);
    }

    private void queueErrorStipeRepaintRequest(int start2, int end) {
        long range = this.myErrorStripeNeedsRepaintRange;
        long requested = TextRangeScalarUtil.toScalarRange((int)start2, (int)end);
        this.myErrorStripeNeedsRepaintRange = TextRangeScalarUtil.union((long)(range == -1L ? requested : range), (long)requested);
        this.errorStripeDelayedRepaintAlarm.cancelAndRequest(50L, () -> this.invokeDelayedErrorStripeRepaint());
    }

    private void errorStripeMarkerChanged(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            EditorImpl.$$$reportNull$$$0(6);
        }
        int start2 = highlighter.getAffectedAreaStartOffset();
        int end = highlighter.getAffectedAreaEndOffset();
        this.queueErrorStipeRepaintRequest(start2, end);
    }

    private void onHighlighterChanged(@NotNull RangeHighlighterEx highlighter, boolean canImpactGutterSize, boolean fontStyleChanged, boolean foregroundColorChanged) {
        boolean isAccessibleGutterElement;
        int hend;
        if (highlighter == null) {
            EditorImpl.$$$reportNull$$$0(7);
        }
        int textLength = this.myDocument.getTextLength();
        int hstart = MathUtil.clamp((int)highlighter.getAffectedAreaStartOffset(), (int)0, (int)textLength);
        HighlighterChange change = new HighlighterChange(hstart, hend = MathUtil.clamp((int)highlighter.getAffectedAreaEndOffset(), (int)hstart, (int)textLength), canImpactGutterSize, fontStyleChanged, foregroundColorChanged, isAccessibleGutterElement = AccessibleGutterLine.isAccessibleGutterElement(highlighter.getGutterIconRenderer()), false);
        HighlighterChange oldChange = this.myCompositeHighlighterChange.getAndAccumulate(change, (change1, change2) -> {
            if (change1 == null) {
                return change2;
            }
            if (change2 == null) {
                return change1;
            }
            int start2 = MathUtil.clamp((int)Math.min(change1.affectedStart, change2.affectedStart), (int)0, (int)textLength);
            int end2 = MathUtil.clamp((int)Math.max(change1.affectedEnd, change2.affectedEnd), (int)0, (int)textLength);
            return new HighlighterChange(start2, end2, change1.canImpactGutterSize() || change2.canImpactGutterSize(), change1.fontStyleChanged() || change2.fontStyleChanged(), change1.foregroundColorChanged() || change2.foregroundColorChanged(), change1.isAccessibleGutterElement() || change2.isAccessibleGutterElement(), change1.needRestart() || change2.needRestart());
        });
        if (oldChange == null || oldChange.needRestart()) {
            EdtInvocationManager.invokeLaterIfNeeded(() -> {
                if (this.isDisposed() || this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode() || this.myDocumentChangeInProgress) {
                    this.myCompositeHighlighterChange.getAndUpdate(old -> old == null ? null : new HighlighterChange(old.affectedStart(), old.affectedEnd(), old.canImpactGutterSize(), old.fontStyleChanged(), old.foregroundColorChanged(), old.isAccessibleGutterElement(), true));
                    return;
                }
                HighlighterChange newChange = this.myCompositeHighlighterChange.getAndSet(null);
                if (newChange == null) {
                    return;
                }
                if (newChange.canImpactGutterSize()) {
                    this.updateGutterSize();
                }
                int docTextLength = this.myDocument.getTextLength();
                int start2 = MathUtil.clamp((int)newChange.affectedStart(), (int)0, (int)docTextLength);
                int end = MathUtil.clamp((int)newChange.affectedEnd(), (int)start2, (int)docTextLength);
                if (this.myGutterComponent.getCurrentAccessibleLine() != null && newChange.isAccessibleGutterElement()) {
                    this.escapeGutterAccessibleLine(start2, end);
                }
                int startLine = this.myDocument.getLineNumber(start2);
                int endLine = this.myDocument.getLineNumber(end);
                if (start2 != end && (newChange.fontStyleChanged() || newChange.foregroundColorChanged())) {
                    this.myView.invalidateRange(start2, end, newChange.fontStyleChanged());
                    if (this.myAdView != null) {
                        this.myAdView.invalidateRange(start2, end, newChange.fontStyleChanged());
                    }
                }
                if (!this.myFoldingModel.isInBatchFoldingOperation()) {
                    this.repaintLines(Math.max(0, startLine - 1), Math.min(endLine + 1, this.getDocument().getLineCount()));
                }
                this.updateCaretCursor();
            });
        }
    }

    private void onInlayUpdated(@NotNull Inlay<?> inlay, int changeFlags) {
        if (inlay == null) {
            EditorImpl.$$$reportNull$$$0(8);
        }
        if (this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode()) {
            return;
        }
        if ((changeFlags & 4) != 0) {
            this.updateGutterSize();
        }
        if (this.myDocument.isInEventsHandling() || (changeFlags & 3) == 0) {
            return;
        }
        this.validateSize();
        int offset = inlay.getOffset();
        Inlay.Placement placement = inlay.getPlacement();
        if (placement == Inlay.Placement.INLINE) {
            this.repaint(offset, offset, false);
        } else if (placement == Inlay.Placement.AFTER_LINE_END) {
            int lineEndOffset = DocumentUtil.getLineEndOffset((int)offset, (Document)this.myDocument);
            this.repaint(lineEndOffset, lineEndOffset, false);
        } else {
            int visualLine = this.offsetToVisualLine(offset);
            int y = EditorUtil.getVisualLineAreaStartY(this, visualLine);
            this.repaintToScreenBottomStartingFrom(y);
        }
    }

    private void onInlayBatchModeFinish() {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.validateSize();
        this.updateGutterSize();
        this.myEditorComponent.repaint();
        this.myGutterComponent.repaint();
        this.myMarkupModel.repaint();
        this.updateCaretCursor();
    }

    private void moveCaretIntoViewIfCoveredByToolWindowBelow(@NotNull VisibleAreaEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(9);
        }
        EditorThreading.run(() -> {
            int caretY;
            Rectangle oldRectangle = e.getOldRectangle();
            Rectangle newRectangle = e.getNewRectangle();
            if (!this.myScrollingToCaret && oldRectangle != null && oldRectangle.height != newRectangle.height && oldRectangle.y == newRectangle.y && newRectangle.height > 0 && (double)(caretY = this.myView.visualLineToY(this.myCaretModel.getVisualPosition().line)) < oldRectangle.getMaxY() && (double)caretY > newRectangle.getMaxY()) {
                this.myScrollingToCaret = true;
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myScrollingToCaret = false;
                    if (!this.isReleased) {
                        EditorUtil.runWithAnimationDisabled(this, () -> this.myScrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE));
                    }
                }, ModalityState.any());
            }
        });
    }

    boolean shouldScrollBarBeOpaque() {
        return !this.myBackgroundImageSet && !Registry.is((String)"editor.transparent.scrollbar");
    }

    @NotNull
    static Color adjustThumbColor(@NotNull Color base, boolean dark) {
        if (base == null) {
            EditorImpl.$$$reportNull$$$0(10);
        }
        Color color = dark ? ColorUtil.withAlpha((Color)ColorUtil.shift((Color)base, (double)1.35), (double)0.5) : ColorUtil.withAlpha((Color)ColorUtil.shift((Color)base, (double)0.68), (double)0.4);
        if (color == null) {
            EditorImpl.$$$reportNull$$$0(11);
        }
        return color;
    }

    boolean isDarkEnough() {
        return ColorUtil.isDark((Color)this.getBackgroundColor());
    }

    private void repaintCaretRegion(@NotNull CaretEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(12);
        }
        CaretImpl caretImpl = (CaretImpl)e.getCaret();
        caretImpl.updateVisualPosition();
        if (caretImpl.hasSelection()) {
            this.repaint(caretImpl.getSelectionStart(), caretImpl.getSelectionEnd(), false);
        }
    }

    @Override
    @NotNull
    public EditorColorsScheme createBoundColorSchemeDelegate(@Nullable EditorColorsScheme customGlobalScheme) {
        return new EditorColorSchemeDelegate(this, customGlobalScheme);
    }

    @Override
    public int getPrefixTextWidthInPixels() {
        return ((Float)EditorThreading.compute(() -> Float.valueOf(this.myView.getPrefixTextWidthInPixels()))).intValue();
    }

    @Override
    public void setPrefixTextAndAttributes(@Nullable String prefixText, @Nullable TextAttributes attributes) {
        EditorThreading.run(() -> {
            this.mySoftWrapModel.recalculate();
            this.myView.setPrefix(prefixText, attributes);
            if (this.myAdView != null) {
                this.myAdView.setPrefix(prefixText, attributes);
            }
        });
    }

    @Override
    public boolean isPurePaintingMode() {
        return this.myPurePaintingMode;
    }

    @Override
    public void setPurePaintingMode(boolean enabled2) {
        this.myPurePaintingMode = enabled2;
    }

    @Override
    public void registerLineExtensionPainter(@NotNull @NotNull IntFunction<? extends @NotNull Collection<? extends LineExtensionInfo>> lineExtensionPainter) {
        if (lineExtensionPainter == null) {
            EditorImpl.$$$reportNull$$$0(13);
        }
        this.myLineExtensionPainters.add(lineExtensionPainter);
    }

    public boolean processLineExtensions(int line, @NotNull Processor<? super LineExtensionInfo> processor2) {
        if (processor2 == null) {
            EditorImpl.$$$reportNull$$$0(14);
        }
        for (IntFunction<? extends Collection<? extends LineExtensionInfo>> intFunction : this.myLineExtensionPainters) {
            for (LineExtensionInfo lineExtensionInfo : intFunction.apply(line)) {
                if (processor2.process((Object)lineExtensionInfo)) continue;
                return false;
            }
        }
        if (this.myProject != null && this.myVirtualFile != null) {
            for (EditorLinePainter editorLinePainter : EditorLinePainter.EP_NAME.getExtensionList()) {
                Collection<LineExtensionInfo> extensions;
                if (LightEdit.owns((Project)this.myProject) && !(editorLinePainter instanceof LightEditCompatible) || (extensions = editorLinePainter.getLineExtensions(this.myProject, this.myVirtualFile, line)) == null) continue;
                for (LineExtensionInfo extension : extensions) {
                    if (processor2.process((Object)extension)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void registerScrollBarRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback) {
        this.myVerticalScrollBar.registerRepaintCallback(callback);
    }

    @Override
    public int getExpectedCaretOffset() {
        int expectedCaretOffset = this.myExpectedCaretOffset;
        return (Integer)EditorThreading.compute(() -> expectedCaretOffset == -1 ? this.getCaretModel().getOffset() : expectedCaretOffset);
    }

    @Override
    public void setContextMenuGroupId(@Nullable String groupId) {
        this.myState.setContextMenuGroupId(groupId);
    }

    @Override
    @Nullable
    public String getContextMenuGroupId() {
        return this.myState.getContextMenuGroupId();
    }

    @Override
    public void installPopupHandler(@NotNull EditorPopupHandler popupHandler2) {
        if (popupHandler2 == null) {
            EditorImpl.$$$reportNull$$$0(15);
        }
        this.myPopupHandlers.add(popupHandler2);
    }

    @ApiStatus.Internal
    @NotNull
    public List<EditorPopupHandler> getPopupHandlers() {
        List<EditorPopupHandler> list2 = this.myPopupHandlers;
        if (list2 == null) {
            EditorImpl.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @Override
    public void uninstallPopupHandler(@NotNull EditorPopupHandler popupHandler2) {
        if (popupHandler2 == null) {
            EditorImpl.$$$reportNull$$$0(17);
        }
        this.myPopupHandlers.remove(popupHandler2);
    }

    @Override
    @Nullable
    public ActionGroup getPopupActionGroup(@NotNull EditorMouseEvent event) {
        if (event == null) {
            EditorImpl.$$$reportNull$$$0(18);
        }
        if (event.getArea() == EditorMouseEventArea.EDITING_AREA) {
            for (int i2 = this.myPopupHandlers.size() - 1; i2 >= 0; --i2) {
                ActionGroup group2;
                ContextMenuPopupHandler o;
                EditorPopupHandler handler = this.myPopupHandlers.get(i2);
                if (handler instanceof ContextMenuPopupHandler) {
                    o = (ContextMenuPopupHandler)handler;
                    v0 = o.getActionGroup(event);
                } else {
                    v0 = group2 = null;
                }
                if (group2 instanceof DefaultActionGroup && (o = (DefaultActionGroup)group2).getChildrenCount() == 0 && group2.getClass() == DefaultActionGroup.class) {
                    return group2;
                }
                if (group2 == null) continue;
                return new EditorMousePopupActionGroup(group2, event);
            }
            return null;
        }
        return this.myGutterComponent.getPopupActionGroup(event);
    }

    @Nullable
    private Cursor getCustomCursor() {
        return (Cursor)ContainerUtil.getFirstItem(this.myCustomCursors.values());
    }

    @Override
    public void setCustomCursor(@NotNull Object requestor, @Nullable Cursor cursor) {
        if (requestor == null) {
            EditorImpl.$$$reportNull$$$0(19);
        }
        EditorThreading.run(() -> {
            if (cursor == null) {
                this.myCustomCursors.remove(requestor);
            } else {
                this.myCustomCursors.put(requestor, cursor);
            }
            this.updateEditorCursor();
        });
    }

    @Override
    public void setViewer(boolean isViewer) {
        this.myState.setViewer(isViewer);
    }

    public boolean isViewer() {
        return this.myState.isViewer() || this.myState.isRendererMode();
    }

    @Override
    public boolean isRendererMode() {
        return this.myState.isRendererMode();
    }

    @Override
    public void setRendererMode(boolean isRendererMode) {
        this.myState.setRendererMode(isRendererMode);
    }

    @Override
    public void setFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            EditorImpl.$$$reportNull$$$0(20);
        }
        if (vFile != this.myVirtualFile) {
            this.myVirtualFile = vFile;
            this.reinitSettings();
        }
    }

    @Override
    @Nullable
    @ApiStatus.Obsolete
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @NotNull
    public SelectionModelImpl getSelectionModel() {
        SelectionModelImpl selectionModelImpl = this.mySelectionModel;
        if (selectionModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(21);
        }
        return selectionModelImpl;
    }

    @Override
    @NotNull
    public MarkupModelEx getMarkupModel() {
        EditorMarkupModelImpl editorMarkupModelImpl = this.myMarkupModel;
        if (editorMarkupModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(22);
        }
        return editorMarkupModelImpl;
    }

    @Override
    @NotNull
    public MarkupModelEx getFilteredDocumentMarkupModel() {
        EditorFilteringMarkupModelEx editorFilteringMarkupModelEx = this.myEditorFilteringMarkupModel;
        if (editorFilteringMarkupModelEx == null) {
            EditorImpl.$$$reportNull$$$0(23);
        }
        return editorFilteringMarkupModelEx;
    }

    @Override
    @NotNull
    public FoldingModelImpl getFoldingModel() {
        FoldingModelImpl foldingModelImpl = this.myFoldingModel;
        if (foldingModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(24);
        }
        return foldingModelImpl;
    }

    @NotNull
    public CaretModelImpl getCaretModel() {
        CaretModelImpl caretModelImpl = this.myCaretModel;
        if (caretModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(25);
        }
        return caretModelImpl;
    }

    @Override
    @NotNull
    public ScrollingModelEx getScrollingModel() {
        ScrollingModelImpl scrollingModelImpl = this.myScrollingModel;
        if (scrollingModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(26);
        }
        return scrollingModelImpl;
    }

    @Override
    @NotNull
    public SoftWrapModelImpl getSoftWrapModel() {
        SoftWrapModelImpl softWrapModelImpl = this.mySoftWrapModel;
        if (softWrapModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(27);
        }
        return softWrapModelImpl;
    }

    @NotNull
    public InlayModelImpl getInlayModel() {
        InlayModelImpl inlayModelImpl = this.myInlayModel;
        if (inlayModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(28);
        }
        return inlayModelImpl;
    }

    @NotNull
    public EditorKind getEditorKind() {
        EditorKind editorKind = this.myKind;
        if (editorKind == null) {
            EditorImpl.$$$reportNull$$$0(29);
        }
        return editorKind;
    }

    @NotNull
    public EditorSettings getSettings() {
        SettingsImpl settingsImpl = this.mySettings;
        if (settingsImpl == null) {
            EditorImpl.$$$reportNull$$$0(30);
        }
        return settingsImpl;
    }

    public void resetSizes() {
        this.myView.reset();
        if (this.myAdView != null) {
            this.myAdView.reset();
        }
    }

    @Override
    public void reinitSettings() {
        this.reinitSettings(true, true);
    }

    @ApiStatus.Internal
    public void refreshEditorFloatingToolbar() {
        if (this.editorFloatingToolbar != null && this.mayShowToolbar()) {
            Disposer.dispose((Disposable)this.editorFloatingToolbar);
            this.myLayeredPane.remove(this.editorFloatingToolbar);
            UiNotifyConnector.doWhenFirstShown((Component)this.myPanel, () -> {
                EditorFloatingToolbar editorFLoatingToolbar = new EditorFloatingToolbar(this);
                this.myLayeredPane.add(editorFLoatingToolbar, FLOATING_TOOLBAR_LAYER);
                this.editorFloatingToolbar = editorFLoatingToolbar;
            }, (Disposable)this.getDisposable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    void reinitSettings(boolean bl, boolean bl2) {
        void updateGutterSize;
        void reinitSettings;
        ThreadingAssertions.assertEventDispatchThread();
        this.myScheme.updateGlobalScheme();
        boolean softWrapsUsedBefore = this.mySoftWrapModel.isSoftWrappingEnabled();
        if (reinitSettings != false) {
            this.mySettings.reinitSettings();
        }
        this.mySoftWrapModel.reinitSettings();
        this.myCaretModel.reinitSettings();
        this.mySelectionModel.reinitSettings();
        this.caretRepaintService.setBlinking(this.mySettings.isBlinkCaret());
        this.caretRepaintService.setBlinkPeriod(this.mySettings.getCaretBlinkPeriod());
        this.caretRepaintService.restart();
        this.myView.reinitSettings();
        if (this.myAdView != null) {
            this.myAdView.reinitSettings();
        }
        this.myFoldingModel.refreshSettings();
        this.myFoldingModel.rebuild();
        this.myInlayModel.reinitSettings();
        if (softWrapsUsedBefore ^ this.mySoftWrapModel.isSoftWrappingEnabled()) {
            this.validateSize();
        }
        this.myHighlighter.setColorScheme((EditorColorsScheme)this.myScheme);
        this.myGutterComponent.reinitSettings((boolean)updateGutterSize);
        this.myGutterComponent.revalidate();
        this.myEditorComponent.repaint();
        this.updateCaretCursor();
        if (this.myInitialMouseEvent != null) {
            this.myIgnoreMouseEventsConsecutiveToInitial = true;
        }
        EditorThreading.run(() -> {
            this.myCaretModel.updateVisualPosition();
            this.getCaretModel().doWithCaretMerging(() -> this.myCaretModel.getAllCarets().forEach(caret -> caret.moveToOffset(caret.getOffset())));
        });
        if (this.myVirtualFile != null && this.myProject != null) {
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        }
        if (this.myFocusModeModel != null) {
            this.myFocusModeModel.clearFocusMode();
        }
        this.myFractionalMetricsHintValue = UISettings.getEditorFractionalMetricsHint();
        this.reinitStickyLines();
    }

    @Contract(value="_->fail")
    public void throwDisposalError(@NonNls @NotNull String msg) {
        if (msg == null) {
            EditorImpl.$$$reportNull$$$0(31);
        }
        this.myTraceableDisposable.throwDisposalError(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void executeNonCancelableBlock(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            EditorImpl.$$$reportNull$$$0(32);
        }
        Object object = this.NON_RELEASABLE_BLOCK_GUARD;
        synchronized (object) {
            runnable2.run();
        }
    }

    @RequiresEdt
    void release() {
        ThreadingAssertions.assertEventDispatchThread();
        this.executeNonCancelableBlock(() -> {
            if (this.isReleased) {
                this.throwDisposalError("Double release of editor:");
            }
            this.myTraceableDisposable.kill(null);
            this.isReleased = true;
            this.mySizeAdjustmentStrategy.cancelAllRequests();
            this.cancelAutoResetForMouseSelectionState();
            this.myFoldingModel.dispose();
            this.mySoftWrapModel.release();
            this.myMarkupModel.dispose();
            this.myScrollingModel.dispose();
            this.myGutterComponent.dispose();
            this.myMousePressedEvent = null;
            this.myMouseMovedEvent = null;
            Disposer.dispose((Disposable)this.myCaretModel);
            Disposer.dispose((Disposable)this.mySoftWrapModel);
            Disposer.dispose((Disposable)this.myView);
            if (this.myAdView != null) {
                Disposer.dispose((Disposable)this.myAdView);
                Disposer.dispose((Disposable)this.myAdEditorModel);
            }
            this.clearCaretThread();
            if (this.caretAnimationJob != null) {
                this.caretAnimationJob.cancel(null);
                this.caretAnimationJob = null;
            }
            this.myFocusListeners.clear();
            this.myMouseListeners.clear();
            this.myMouseMotionListeners.clear();
            this.myEditorComponent.removeFocusListener(this);
            this.myEditorComponent.removeMouseListener(this.myMouseListener);
            this.myGutterComponent.removeMouseListener(this.myMouseListener);
            this.myEditorComponent.removeMouseMotionListener(this.myMouseMotionListener);
            this.myGutterComponent.removeMouseMotionListener(this.myMouseMotionListener);
            Disposer.dispose((Disposable)this.myDisposable);
            this.myVerticalScrollBar.setPersistentUI(JBScrollBar.createDefaultUI());
            this.mouseSelectionStateAlarm.dispose();
            this.errorStripeDelayedRepaintAlarm.dispose();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaretThread() {
        EditorCaretRepaintService editorCaretRepaintService = this.caretRepaintService;
        synchronized (editorCaretRepaintService) {
            if (this.caretRepaintService.getEditor() == this) {
                this.caretRepaintService.setEditor(null);
            }
        }
    }

    private void initComponent() {
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.add((Component)this.myHeaderPanel, "North");
        this.myGutterComponent.setOpaque(true);
        this.myScrollPane.setViewportView(this.myEditorComponent);
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.setRowHeaderView(this.myGutterComponent);
        this.myScrollingModel.initListeners();
        this.myEditorComponent.setTransferHandler(new EditorTransferHandler());
        this.myEditorComponent.setAutoscrolls(false);
        this.myLayeredPane = new PanelWithFloatingToolbar();
        this.myLayeredPane.add((Component)((Object)this.myScrollPane), SCROLL_PANE_LAYER);
        UiNotifyConnector.doWhenFirstShown((Component)this.myPanel, () -> {
            if (this.mayShowToolbar()) {
                EditorFloatingToolbar editorFLoatingToolbar = new EditorFloatingToolbar(this);
                this.myLayeredPane.add(editorFLoatingToolbar, FLOATING_TOOLBAR_LAYER);
                this.editorFloatingToolbar = editorFLoatingToolbar;
            }
        }, (Disposable)this.getDisposable());
        this.myPanel.add((Component)((Object)this.myLayeredPane), "Center");
        this.myEditorComponent.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (EVENT_LOG.isDebugEnabled()) {
                    EVENT_LOG.debug(e.toString());
                }
                if (e.getKeyCode() >= 65 && e.getKeyCode() <= 90) {
                    EditorImpl.this.myCharKeyPressed = true;
                }
            }

            @Override
            public void keyTyped(@NotNull KeyEvent event) {
                if (event == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (EVENT_LOG.isDebugEnabled()) {
                    EVENT_LOG.debug(event.toString());
                }
                EditorImpl.this.myNeedToSelectPreviousChar = false;
                if (event.isConsumed()) {
                    return;
                }
                if (((Boolean)WriteIntentReadAction.compute(() -> EditorImpl.this.processKeyTyped(event))).booleanValue()) {
                    event.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (EVENT_LOG.isDebugEnabled()) {
                    EVENT_LOG.debug(e.toString());
                }
                EditorImpl.this.myCharKeyPressed = false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "keyPressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "keyTyped";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myEditorComponent.addMouseListener(this.myMouseListener);
        this.myGutterComponent.addMouseListener(this.myMouseListener);
        this.myEditorComponent.addMouseMotionListener(this.myMouseMotionListener);
        this.myGutterComponent.addMouseMotionListener(this.myMouseMotionListener);
        this.myEditorComponent.addFocusListener(this);
        UiNotifyConnector.doWhenFirstShown((Component)this.myEditorComponent, this.myGutterComponent::updateSizeOnShowNotify, (Disposable)this.getDisposable());
        try {
            DropTarget dropTarget = this.myEditorComponent.getDropTarget();
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(new DropTargetAdapter(){

                    @Override
                    public void drop(@NotNull DropTargetDropEvent e) {
                        if (e == null) {
                            8.$$$reportNull$$$0(0);
                        }
                    }

                    @Override
                    public void dragOver(@NotNull DropTargetDragEvent e) {
                        if (e == null) {
                            8.$$$reportNull$$$0(1);
                        }
                        Point location = e.getLocation();
                        CaretImpl caret = EditorImpl.this.getCaretModel().getCurrentCaret();
                        caret.moveToVisualPosition(EditorImpl.this.getTargetPosition(location.x, location.y, true, caret));
                        EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        EditorImpl.this.requestFocus();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$8";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "drop";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "dragOver";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
        catch (TooManyListenersException e2) {
            LOG.error((Throwable)e2);
        }
        this.myPanel.addHierarchyListener(e -> this.mySoftWrapModel.getApplianceManager().updateAvailableArea());
        this.myPanel.addComponentListener(new ComponentAdapter(){

            @Override
            @DirtyUI
            public void componentResized(@NotNull ComponentEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                EditorImpl.this.myMarkupModel.recalcEditorDimensions();
                EditorImpl.this.myMarkupModel.repaint();
                if (!EditorImpl.this.isRightAligned()) {
                    return;
                }
                EditorImpl.this.updateCaretCursor();
                EditorImpl.this.myCaretCursor.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$9", "componentResized"));
            }
        });
    }

    private boolean mayShowToolbar() {
        return !this.isOneLineMode() && !DiffUtil.isDiffEditor(this) && this.isFileEditor();
    }

    private boolean isFileEditor() {
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = documentManager.getFile((Document)this.myDocument);
        return virtualFile != null && virtualFile.isValid();
    }

    @Override
    public void setFontSize(int fontSize) {
        EditorThreading.run(() -> this.setFontSizeImpl(fontSize, null, false));
    }

    @Override
    public void setFontSize(float fontSize) {
        EditorThreading.run(() -> this.setFontSizeImpl(fontSize, null, false));
    }

    @ApiStatus.Internal
    public void setFontSize(float fontSize, @Nullable Point zoomCenter, boolean validateImmediately) {
        EditorThreading.run(() -> this.setFontSizeImpl(fontSize, zoomCenter, validateImmediately));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFontSizeImpl(float fontSize, @Nullable Point zoomCenter, boolean validateImmediately) {
        int oldFontSize = this.myScheme.getEditorFontSize();
        float oldFontSize2D = this.myScheme.getEditorFontSize2D();
        Rectangle visibleArea = this.myScrollingModel.getVisibleArea();
        Point zoomCenterRelative = zoomCenter == null ? new Point() : zoomCenter;
        Point zoomCenterAbsolute = new Point(visibleArea.x + zoomCenterRelative.x, visibleArea.y + zoomCenterRelative.y);
        LogicalPosition zoomCenterLogical = this.xyToLogicalPosition(zoomCenterAbsolute);
        int oldLineHeight = this.getLineHeight();
        int intraLineOffset = zoomCenterAbsolute.y % oldLineHeight;
        this.myScheme.setEditorFontSize(fontSize);
        int newFontSize = this.myScheme.getEditorFontSize();
        float newFontSize2D = this.myScheme.getEditorFontSize2D();
        this.myPropertyChangeSupport.firePropertyChange("fontSize", oldFontSize, newFontSize);
        this.myPropertyChangeSupport.firePropertyChange("fontSize2D", Float.valueOf(oldFontSize2D), Float.valueOf(newFontSize2D));
        if (validateImmediately) {
            this.validateSize();
        } else {
            this.myScrollPane.getViewport().invalidate();
        }
        Point shiftedZoomCenterAbsolute = this.logicalPositionToXY(zoomCenterLogical);
        this.myScrollingModel.disableAnimation();
        try {
            int targetX = visibleArea.x == 0 ? 0 : shiftedZoomCenterAbsolute.x - zoomCenterRelative.x;
            int targetY = shiftedZoomCenterAbsolute.y - zoomCenterRelative.y + (intraLineOffset * this.getLineHeight() + oldLineHeight / 2) / oldLineHeight;
            this.myScrollingModel.scroll(targetX, targetY);
        }
        finally {
            this.myScrollingModel.enableAnimation();
        }
    }

    public int getFontSize() {
        return this.myScheme.getEditorFontSize();
    }

    public float getFontSize2D() {
        return this.myScheme.getEditorFontSize2D();
    }

    @NotNull
    public ActionCallback type(@NotNull String text2) {
        if (text2 == null) {
            EditorImpl.$$$reportNull$$$0(33);
        }
        ActionCallback result2 = new ActionCallback();
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            this.myLastTypedActionTimestamp = System.currentTimeMillis();
            char c = text2.charAt(i2);
            this.myLastTypedAction = Character.toString(c);
            if (this.processKeyTyped(c)) continue;
            result2.setRejected();
            ActionCallback actionCallback = result2;
            if (actionCallback == null) {
                EditorImpl.$$$reportNull$$$0(34);
            }
            return actionCallback;
        }
        result2.setDone();
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            EditorImpl.$$$reportNull$$$0(35);
        }
        return actionCallback;
    }

    private boolean processKeyTyped(char c) {
        FileDocumentManager manager2;
        VirtualFile file2;
        if (ProgressManager.getInstance().hasModalProgressIndicator()) {
            return false;
        }
        if (LocalEditorSupportUtil.isMonolith() && (file2 = (manager2 = FileDocumentManager.getInstance()).getFile((Document)this.myDocument)) != null && !file2.isValid()) {
            return false;
        }
        DataContext context = this.getDataContext();
        Graphics graphics = GraphicsUtil.safelyGetGraphics((Component)this.myEditorComponent);
        if (graphics != null) {
            PaintUtil.alignTxToInt((Graphics2D)((Graphics2D)graphics), (Point2D)PaintUtil.insets2offset((Insets)this.getInsets()), (boolean)true, (boolean)false, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
            this.processKeyTypedImmediately(c, graphics, context);
            graphics.dispose();
        }
        ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c, context);
        EditorUIUtil.hideCursorInEditor(this);
        this.processKeyTypedNormally(c, context);
        ActionManagerEx.getInstanceEx().fireAfterEditorTyping(c, context);
        return true;
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public void processKeyTypedImmediately(char c, @NotNull Graphics graphics, @NotNull DataContext dataContext2) {
        if (graphics == null) {
            EditorImpl.$$$reportNull$$$0(36);
        }
        if (dataContext2 == null) {
            EditorImpl.$$$reportNull$$$0(37);
        }
        EditorActionPlan plan = new EditorActionPlan(this);
        EditorActionManager.getInstance();
        TypedAction.getInstance().beforeActionPerformed((Editor)this, c, dataContext2, (ActionPlan)plan);
        if (this.myImmediatePainter.paint(graphics, plan)) {
            this.measureTypingLatency();
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public void processKeyTypedNormally(char c, @NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            EditorImpl.$$$reportNull$$$0(38);
        }
        EditorActionManager.getInstance();
        WriteIntentReadAction.run(() -> TypedAction.getInstance().actionPerformed((Editor)this, c, dataContext2));
    }

    private void fireFocusLost(@NotNull FocusEvent event) {
        if (event == null) {
            EditorImpl.$$$reportNull$$$0(39);
        }
        for (FocusChangeListener listener2 : this.myFocusListeners) {
            listener2.focusLost(this, event);
        }
    }

    private void fireFocusGained(@NotNull FocusEvent event) {
        if (event == null) {
            EditorImpl.$$$reportNull$$$0(40);
        }
        for (FocusChangeListener listener2 : this.myFocusListeners) {
            listener2.focusGained(this, event);
        }
    }

    @Override
    public void setHighlighter(@NotNull EditorHighlighter highlighter) {
        if (highlighter == null) {
            EditorImpl.$$$reportNull$$$0(41);
        }
        if (this.isReleased) {
            return;
        }
        EditorImpl.assertIsDispatchThread();
        WriteIntentReadAction.run(() -> {
            DocumentEx document2 = this.getDocument();
            Disposer.dispose((Disposable)this.myHighlighterDisposable);
            this.myHighlighterDisposable = Disposer.newDisposable();
            document2.addDocumentListener((DocumentListener)highlighter, this.myHighlighterDisposable);
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.myHighlighterDisposable);
            highlighter.setEditor((HighlighterClient)this);
            try (AccessToken ignored = SlowOperations.knownIssue((String)"IJPL-162348");){
                highlighter.setText(document2.getImmutableCharSequence());
            }
            if (!(highlighter instanceof EmptyEditorHighlighter)) {
                EditorHighlighterCache.rememberEditorHighlighterForCachesOptimization((Document)document2, highlighter);
            }
            EditorHighlighter oldHighlighter = this.myHighlighter;
            this.myHighlighter = highlighter;
            this.myPropertyChangeSupport.firePropertyChange("highlighter", oldHighlighter, highlighter);
            if (this.myPanel != null) {
                this.reinitSettings();
            }
        });
    }

    @NotNull
    public EditorHighlighter getHighlighter() {
        EditorHighlighter editorHighlighter = this.myHighlighter;
        if (editorHighlighter == null) {
            EditorImpl.$$$reportNull$$$0(42);
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorComponentImpl getContentComponent() {
        EditorComponentImpl editorComponentImpl = this.myEditorComponent;
        if (editorComponentImpl == null) {
            EditorImpl.$$$reportNull$$$0(43);
        }
        return editorComponentImpl;
    }

    @Override
    @NotNull
    public EditorGutterComponentEx getGutterComponentEx() {
        EditorGutterComponentImpl editorGutterComponentImpl = this.myGutterComponent;
        if (editorGutterComponentImpl == null) {
            EditorImpl.$$$reportNull$$$0(44);
        }
        return editorGutterComponentImpl;
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(45);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(46);
        }
        if (parentDisposable == null) {
            EditorImpl.$$$reportNull$$$0(47);
        }
        this.addPropertyChangeListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removePropertyChangeListener(listener2));
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(48);
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    @Override
    public void setInsertMode(boolean mode) {
        EditorImpl.assertIsDispatchThread();
        EditorThreading.run(() -> this.myState.setInsertMode(mode));
    }

    private void isInsertModeChanged(ObservableStateListener.PropertyChangeEvent event) {
        EditorImpl.assertIsDispatchThread();
        Object oldValue = EditorImpl.extractOldValueOrLog(event, false);
        this.myPropertyChangeSupport.firePropertyChange("insertMode", oldValue, event.getNewValue());
        this.myCaretCursor.repaint();
    }

    public boolean isInsertMode() {
        return this.myState.isInsertMode();
    }

    @Override
    public void setColumnMode(boolean mode) {
        EditorImpl.assertIsDispatchThread();
        EditorThreading.run(() -> this.myState.setColumnMode(mode));
    }

    private void isColumnModeChanged(ObservableStateListener.PropertyChangeEvent event) {
        EditorImpl.assertIsDispatchThread();
        Object oldValue = EditorImpl.extractOldValueOrLog(event, false);
        this.myPropertyChangeSupport.firePropertyChange("columnMode", oldValue, event.getNewValue());
    }

    public boolean isColumnMode() {
        return this.myState.isColumnMode();
    }

    public int yToVisualLine(int y) {
        return this.myView.yToVisualLine(y);
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        if (p == null) {
            EditorImpl.$$$reportNull$$$0(49);
        }
        VisualPosition visualPosition = (VisualPosition)EditorThreading.compute(() -> this.myView.xyToVisualPosition(p));
        if (visualPosition == null) {
            EditorImpl.$$$reportNull$$$0(50);
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        if (p == null) {
            EditorImpl.$$$reportNull$$$0(51);
        }
        VisualPosition visualPosition = (VisualPosition)EditorThreading.compute(() -> this.myView.xyToVisualPosition(p));
        if (visualPosition == null) {
            EditorImpl.$$$reportNull$$$0(52);
        }
        return visualPosition;
    }

    @NotNull
    public Point2D offsetToPoint2D(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        Point2D point2D = (Point2D)EditorThreading.compute(() -> this.myView.offsetToXY(offset, leanTowardsLargerOffsets, beforeSoftWrap));
        if (point2D == null) {
            EditorImpl.$$$reportNull$$$0(53);
        }
        return point2D;
    }

    @NotNull
    public Point offsetToXY(int offset, boolean leanForward, boolean beforeSoftWrap) {
        Point point = (Point)EditorThreading.compute(() -> {
            Point2D point2D = this.offsetToPoint2D(offset, leanForward, beforeSoftWrap);
            return new Point((int)point2D.getX(), (int)point2D.getY());
        });
        if (point == null) {
            EditorImpl.$$$reportNull$$$0(54);
        }
        return point;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        VisualPosition visualPosition = this.offsetToVisualPosition(offset, false, false);
        if (visualPosition == null) {
            EditorImpl.$$$reportNull$$$0(55);
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = (VisualPosition)EditorThreading.compute(() -> this.myView.offsetToVisualPosition(offset, leanForward, beforeSoftWrap));
        if (visualPosition == null) {
            EditorImpl.$$$reportNull$$$0(56);
        }
        return visualPosition;
    }

    public int offsetToVisualColumnInFoldRegion(@NotNull FoldRegion region, int offset, boolean leanTowardsLargerOffsets) {
        if (region == null) {
            EditorImpl.$$$reportNull$$$0(57);
        }
        EditorImpl.assertIsDispatchThread();
        return (Integer)EditorThreading.compute(() -> this.myView.offsetToVisualColumnInFoldRegion(region, offset, leanTowardsLargerOffsets));
    }

    public int visualColumnToOffsetInFoldRegion(@NotNull FoldRegion region, int visualColumn, boolean leansRight) {
        if (region == null) {
            EditorImpl.$$$reportNull$$$0(58);
        }
        EditorImpl.assertIsDispatchThread();
        return (Integer)EditorThreading.compute(() -> this.myView.visualColumnToOffsetInFoldRegion(region, visualColumn, leansRight));
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        LogicalPosition logicalPosition = (LogicalPosition)EditorThreading.compute(() -> this.myView.offsetToLogicalPosition(offset));
        if (logicalPosition == null) {
            EditorImpl.$$$reportNull$$$0(59);
        }
        return logicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void setCaretActive() {
        EditorCaretRepaintService editorCaretRepaintService = this.caretRepaintService;
        synchronized (editorCaretRepaintService) {
            this.caretRepaintService.setEditor(this);
            this.caretRepaintService.restart();
        }
    }

    public int offsetToVisualLine(int offset) {
        return this.offsetToVisualLine(offset, false);
    }

    public int offsetToVisualLine(int offset, boolean beforeSoftWrap) {
        return this.myView.offsetToVisualLine(offset, beforeSoftWrap);
    }

    public int visualLineStartOffset(int visualLine) {
        return this.myView.visualLineToOffset(visualLine);
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            EditorImpl.$$$reportNull$$$0(60);
        }
        LogicalPosition logicalPosition = (LogicalPosition)EditorThreading.compute(() -> this.myView.xyToLogicalPosition(p));
        if (logicalPosition == null) {
            EditorImpl.$$$reportNull$$$0(61);
        }
        return logicalPosition;
    }

    private int logicalToVisualLine(int logicalLine) {
        return logicalLine < this.getEditorModel().getDocument().getLineCount() ? this.offsetToVisualLine(this.getEditorModel().getDocument().getLineStartOffset(logicalLine)) : (this.myAdView == null ? this.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)logicalLine, (int)0)).line : this.myAdView.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)logicalLine, (int)0), (boolean)false).line);
    }

    int logicalLineToY(int line) {
        int visualLine = this.logicalToVisualLine(line);
        return this.myAdView == null ? this.visualLineToY(visualLine) : this.myAdView.visualLineToY(visualLine);
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        if (pos == null) {
            EditorImpl.$$$reportNull$$$0(62);
        }
        Point point = (Point)EditorThreading.compute(() -> {
            VisualPosition visible = this.logicalToVisualPosition(pos);
            return this.visualPositionToXY(visible);
        });
        if (point == null) {
            EditorImpl.$$$reportNull$$$0(63);
        }
        return point;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        if (visible == null) {
            EditorImpl.$$$reportNull$$$0(64);
        }
        Point point = (Point)EditorThreading.compute(() -> {
            Point2D point2D = this.myView.visualPositionToXY(visible);
            return new Point((int)point2D.getX(), (int)point2D.getY());
        });
        if (point == null) {
            EditorImpl.$$$reportNull$$$0(65);
        }
        return point;
    }

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition visible) {
        if (visible == null) {
            EditorImpl.$$$reportNull$$$0(66);
        }
        Point2D point2D = (Point2D)EditorThreading.compute(() -> this.myView.visualPositionToXY(visible));
        if (point2D == null) {
            EditorImpl.$$$reportNull$$$0(67);
        }
        return point2D;
    }

    public float getScale() {
        if (Registry.is((String)"editor.scale.gutter.icons")) {
            float newUINormLineHeight = (float)Registry.doubleValue((String)"ide.new.ui.editor.normalized.line.height");
            float standardNormalizedLineHeight = ExperimentalUI.isNewUI() ? newUINormLineHeight : 16.0f;
            float normLineHeight = (float)this.getLineHeight() / this.myScheme.getLineSpacing();
            return normLineHeight / JBUIScale.scale((float)standardNormalizedLineHeight);
        }
        return 1.0f;
    }

    public int findNearestDirectionBoundary(int offset, boolean lookForward) {
        return (Integer)EditorThreading.compute(() -> this.myView.findNearestDirectionBoundary(offset, lookForward));
    }

    public int visualLineToY(int line) {
        return (Integer)EditorThreading.compute(() -> this.myView.visualLineToY(line));
    }

    public int @NotNull [] visualLineToYRange(int visualLine) {
        int[] nArray = this.myView.visualLineToYRange(visualLine);
        if (nArray == null) {
            EditorImpl.$$$reportNull$$$0(68);
        }
        return nArray;
    }

    @Override
    public void repaint(int startOffset, int endOffset) {
        this.repaint(startOffset, endOffset, true);
        this.myHighlighterListeners.forEach(listener2 -> listener2.highlighterChanged(startOffset, endOffset));
    }

    public void addHighlighterListener(@NotNull HighlighterListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(69);
        }
        if (parentDisposable == null) {
            EditorImpl.$$$reportNull$$$0(70);
        }
        ContainerUtil.add((Object)listener2, this.myHighlighterListeners, (Disposable)parentDisposable);
    }

    void repaint(int startOffset, int endOffset, boolean invalidateTextLayout) {
        if (this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode()) {
            return;
        }
        if (this.myView == null) {
            return;
        }
        EditorImpl.assertIsDispatchThread();
        EditorThreading.run(() -> {
            int minEndOffset = Math.min(endOffset, this.getEditorModel().getDocument().getTextLength());
            if (invalidateTextLayout) {
                this.myView.invalidateRange(startOffset, minEndOffset, true);
                if (this.myAdView != null) {
                    this.myAdView.invalidateRange(startOffset, minEndOffset, true);
                }
            }
            if (!this.isShowing()) {
                return;
            }
            if (this.myDocumentChangeInProgress) {
                if (startOffset < this.myRangeToRepaintStart) {
                    this.myRangeToRepaintStart = startOffset;
                }
                if (minEndOffset > this.myRangeToRepaintEnd) {
                    this.myRangeToRepaintEnd = minEndOffset;
                }
                return;
            }
            if (startOffset <= minEndOffset) {
                int endLine;
                int startLine;
                if (this.myAdView != null) {
                    startLine = this.myAdView.offsetToVisualLine(startOffset, false);
                    endLine = this.myAdView.offsetToVisualLine(minEndOffset, true);
                } else {
                    startLine = this.myView.offsetToVisualLine(startOffset, false);
                    endLine = this.myView.offsetToVisualLine(minEndOffset, true);
                }
                this.doRepaint(startLine, endLine);
            }
        });
    }

    private boolean isShowing() {
        return this.myGutterComponent.isShowing();
    }

    private void repaintToScreenBottom(int startLine) {
        int yStartLine = this.logicalLineToY(startLine);
        this.repaintToScreenBottomStartingFrom(yStartLine);
    }

    private void repaintToScreenBottomStartingFrom(int y) {
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int yEndLine = visibleArea.y + visibleArea.height;
        this.myEditorComponent.repaintEditorComponent(visibleArea.x, y, visibleArea.x + visibleArea.width, yEndLine - y);
        this.myGutterComponent.repaint(0, y, this.myGutterComponent.getWidth(), yEndLine - y);
        this.myMarkupModel.repaint();
    }

    void repaintLines(int startLine, int endLine) {
        if (!this.isShowing()) {
            return;
        }
        int startVisualLine = this.logicalToVisualLine(startLine);
        DocumentEx document2 = this.getEditorModel().getDocument();
        int endVisualLine = document2.getTextLength() <= 0 ? 0 : this.offsetToVisualLine(document2.getLineEndOffset(Math.min(document2.getLineCount() - 1, endLine)));
        this.doRepaint(startVisualLine, endVisualLine);
    }

    private void doRepaint(int startVisualLine, int endVisualLine) {
        int height;
        int yStart;
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        if (this.myAdView != null) {
            yStart = this.myAdView.visualLineToY(startVisualLine);
            height = this.myAdView.visualLineToYRange(endVisualLine)[1] + 2 - yStart;
        } else {
            yStart = this.visualLineToY(startVisualLine);
            height = this.visualLineToYRange(endVisualLine)[1] + 2 - yStart;
        }
        this.myEditorComponent.repaintEditorComponent(visibleArea.x, yStart, visibleArea.x + visibleArea.width, height);
        this.myGutterComponent.repaint(0, yStart, this.myGutterComponent.getWidth(), height);
        if (this.myStickyLinesManager != null) {
            this.myStickyLinesManager.repaintLines(startVisualLine, endVisualLine);
        }
    }

    private void bulkUpdateStarted() {
        if (this.myInlayModel.isInBatchMode()) {
            LOG.error("Document bulk mode shouldn't be started from batch inlay operation");
        }
        this.myView.getPreferredSize();
        if (this.myAdView != null) {
            this.myAdView.getPreferredSize();
        }
        this.myScrollingModel.onBulkDocumentUpdateStarted();
        if (this.myScrollingPositionKeeper != null) {
            this.myScrollingPositionKeeper.savePosition();
        }
        this.myCaretModel.onBulkDocumentUpdateStarted();
        this.mySoftWrapModel.onBulkDocumentUpdateStarted();
        this.myFoldingModel.onBulkDocumentUpdateStarted();
    }

    private void bulkUpdateFinished() {
        if (this.myInlayModel.isInBatchMode()) {
            LOG.error("Document bulk mode shouldn't be finished from batch inlay operation");
        }
        this.myFoldingModel.onBulkDocumentUpdateFinished();
        this.mySoftWrapModel.onBulkDocumentUpdateFinished();
        this.myView.reset();
        this.myCaretModel.onBulkDocumentUpdateFinished();
        this.setMouseSelectionState(0);
        this.validateSize();
        this.updateGutterSize();
        this.repaintToScreenBottom(0);
        this.updateCaretCursor();
        if (!Boolean.TRUE.equals(this.getUserData(DISABLE_CARET_POSITION_KEEPING)) && this.myScrollingPositionKeeper != null) {
            this.myScrollingPositionKeeper.restorePosition(true);
        }
    }

    private void beforeChangedUpdate(@NotNull DocumentEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(71);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myDocumentChangeInProgress = true;
        if (this.isStickySelection()) {
            this.setStickySelection(false);
        }
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.myRangeToRepaintStart = Integer.MAX_VALUE;
        this.myRangeToRepaintEnd = 0;
        boolean bl = this.myRestoreScrollingPosition = this.getCaretModel().getOffset() < e.getOffset() || this.getCaretModel().getOffset() > e.getOffset() + e.getOldLength();
        if (this.myRestoreScrollingPosition && this.myScrollingPositionKeeper != null) {
            this.myScrollingPositionKeeper.savePosition();
        }
    }

    @RequiresEdt
    void invokeDelayedErrorStripeRepaint() {
        ThreadingAssertions.assertEventDispatchThread();
        long range = this.myErrorStripeNeedsRepaintRange;
        if (range != -1L) {
            this.errorStripeDelayedRepaintAlarm.cancel();
            this.myMarkupModel.repaint(TextRangeScalarUtil.startOffset((long)range), TextRangeScalarUtil.endOffset((long)range));
            this.myErrorStripeNeedsRepaintRange = -1L;
        }
    }

    private void changedUpdate(@NotNull DocumentEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(72);
        }
        this.myDocumentChangeInProgress = false;
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (this.myErrorStripeNeedsRepaintRange != -1L) {
            this.queueErrorStipeRepaintRequest(e.getOffset(), e.getOffset() + e.getNewLength());
            this.invokeDelayedErrorStripeRepaint();
        }
        this.setMouseSelectionState(0);
        if (this.myGutterComponent.getCurrentAccessibleLine() != null) {
            this.escapeGutterAccessibleLine(e.getOffset(), e.getOffset() + e.getNewLength());
        }
        this.validateSize();
        int startLine = this.offsetToLogicalLine(e.getOffset());
        int endLine = this.offsetToLogicalLine(e.getOffset() + e.getNewLength());
        if (startLine != endLine || StringUtil.indexOf((CharSequence)e.getOldFragment(), (char)'\n') != -1) {
            this.myGutterComponent.clearLineToGutterRenderersCache();
        }
        if (this.myRangeToRepaintStart < this.myDocument.getLineStartOffset(startLine)) {
            startLine = this.myDocument.getLineNumber(this.myRangeToRepaintStart);
        }
        if (this.myRangeToRepaintEnd > this.myDocument.getLineEndOffset(endLine)) {
            endLine = this.myDocument.getLineNumber(Math.min(this.myRangeToRepaintEnd, this.myDocument.getTextLength()));
        }
        if (EditorImpl.countLineFeeds(e.getOldFragment()) != EditorImpl.countLineFeeds(e.getNewFragment())) {
            this.repaintToScreenBottom(startLine);
        } else {
            this.repaintLines(startLine, endLine);
        }
        this.updateCaretCursor();
        if (this.myRestoreScrollingPosition && !Boolean.TRUE.equals(this.getUserData(DISABLE_CARET_POSITION_KEEPING)) && this.myScrollingPositionKeeper != null) {
            this.myScrollingPositionKeeper.restorePosition(true);
        }
    }

    private void escapeGutterAccessibleLine(int offsetStart, int offsetEnd) {
        int startVisLine = this.offsetToVisualLine(offsetStart);
        int endVisLine = this.offsetToVisualLine(offsetEnd);
        int line = this.getCaretModel().getPrimaryCaret().getVisualPosition().line;
        if (startVisLine <= line && endVisLine >= line) {
            this.myGutterComponent.escapeCurrentAccessibleLine();
        }
    }

    public void hideCursor() {
        if (!this.myState.isViewer() && EMPTY_CURSOR != null && Registry.is((String)"ide.hide.cursor.when.typing")) {
            this.myDefaultCursor = EMPTY_CURSOR;
            this.updateEditorCursor();
        }
    }

    public boolean isCursorHidden() {
        return this.myDefaultCursor == EMPTY_CURSOR;
    }

    public boolean isScrollToCaret() {
        return this.myState.isScrollToCaret();
    }

    public void setScrollToCaret(boolean scrollToCaret) {
        this.myState.setScrollToCaret(scrollToCaret);
    }

    @NotNull
    public Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            EditorImpl.$$$reportNull$$$0(73);
        }
        return disposable;
    }

    private static int countLineFeeds(@NotNull CharSequence c) {
        if (c == null) {
            EditorImpl.$$$reportNull$$$0(74);
        }
        return StringUtil.countNewLines((CharSequence)c);
    }

    private void updateGutterSize() {
        EditorImpl.assertIsDispatchThread();
        if (!this.updatingSize) {
            this.updatingSize = true;
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    if (!this.isDisposed()) {
                        this.myGutterComponent.updateSize();
                    }
                }
                finally {
                    this.updatingSize = false;
                }
            }, ModalityState.any(), __ -> this.isDisposed());
        }
    }

    void validateSize() {
        if (this.isReleased) {
            return;
        }
        Dimension dim = this.getPreferredSize();
        if (!(dim.equals(this.myPreferredSize) || this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode() || (dim = this.mySizeAdjustmentStrategy.adjust(dim, this.myPreferredSize, this)).equals(this.myPreferredSize))) {
            this.myPreferredSize = dim;
            this.updateGutterSize();
            this.myEditorComponent.setSize(dim);
            this.myEditorComponent.fireResized();
            this.myMarkupModel.recalcEditorDimensions();
            this.myMarkupModel.repaint();
        }
    }

    void recalculateSizeAndRepaint() {
        this.validateSize();
        this.myEditorComponent.repaint();
    }

    @Override
    @NotNull
    public DocumentEx getDocument() {
        DocumentEx documentEx = this.myDocument;
        if (documentEx == null) {
            EditorImpl.$$$reportNull$$$0(75);
        }
        return documentEx;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            EditorImpl.$$$reportNull$$$0(76);
        }
        return jPanel;
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(77);
        }
        this.myMouseListeners.add(listener2);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        boolean success2;
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(78);
        }
        LOG.assertTrue((success2 = this.myMouseListeners.remove(listener2)) || this.isReleased);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(79);
        }
        this.myMouseMotionListeners.add(listener2);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        boolean success2;
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(80);
        }
        LOG.assertTrue((success2 = this.myMouseMotionListeners.remove(listener2)) || this.isReleased);
    }

    @ApiStatus.Internal
    public void setRepaintCallback(@Nullable Runnable callback) {
        this.myEditorComponent.setRepaintCallback(callback);
    }

    @ApiStatus.Internal
    public void setPaintCallback(@Nullable Runnable callback) {
        this.myView.setPaintCallback(callback);
    }

    @Override
    public boolean isStickySelection() {
        return this.myState.isStickySelection();
    }

    @Override
    public void setStickySelection(boolean enable2) {
        this.myState.setStickySelection(enable2);
    }

    private void isStickySelectionChanged(ObservableStateListener.PropertyChangeEvent event) {
        Object newValue = event.getNewValue();
        if (!(newValue instanceof Boolean)) {
            LOG.error("newValue is not Boolean. property name = " + event.getPropertyName() + ", newValue = " + String.valueOf(newValue));
            return;
        }
        if (((Boolean)newValue).booleanValue()) {
            this.myStickySelectionStart = this.getCaretModel().getOffset();
        } else {
            this.mySelectionModel.removeSelection();
        }
    }

    public void setHorizontalTextAlignment(int alignment) {
        this.myState.setHorizontalTextAlignment(alignment);
    }

    public boolean isRightAligned() {
        return this.myState.getHorizontalTextAlignment() == 1;
    }

    public boolean isDisposed() {
        return this.isReleased;
    }

    public void stopDumbLater() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(this::stopDumb, ModalityState.current(), __ -> this.isDisposed());
    }

    private void stopDumb() {
        this.putUserData(BUFFER, null);
        this.myEditorComponent.repaint();
    }

    public void startDumb() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || !this.myEditorComponent.isShowing()) {
            return;
        }
        if (!Registry.is((String)"editor.dumb.mode.available")) {
            return;
        }
        this.putUserData(BUFFER, null);
        Rectangle rect = ((JViewport)this.myEditorComponent.getParent()).getViewRect();
        if (rect.isEmpty()) {
            return;
        }
        if (this.myStickyLinesManager != null) {
            this.myStickyLinesManager.startDumb();
        }
        BufferedImage image2 = UIUtil.createImage((Component)this.myEditorComponent, (int)rect.width, (int)rect.height, (int)1);
        Graphics2D imageGraphics = image2.createGraphics();
        ((Graphics)imageGraphics).translate(-rect.x, -rect.y);
        Graphics2D graphics = JBSwingUtilities.runGlobalCGTransform((JComponent)this.myEditorComponent, (Graphics)imageGraphics);
        graphics.setClip(rect.x, rect.y, rect.width, rect.height);
        this.myEditorComponent.paintComponent(graphics);
        graphics.dispose();
        this.putUserData(BUFFER, image2);
    }

    public boolean isDumb() {
        return this.getUserData(BUFFER) != null;
    }

    @ApiStatus.Internal
    public void suppressPainting(boolean suppress) {
        this.mySuppressPainting = suppress;
    }

    @ApiStatus.Internal
    public void suppressDisposedPainting(boolean suppress) {
        this.mySuppressDisposedPainting = suppress;
    }

    private boolean shouldPaint() {
        return !this.isReleased && !this.mySuppressPainting;
    }

    private void fillPlaceholder(@NotNull Graphics2D g) {
        Rectangle clip;
        if (g == null) {
            EditorImpl.$$$reportNull$$$0(81);
        }
        if ((clip = g.getClipBounds()) == null) {
            return;
        }
        Color bg = this.isReleased ? this.getDisposedBackground() : this.getBackgroundColor();
        g.setColor(bg);
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
    }

    void paint(@NotNull Graphics2D g) {
        BufferedImage buffer2;
        if (g == null) {
            EditorImpl.$$$reportNull$$$0(82);
        }
        if (g.getClipBounds() == null) {
            return;
        }
        BufferedImage bufferedImage = buffer2 = Registry.is((String)"editor.dumb.mode.available", (boolean)true) ? (BufferedImage)this.getUserData(BUFFER) : null;
        if (buffer2 != null) {
            Rectangle rect = this.getContentComponent().getVisibleRect();
            StartupUiUtil.drawImage((Graphics)g, (BufferedImage)buffer2, null, (int)rect.x, (int)rect.y);
            return;
        }
        if (!this.shouldPaint()) {
            this.fillPlaceholder(g);
            return;
        }
        EditorThreading.run(() -> {
            if (this.myUpdateCursor && !this.myPurePaintingMode) {
                this.setCursorPosition();
                this.myUpdateCursor = false;
            }
            if (this.myProject != null && this.myProject.isDisposed()) {
                return;
            }
            if (this.myAdView != null) {
                this.myAdView.paint(g);
            } else {
                this.myView.paint(g);
            }
        });
        boolean isBackgroundImageSet = IdeBackgroundUtil.isEditorBackgroundImageSet(this.myProject);
        if (this.myBackgroundImageSet != isBackgroundImageSet) {
            this.myBackgroundImageSet = isBackgroundImageSet;
            EditorImpl.updateOpaque(this.myScrollPane.getHorizontalScrollBar());
            EditorImpl.updateOpaque(this.myScrollPane.getVerticalScrollBar());
        }
    }

    @NotNull
    Color getDisposedBackground() {
        if (this.mySuppressDisposedPainting || this.mySuppressPainting) {
            Color color = this.getBackgroundColor();
            if (color == null) {
                EditorImpl.$$$reportNull$$$0(83);
            }
            return color;
        }
        return new JBColor(new Color(128, 255, 128), new Color(128, 255, 128));
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        IndentsModel indentsModel = this.myIndentsModel;
        if (indentsModel == null) {
            EditorImpl.$$$reportNull$$$0(84);
        }
        return indentsModel;
    }

    public void setHeaderComponent(@Nullable JComponent header) {
        JComponent oldComponent = this.getHeaderComponent();
        this.myHeaderPanel.removeAll();
        JComponent permanentHeader = this.getPermanentHeaderComponent();
        if (header == null) {
            header = permanentHeader;
        } else if (permanentHeader != null && header != permanentHeader) {
            JPanel headerPanel = new JPanel(new BorderLayout());
            headerPanel.add((Component)permanentHeader, "North");
            headerPanel.add((Component)header, "South");
            header = headerPanel;
        }
        if (header != null) {
            this.myHeaderPanel.add(header);
            this.myPropertyChangeSupport.firePropertyChange("headerComponent", oldComponent, header);
        }
        this.myHeaderPanel.revalidate();
        this.myHeaderPanel.repaint();
        InternalUICustomization customization = InternalUICustomization.getInstance();
        if (customization != null) {
            customization.updateEditorHeader(this.myHeaderPanel);
        }
        if (SystemInfo.isMac) {
            TouchbarSupport.onUpdateEditorHeader(this);
        }
    }

    public boolean hasHeaderComponent() {
        return (Boolean)EditorThreading.compute(() -> {
            JComponent header = this.getHeaderComponent();
            return header != null && header != this.getPermanentHeaderComponent();
        });
    }

    @Override
    @Nullable
    public JComponent getPermanentHeaderComponent() {
        return (JComponent)EditorThreading.compute(() -> (JComponent)this.getUserData(PERMANENT_HEADER));
    }

    @Override
    public void setPermanentHeaderComponent(@Nullable JComponent component2) {
        this.putUserData(PERMANENT_HEADER, component2);
    }

    @Nullable
    public JComponent getHeaderComponent() {
        if (this.myHeaderPanel.getComponentCount() > 0) {
            return (JComponent)this.myHeaderPanel.getComponent(0);
        }
        return null;
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (this.getBackgroundIgnoreForced().equals(color)) {
            this.myState.setMyForcedBackground(null);
        } else {
            this.myState.setMyForcedBackground(color);
        }
    }

    @NotNull
    Color getForegroundColor() {
        Color color = this.myScheme.getDefaultForeground();
        if (color == null) {
            EditorImpl.$$$reportNull$$$0(85);
        }
        return color;
    }

    @Override
    @NotNull
    public Color getBackgroundColor() {
        Color color = (Color)EditorThreading.compute(() -> {
            Color forcedBackground = this.myState.getMyForcedBackground();
            return forcedBackground == null ? this.getBackgroundIgnoreForced() : forcedBackground;
        });
        if (color == null) {
            EditorImpl.$$$reportNull$$$0(86);
        }
        return color;
    }

    @Override
    @NotNull
    public TextDrawingCallback getTextDrawingCallback() {
        TextDrawingCallback textDrawingCallback = this.myTextDrawingCallback;
        if (textDrawingCallback == null) {
            EditorImpl.$$$reportNull$$$0(87);
        }
        return textDrawingCallback;
    }

    @Override
    public void setPlaceholder(@Nullable CharSequence text2) {
        this.myState.setMyPlaceholderText(text2);
    }

    @Override
    public void setPlaceholderAttributes(@Nullable TextAttributes attributes) {
        this.myState.setMyPlaceholderAttributes(attributes);
    }

    @Nullable
    public TextAttributes getPlaceholderAttributes() {
        return this.myState.getMyPlaceholderAttributes();
    }

    public CharSequence getPlaceholder() {
        return this.myState.getMyPlaceholderText();
    }

    @Override
    public void setShowPlaceholderWhenFocused(boolean show2) {
        this.myState.setMyShowPlaceholderWhenFocused(show2);
    }

    public boolean getShowPlaceholderWhenFocused() {
        return this.myState.getMyShowPlaceholderWhenFocused();
    }

    Color getBackgroundColor(@NotNull TextAttributes attributes) {
        Color attrColor;
        if (attributes == null) {
            EditorImpl.$$$reportNull$$$0(88);
        }
        return Comparing.equal((Object)(attrColor = attributes.getBackgroundColor()), (Object)this.myScheme.getDefaultBackground()) ? this.getBackgroundColor() : attrColor;
    }

    @NotNull
    private Color getBackgroundIgnoreForced() {
        Color color = this.myScheme.getDefaultBackground();
        if (this.myDocument.isWritable()) {
            Color color2 = color;
            if (color2 == null) {
                EditorImpl.$$$reportNull$$$0(89);
            }
            return color2;
        }
        Color readOnlyColor = this.myScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
        Color color3 = readOnlyColor != null ? readOnlyColor : color;
        if (color3 == null) {
            EditorImpl.$$$reportNull$$$0(90);
        }
        return color3;
    }

    @Nullable
    public TextRange getComposedTextRange() {
        MyInputMethodHandler handler = this.getMyInputMethodHandler();
        return handler != null ? handler.getRange() : null;
    }

    private boolean composedTextExists() {
        MyInputMethodHandler handler = this.getMyInputMethodHandler();
        return handler != null && handler.isComposedTextShown();
    }

    @Nullable
    private MyInputMethodHandler getMyInputMethodHandler() {
        MyInputMethodHandler handler;
        InputMethodRequests inputMethodRequests;
        EditorInputMethodSupport support = this.myInputMethodSupport;
        return support != null && (inputMethodRequests = support.getRequests()) instanceof MyInputMethodHandler ? (handler = (MyInputMethodHandler)inputMethodRequests) : null;
    }

    @Override
    public int getMaxWidthInRange(int startOffset, int endOffset) {
        return (Integer)EditorThreading.compute(() -> this.myView.getMaxWidthInRange(startOffset, endOffset));
    }

    public boolean isPaintSelection() {
        return this.myState.isPaintSelection() || !this.isOneLineMode() || IJSwingUtilities.hasFocus(this.getContentComponent());
    }

    public void setPaintSelection(boolean paintSelection) {
        this.myState.setPaintSelection(paintSelection);
    }

    @NotNull
    @NonNls
    public String dumpState() {
        String string = "allow caret inside tab: " + this.mySettings.isCaretInsideTabs() + ", allow caret after line end: " + this.mySettings.isVirtualSpace() + ", soft wraps: " + (this.mySoftWrapModel.isSoftWrappingEnabled() ? "on" : "off") + ", caret model: " + this.getCaretModel().dumpState() + ", soft wraps data: " + this.getSoftWrapModel().dumpState() + "\n\nfolding data: " + this.getFoldingModel().dumpState() + "\ninlay model: " + this.getInlayModel().dumpState() + (String)(this.myDocument instanceof DocumentImpl ? "\n\ndocument info: " + ((DocumentImpl)this.myDocument).dumpState() : "") + "\nfont preferences: " + String.valueOf(this.myScheme.getFontPreferences()) + "\npure painting mode: " + this.myPurePaintingMode + "\ninsets: " + String.valueOf(this.myEditorComponent.getInsets()) + (String)(this.myView == null ? "" : "\nview: " + this.myView.dumpState());
        if (string == null) {
            EditorImpl.$$$reportNull$$$0(91);
        }
        return string;
    }

    public CaretRectangle @Nullable [] getCaretLocations(boolean onlyIfShown) {
        return this.myCaretCursor.getCaretLocations(onlyIfShown);
    }

    public int getAscent() {
        return this.myView.getAscent();
    }

    public int getLineHeight() {
        return (Integer)EditorThreading.compute(() -> this.myView.getLineHeight());
    }

    public int getDescent() {
        return this.myView.getDescent();
    }

    public int getCharHeight() {
        return this.myView.getCharHeight();
    }

    @NotNull
    public FontMetrics getFontMetrics(@JdkConstants.FontStyle int fontType) {
        EditorFontType ft;
        if (fontType == 0) {
            ft = EditorFontType.PLAIN;
        } else if (fontType == 1) {
            ft = EditorFontType.BOLD;
        } else if (fontType == 2) {
            ft = EditorFontType.ITALIC;
        } else if (fontType == 3) {
            ft = EditorFontType.BOLD_ITALIC;
        } else {
            LOG.error("Unknown font type: " + fontType);
            ft = EditorFontType.PLAIN;
        }
        FontMetrics fontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(ft));
        if (fontMetrics == null) {
            EditorImpl.$$$reportNull$$$0(92);
        }
        return fontMetrics;
    }

    public int getPreferredHeight() {
        return this.isReleased ? 0 : this.myView.getPreferredHeight();
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = (Dimension)EditorThreading.compute(() -> this.isReleased ? new Dimension() : (Registry.is((String)"idea.true.smooth.scrolling.dynamic.scrollbars") ? new Dimension(this.getPreferredWidthOfVisibleLines(), this.myView.getPreferredHeight()) : this.myView.getPreferredSize()));
        if (dimension == null) {
            EditorImpl.$$$reportNull$$$0(93);
        }
        return dimension;
    }

    private int getPreferredWidthOfVisibleLines() {
        Rectangle area = this.getScrollingModel().getVisibleArea();
        VisualPosition begin = this.xyToVisualPosition(area.getLocation());
        VisualPosition end = this.xyToVisualPosition(new Point(area.x + area.width, area.y + area.height));
        return Math.max(this.myView.getPreferredWidth(begin.line, end.line), this.getScrollingWidth());
    }

    private int getScrollingWidth() {
        BoundedRangeModel model2;
        JScrollBar scrollbar = this.myScrollPane.getHorizontalScrollBar();
        if (scrollbar != null && (model2 = scrollbar.getModel()) != null) {
            return model2.getValue() + model2.getExtent();
        }
        return 0;
    }

    @Override
    @NotNull
    public Dimension getContentSize() {
        Dimension dimension = (Dimension)EditorThreading.compute(() -> this.isReleased ? new Dimension() : this.myView.getPreferredSize());
        if (dimension == null) {
            EditorImpl.$$$reportNull$$$0(94);
        }
        return dimension;
    }

    @Override
    @NotNull
    public JScrollPane getScrollPane() {
        MyScrollPane myScrollPane2 = this.myScrollPane;
        if (myScrollPane2 == null) {
            EditorImpl.$$$reportNull$$$0(95);
        }
        return myScrollPane2;
    }

    public void setBorder(@Nullable Border border) {
        if (border == null) {
            border = JBUI.Borders.empty();
        }
        this.myState.setMyBorder(border);
    }

    private void borderChanged() {
        this.myScrollPane.doSetBorder(this.myState.getMyBorder());
    }

    public Insets getInsets() {
        return (Insets)EditorThreading.compute(() -> this.myScrollPane.getInsets());
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            EditorImpl.$$$reportNull$$$0(96);
        }
        return (Integer)EditorThreading.compute(() -> this.myView.logicalPositionToOffset(pos));
    }

    public int getVisibleLineCount() {
        return (Integer)EditorThreading.compute(() -> this.myView.getVisibleLineCount());
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        if (logicalPos == null) {
            EditorImpl.$$$reportNull$$$0(97);
        }
        VisualPosition visualPosition = (VisualPosition)EditorThreading.compute(() -> this.myView.logicalToVisualPosition(logicalPos, false));
        if (visualPosition == null) {
            EditorImpl.$$$reportNull$$$0(98);
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        if (visiblePos == null) {
            EditorImpl.$$$reportNull$$$0(99);
        }
        LogicalPosition logicalPosition = (LogicalPosition)EditorThreading.compute(() -> this.myView.visualToLogicalPosition(visiblePos));
        if (logicalPosition == null) {
            EditorImpl.$$$reportNull$$$0(100);
        }
        return logicalPosition;
    }

    private int offsetToLogicalLine(int offset) {
        int textLength = this.myDocument.getTextLength();
        if (textLength == 0) {
            return 0;
        }
        if (offset > textLength || offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + " textLength: " + textLength);
        }
        int lineIndex = this.myDocument.getLineNumber(offset);
        LOG.assertTrue(lineIndex >= 0 && lineIndex < this.myDocument.getLineCount());
        return lineIndex;
    }

    @NotNull
    private VisualPosition getTargetPosition(int x, int y, boolean trimToLineWidth, @Nullable Caret targetCaret) {
        Caret caret;
        if (this.myDocument.getLineCount() == 0) {
            return new VisualPosition(0, 0);
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        int visualLineCount = this.getVisibleLineCount();
        if (this.yToVisualLine(y) >= visualLineCount) {
            y = this.visualLineToY(Math.max(0, visualLineCount - 1));
        }
        VisualPosition visualPosition = this.xyToVisualPosition(new Point(x, y));
        Object object = caret = targetCaret != null ? targetCaret : this.getCaretModel().getPrimaryCaret();
        if (EditorUtil.isBlockLikeCaret(caret) && !visualPosition.leansRight && visualPosition.column > 0) {
            visualPosition = new VisualPosition(visualPosition.line, visualPosition.column - 1, true);
        }
        if (trimToLineWidth && !this.mySettings.isVirtualSpace()) {
            LogicalPosition logicalPosition = this.visualToLogicalPosition(visualPosition);
            LogicalPosition lineEndPosition = this.offsetToLogicalPosition(this.myDocument.getLineEndOffset(logicalPosition.line));
            if (logicalPosition.column > lineEndPosition.column) {
                visualPosition = this.logicalToVisualPosition(lineEndPosition.leanForward(true));
            } else if (this.mySoftWrapModel.isInsideSoftWrap(visualPosition)) {
                VisualPosition beforeSoftWrapPosition = this.myView.logicalToVisualPosition(logicalPosition, true);
                visualPosition = visualPosition.line == beforeSoftWrapPosition.line ? beforeSoftWrapPosition : this.myView.logicalToVisualPosition(logicalPosition, false);
            }
        }
        VisualPosition visualPosition2 = visualPosition;
        if (visualPosition2 == null) {
            EditorImpl.$$$reportNull$$$0(101);
        }
        return visualPosition2;
    }

    private boolean checkIgnore(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(102);
        }
        if (!this.myIgnoreMouseEventsConsecutiveToInitial) {
            this.myInitialMouseEvent = null;
            return false;
        }
        if (!(this.myInitialMouseEvent == null || e.getComponent() == this.myInitialMouseEvent.getComponent() && e.getPoint().equals(this.myInitialMouseEvent.getPoint()))) {
            this.myIgnoreMouseEventsConsecutiveToInitial = false;
            this.myInitialMouseEvent = null;
            return false;
        }
        this.myIgnoreMouseEventsConsecutiveToInitial = false;
        this.myInitialMouseEvent = null;
        e.consume();
        return true;
    }

    private void processMouseReleased(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(103);
        }
        if (this.checkIgnore(e)) {
            return;
        }
        if (!(e.getSource() != this.myGutterComponent || this.myMousePressedEvent != null && this.myMousePressedEvent.isConsumed())) {
            this.myGutterComponent.mouseReleased(e);
        }
        if (this.getMouseEventArea(e) != EditorMouseEventArea.EDITING_AREA || e.getY() < 0 || e.getX() < 0) {
            return;
        }
        FoldRegion region = this.getFoldingModel().getFoldingPlaceholderAt(e.getPoint());
        if (region != null && region == this.myMouseSelectedRegion) {
            this.getFoldingModel().runBatchFoldingOperation(() -> region.setExpanded(true), true, false);
            this.validateMousePointer(e, null);
        }
        if (!(this.myMousePressedEvent == null || !this.myKeepSelectionOnMousePress || this.myLastPressWasAtBlockInlay || this.myDragStarted || this.myMousePressedEvent.getClickCount() != 1 || this.myMousePressedEvent.isShiftDown() || this.myMousePressedEvent.isPopupTrigger() || e.isPopupTrigger() || EditorImpl.isToggleCaretEvent(this.myMousePressedEvent) || EditorImpl.isCreateRectangularSelectionEvent(this.myMousePressedEvent))) {
            this.getSelectionModel().removeSelection();
        }
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext2 = EditorUtil.getEditorDataContext(this);
        if (dataContext2 == null) {
            EditorImpl.$$$reportNull$$$0(104);
        }
        return dataContext2;
    }

    private boolean isInsideGutterWhitespaceArea(@NotNull MouseEvent e) {
        EditorMouseEventArea area;
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(105);
        }
        return (area = this.getMouseEventArea(e)) == EditorMouseEventArea.FOLDING_OUTLINE_AREA && this.myGutterComponent.convertX(e.getX()) > this.myGutterComponent.getWhitespaceSeparatorOffset();
    }

    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(106);
        }
        return (EditorMouseEventArea)EditorThreading.compute(() -> {
            if (this.myGutterComponent != e.getSource()) {
                return EditorMouseEventArea.EDITING_AREA;
            }
            int x = this.myGutterComponent.convertX(e.getX());
            return this.myGutterComponent.getEditorMouseAreaByOffset(x);
        });
    }

    private void requestFocus() {
        if (!this.myEditorComponent.hasFocus()) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myEditorComponent, true);
        }
    }

    private void resetMousePointer() {
        UIUtil.setCursor((Component)this.myEditorComponent, (Cursor)Cursor.getPredefinedCursor(2));
    }

    private void validateMousePointer(@NotNull MouseEvent e, @Nullable EditorMouseEvent editorMouseEvent) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(107);
        }
        if (e.getSource() == this.myGutterComponent) {
            this.myGutterComponent.validateMousePointer(e);
        } else {
            this.myGutterComponent.setActiveFoldRegions(Collections.emptyList());
            this.myDefaultCursor = this.getDefaultCursor(e, editorMouseEvent);
            this.updateEditorCursor();
        }
    }

    private void updateEditorCursor() {
        Cursor cursor;
        Cursor customCursor = this.getCustomCursor();
        if (customCursor == null && this.myCursorSetExternally && this.myEditorComponent.isCursorSet() && (cursor = this.myEditorComponent.getCursor()) != Cursor.getPredefinedCursor(0) && cursor != Cursor.getPredefinedCursor(2) && cursor != EMPTY_CURSOR) {
            return;
        }
        UIUtil.setCursor((Component)this.myEditorComponent, (Cursor)(customCursor == null ? this.myDefaultCursor : customCursor));
        this.myCursorSetExternally = false;
    }

    @NotNull
    private Cursor getDefaultCursor(@NotNull MouseEvent e, @Nullable EditorMouseEvent editorMouseEvent) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(108);
        }
        Cursor result2 = null;
        if (this.getSelectionModel().hasSelection() && (e.getModifiersEx() & 0xC00) == 0) {
            int offset;
            int n = offset = editorMouseEvent == null ? this.logicalPositionToOffset(this.xyToLogicalPosition(e.getPoint())) : editorMouseEvent.getOffset();
            if (this.getSelectionModel().getSelectionStart() <= offset && offset < this.getSelectionModel().getSelectionEnd()) {
                result2 = Cursor.getPredefinedCursor(0);
            }
        }
        if (result2 == null) {
            FoldRegion foldRegion;
            FoldRegion foldRegion2 = foldRegion = editorMouseEvent == null ? this.myFoldingModel.getFoldingPlaceholderAt(e.getPoint()) : editorMouseEvent.getCollapsedFoldRegion();
            if (foldRegion != null && !(foldRegion instanceof CustomFoldRegion)) {
                result2 = Cursor.getPredefinedCursor(12);
            }
        }
        Cursor cursor = result2 == null ? Cursor.getPredefinedCursor(2) : result2;
        if (cursor == null) {
            EditorImpl.$$$reportNull$$$0(109);
        }
        return cursor;
    }

    private void runMouseDraggedCommand(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(110);
        }
        if (this.myCommandProcessor == null || e.isConsumed() || this.myMousePressedEvent != null && this.myMousePressedEvent.isConsumed()) {
            return;
        }
        WriteIntentReadAction.run(() -> this.myCommandProcessor.executeCommand(this.myProject, () -> this.mouseDragHandler.mouseDragged(e), "", MOUSE_DRAGGED_COMMAND_GROUP, UndoConfirmationPolicy.DEFAULT, (Document)this.getDocument()));
    }

    private void processMouseDragged(@NotNull MouseEvent e) {
        boolean columnSelectionDrag;
        EditorMouseEventArea eventArea;
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(111);
        }
        if (!SwingUtilities.isLeftMouseButton(e) && !SwingUtilities.isMiddleMouseButton(e) || Registry.is((String)"editor.disable.drag.with.right.button") && SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        if (!this.myMouseDragStarted) {
            Point point = EditorImpl.convertPoint(e.getComponent(), e.getPoint(), this.myEditorComponent);
            int sensitivity = EditorImpl.dragSensitivity();
            boolean bl = this.myMouseDragStarted = this.myLastMousePressedPoint == null || !this.myLastPressedOnGutter || Math.abs(this.myLastMousePressedPoint.x - point.x) >= sensitivity || Math.abs(this.myLastMousePressedPoint.y - point.y) >= sensitivity;
            if (!this.myMouseDragStarted) {
                return;
            }
            if (this.mySuppressedByBreakpointsLastPressPosition != null) {
                this.getCaretModel().removeSecondaryCarets();
                this.getCaretModel().moveToVisualPosition(this.mySuppressedByBreakpointsLastPressPosition);
                this.mySuppressedByBreakpointsLastPressPosition = null;
            }
        }
        if ((eventArea = this.getMouseEventArea(e)) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            return;
        }
        if (eventArea == EditorMouseEventArea.LINE_MARKERS_AREA || eventArea == EditorMouseEventArea.FOLDING_OUTLINE_AREA && !this.isInsideGutterWhitespaceArea(e)) {
            if (this.myDragOnGutterSelectionStartLine >= 0) {
                this.mySelectionModel.removeSelection();
                this.myCaretModel.moveToOffset(this.myDragOnGutterSelectionStartLine < this.myDocument.getLineCount() ? this.myDocument.getLineStartOffset(this.myDragOnGutterSelectionStartLine) : this.myDocument.getTextLength());
            }
            this.myDragOnGutterSelectionStartLine = -1;
        }
        if (eventArea == EditorMouseEventArea.LINE_NUMBERS_AREA && NewUI.isEnabled() && EditorUtil.isBreakPointsOnLineNumbers() && this.getMouseSelectionState() != 2 && !this.myLastPressedOnGutterIcon && !this.myDragSelectionStarted) {
            this.selectLineAtCaret(true);
            this.getGutterComponentEx().putClientProperty("active.line.number", null);
            this.myDragSelectionStarted = true;
        }
        boolean columnSelectionDragEvent = EditorImpl.isColumnSelectionDragEvent(e);
        boolean toggleCaretEvent = EditorImpl.isToggleCaretEvent(e);
        boolean addRectangularSelectionEvent = EditorImpl.isAddRectangularSelectionEvent(e);
        boolean bl = columnSelectionDrag = this.isColumnMode() && !this.myLastPressCreatedCaret || columnSelectionDragEvent;
        if (!columnSelectionDragEvent && toggleCaretEvent && !this.myLastPressCreatedCaret) {
            return;
        }
        if (this.myLastPressWasAtBlockInlay) {
            return;
        }
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int x = e.getX();
        if (e.getSource() == this.myGutterComponent) {
            x = 0;
        }
        int dx = 0;
        if (x < visibleArea.x && visibleArea.x > 0) {
            dx = x - visibleArea.x;
        } else if (x > visibleArea.x + visibleArea.width) {
            dx = x - visibleArea.x - visibleArea.width;
        }
        int dy = 0;
        int y = e.getY();
        if (y < visibleArea.y && visibleArea.y > 0) {
            dy = y - visibleArea.y;
        } else if (y > visibleArea.y + visibleArea.height && visibleArea.y + visibleArea.height < this.myEditorComponent.getHeight()) {
            dy = y - visibleArea.y - visibleArea.height;
        }
        if (dx == 0 && dy == 0) {
            this.myScrollingTimer.stop();
            if (this.myLastPressedOnGutterIcon) {
                return;
            }
            SelectionModelImpl selectionModel = this.getSelectionModel();
            Caret leadCaret = this.getLeadCaret();
            int oldSelectionStart = leadCaret.getLeadSelectionOffset();
            VisualPosition oldVisLeadSelectionStart = leadCaret.getLeadSelectionPosition();
            int oldCaretOffset = this.getCaretModel().getOffset();
            boolean multiCaretSelection = columnSelectionDrag || toggleCaretEvent;
            VisualPosition newVisualCaret = this.getTargetPosition(x, y, !multiCaretSelection, leadCaret);
            LogicalPosition newLogicalCaret = this.visualToLogicalPosition(newVisualCaret);
            if (multiCaretSelection) {
                this.myMultiSelectionInProgress = true;
                this.myRectangularSelectionInProgress = columnSelectionDrag || addRectangularSelectionEvent;
                this.myTargetMultiSelectionPosition = this.xyToVisualPosition(new Point(Math.max(x, 0), Math.max(y, 0)));
            } else {
                this.getCaretModel().moveToVisualPosition(newVisualCaret);
            }
            int newCaretOffset = this.getCaretModel().getOffset();
            newVisualCaret = this.getCaretModel().getVisualPosition();
            int caretShift = newCaretOffset - this.mySavedSelectionStart;
            if (this.myMousePressedEvent != null && this.getMouseEventArea(this.myMousePressedEvent) != EditorMouseEventArea.EDITING_AREA && this.getMouseEventArea(this.myMousePressedEvent) != EditorMouseEventArea.LINE_NUMBERS_AREA) {
                selectionModel.setSelection(oldSelectionStart, newCaretOffset);
                this.myDragSelectionStarted = true;
            } else if (multiCaretSelection) {
                if (this.myLastMousePressedLocation != null && (this.myCurrentDragIsSubstantial || !newLogicalCaret.equals((Object)this.myLastMousePressedLocation))) {
                    this.createSelectionTill(newLogicalCaret);
                    this.blockActionsIfNeeded(e, this.myLastMousePressedLocation, newLogicalCaret);
                    this.myDragSelectionStarted = true;
                }
            } else {
                if (this.getMouseSelectionState() != 0) {
                    this.setupSpecialSelectionOnMouseDrag(newCaretOffset, caretShift);
                    this.cancelAutoResetForMouseSelectionState();
                    return;
                }
                if (!this.myKeepSelectionOnMousePress) {
                    if ((this.myMousePressArea == EditorMouseEventArea.LINE_NUMBERS_AREA || this.myMousePressArea == EditorMouseEventArea.LINE_MARKERS_AREA) && selectionModel.hasSelection()) {
                        if (newCaretOffset >= selectionModel.getSelectionEnd()) {
                            oldSelectionStart = selectionModel.getSelectionStart();
                            oldVisLeadSelectionStart = selectionModel.getSelectionStartPosition();
                        } else if (newCaretOffset <= selectionModel.getSelectionStart()) {
                            oldSelectionStart = selectionModel.getSelectionEnd();
                            oldVisLeadSelectionStart = selectionModel.getSelectionEndPosition();
                        }
                    } else if (EditorUtil.isBlockLikeCaret(this.getCaretModel().getPrimaryCaret()) && Registry.is((String)"editor.block.caret.selection.vim-like")) {
                        if (this.mySelectionModel.hasSelection() && oldVisLeadSelectionStart.equals((Object)this.mySelectionModel.getSelectionEndPosition())) {
                            oldVisLeadSelectionStart = this.prevSelectionVisualPosition(oldVisLeadSelectionStart);
                        }
                        if (newVisualCaret.after(oldVisLeadSelectionStart)) {
                            newVisualCaret = this.nextSelectionVisualPosition(newVisualCaret);
                            newCaretOffset = this.visualPositionToOffset(newVisualCaret);
                        } else if (oldVisLeadSelectionStart.after(newVisualCaret) || oldVisLeadSelectionStart.equals((Object)newVisualCaret) && this.mySelectionModel.hasSelection()) {
                            oldVisLeadSelectionStart = this.nextSelectionVisualPosition(oldVisLeadSelectionStart);
                        }
                        oldSelectionStart = this.visualPositionToOffset(oldVisLeadSelectionStart);
                    }
                    this.setSelectionAndBlockActions(e, oldVisLeadSelectionStart, oldSelectionStart, newVisualCaret, newCaretOffset);
                    this.cancelAutoResetForMouseSelectionState();
                    this.myDragSelectionStarted = true;
                } else if (caretShift != 0 && this.myMousePressedEvent != null) {
                    if (this.mySettings.isDndEnabled()) {
                        if (!this.myDragStarted) {
                            if (ApplicationManager.getApplication().isUnitTestMode()) {
                                throw new UnsupportedOperationException("Drag'n'drop operation shouldn't be started in tests");
                            }
                            this.myDragStarted = true;
                            boolean isCopy = UIUtil.isControlKeyDown((MouseEvent)e) || this.isViewer() || !this.getDocument().isWritable();
                            this.mySavedCaretOffsetForDNDUndoHack = oldCaretOffset;
                            this.getContentComponent().getTransferHandler().exportAsDrag(this.getContentComponent(), e, isCopy ? 1 : 2);
                        }
                    } else {
                        selectionModel.removeSelection();
                    }
                }
            }
        } else {
            this.myScrollingTimer.start(dx, dy);
            this.onSubstantialDrag(e);
        }
    }

    @ApiStatus.Internal
    public static int dragSensitivity() {
        return Registry.intValue((String)"editor.drag.sensitivity", (int)5, (int)0, (int)25);
    }

    @NotNull
    private static Point convertPoint(@NotNull Component from, @NotNull Point point, @NotNull Component to) {
        if (from == null) {
            EditorImpl.$$$reportNull$$$0(112);
        }
        if (point == null) {
            EditorImpl.$$$reportNull$$$0(113);
        }
        if (to == null) {
            EditorImpl.$$$reportNull$$$0(114);
        }
        Point result2 = new Point(point);
        Component fromTopParent = from;
        for (Container c = from.getParent(); c != null; c = c.getParent()) {
            fromTopParent = c;
            if (c.getParent() == null) break;
            result2.translate(c.getX(), c.getY());
        }
        Component toTopParent = to;
        Point toOffset = new Point(0, 0);
        for (Container c = to.getParent(); c != null; c = c.getParent()) {
            toTopParent = c;
            if (c.getParent() == null) break;
            toOffset.translate(c.getX(), c.getY());
        }
        if (fromTopParent != toTopParent) {
            throw new IllegalArgumentException("Components don't have a common parent: " + String.valueOf(from) + " and " + String.valueOf(to));
        }
        result2.translate(-toOffset.x, -toOffset.y);
        Point point2 = result2;
        if (point2 == null) {
            EditorImpl.$$$reportNull$$$0(115);
        }
        return point2;
    }

    @NotNull
    private VisualPosition nextSelectionVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            EditorImpl.$$$reportNull$$$0(116);
        }
        if (!this.isColumnMode() && pos.column >= EditorUtil.getLastVisualLineColumnNumber(this, pos.line)) {
            return new VisualPosition(pos.line + 1, 0, false);
        }
        return new VisualPosition(pos.line, pos.column + 1, false);
    }

    @NotNull
    private VisualPosition prevSelectionVisualPosition(@NotNull VisualPosition pos) {
        int prevColumn;
        if (pos == null) {
            EditorImpl.$$$reportNull$$$0(117);
        }
        if ((prevColumn = pos.column - 1) >= 0) {
            return new VisualPosition(pos.line, prevColumn, true);
        }
        if (this.isColumnMode() || pos.line == 0) {
            return new VisualPosition(pos.line, 0, true);
        }
        int prevLine = pos.line - 1;
        return new VisualPosition(prevLine, EditorUtil.getLastVisualLineColumnNumber(this, prevLine), true);
    }

    private void setupSpecialSelectionOnMouseDrag(int newCaretOffset, int caretShift) {
        int newSelectionStart;
        int newSelectionEnd = newCaretOffset;
        if (caretShift < 0) {
            if (this.getMouseSelectionState() == 1) {
                newSelectionEnd = this.myCaretModel.getWordAtCaretStart(this.mySettings.isCamelWords() && this.mySettings.isMouseClickSelectionHonorsCamelWords());
            } else if (this.getMouseSelectionState() == 2) {
                newSelectionEnd = this.visualPositionToOffset(new VisualPosition(this.getCaretModel().getVisualPosition().line, 0));
            }
            newSelectionStart = this.validateOffset(this.mySavedSelectionEnd);
        } else {
            if (this.getMouseSelectionState() == 1) {
                newSelectionEnd = this.myCaretModel.getWordAtCaretEnd(this.mySettings.isCamelWords() && this.mySettings.isMouseClickSelectionHonorsCamelWords());
            } else if (this.getMouseSelectionState() == 2) {
                newSelectionEnd = this.visualPositionToOffset(new VisualPosition(this.getCaretModel().getVisualPosition().line + 1, 0));
            }
            newSelectionStart = this.validateOffset(this.mySavedSelectionStart);
        }
        if (newSelectionEnd < 0) {
            newSelectionEnd = newCaretOffset;
        }
        this.mySelectionModel.setSelection(newSelectionStart, newSelectionEnd);
        this.myCaretModel.moveToOffset(newSelectionEnd);
    }

    private int validateOffset(int offset) {
        if (offset < 0) {
            return 0;
        }
        if (offset > this.myDocument.getTextLength()) {
            return this.myDocument.getTextLength();
        }
        return offset;
    }

    void clearDnDContext() {
        if (this.myDraggedRange != null) {
            this.myDraggedRange.dispose();
            this.myDraggedRange = null;
        }
        this.myGutterComponent.myDnDInProgress = false;
    }

    private void createSelectionTill(@NotNull LogicalPosition targetPosition) {
        if (targetPosition == null) {
            EditorImpl.$$$reportNull$$$0(118);
        }
        ArrayList<CaretState> caretStates = new ArrayList<CaretState>(this.myCaretStateBeforeLastPress);
        if (this.myRectangularSelectionInProgress) {
            caretStates.addAll(EditorModificationUtil.calcBlockSelectionState((Editor)this, (LogicalPosition)this.myLastMousePressedLocation, (LogicalPosition)targetPosition));
        } else {
            LogicalPosition selectionStart = this.myLastMousePressedLocation;
            LogicalPosition selectionEnd = targetPosition;
            if (this.getMouseSelectionState() != 0) {
                int newCaretOffset = this.logicalPositionToOffset(targetPosition);
                if (newCaretOffset < this.mySavedSelectionStart) {
                    selectionStart = this.offsetToLogicalPosition(this.mySavedSelectionEnd);
                    if (this.getMouseSelectionState() == 2) {
                        targetPosition = selectionEnd = this.visualToLogicalPosition(new VisualPosition(this.offsetToVisualLine(newCaretOffset), 0));
                    }
                } else {
                    selectionStart = this.offsetToLogicalPosition(this.mySavedSelectionStart);
                    int selectionEndOffset = Math.max(newCaretOffset, this.mySavedSelectionEnd);
                    if (this.getMouseSelectionState() == 1) {
                        targetPosition = selectionEnd = this.offsetToLogicalPosition(selectionEndOffset);
                    } else if (this.getMouseSelectionState() == 2) {
                        targetPosition = selectionEnd = this.visualToLogicalPosition(new VisualPosition(this.offsetToVisualLine(selectionEndOffset) + 1, 0));
                    }
                }
                this.cancelAutoResetForMouseSelectionState();
            }
            caretStates.add(new CaretState(targetPosition, selectionStart, selectionEnd));
        }
        this.myCaretModel.setCaretsAndSelections(caretStates);
    }

    @NotNull
    private Caret getLeadCaret() {
        List<Caret> allCarets = this.myCaretModel.getAllCarets();
        Caret firstCaret = allCarets.get(0);
        if (firstCaret == this.myCaretModel.getPrimaryCaret()) {
            Caret caret = allCarets.get(allCarets.size() - 1);
            if (caret == null) {
                EditorImpl.$$$reportNull$$$0(119);
            }
            return caret;
        }
        Caret caret = firstCaret;
        if (caret == null) {
            EditorImpl.$$$reportNull$$$0(120);
        }
        return caret;
    }

    private void setSelectionAndBlockActions(@NotNull MouseEvent mouseDragEvent, @NotNull VisualPosition startPosition, int startOffset, @NotNull VisualPosition endPosition, int endOffset) {
        if (mouseDragEvent == null) {
            EditorImpl.$$$reportNull$$$0(121);
        }
        if (startPosition == null) {
            EditorImpl.$$$reportNull$$$0(122);
        }
        if (endPosition == null) {
            EditorImpl.$$$reportNull$$$0(123);
        }
        this.mySelectionModel.setSelection(startPosition, startOffset, endPosition, endOffset);
        if (this.myCurrentDragIsSubstantial || startOffset != endOffset || !Comparing.equal((Object)startPosition, (Object)endPosition)) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void blockActionsIfNeeded(@NotNull MouseEvent mouseDragEvent, @NotNull LogicalPosition startPosition, @NotNull LogicalPosition endPosition) {
        if (mouseDragEvent == null) {
            EditorImpl.$$$reportNull$$$0(124);
        }
        if (startPosition == null) {
            EditorImpl.$$$reportNull$$$0(125);
        }
        if (endPosition == null) {
            EditorImpl.$$$reportNull$$$0(126);
        }
        if (this.myCurrentDragIsSubstantial || !startPosition.equals((Object)endPosition)) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void onSubstantialDrag(@NotNull MouseEvent mouseDragEvent) {
        if (mouseDragEvent == null) {
            EditorImpl.$$$reportNull$$$0(127);
        }
        IdeEventQueue.getInstance().blockNextEvents(mouseDragEvent, IdeEventQueue.BlockMode.ACTIONS);
        this.myCurrentDragIsSubstantial = true;
    }

    void updateCaretCursor() {
        this.myUpdateCursor = true;
        if (this.myCaretCursor.myIsShown) {
            this.myCaretCursor.myStartTime = System.currentTimeMillis();
        } else {
            this.myCaretCursor.myIsShown = true;
            this.myCaretCursor.myBlinkOpacity = 1.0f;
            this.myCaretCursor.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCursorPosition() {
        EditorCaretMoveService editorCaretMoveService = this.caretMoveService;
        synchronized (editorCaretMoveService) {
            if (!this.getSettings().isAnimatedCaret() || this.gainedFocus.getAndSet(false) || this.myMouseDragStarted) {
                this.caretMoveService.setCursorPositionImmediately(this);
            } else {
                this.caretMoveService.setCursorPosition(this);
            }
        }
    }

    @Override
    public boolean setCaretVisible(boolean b) {
        return (Boolean)EditorThreading.compute(() -> {
            boolean old = this.myCaretCursor.isActive();
            if (b) {
                this.myCaretCursor.activate();
            } else {
                this.myCaretCursor.passivate();
            }
            return old;
        });
    }

    @Override
    public boolean setCaretEnabled(boolean enabled2) {
        return (Boolean)EditorThreading.compute(() -> {
            boolean old = this.myCaretCursor.isEnabled();
            this.myCaretCursor.setEnabled(enabled2);
            return old;
        });
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener2) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(128);
        }
        this.myFocusListeners.add(listener2);
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(129);
        }
        if (parentDisposable == null) {
            EditorImpl.$$$reportNull$$$0(130);
        }
        ContainerUtil.add((Object)listener2, this.myFocusListeners, (Disposable)parentDisposable);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isOneLineMode() {
        return this.myState.isOneLineMode();
    }

    @Override
    public boolean isEmbeddedIntoDialogWrapper() {
        return this.myState.isEmbeddedIntoDialogWrapper();
    }

    @Override
    public void setEmbeddedIntoDialogWrapper(boolean b) {
        EditorImpl.assertIsDispatchThread();
        EditorThreading.run(() -> this.myState.setEmbeddedIntoDialogWrapper(b));
    }

    private void isEmbeddedIntoDialogWrapperChanged(ObservableStateListener.PropertyChangeEvent event) {
        EditorImpl.assertIsDispatchThread();
        Object newValue = event.getNewValue();
        if (!(newValue instanceof Boolean)) {
            LOG.error("newValue is not Boolean. property name = " + event.getPropertyName() + ", newValue = " + String.valueOf(newValue));
            return;
        }
        boolean newValueBoolean = (Boolean)newValue;
        this.myScrollPane.setFocusable(!newValueBoolean);
        this.myEditorComponent.setFocusCycleRoot(!newValueBoolean);
        this.myEditorComponent.setFocusable(newValueBoolean);
    }

    @Override
    public void setOneLineMode(boolean isOneLineMode) {
        this.myState.setOneLineMode(isOneLineMode);
    }

    private void isOneLineModeChanged(ObservableStateListener.PropertyChangeEvent event) {
        JComponent component2;
        Object newValue = event.getNewValue();
        if (!(newValue instanceof Boolean)) {
            LOG.error("newValue is not Boolean. property name = " + event.getPropertyName() + ", newValue = " + String.valueOf(newValue));
            return;
        }
        this.mouseDragHandler.setNativeSelectionEnabled((Boolean)newValue);
        this.getScrollPane().setInputMap(1, null);
        JBScrollPane pane2 = (JBScrollPane)ObjectUtils.tryCast((Object)this.getScrollPane(), JBScrollPane.class);
        JComponent jComponent = component2 = pane2 == null ? null : pane2.getStatusComponent();
        if (component2 != null) {
            component2.setVisible(!this.isOneLineMode());
        }
        this.reinitSettings();
        Object oldValue = EditorImpl.extractOldValueOrLog(event, false);
        this.myPropertyChangeSupport.firePropertyChange("oneLineMode", oldValue, event.getNewValue());
    }

    @ApiStatus.Internal
    public float getCaretBlinkOpacity() {
        return this.myCaretCursor.getBlinkOpacity();
    }

    private static void updateOpaque(@Nullable JScrollBar bar2) {
        if (bar2 instanceof OpaqueAwareScrollBar) {
            bar2.setOpaque(((OpaqueAwareScrollBar)((Object)bar2)).myOpaque);
        }
    }

    @Override
    @NotNull
    public CopyProvider getCopyProvider() {
        EditorCopyPastProvider editorCopyPastProvider = this.myEditable;
        if (editorCopyPastProvider == null) {
            EditorImpl.$$$reportNull$$$0(131);
        }
        return editorCopyPastProvider;
    }

    @Override
    @NotNull
    public CutProvider getCutProvider() {
        EditorCopyPastProvider editorCopyPastProvider = this.myEditable;
        if (editorCopyPastProvider == null) {
            EditorImpl.$$$reportNull$$$0(132);
        }
        return editorCopyPastProvider;
    }

    @Override
    @NotNull
    public PasteProvider getPasteProvider() {
        EditorCopyPastProvider editorCopyPastProvider = this.myEditable;
        if (editorCopyPastProvider == null) {
            EditorImpl.$$$reportNull$$$0(133);
        }
        return editorCopyPastProvider;
    }

    @Override
    @NotNull
    public DeleteProvider getDeleteProvider() {
        EditorCopyPastProvider editorCopyPastProvider = this.myEditable;
        if (editorCopyPastProvider == null) {
            EditorImpl.$$$reportNull$$$0(134);
        }
        return editorCopyPastProvider;
    }

    @ApiStatus.Internal
    @Nullable
    public CharacterGrid getCharacterGrid() {
        if (this.getSettings().getCharacterGridWidthMultiplier() == null) {
            this.myCharacterGrid = null;
            return null;
        }
        if (this.myCharacterGrid == null) {
            this.myCharacterGrid = new CharacterGridImpl(this);
        }
        return this.myCharacterGrid;
    }

    @Override
    public void setColorsScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            EditorImpl.$$$reportNull$$$0(135);
        }
        EditorImpl.assertIsDispatchThread();
        EditorThreading.run(() -> {
            EditorColorsManager colorsManager = (EditorColorsManager)ApplicationManager.getApplication().getServiceIfCreated(EditorColorsManager.class);
            if (colorsManager == null) {
                LOG.info("Skipping attempt to set color scheme without EditorColorsManager");
                return;
            }
            this.myScheme = scheme instanceof EditorColorSchemeDelegate ? (EditorColorSchemeDelegate)scheme : new EditorColorSchemeDelegate(this, scheme);
            this.reinitSettings();
        });
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        EditorColorSchemeDelegate editorColorSchemeDelegate = this.myScheme;
        if (editorColorSchemeDelegate == null) {
            EditorImpl.$$$reportNull$$$0(136);
        }
        return editorColorSchemeDelegate;
    }

    static void assertIsDispatchThread() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @Override
    public void setVerticalScrollbarOrientation(int type) {
        EditorImpl.assertIsDispatchThread();
        EditorThreading.run(() -> this.myState.setVerticalScrollBarOrientation(type));
    }

    private void verticalScrollBarOrientationChanged(ObservableStateListener.PropertyChangeEvent event) {
        EditorImpl.assertIsDispatchThread();
        Object newValue = event.getNewValue();
        if (!(newValue instanceof Integer)) {
            LOG.error("newValue is not Integer. property name = " + event.getPropertyName() + ", newValue = " + String.valueOf(newValue));
            return;
        }
        int currentHorOffset = this.myScrollingModel.getHorizontalScrollOffset();
        this.myScrollPane.putClientProperty(JBScrollPane.Flip.class, (Integer)newValue == 0 ? JBScrollPane.Flip.HORIZONTAL : null);
        this.myScrollingModel.scrollHorizontally(currentHorOffset);
    }

    @Override
    public void setVerticalScrollbarVisible(boolean b) {
        this.myScrollPane.setVerticalScrollBarPolicy(b ? 22 : 21);
    }

    @Override
    public void setHorizontalScrollbarVisible(boolean b) {
        this.myScrollPane.setHorizontalScrollBarPolicy(b ? 30 : 31);
    }

    @Override
    public int getVerticalScrollbarOrientation() {
        return this.myState.getVerticalScrollBarOrientation();
    }

    public boolean isMirrored() {
        return this.myState.getVerticalScrollBarOrientation() != 1;
    }

    @NotNull
    MyScrollBar getVerticalScrollBar() {
        MyScrollBar myScrollBar = this.myVerticalScrollBar;
        if (myScrollBar == null) {
            EditorImpl.$$$reportNull$$$0(137);
        }
        return myScrollBar;
    }

    @ApiStatus.Internal
    public int getStickyLinesPanelWidth() {
        return this.myPanel.getWidth();
    }

    @MouseSelectionState
    private int getMouseSelectionState() {
        return this.myMouseSelectionState;
    }

    @ApiStatus.Internal
    public void updateMouseWordSelectionStateToCaret() {
        if (this.myMouseSelectionState != 1) {
            return;
        }
        CaretImpl caret = this.getCaretModel().getCurrentCaret();
        this.mySavedSelectionStart = caret.getSelectionStart();
        this.mySavedSelectionEnd = caret.getSelectionEnd();
        caret.moveToOffset(this.mySavedSelectionEnd);
    }

    private void setMouseSelectionState(@MouseSelectionState int mouseSelectionState) {
        if (this.getMouseSelectionState() == mouseSelectionState) {
            return;
        }
        this.myMouseSelectionState = mouseSelectionState;
        this.myMouseSelectionChangeTimestamp = System.currentTimeMillis();
        this.mouseSelectionStateAlarm.cancel();
        if (this.myMouseSelectionState != 0) {
            if (this.mouseSelectionStateResetRunnable == null) {
                this.mouseSelectionStateResetRunnable = () -> WriteIntentReadAction.run(() -> this.resetMouseSelectionState(null, null));
            }
            this.mouseSelectionStateAlarm.request((long)Registry.intValue((String)"editor.mouseSelectionStateResetTimeout"), ModalityState.stateForComponent((Component)this.myEditorComponent), this.mouseSelectionStateResetRunnable);
        }
    }

    private void resetMouseSelectionState(@Nullable MouseEvent event, @Nullable EditorMouseEvent editorMouseEvent) {
        MouseEvent e;
        this.setMouseSelectionState(0);
        MouseEvent mouseEvent = e = event != null ? event : this.myMouseMovedEvent;
        if (e != null) {
            this.validateMousePointer(e, editorMouseEvent);
        }
    }

    private void cancelAutoResetForMouseSelectionState() {
        this.mouseSelectionStateAlarm.cancel();
    }

    @RequiresEdt(generateAssertion=false)
    @NotNull
    EditorInputMethodSupport getInputMethodSupport() {
        if (this.myInputMethodSupport == null) {
            MyInputMethodHandler handler = new MyInputMethodHandler();
            this.myInputMethodSupport = new EditorInputMethodSupport(handler, new EditorInputMethodListener(handler));
        }
        EditorInputMethodSupport editorInputMethodSupport = this.myInputMethodSupport;
        if (editorInputMethodSupport == null) {
            EditorImpl.$$$reportNull$$$0(138);
        }
        return editorInputMethodSupport;
    }

    @ApiStatus.Internal
    @RequiresEdt(generateAssertion=false)
    public void setInputMethodSupport(@Nullable EditorInputMethodSupport inputMethodSupport) {
        this.myInputMethodSupport = inputMethodSupport;
    }

    @Override
    public boolean processKeyTyped(@NotNull KeyEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(139);
        }
        this.myLastTypedActionTimestamp = -1L;
        if (e.getID() != 400) {
            return false;
        }
        if (!UIUtil.isReallyTypedEvent((KeyEvent)e)) {
            return false;
        }
        char c = e.getKeyChar();
        this.myLastTypedActionTimestamp = e.getWhen();
        this.myLastTypedAction = Character.toString(c);
        this.processKeyTyped(c);
        return true;
    }

    public void recordLatencyAwareAction(@NotNull String actionId, long timestampMs) {
        if (actionId == null) {
            EditorImpl.$$$reportNull$$$0(140);
        }
        this.myLastTypedActionTimestamp = timestampMs;
        this.myLastTypedAction = actionId;
    }

    void measureTypingLatency() {
        if (this.myLastTypedActionTimestamp == -1L) {
            return;
        }
        long latencyMs2 = System.currentTimeMillis() - this.myLastTypedActionTimestamp;
        this.myLastTypedActionTimestamp = -1L;
        LatencyListener latencyPublisher = this.myLatencyPublisher;
        if (latencyPublisher == null) {
            this.myLatencyPublisher = latencyPublisher = (LatencyListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LatencyListener.TOPIC);
        }
        latencyPublisher.recordTypingLatency((Editor)this, this.myLastTypedAction, latencyMs2);
    }

    public boolean isProcessingTypedAction() {
        return this.myLastTypedActionTimestamp != -1L;
    }

    void beforeModalityStateChanged() {
        this.myScrollingModel.beforeModalityStateChanged();
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myGutterComponent.resetMousePointer();
            this.resetMousePointer();
        }
    }

    EditorDropHandler getDropHandler() {
        return this.myDropHandler;
    }

    public void setDropHandler(@NotNull EditorDropHandler dropHandler) {
        if (dropHandler == null) {
            EditorImpl.$$$reportNull$$$0(141);
        }
        this.myDropHandler = dropHandler;
    }

    RangeMarker getDraggedRange() {
        return this.myDraggedRange;
    }

    void setDraggedRange(RangeMarker draggedRange) {
        this.myDraggedRange = draggedRange;
    }

    @Deprecated
    public void setHighlightingPredicate(@Nullable Predicate<? super RangeHighlighter> filter2) {
        if (filter2 == null) {
            this.removeHighlightingPredicate(EditorHighlightingPredicateWrapper.KEY);
        } else {
            EditorHighlightingPredicateWrapper wrapper2 = new EditorHighlightingPredicateWrapper(filter2);
            this.addHighlightingPredicate(EditorHighlightingPredicateWrapper.KEY, wrapper2);
        }
    }

    @ApiStatus.Experimental
    @RequiresEdt
    @Nullable
    public <T extends EditorHighlightingPredicate> T addHighlightingPredicate(@NotNull Key<T> key, @NotNull T predicate) {
        if (key == null) {
            EditorImpl.$$$reportNull$$$0(142);
        }
        if (predicate == null) {
            EditorImpl.$$$reportNull$$$0(143);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorHighlightingPredicate oldPredicate = (EditorHighlightingPredicate)this.getUserData(key);
        this.putUserData(key, predicate);
        HighlighterFilter oldFilter = this.myHighlightingFilter.updatePredicate(predicate, oldPredicate);
        this.updateRangeMarkers(oldFilter);
        return (T)oldPredicate;
    }

    @ApiStatus.Experimental
    @RequiresEdt
    @Nullable
    public <T extends EditorHighlightingPredicate> T removeHighlightingPredicate(@NotNull Key<T> key) {
        if (key == null) {
            EditorImpl.$$$reportNull$$$0(144);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorHighlightingPredicate predicate = (EditorHighlightingPredicate)this.getUserData(key);
        if (predicate == null) {
            return null;
        }
        this.putUserData(key, null);
        HighlighterFilter oldFilter = this.myHighlightingFilter.removePredicate(predicate);
        this.updateRangeMarkers(oldFilter);
        return (T)predicate;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    @RequiresEdt
    private void updateRangeMarkers(@Nullable HighlighterFilter highlighterFilter) {
        void oldFilter;
        ThreadingAssertions.assertEventDispatchThread();
        if (oldFilter == null) {
            return;
        }
        TextEditor textEditor = null;
        for (RangeHighlighter highlighter : this.myEditorFilteringMarkupModel.getDelegate().getAllHighlighters()) {
            JComponent component2;
            boolean newAvailable;
            boolean oldAvailable = oldFilter.shouldRender(highlighter);
            if (oldAvailable == (newAvailable = this.myHighlightingFilter.shouldRender(highlighter))) continue;
            TextAttributes attributes = highlighter.getTextAttributes(this.getColorsScheme());
            this.myMarkupModelListener.attributesChanged((RangeHighlighterEx)highlighter, true, EditorUtil.attributesImpactFontStyle(attributes), EditorUtil.attributesImpactForegroundColor(attributes));
            HighlightInfo fileLevelInfo = HighlightInfo.fromRangeHighlighter((RangeHighlighter)highlighter);
            if (fileLevelInfo == null || !fileLevelInfo.isFileLevelAnnotation()) continue;
            if (textEditor == null) {
                textEditor = TextEditorProvider.getInstance().getTextEditor(this);
            }
            if ((component2 = fileLevelInfo.getFileLevelComponent(textEditor)) == null) continue;
            component2.setVisible(newAvailable);
        }
    }

    boolean isHighlighterAvailable(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            EditorImpl.$$$reportNull$$$0(145);
        }
        return this.myHighlightingFilter.shouldRender(highlighter);
    }

    private boolean hasBlockInlay(@NotNull Point point) {
        Inlay<?> inlay;
        if (point == null) {
            EditorImpl.$$$reportNull$$$0(146);
        }
        return (inlay = this.myInlayModel.getElementAt(point)) != null && (inlay.getPlacement() == Inlay.Placement.ABOVE_LINE || inlay.getPlacement() == Inlay.Placement.BELOW_LINE);
    }

    private static boolean isColumnSelectionDragEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(147);
        }
        return EditorImpl.isMouseActionEvent(e, "EditorCreateRectangularSelectionOnMouseDrag");
    }

    private static boolean isToggleCaretEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(148);
        }
        return EditorImpl.isMouseActionEvent(e, "EditorAddOrRemoveCaret") || EditorImpl.isAddRectangularSelectionEvent(e);
    }

    private static boolean isAddRectangularSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(149);
        }
        return EditorImpl.isMouseActionEvent(e, "EditorAddRectangularSelectionOnMouseDrag");
    }

    private static boolean isCreateRectangularSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(150);
        }
        return EditorImpl.isMouseActionEvent(e, "EditorCreateRectangularSelection");
    }

    private static boolean isMouseActionEvent(@NotNull MouseEvent e, @NotNull String actionId) {
        MouseShortcut mouseShortcut;
        KeymapManager keymapManager;
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(151);
        }
        if (actionId == null) {
            EditorImpl.$$$reportNull$$$0(152);
        }
        if ((keymapManager = KeymapManager.getInstance()) == null) {
            return false;
        }
        Keymap keymap2 = keymapManager.getActiveKeymap();
        List mappedActions = keymap2.getActionIds(mouseShortcut = KeymapUtil.createMouseShortcut((MouseEvent)e));
        if (!mappedActions.contains(actionId)) {
            return false;
        }
        if (mappedActions.size() < 2 || e.getID() == 506) {
            return true;
        }
        ActionManager actionManager = ActionManager.getInstance();
        for (String mappedActionId : mappedActions) {
            if (actionId.equals(mappedActionId)) continue;
            AnAction action2 = actionManager.getAction(mappedActionId);
            DataContext dataContext2 = DataManager.getInstance().getDataContext(e.getComponent());
            AnActionEvent actionEvent = AnActionEvent.createFromAnAction((AnAction)action2, (InputEvent)e, (String)"MainMenu", (DataContext)dataContext2);
            ActionUtil.updateAction((AnAction)action2, (AnActionEvent)actionEvent);
            if (!actionEvent.getPresentation().isEnabled()) continue;
            return false;
        }
        return true;
    }

    private void selectWordAtCaret(boolean honorCamelCase) {
        CaretImpl caret = this.getCaretModel().getCurrentCaret();
        try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
            caret.selectWordAtCaret(honorCamelCase);
        }
        this.setMouseSelectionState(1);
        this.mySavedSelectionStart = caret.getSelectionStart();
        this.mySavedSelectionEnd = caret.getSelectionEnd();
        this.getCaretModel().moveToOffset(this.mySavedSelectionEnd);
    }

    private void selectLineAtCaret(boolean moveToEnd) {
        CaretImpl caret = this.getCaretModel().getCurrentCaret();
        caret.selectLineAtCaret();
        this.setMouseSelectionState(2);
        this.mySavedSelectionStart = caret.getSelectionStart();
        this.mySavedSelectionEnd = caret.getSelectionEnd();
        if (moveToEnd) {
            caret.moveToOffset(this.mySavedSelectionEnd);
        }
    }

    private boolean tweakSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(153);
        }
        return this.getSelectionModel().hasSelection() && e.getButton() == 1 && e.isShiftDown() && this.getMouseEventArea(e) == EditorMouseEventArea.LINE_NUMBERS_AREA;
    }

    private boolean tweakSelectionIfNecessary(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(154);
        }
        if (!this.tweakSelectionEvent(e)) {
            return false;
        }
        int startSelectionOffset = this.getSelectionModel().getSelectionStart();
        int startVisLine = this.offsetToVisualLine(startSelectionOffset);
        int endSelectionOffset = this.getSelectionModel().getSelectionEnd();
        int endVisLine = this.offsetToVisualLine(endSelectionOffset - 1);
        int clickVisLine = this.yToVisualLine(e.getPoint().y);
        if (clickVisLine < startVisLine) {
            int startOffset = this.visualPositionToOffset(new VisualPosition(clickVisLine, 0));
            this.getSelectionModel().setSelection(startOffset, endSelectionOffset);
            this.getCaretModel().moveToOffset(startOffset);
        } else if (clickVisLine > endVisLine) {
            int endLineOffset = EditorUtil.getVisualLineEndOffset(this, clickVisLine);
            this.getSelectionModel().setSelection(this.getSelectionModel().getSelectionStart(), endLineOffset);
            this.getCaretModel().moveToOffset(endLineOffset, true);
        } else if (startVisLine == endVisLine) {
            this.getSelectionModel().removeSelection();
        } else if (this.getSelectionModel().getLeadSelectionOffset() == endSelectionOffset) {
            if (clickVisLine == startVisLine) {
                ++clickVisLine;
            }
            int startOffset = this.visualPositionToOffset(new VisualPosition(clickVisLine, 0));
            this.getSelectionModel().setSelection(startOffset, endSelectionOffset);
            this.getCaretModel().moveToOffset(startOffset);
        } else {
            if (clickVisLine == endVisLine) {
                --clickVisLine;
            }
            int endLineOffset = EditorUtil.getVisualLineEndOffset(this, clickVisLine);
            this.getSelectionModel().setSelection(startSelectionOffset, endLineOffset);
            this.getCaretModel().moveToOffset(endLineOffset);
        }
        e.consume();
        return true;
    }

    boolean useEditorAntialiasing() {
        return this.myState.isUseAntialiasing();
    }

    public void setUseEditorAntialiasing(boolean value) {
        this.myState.setUseAntialiasing(value);
    }

    @ApiStatus.Internal
    public void addLayer(@NotNull JComponent component2, int index) {
        if (component2 == null) {
            EditorImpl.$$$reportNull$$$0(155);
        }
        component2.putClientProperty(CUSTOM_LAYER_MARKER, true);
        this.myLayeredPane.add(component2, index);
    }

    @NotNull
    private EditorMouseEvent createEditorMouseEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(156);
        }
        Point point = e.getPoint();
        EditorMouseEventArea area = this.getMouseEventArea(e);
        boolean inEditingArea = area == EditorMouseEventArea.EDITING_AREA;
        EditorLocation location = new EditorLocation(this, inEditingArea ? point : new Point(0, point.y));
        VisualPosition visualPosition = location.getVisualPosition();
        LogicalPosition logicalPosition = location.getLogicalPosition();
        int offset = location.getOffset();
        int relX = point.x - this.myEditorComponent.getInsets().left;
        Inlay<?> inlayCandidate = inEditingArea ? this.myInlayModel.getElementAt(location, true) : null;
        Inlay<?> inlay = inlayCandidate == null || (inlayCandidate.getPlacement() == Inlay.Placement.BELOW_LINE || inlayCandidate.getPlacement() == Inlay.Placement.ABOVE_LINE) && inlayCandidate.getWidthInPixels() <= relX ? null : inlayCandidate;
        FoldRegion foldRegionCandidate = inEditingArea ? this.myFoldingModel.getFoldingPlaceholderAt(location, true) : null;
        FoldRegion foldRegion = foldRegionCandidate instanceof CustomFoldRegion && ((CustomFoldRegion)foldRegionCandidate).getWidthInPixels() <= relX ? null : foldRegionCandidate;
        GutterIconRenderer gutterIconRenderer = inEditingArea ? null : this.myGutterComponent.getGutterRenderer(point);
        boolean overText = inlayCandidate == null && (foldRegionCandidate == null || foldRegion != null) && this.offsetToLogicalPosition(offset).equals((Object)logicalPosition);
        return new EditorMouseEvent((Editor)this, e, area, offset, logicalPosition, visualPosition, overText, foldRegion, inlay, gutterIconRenderer);
    }

    static boolean handleDrop(@NotNull EditorImpl editor2, @NotNull Transferable t, int dropAction) {
        if (editor2 == null) {
            EditorImpl.$$$reportNull$$$0(157);
        }
        if (t == null) {
            EditorImpl.$$$reportNull$$$0(158);
        }
        EditorDropHandler dropHandler = editor2.getDropHandler();
        if (Registry.is((String)"debugger.click.disable.breakpoints")) {
            try {
                GutterDraggableObject object;
                Object attachedObject;
                if (t.isDataFlavorSupported(GutterDraggableObject.flavor) && (attachedObject = t.getTransferData(GutterDraggableObject.flavor)) instanceof GutterIconRenderer && (object = ((GutterIconRenderer)attachedObject).getDraggableObject()) != null) {
                    object.remove();
                    Point mouseLocationOnScreen = MouseInfo.getPointerInfo().getLocation();
                    JComponent editorComponent = editor2.getComponent();
                    Point editorComponentLocationOnScreen = editorComponent.getLocationOnScreen();
                    Disposable painterListenersDisposable = Disposer.newDisposable((String)"PainterListenersDisposable");
                    Disposer.register((Disposable)editor2.getDisposable(), (Disposable)painterListenersDisposable);
                    GutterIconDropAnimator painter = new GutterIconDropAnimator(new Point(mouseLocationOnScreen.x - editorComponentLocationOnScreen.x, mouseLocationOnScreen.y - editorComponentLocationOnScreen.y), editor2.myGutterComponent.getDragImage((GutterMark)((GutterIconRenderer)attachedObject)), painterListenersDisposable);
                    IdeGlassPaneUtil.installPainter((JComponent)editorComponent, (Painter)painter, (Disposable)painterListenersDisposable);
                    return true;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        if (dropHandler != null && dropHandler.canHandleDrop(t.getTransferDataFlavors())) {
            dropHandler.handleDrop(t, editor2.getProject(), null, dropAction);
            return true;
        }
        int caretOffset = editor2.getCaretModel().getOffset();
        if (editor2.myDraggedRange != null && editor2.myDraggedRange.getTextRange().contains(caretOffset)) {
            return false;
        }
        if (editor2.myDraggedRange != null) {
            editor2.getCaretModel().moveToOffset(editor2.mySavedCaretOffsetForDNDUndoHack);
        }
        CommandProcessor.getInstance().executeCommand(editor2.myProject, () -> {
            try {
                DnDManager patt0$temp;
                int offset;
                editor2.getSelectionModel().removeSelection();
                if (editor2.myDraggedRange != null) {
                    editor2.getCaretModel().moveToOffset(caretOffset);
                    offset = caretOffset;
                } else {
                    offset = editor2.getCaretModel().getOffset();
                }
                if (editor2.getDocument().getRangeGuard(offset, offset) != null) {
                    return;
                }
                editor2.putUserData(LAST_PASTED_REGION, null);
                AnAction pasteAction = ActionManager.getInstance().getAction("EditorPaste");
                if (pasteAction instanceof EditorAction) {
                    EditorTextInsertHandler handler = (EditorTextInsertHandler)((EditorAction)pasteAction).getHandlerOfType(EditorTextInsertHandler.class);
                    if (handler == null) {
                        LOG.error("No suitable paste handler found");
                    } else {
                        try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
                            handler.execute((Editor)editor2, editor2.getDataContext(), () -> t);
                        }
                    }
                } else {
                    LOG.error("Couldn't find paste action: " + String.valueOf(pasteAction));
                }
                TextRange range = (TextRange)editor2.getUserData(LAST_PASTED_REGION);
                if (range != null) {
                    editor2.getCaretModel().moveToOffset(range.getStartOffset());
                    editor2.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                }
                if ((patt0$temp = DnDManager.getInstance()) instanceof DnDManagerImpl) {
                    DnDManagerImpl manager2 = (DnDManagerImpl)patt0$temp;
                    manager2.setLastDropHandler(editor2.getContentComponent());
                }
            }
            catch (Exception exception) {
                LOG.error((Throwable)exception);
            }
        }, EditorBundle.message((String)"paste.command.name", (Object[])new Object[0]), DND_COMMAND_GROUP, UndoConfirmationPolicy.DEFAULT, (Document)editor2.getDocument());
        return true;
    }

    @NotNull
    public EditorGutter getGutter() {
        EditorGutterComponentEx editorGutterComponentEx = this.getGutterComponentEx();
        if (editorGutterComponentEx == null) {
            EditorImpl.$$$reportNull$$$0(159);
        }
        return editorGutterComponentEx;
    }

    public boolean isInDistractionFreeMode() {
        return EditorUtil.isRealFileEditor(this) && (DistractionFreeModeController.isDistractionFreeModeEnabled() || this.isInPresentationMode());
    }

    boolean isInPresentationMode() {
        return UISettings.getInstance().getPresentationMode() && EditorUtil.isRealFileEditor(this);
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @NotNull
    public EditorState getState() {
        EditorState editorState = this.myState;
        if (editorState == null) {
            EditorImpl.$$$reportNull$$$0(160);
        }
        return editorState;
    }

    @Nullable
    private static Object extractOldValueOrLog(@NotNull ObservableStateListener.PropertyChangeEvent event, @Nullable Object fallbackValue) {
        Ref<Object> oldValueRef;
        if (event == null) {
            EditorImpl.$$$reportNull$$$0(161);
        }
        if ((oldValueRef = event.getOldValueRef()) == null) {
            LOG.error("oldValueRef is expected not-null for the property: property name = " + event.getPropertyName());
            return fallbackValue;
        }
        return oldValueRef.get();
    }

    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            EditorImpl.$$$reportNull$$$0(162);
        }
        VisualPosition visual = this.getCaretModel().getVisualPosition();
        info.put("caret", visual.getLine() + ":" + visual.getColumn());
    }

    private void invokePopupIfNeeded(@NotNull EditorMouseEvent event) {
        if (event == null) {
            EditorImpl.$$$reportNull$$$0(163);
        }
        if (this.myPopupHandlers.isEmpty()) {
            return;
        }
        if (event.getArea() == EditorMouseEventArea.EDITING_AREA && event.getMouseEvent().isPopupTrigger() && !event.isConsumed()) {
            if (ContainerUtil.all(this.myPopupHandlers, o -> o instanceof ContextMenuPopupHandler)) {
                DefaultActionGroup o2;
                ActionGroup group2 = this.getPopupActionGroup(event);
                if (group2 == null) {
                    return;
                }
                if (group2 instanceof DefaultActionGroup && (o2 = (DefaultActionGroup)group2).getChildrenCount() == 0 && group2.getClass() == DefaultActionGroup.class) {
                    return;
                }
                new ContextMenuPopupHandler.Simple(group2).handlePopup(event);
            } else {
                String message = "Non-ContextMenuPopupHandler popup handler detected: " + String.valueOf(ContainerUtil.map(this.myPopupHandlers, o -> o.getClass().getName()));
                if (ClientId.isCurrentlyUnderLocalId()) {
                    LOG.warn(message);
                } else {
                    LOG.error(message);
                }
                for (int i2 = this.myPopupHandlers.size() - 1; i2 >= 0 && !this.myPopupHandlers.get(i2).handlePopup(event); --i2) {
                }
            }
        }
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        if (event == null) {
            EditorImpl.$$$reportNull$$$0(164);
        }
        if (this.myProject != null) {
            VirtualFile eventFile = event.getVirtualFile();
            VirtualFile file2 = this.getVirtualFile();
            if (eventFile != null && !eventFile.equals(file2)) {
                return;
            }
            int oldTabSize = EditorUtil.getTabSize(this);
            CodeStyleSettings eventSettings = event.getSettings();
            CodeStyleSettings cachedSettings = (CodeStyleSettings)this.getUserData(CODE_STYLE_SETTINGS);
            if (cachedSettings != null && eventSettings == null) {
                CodeStyle.getSettings((Project)this.myProject, (VirtualFile)file2);
            }
            if (eventSettings != null) {
                this.putUserData(CODE_STYLE_SETTINGS, eventSettings);
            }
            this.mySettings.reinitSettings();
            int newTabSize = EditorUtil.getTabSize(this);
            if (oldTabSize != newTabSize) {
                this.reinitSettings(false, true);
            } else {
                this.myEditorComponent.repaint();
            }
        }
    }

    public void bidiTextFound() {
        if (this.myProject != null && this.myVirtualFile != null && this.replace(CONTAINS_BIDI_TEXT, null, Boolean.TRUE)) {
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        }
    }

    @TestOnly
    @ApiStatus.Internal
    public void validateState() {
        this.myView.validateState();
        this.mySoftWrapModel.validateState();
        this.myFoldingModel.validateState();
        this.myCaretModel.validateState();
        this.myInlayModel.validateState();
    }

    public String toString() {
        return "EditorImpl[" + String.valueOf(FileDocumentManager.getInstance().getFile((Document)this.myDocument)) + "]";
    }

    public void adjustGlobalFontSize(float size2) {
        EditorColorsManager.getInstance().getGlobalScheme().setEditorFontSize(size2);
        this.myScheme.resetEditorFontSize();
        EditorColorsManagerImpl.fireGlobalSchemeChange(null);
    }

    @ApiStatus.Internal
    public MouseListener getMouseListener() {
        return this.myMouseListener;
    }

    @Override
    @ApiStatus.Internal
    public int getStickyLinesPanelHeight() {
        if (this.myStickyLinesManager == null || !this.getSettings().areStickyLinesShown()) {
            return 0;
        }
        return this.myStickyLinesManager.panelHeight();
    }

    @ApiStatus.Internal
    public boolean shouldSuppressEditorFragmentHint(int hintStartLogicalLine) {
        if (!ClientId.isCurrentlyUnderLocalId()) {
            return true;
        }
        if (this.myStickyLinesManager != null) {
            return this.myStickyLinesManager.suppressHintForLine(hintStartLogicalLine);
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean isStickyLinePainting() {
        return this.myIsStickyLinePainting;
    }

    @ApiStatus.Internal
    public void setStickyLinePainting(boolean stickyLinePainting) {
        this.myIsStickyLinePainting = stickyLinePainting;
    }

    @ApiStatus.Internal
    public void stickyLinesForLangChanged(@NotNull ObservableStateListener.PropertyChangeEvent event) {
        Object object;
        Ref<Object> oldValRef;
        if (event == null) {
            EditorImpl.$$$reportNull$$$0(165);
        }
        if (this.myStickyLinesManager != null && (oldValRef = event.getOldValueRef()) != null && (object = oldValRef.get()) instanceof Boolean) {
            Boolean oldVal = (Boolean)object;
            object = event.getNewValue();
            if (object instanceof Boolean) {
                Boolean newVal = (Boolean)object;
                if (oldVal.booleanValue() && !newVal.booleanValue()) {
                    this.myStickyLinesManager.clearStickyModel();
                }
            }
        }
    }

    void reinitStickyLines() {
        if (this.myStickyLinesManager != null) {
            this.myStickyLinesManager.reinitSettings();
        }
    }

    @Nullable
    private StickyLinesManager createStickyLinesPanel() {
        if (this.myProject != null && this.myKind == EditorKind.MAIN_EDITOR && !this.isMirrored()) {
            StickyLinesModel stickyModel = StickyLinesModel.getModel((MarkupModel)this.myEditorFilteringMarkupModel.getDelegate());
            VisualStickyLines visualStickyLines = new VisualStickyLines(this, stickyModel);
            StickyLineColors colors = new StickyLineColors(this.getColorsScheme());
            StickyLinesPanel stickyPanel = new StickyLinesPanel(this, visualStickyLines, new StickyLineShadowBorder(this, colors, new StickyLineShadowPainter(colors)));
            StickyLinesManager stickyManager = new StickyLinesManager(this, stickyModel, stickyPanel, colors, visualStickyLines, this.myDisposable);
            this.myLayeredPane.add((Component)((Object)stickyPanel), STICKY_PANEL_LAYER);
            this.myLayeredPane.add((Component)((Object)this.myVerticalScrollBar), VERTICAL_SCROLLBAR_LAYER);
            ((MyScrollPaneLayout)((Object)this.myScrollPane.getLayout())).setVerticalScrollBar((JScrollBar)((Object)this.myVerticalScrollBar));
            return stickyManager;
        }
        return null;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public EditorView getView() {
        return this.myView;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @NotNull
    public EditorModel getEditorModel() {
        if (this.myAdEditorModel != null) {
            EditorModel editorModel = this.myAdEditorModel;
            if (editorModel == null) {
                EditorImpl.$$$reportNull$$$0(166);
            }
            return editorModel;
        }
        EditorModel editorModel = this.myEditorModel;
        if (editorModel == null) {
            EditorImpl.$$$reportNull$$$0(167);
        }
        return editorModel;
    }

    static {
        SCROLL_PANE_LAYER = 0;
        STICKY_PANEL_LAYER = 200;
        VERTICAL_SCROLLBAR_LAYER = 250;
        FLOATING_TOOLBAR_LAYER = 300;
        STATUS_COMPONENT_LAYER = 300;
        Cursor emptyCursor = null;
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                emptyCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtil.createImage((int)1, (int)1, (int)2), new Point(), "Empty cursor");
            }
            catch (Exception e) {
                LOG.warn("Couldn't create an empty cursor", (Throwable)e);
            }
        }
        EMPTY_CURSOR = emptyCursor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 11, 16, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 34, 35, 42, 43, 44, 50, 52, 53, 54, 55, 56, 59, 61, 63, 65, 67, 68, 73, 75, 76, 83, 84, 85, 86, 87, 89, 90, 91, 92, 93, 94, 95, 98, 100, 101, 104, 109, 115, 119, 120, 131, 132, 133, 134, 136, 137, 138, 159, 160, 166, 167 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 3: 
            case 11: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 68: 
            case 73: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 100: 
            case 101: 
            case 104: 
            case 109: 
            case 115: 
            case 119: 
            case 120: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 138: 
            case 159: 
            case 160: 
            case 166: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorImpl";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 12: 
            case 71: 
            case 72: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 139: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 7: 
            case 41: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineExtensionPainter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupHandler";
                break;
            }
            case 18: 
            case 39: 
            case 40: 
            case 161: 
            case 163: 
            case 164: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 45: 
            case 46: 
            case 48: 
            case 69: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 128: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 47: 
            case 70: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 49: 
            case 51: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 62: 
            case 96: 
            case 116: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visible";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalPos";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePos";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 113: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPosition";
                break;
            }
            case 121: 
            case 124: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseDragEvent";
                break;
            }
            case 122: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPosition";
                break;
            }
            case 123: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endPosition";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 140: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dropHandler";
                break;
            }
            case 142: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusModeModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustThumbColor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupHandlers";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkupModel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredDocumentMarkupModel";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModel";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretModel";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollingModel";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftWrapModel";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlayModel";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorKind";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "type";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentComponent";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getGutterComponentEx";
                break;
            }
            case 50: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "xyToVisualPosition";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToPoint2D";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToXY";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToVisualPosition";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToLogicalPosition";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "xyToLogicalPosition";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "logicalPositionToXY";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "visualPositionToXY";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "visualPositionToPoint2D";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "visualLineToYRange";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposedBackground";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentsModel";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getForegroundColor";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextDrawingCallback";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundIgnoreForced";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontMetrics";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentSize";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollPane";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "logicalToVisualPosition";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "visualToLogicalPosition";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPosition";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCursor";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPoint";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadCaret";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyProvider";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "getCutProvider";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "getPasteProvider";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteProvider";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerticalScrollBar";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputMethodSupport";
                break;
            }
            case 159: {
                objectArray = objectArray2;
                objectArray2[1] = "getGutter";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 166: 
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInFocusMode";
                break;
            }
            case 3: 
            case 11: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 68: 
            case 73: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 100: 
            case 101: 
            case 104: 
            case 109: 
            case 115: 
            case 119: 
            case 120: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 138: 
            case 159: 
            case 160: 
            case 166: 
            case 167: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "focusGained";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "focusLost";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "errorStripeMarkerChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onHighlighterChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onInlayUpdated";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretIntoViewIfCoveredByToolWindowBelow";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "adjustThumbColor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "repaintCaretRegion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerLineExtensionPainter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processLineExtensions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "uninstallPopupHandler";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPopupActionGroup";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setCustomCursor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "throwDisposalError";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "executeNonCancelableBlock";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processKeyTypedImmediately";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processKeyTypedNormally";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "fireFocusLost";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "fireFocusGained";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setHighlighter";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 49: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "xyToVisualPosition";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "offsetToVisualColumnInFoldRegion";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "visualColumnToOffsetInFoldRegion";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "xyToLogicalPosition";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToXY";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToXY";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToPoint2D";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "addHighlighterListener";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "beforeChangedUpdate";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdate";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "countLineFeeds";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addEditorMouseListener";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorMouseListener";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addEditorMouseMotionListener";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorMouseMotionListener";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "fillPlaceholder";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColor";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToOffset";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "logicalToVisualPosition";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "visualToLogicalPosition";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "checkIgnore";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "processMouseReleased";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "isInsideGutterWhitespaceArea";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getMouseEventArea";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "validateMousePointer";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultCursor";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "runMouseDraggedCommand";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "processMouseDragged";
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "convertPoint";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "nextSelectionVisualPosition";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "prevSelectionVisualPosition";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "createSelectionTill";
                break;
            }
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "setSelectionAndBlockActions";
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "blockActionsIfNeeded";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "onSubstantialDrag";
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "addFocusListener";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "setColorsScheme";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "processKeyTyped";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "recordLatencyAwareAction";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "setDropHandler";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "addHighlightingPredicate";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlightingPredicate";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighterAvailable";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "hasBlockInlay";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "isColumnSelectionDragEvent";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "isToggleCaretEvent";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "isAddRectangularSelectionEvent";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "isCreateRectangularSelectionEvent";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "isMouseActionEvent";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "tweakSelectionEvent";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "tweakSelectionIfNecessary";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "addLayer";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "createEditorMouseEvent";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "handleDrop";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "extractOldValueOrLog";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "invokePopupIfNeeded";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "codeStyleSettingsChanged";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "stickyLinesForLangChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 11, 16, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 34, 35, 42, 43, 44, 50, 52, 53, 54, 55, 56, 59, 61, 63, 65, 67, 68, 73, 75, 76, 83, 84, 85, 86, 87, 89, 90, 91, 92, 93, 94, 95, 98, 100, 101, 104, 109, 115, 119, 120, 131, 132, 133, 134, 136, 137, 138, 159, 160, 166, 167 -> new IllegalStateException(string);
        };
    }

    private final class ScrollingTimer {
        private Timer myTimer;
        private static final int CYCLE_SIZE = 20;
        private int myXCycles;
        private int myYCycles;
        private int myDx;
        private int myDy;
        private int xPassedCycles;
        private int yPassedCycles;

        private ScrollingTimer() {
        }

        private void start(int dx, int dy) {
            this.myDx = 0;
            this.myDy = 0;
            if (dx > 0) {
                this.myXCycles = 20 / dx + 1;
                this.myDx = 1 + dx / 20;
            } else if (dx < 0) {
                this.myXCycles = -20 / dx + 1;
                this.myDx = -1 + dx / 20;
            }
            if (dy > 0) {
                this.myYCycles = 20 / dy + 1;
                this.myDy = 1 + dy / 20;
            } else if (dy < 0) {
                this.myYCycles = -20 / dy + 1;
                this.myDy = -1 + dy / 20;
            }
            if (this.myTimer != null) {
                return;
            }
            this.myTimer = TimerUtil.createNamedTimer((String)"Editor scroll timer", (int)Registry.intValue((String)"editor.scrolling.animation.interval.ms"), e -> {
                if (EditorImpl.this.isDisposed()) {
                    this.stop();
                    return;
                }
                Runnable command = () -> {
                    int oldSelectionStart = EditorImpl.this.mySelectionModel.getLeadSelectionOffset();
                    VisualPosition caretPosition = EditorImpl.this.myMultiSelectionInProgress ? EditorImpl.this.myTargetMultiSelectionPosition : EditorImpl.this.getCaretModel().getVisualPosition();
                    int column = caretPosition.column;
                    ++this.xPassedCycles;
                    if (this.xPassedCycles >= this.myXCycles) {
                        this.xPassedCycles = 0;
                        column += this.myDx;
                    }
                    int line = caretPosition.line;
                    ++this.yPassedCycles;
                    if (this.yPassedCycles >= this.myYCycles) {
                        this.yPassedCycles = 0;
                        line += this.myDy;
                    }
                    line = Math.max(0, line);
                    column = Math.max(0, column);
                    VisualPosition pos = new VisualPosition(line, column);
                    if (!EditorImpl.this.myMultiSelectionInProgress) {
                        EditorImpl.this.getCaretModel().moveToVisualPosition(pos);
                        EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    }
                    int newCaretOffset = EditorImpl.this.getCaretModel().getOffset();
                    int caretShift = newCaretOffset - EditorImpl.this.mySavedSelectionStart;
                    if (EditorImpl.this.getMouseSelectionState() != 0) {
                        EditorImpl.this.setupSpecialSelectionOnMouseDrag(newCaretOffset, caretShift);
                        return;
                    }
                    if (EditorImpl.this.myMultiSelectionInProgress && EditorImpl.this.myLastMousePressedLocation != null) {
                        EditorImpl.this.myTargetMultiSelectionPosition = pos;
                        LogicalPosition newLogicalPosition = EditorImpl.this.visualToLogicalPosition(pos);
                        EditorImpl.this.getScrollingModel().scrollTo(newLogicalPosition, ScrollType.RELATIVE);
                        EditorImpl.this.createSelectionTill(newLogicalPosition);
                    } else {
                        EditorImpl.this.mySelectionModel.setSelection(oldSelectionStart, EditorImpl.this.getCaretModel().getOffset());
                    }
                };
                WriteIntentReadAction.run(() -> EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, command, EditorBundle.message((String)"move.cursor.command.name", (Object[])new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument()));
            });
            this.myTimer.start();
        }

        private void stop() {
            if (this.myTimer != null) {
                this.myTimer.stop();
                this.myTimer = null;
            }
        }
    }

    private final class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(0);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            EditorImpl.this.requestFocus();
            WriteIntentReadAction.run(() -> this.runMousePressedCommand(e));
            EditorImpl.this.myInitialMouseEvent = e.isConsumed() ? e : null;
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(1);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            EditorImpl.this.myMousePressArea = null;
            EditorImpl.this.myLastMousePressedLocation = null;
            WriteIntentReadAction.run(() -> {
                this.runMouseReleasedCommand(e);
                if (!e.isConsumed() && EditorImpl.this.myMousePressedEvent != null && !EditorImpl.this.myMousePressedEvent.isConsumed() && Math.abs(e.getX() - EditorImpl.this.myMousePressedEvent.getX()) < EditorUtil.getSpaceWidth(0, EditorImpl.this) && Math.abs(e.getY() - EditorImpl.this.myMousePressedEvent.getY()) < EditorImpl.this.getLineHeight()) {
                    this.runMouseClickedCommand(e);
                }
            });
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(2);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            this.runMouseEnteredCommand(e);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(3);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            this.runMouseExitedCommand(e);
            EditorImpl.this.myGutterComponent.mouseExited(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runMousePressedCommand(@NotNull MouseEvent e) {
            InputContext inputContext;
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(4);
            }
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            EditorImpl.this.myLastPressWasAtBlockInlay = false;
            EditorImpl.this.myLastMousePressedLocation = event.getLogicalPosition();
            EditorImpl.this.myLastMousePressedPoint = EditorImpl.convertPoint(e.getComponent(), e.getPoint(), EditorImpl.this.myEditorComponent);
            EditorImpl.this.myLastPressedOnGutter = e.getSource() == EditorImpl.this.myGutterComponent;
            Point lastPressedPointOnGutter = EditorImpl.convertPoint(EditorImpl.this.myEditorComponent, EditorImpl.this.myLastMousePressedPoint, EditorImpl.this.myGutterComponent);
            EditorImpl.this.myLastPressedOnGutterIcon = EditorImpl.this.myGutterComponent.getGutterRenderer(lastPressedPointOnGutter) != null;
            EditorImpl.this.myCaretStateBeforeLastPress = EditorImpl.isToggleCaretEvent(e) ? EditorImpl.this.myCaretModel.getCaretsAndSelections() : Collections.emptyList();
            EditorImpl.this.myCurrentDragIsSubstantial = false;
            EditorImpl.this.myMouseDragStarted = false;
            EditorImpl.this.myDragStarted = false;
            EditorImpl.this.myDragSelectionStarted = false;
            EditorImpl.this.myForcePushHappened = false;
            EditorImpl.this.clearDnDContext();
            EditorImpl.this.myMousePressedEvent = e;
            EditorImpl.this.myExpectedCaretOffset = event.getOffset();
            try {
                for (EditorMouseListener mouseListener2 : EditorImpl.this.myMouseListeners) {
                    mouseListener2.mousePressed(event);
                    if (!EditorImpl.this.isReleased) continue;
                    return;
                }
            }
            finally {
                EditorImpl.this.myExpectedCaretOffset = -1;
            }
            if (EditorImpl.this.composedTextExists() && (inputContext = EditorImpl.this.myEditorComponent.getInputContext()) != null) {
                inputContext.endComposition();
            }
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA || event.getArea() == EditorMouseEventArea.FOLDING_OUTLINE_AREA && !EditorImpl.this.isInsideGutterWhitespaceArea(e)) {
                EditorImpl.this.myDragOnGutterSelectionStartLine = EditorUtil.yPositionToLogicalLine((Editor)EditorImpl.this, e);
            }
            if (event.isConsumed()) {
                return;
            }
            if (EditorImpl.this.myCommandProcessor != null) {
                Runnable runnable2 = () -> {
                    if (this.processMousePressed(e) && EditorImpl.this.myProject != null && !EditorImpl.this.myProject.isDefault()) {
                        IdeDocumentHistory.getInstance(EditorImpl.this.myProject).includeCurrentCommandAsNavigation();
                    }
                };
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, runnable2, "", (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            } else {
                this.processMousePressed(e);
            }
            EditorImpl.this.invokePopupIfNeeded(event);
        }

        private void runMouseClickedCommand(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(5);
            }
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseClicked(event);
                if (!EditorImpl.this.isReleased && !event.isConsumed()) continue;
                return;
            }
        }

        private void runMouseReleasedCommand(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(6);
            }
            EditorImpl.this.myMultiSelectionInProgress = false;
            EditorImpl.this.myDragOnGutterSelectionStartLine = -1;
            EditorImpl.this.myScrollingTimer.stop();
            if (e.isConsumed()) {
                return;
            }
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseReleased(event);
                if (!EditorImpl.this.isReleased && !event.isConsumed()) continue;
                return;
            }
            EditorImpl.this.invokePopupIfNeeded(event);
            if (event.isConsumed()) {
                return;
            }
            if (EditorImpl.this.myCommandProcessor != null) {
                Runnable runnable2 = () -> EditorImpl.this.processMouseReleased(e);
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, runnable2, "", (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            } else {
                EditorImpl.this.processMouseReleased(e);
            }
        }

        private void runMouseEnteredCommand(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(7);
            }
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseEntered(event);
                if (EditorImpl.this.isReleased) {
                    return;
                }
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private void runMouseExitedCommand(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(8);
            }
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseExited(event);
                if (EditorImpl.this.isReleased) {
                    return;
                }
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private boolean processMousePressed(@NotNull MouseEvent e) {
            boolean isNavigation;
            boolean moveCaret;
            FoldRegion range;
            EditorMouseEventArea eventArea;
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(9);
            }
            if (EditorImpl.this.myMouseSelectionState != 0 && System.currentTimeMillis() - EditorImpl.this.myMouseSelectionChangeTimestamp > (long)Registry.intValue((String)"editor.mouseSelectionStateResetTimeout")) {
                EditorImpl.this.resetMouseSelectionState(e, null);
            }
            int x = e.getX();
            int y = e.getY();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            EditorImpl.this.myMousePressArea = eventArea = EditorImpl.this.getMouseEventArea(e);
            if (eventArea == EditorMouseEventArea.FOLDING_OUTLINE_AREA && e.getButton() == 1 && (range = EditorImpl.this.myGutterComponent.findFoldingAnchorAt(x, y)) != null) {
                boolean expansion = !range.isExpanded();
                UIEventLogger.EditorFoldingIconClicked.log((Object)expansion, (Object)e.isAltDown());
                int scrollShift = expansion ? 0 : EditorImpl.this.visualLineToY(EditorImpl.this.yToVisualLine(y)) - EditorImpl.this.getScrollingModel().getVerticalScrollOffset();
                EditorImpl.this.getFoldingModel().runBatchFoldingOperation(() -> {
                    range.setExpanded(expansion);
                    if (e.isAltDown()) {
                        for (FoldRegion region : EditorImpl.this.myFoldingModel.getAllFoldRegions()) {
                            if (region.getStartOffset() < range.getStartOffset() || region.getEndOffset() > range.getEndOffset()) continue;
                            region.setExpanded(expansion);
                        }
                    }
                }, true, false);
                if (!expansion) {
                    int newY = EditorImpl.this.visualLineToY(EditorImpl.this.offsetToVisualLine(range.getStartOffset()));
                    EditorUtil.runWithAnimationDisabled(EditorImpl.this, () -> EditorImpl.this.myScrollingModel.scrollVertically(newY - scrollShift));
                }
                EditorImpl.this.myGutterComponent.updateSize();
                EditorImpl.this.validateMousePointer(e, null);
                e.consume();
                return false;
            }
            if (e.getSource() == EditorImpl.this.myGutterComponent) {
                if (!EditorImpl.this.tweakSelectionIfNecessary(e)) {
                    EditorImpl.this.myGutterComponent.mousePressed(e);
                }
                if (e.isConsumed()) {
                    return false;
                }
                x = 0;
            }
            Caret selectionCaret = null;
            int oldSelectionStart = EditorImpl.this.mySelectionModel.getLeadSelectionOffset();
            int oldStart = EditorImpl.this.mySelectionModel.getSelectionStart();
            int oldEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
            LogicalPosition oldBlockStart = null;
            if (EditorImpl.this.isColumnMode()) {
                @NotNull List<CaretState> caretsAndSelections = EditorImpl.this.getCaretModel().getCaretsAndSelections();
                CaretState originalCaret = caretsAndSelections.get(0);
                oldBlockStart = Objects.equals(originalCaret.getCaretPosition(), originalCaret.getSelectionEnd()) ? originalCaret.getSelectionStart() : originalCaret.getSelectionEnd();
            }
            boolean toggleCaret = e.getSource() != EditorImpl.this.myGutterComponent && EditorImpl.isToggleCaretEvent(e);
            boolean lastPressCreatedCaret = EditorImpl.this.myLastPressCreatedCaret;
            if (e.getClickCount() == 1) {
                EditorImpl.this.myLastPressCreatedCaret = false;
            }
            EditorImpl.this.myLastPressWasAtBlockInlay = eventArea == EditorMouseEventArea.EDITING_AREA && EditorImpl.this.hasBlockInlay(e.getPoint());
            boolean clickOnBreakpointOverLineNumbers = eventArea == EditorMouseEventArea.LINE_NUMBERS_AREA && ExperimentalUI.isNewUI() && EditorUtil.isBreakPointsOnLineNumbers();
            boolean bl = moveCaret = eventArea == EditorMouseEventArea.LINE_NUMBERS_AREA && !clickOnBreakpointOverLineNumbers || EditorImpl.this.isInsideGutterWhitespaceArea(e) || eventArea == EditorMouseEventArea.EDITING_AREA && !EditorImpl.this.myLastPressWasAtBlockInlay;
            assert (!moveCaret || !clickOnBreakpointOverLineNumbers);
            VisualPosition visualPosition = EditorImpl.this.getTargetPosition(x, y, true, null);
            if (clickOnBreakpointOverLineNumbers) {
                EditorImpl.this.mySuppressedByBreakpointsLastPressPosition = visualPosition;
            } else if (moveCaret) {
                EditorImpl.this.mySuppressedByBreakpointsLastPressPosition = null;
                LogicalPosition pos = EditorImpl.this.visualToLogicalPosition(visualPosition);
                if (toggleCaret) {
                    Caret caret = EditorImpl.this.getCaretModel().getCaretAt(visualPosition);
                    if (e.getClickCount() == 1) {
                        if (caret == null) {
                            EditorImpl.this.myLastPressCreatedCaret = !EditorUtil.checkMaxCarets(EditorImpl.this) && EditorImpl.this.getCaretModel().addCaret(visualPosition) != null;
                        } else {
                            EditorImpl.this.getCaretModel().removeCaret(caret);
                        }
                    } else if (e.getClickCount() == 3 && lastPressCreatedCaret) {
                        EditorImpl.this.getCaretModel().moveToVisualPosition(visualPosition);
                    }
                } else if (e.getSource() != EditorImpl.this.myGutterComponent && EditorImpl.isCreateRectangularSelectionEvent(e)) {
                    LogicalPosition anchor;
                    CaretState anchorCaretState = EditorImpl.this.myCaretModel.getCaretsAndSelections().get(0);
                    LogicalPosition logicalPosition = anchor = Objects.equals(anchorCaretState.getCaretPosition(), anchorCaretState.getSelectionStart()) ? anchorCaretState.getSelectionEnd() : anchorCaretState.getSelectionStart();
                    if (anchor == null) {
                        anchor = EditorImpl.this.myCaretModel.getLogicalPosition();
                    }
                    EditorImpl.this.mySelectionModel.setBlockSelection(anchor, pos);
                } else {
                    Caret caret = selectionCaret = eventArea == EditorMouseEventArea.EDITING_AREA && SwingUtilities.isRightMouseButton(e) && EditorImpl.this.getCaretModel().getCaretCount() > 1 ? this.getSelectionCaret(pos) : null;
                    if (selectionCaret == null) {
                        EditorImpl.this.getCaretModel().removeSecondaryCarets();
                        EditorImpl.this.getCaretModel().moveToVisualPosition(visualPosition);
                    } else {
                        selectionCaret.moveToVisualPosition(visualPosition);
                    }
                }
            }
            if (e.isPopupTrigger()) {
                return false;
            }
            EditorImpl.this.requestFocus();
            int caretOffset = EditorImpl.this.getCaretModel().getOffset();
            int newStart = EditorImpl.this.mySelectionModel.getSelectionStart();
            int newEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
            Point p = new Point(x, y);
            EditorImpl.this.myMouseSelectedRegion = EditorImpl.this.myFoldingModel.getFoldingPlaceholderAt(p);
            EditorImpl.this.myKeepSelectionOnMousePress = selectionCaret != null || EditorImpl.this.mySelectionModel.hasSelection() && caretOffset >= EditorImpl.this.mySelectionModel.getSelectionStart() && caretOffset <= EditorImpl.this.mySelectionModel.getSelectionEnd() && !this.isPointAfterSelectionEnd(p) && (SwingUtilities.isLeftMouseButton(e) && EditorImpl.this.mySettings.isDndEnabled() || SwingUtilities.isRightMouseButton(e));
            boolean bl2 = isNavigation = oldStart == oldEnd && newStart == newEnd && oldStart != newStart;
            if (eventArea == EditorMouseEventArea.LINE_NUMBERS_AREA && e.getClickCount() == 1) {
                if (clickOnBreakpointOverLineNumbers) {
                    return false;
                }
                EditorImpl.this.selectLineAtCaret(true);
                return isNavigation;
            }
            if (moveCaret) {
                if (e.isShiftDown() && !e.isControlDown() && !e.isAltDown() && !e.isMetaDown()) {
                    if (oldBlockStart != null) {
                        EditorImpl.this.mySelectionModel.setBlockSelection(oldBlockStart, EditorImpl.this.getCaretModel().getLogicalPosition());
                    } else {
                        int startToUse;
                        if (EditorImpl.this.getMouseSelectionState() != 0) {
                            startToUse = caretOffset < EditorImpl.this.mySavedSelectionStart ? EditorImpl.this.mySavedSelectionEnd : EditorImpl.this.mySavedSelectionStart;
                        } else {
                            startToUse = oldSelectionStart;
                            if (EditorImpl.this.mySelectionModel.isUnknownDirection() && caretOffset > startToUse) {
                                startToUse = Math.min(oldStart, oldEnd);
                            }
                        }
                        EditorImpl.this.mySelectionModel.setSelection(startToUse, caretOffset);
                    }
                } else if (!EditorImpl.this.myKeepSelectionOnMousePress && EditorImpl.this.getSelectionModel().hasSelection() && !EditorImpl.isCreateRectangularSelectionEvent(e) && e.getClickCount() == 1) {
                    if (!toggleCaret) {
                        EditorImpl.this.setMouseSelectionState(0);
                        EditorImpl.this.mySelectionModel.setSelection(caretOffset, caretOffset);
                    }
                } else if (!(e.getButton() != 1 || eventArea != EditorMouseEventArea.EDITING_AREA && eventArea != EditorMouseEventArea.LINE_NUMBERS_AREA || toggleCaret && !lastPressCreatedCaret || EditorImpl.this.myMouseSelectedRegion instanceof CustomFoldRegion)) {
                    switch (e.getClickCount()) {
                        case 2: {
                            EditorImpl.this.selectWordAtCaret(EditorImpl.this.mySettings.isMouseClickSelectionHonorsCamelWords() && EditorImpl.this.mySettings.isCamelWords());
                            break;
                        }
                        case 3: {
                            if (eventArea == EditorMouseEventArea.EDITING_AREA && HONOR_CAMEL_HUMPS_ON_TRIPLE_CLICK && EditorImpl.this.mySettings.isCamelWords()) {
                                EditorImpl.this.selectWordAtCaret(false);
                                break;
                            }
                        }
                        case 4: {
                            EditorImpl.this.selectLineAtCaret(false);
                            EditorImpl.this.mySelectionModel.setUnknownDirection(true);
                        }
                    }
                }
            }
            return isNavigation;
        }

        private boolean isPointAfterSelectionEnd(@NotNull Point p) {
            if (p == null) {
                MyMouseAdapter.$$$reportNull$$$0(10);
            }
            VisualPosition selectionEndPosition = EditorImpl.this.myCaretModel.getCurrentCaret().getSelectionEndPosition();
            Point selectionEnd = EditorImpl.this.visualPositionToXY(selectionEndPosition);
            return p.y >= selectionEnd.y + EditorImpl.this.getLineHeight() || p.y >= selectionEnd.y && p.x > selectionEnd.x && EditorImpl.this.xyToVisualPosition((Point)p).column > selectionEndPosition.column;
        }

        private Caret getSelectionCaret(@NotNull LogicalPosition logicalPosition) {
            if (logicalPosition == null) {
                MyMouseAdapter.$$$reportNull$$$0(11);
            }
            int offset = EditorImpl.this.logicalPositionToOffset(logicalPosition);
            for (Caret caret : EditorImpl.this.getCaretModel().getAllCarets()) {
                if (offset < caret.getSelectionStart() || offset > caret.getSelectionEnd()) continue;
                return caret;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logicalPosition";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runMousePressedCommand";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runMouseClickedCommand";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runMouseReleasedCommand";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runMouseEnteredCommand";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runMouseExitedCommand";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processMousePressed";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPointAfterSelectionEnd";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectionCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        @DirtyUI
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseMotionListener.$$$reportNull$$$0(0);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            if (EditorImpl.this.myDraggedRange != null || EditorImpl.this.myGutterComponent.myDnDInProgress) {
                return;
            }
            if (EditorImpl.this.myForcePushHappened) {
                return;
            }
            EditorImpl.this.validateMousePointer(e, null);
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            for (EditorMouseMotionListener listener2 : EditorImpl.this.myMouseMotionListeners) {
                listener2.mouseDragged(event);
                if (!EditorImpl.this.isReleased) continue;
                return;
            }
            ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> EditorImpl.this.runMouseDraggedCommand(e));
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA) {
                EditorImpl.this.myGutterComponent.mouseDragged(e);
            }
        }

        @Override
        @DirtyUI
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseMotionListener.$$$reportNull$$$0(1);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            if (EditorImpl.this.getMouseSelectionState() != 0) {
                if (EditorImpl.this.myMousePressedEvent != null && EditorImpl.this.myMousePressedEvent.getComponent() == e.getComponent()) {
                    Point lastPoint = EditorImpl.this.myMousePressedEvent.getPoint();
                    Point point = e.getPoint();
                    int deadZone = Registry.intValue((String)"editor.mouseSelectionStateResetDeadZone");
                    if (Math.abs(lastPoint.x - point.x) >= deadZone || Math.abs(lastPoint.y - point.y) >= deadZone) {
                        EditorImpl.this.resetMouseSelectionState(e, event);
                    }
                } else {
                    EditorImpl.this.validateMousePointer(e, event);
                }
            } else {
                EditorImpl.this.validateMousePointer(e, event);
            }
            EditorImpl.this.myMouseMovedEvent = e;
            if (e.getSource() == EditorImpl.this.myGutterComponent) {
                EditorImpl.this.myGutterComponent.mouseMoved(e);
            }
            for (EditorMouseMotionListener listener2 : EditorImpl.this.myMouseMotionListeners) {
                listener2.mouseMoved(event);
                if (!EditorImpl.this.isReleased) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseDragged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @DirtyUI
    private final class MyScrollPane
    extends JBScrollPane {
        private final boolean myInitialized;
        private JComponent myStatusComponent;

        private MyScrollPane() {
            super(0);
            this.setupCorners();
            this.myInitialized = true;
        }

        public void setUI(ScrollPaneUI ui) {
            super.setUI(ui);
            this.setInputMap(1, null);
        }

        public void layout() {
            EditorThreading.run(() -> {
                if (EditorImpl.this.isInDistractionFreeMode()) {
                    EditorImpl.this.myGutterComponent.updateSize(true, true);
                }
                super.layout();
            });
        }

        protected void processMouseWheelEvent(@NotNull MouseWheelEvent e) {
            if (e == null) {
                MyScrollPane.$$$reportNull$$$0(0);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            if (EditorImpl.this.mySettings.isWheelFontChangeEnabled() && EditorUtil.isChangeFontSize(e)) {
                boolean isWheelFontChangePersistent = EditorSettingsExternalizable.getInstance().isWheelFontChangePersistent() && !UISettings.getInstance().getPresentationMode();
                float shift = e.getWheelRotation();
                ChangeEditorFontSizeStrategy strategy = (ChangeEditorFontSizeStrategy)EditorImpl.this.getUserData(ChangeEditorFontSizeStrategy.KEY);
                if (strategy != null) {
                    strategy.setFontSize(strategy.getFontSize() - shift);
                    return;
                }
                float size2 = EditorImpl.this.myScheme.getEditorFontSize2D();
                if (isWheelFontChangePersistent) {
                    size2 = EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize2D();
                }
                if ((size2 -= shift) >= 4.0f) {
                    if (isWheelFontChangePersistent) {
                        EditorImpl.this.setFontSizeImpl(UISettingsUtils.getInstance().scaleFontSize(size2), EditorImpl.convertPoint((Component)((Object)this), e.getPoint(), this.getViewport()), false);
                        EditorImpl.this.adjustGlobalFontSize(size2);
                    } else {
                        EditorImpl.this.setFontSizeImpl(size2, EditorImpl.convertPoint((Component)((Object)this), e.getPoint(), this.getViewport()), false);
                    }
                }
                return;
            }
            super.processMouseWheelEvent(e);
        }

        @NotNull
        public JScrollBar createHorizontalScrollBar() {
            return new OpaqueAwareScrollBar(0);
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            return new MyScrollBar(1);
        }

        protected void setupCorners() {
            super.setupCorners();
            this.setBorder((Border)((Object)new EditorTablessBorder(EditorImpl.this.myProject, EditorImpl.this.myHeaderPanel)));
        }

        void placeStatusOnTopOfStickyPanel() {
            this.setStatusComponent(super.getStatusComponent());
        }

        public JComponent getStatusComponent() {
            if (EditorImpl.this.myStickyLinesManager == null) {
                return super.getStatusComponent();
            }
            return this.myStatusComponent;
        }

        public void setStatusComponent(JComponent statusComponent) {
            if (EditorImpl.this.myStickyLinesManager == null) {
                super.setStatusComponent(statusComponent);
            } else {
                JComponent oldStatus = super.getStatusComponent();
                if (oldStatus != null) {
                    super.setStatusComponent(null);
                }
                if (statusComponent != null) {
                    EditorImpl.this.myLayeredPane.add(statusComponent, STATUS_COMPONENT_LAYER);
                } else if (this.myStatusComponent != null) {
                    EditorImpl.this.myLayeredPane.remove(this.myStatusComponent);
                }
                this.firePropertyChange("statusComponent", this.myStatusComponent, statusComponent);
                this.myStatusComponent = statusComponent;
                this.revalidate();
                this.repaint();
            }
        }

        protected JBScrollPane.Layout createLayout() {
            return new MyScrollPaneLayout();
        }

        public void setBorder(Border border) {
            if (this.myInitialized) {
                EditorImpl.this.setBorder(border);
            } else {
                this.doSetBorder(border);
            }
        }

        private void doSetBorder(Border border) {
            super.setBorder(border);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyScrollPane", "processMouseWheelEvent"));
        }
    }

    final class CaretCursor {
        private CaretRectangle @NotNull [] myLocations = new CaretRectangle[]{new CaretRectangle(new Point(0, 0), 0.0f, null, false)};
        private boolean myEnabled = true;
        private boolean myIsShown;
        private float myBlinkOpacity = 1.0f;
        private long myStartTime;

        CaretCursor() {
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled2) {
            this.myEnabled = enabled2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activate() {
            boolean blink = EditorImpl.this.mySettings.isBlinkCaret();
            int blinkPeriod = EditorImpl.this.mySettings.getCaretBlinkPeriod();
            EditorCaretRepaintService editorCaretRepaintService = EditorImpl.this.caretRepaintService;
            synchronized (editorCaretRepaintService) {
                EditorImpl.this.caretRepaintService.setEditor(EditorImpl.this);
                EditorImpl.this.caretRepaintService.setBlinking(blink);
                EditorImpl.this.caretRepaintService.setBlinkPeriod(blinkPeriod);
                this.myIsShown = true;
                this.myBlinkOpacity = 1.0f;
                EditorImpl.this.caretRepaintService.restart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            EditorCaretRepaintService editorCaretRepaintService = EditorImpl.this.caretRepaintService;
            synchronized (editorCaretRepaintService) {
                return this.myIsShown;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActive(boolean isActive) {
            EditorCaretRepaintService editorCaretRepaintService = EditorImpl.this.caretRepaintService;
            synchronized (editorCaretRepaintService) {
                this.myIsShown = isActive;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFullOpacity() {
            EditorCaretRepaintService editorCaretRepaintService = EditorImpl.this.caretRepaintService;
            synchronized (editorCaretRepaintService) {
                this.myIsShown = true;
                this.myBlinkOpacity = 1.0f;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void passivate() {
            EditorCaretRepaintService editorCaretRepaintService = EditorImpl.this.caretRepaintService;
            synchronized (editorCaretRepaintService) {
                this.myIsShown = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        float getBlinkOpacity() {
            EditorCaretRepaintService editorCaretRepaintService = EditorImpl.this.caretRepaintService;
            synchronized (editorCaretRepaintService) {
                return this.myBlinkOpacity;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setBlinkOpacity(float opacity) {
            EditorCaretRepaintService editorCaretRepaintService = EditorImpl.this.caretRepaintService;
            synchronized (editorCaretRepaintService) {
                this.myBlinkOpacity = opacity;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getStartTime() {
            EditorCaretRepaintService editorCaretRepaintService = EditorImpl.this.caretRepaintService;
            synchronized (editorCaretRepaintService) {
                return this.myStartTime;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setStartTime(long startTime) {
            EditorCaretRepaintService editorCaretRepaintService = EditorImpl.this.caretRepaintService;
            synchronized (editorCaretRepaintService) {
                this.myStartTime = startTime;
            }
        }

        void setPositions(CaretRectangle @NotNull [] locations) {
            if (locations == null) {
                CaretCursor.$$$reportNull$$$0(0);
            }
            this.myStartTime = System.currentTimeMillis();
            this.myLocations = locations;
        }

        void repaint() {
            EditorImpl.this.myView.repaintCarets();
        }

        private boolean isEditorInputFocusOwner() {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            EditorComponentImpl content2 = EditorImpl.this.getContentComponent();
            Component temp = focusOwner;
            while (temp != null) {
                EditorHostedComponent hostedComponent;
                if (temp == content2) {
                    return true;
                }
                if (temp instanceof EditorHostedComponent && (hostedComponent = (EditorHostedComponent)((Object)temp)).isInputFocusOwner()) {
                    return false;
                }
                temp = temp instanceof Window ? null : temp.getParent();
            }
            return false;
        }

        CaretRectangle @Nullable [] getCaretLocations(boolean onlyIfShown) {
            if (!(!onlyIfShown || this.isEnabled() && this.isActive() && !EditorImpl.this.isRendererMode() && this.isEditorInputFocusOwner())) {
                return null;
            }
            return this.myLocations;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locations", "com/intellij/openapi/editor/impl/EditorImpl$CaretCursor", "setPositions"));
        }
    }

    final class MyScrollBar
    extends OpaqueAwareScrollBar {
        @NonNls
        private static final String APPLE_LAF_AQUA_SCROLL_BAR_UI_CLASS = "apple.laf.AquaScrollBarUI";
        private ScrollBarUI myPersistentUI;

        private MyScrollBar(int orientation) {
            super(orientation);
        }

        void setPersistentUI(@NotNull ScrollBarUI ui) {
            if (ui == null) {
                MyScrollBar.$$$reportNull$$$0(0);
            }
            this.myPersistentUI = ui;
            this.setUI(ui);
        }

        public void setUI(ScrollBarUI ui) {
            if (this.myPersistentUI == null) {
                this.myPersistentUI = ui;
            }
            super.setUI(this.myPersistentUI);
        }

        int getDecScrollButtonHeight() {
            ScrollBarUI barUI = this.getUI();
            Insets insets = this.getInsets();
            int top = Math.max(0, insets.top);
            if (barUI instanceof ButtonlessScrollBarUI) {
                return top + ((ButtonlessScrollBarUI)barUI).getDecrementButtonHeight();
            }
            if (barUI instanceof BasicScrollBarUI) {
                try {
                    JButton decrButtonValue = BasicScrollBarUiButtonHolder.decrButtonField.invoke(barUI);
                    LOG.assertTrue(decrButtonValue != null);
                    return top + decrButtonValue.getHeight();
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            }
            return top + 15;
        }

        int getIncScrollButtonHeight() {
            ScrollBarUI barUI = this.getUI();
            Insets insets = this.getInsets();
            if (barUI instanceof ButtonlessScrollBarUI) {
                return insets.top + ((ButtonlessScrollBarUI)barUI).getIncrementButtonHeight();
            }
            if (barUI instanceof BasicScrollBarUI) {
                try {
                    JButton incrButtonValue = BasicScrollBarUiButtonHolder.incrButtonField.invoke(barUI);
                    LOG.assertTrue(incrButtonValue != null);
                    return insets.bottom + incrButtonValue.getHeight();
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            }
            if (barUI != null && APPLE_LAF_AQUA_SCROLL_BAR_UI_CLASS.equals(barUI.getClass().getName())) {
                return insets.bottom + 30;
            }
            return insets.bottom + 15;
        }

        public int getUnitIncrement(int direction) {
            JViewport vp = EditorImpl.this.myScrollPane.getViewport();
            Rectangle vr = vp.getViewRect();
            return EditorImpl.this.myEditorComponent.getScrollableUnitIncrement(vr, 1, direction);
        }

        public int getBlockIncrement(int direction) {
            JViewport vp = EditorImpl.this.myScrollPane.getViewport();
            Rectangle vr = vp.getViewRect();
            return EditorImpl.this.myEditorComponent.getScrollableBlockIncrement(vr, 1, direction);
        }

        private void registerRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback) {
            if (this.myPersistentUI instanceof ButtonlessScrollBarUI) {
                ((ButtonlessScrollBarUI)this.myPersistentUI).registerRepaintCallback(callback);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/openapi/editor/impl/EditorImpl$MyScrollBar", "setPersistentUI"));
        }
    }

    private final class DefaultPopupHandler
    extends ContextMenuPopupHandler {
        private DefaultPopupHandler() {
        }

        @Override
        @Nullable
        public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
            if (event == null) {
                DefaultPopupHandler.$$$reportNull$$$0(0);
            }
            String contextMenuGroupId = EditorImpl.this.myState.getContextMenuGroupId();
            Inlay inlay = event.getInlay();
            if (inlay != null) {
                ActionGroup group2 = inlay.getRenderer().getContextMenuGroup(inlay);
                if (group2 != null) {
                    return group2;
                }
                String inlayContextMenuGroupId = inlay.getRenderer().getContextMenuGroupId(inlay);
                if (inlayContextMenuGroupId != null) {
                    contextMenuGroupId = inlayContextMenuGroupId;
                }
            } else {
                CustomFoldRegion customFoldRegion;
                ActionGroup group3;
                FoldRegion foldRegion = event.getCollapsedFoldRegion();
                if (foldRegion instanceof CustomFoldRegion && (group3 = (customFoldRegion = (CustomFoldRegion)foldRegion).getRenderer().getContextMenuGroup(customFoldRegion)) != null) {
                    return group3;
                }
            }
            return DefaultPopupHandler.getGroupForId(contextMenuGroupId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/EditorImpl$DefaultPopupHandler", "getActionGroup"));
        }
    }

    private final class EditorDocumentAdapter
    implements PrioritizedDocumentListener {
        private EditorDocumentAdapter() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                EditorDocumentAdapter.$$$reportNull$$$0(0);
            }
            EditorImpl.this.beforeChangedUpdate(e);
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                EditorDocumentAdapter.$$$reportNull$$$0(1);
            }
            EditorImpl.this.changedUpdate(e);
        }

        public void bulkUpdateStarting(@NotNull Document document2) {
            if (document2 == null) {
                EditorDocumentAdapter.$$$reportNull$$$0(2);
            }
            EditorImpl.this.bulkUpdateStarted();
        }

        public void bulkUpdateFinished(@NotNull Document document2) {
            if (document2 == null) {
                EditorDocumentAdapter.$$$reportNull$$$0(3);
            }
            EditorImpl.this.bulkUpdateFinished();
        }

        public int getPriority() {
            return 160;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$EditorDocumentAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bulkUpdateStarting";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bulkUpdateFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record HighlighterChange(int affectedStart, int affectedEnd, boolean canImpactGutterSize, boolean fontStyleChanged, boolean foregroundColorChanged, boolean isAccessibleGutterElement, boolean needRestart) {
    }

    private final class PanelWithFloatingToolbar
    extends JBLayeredPane {
        private PanelWithFloatingToolbar() {
        }

        public void doLayout() {
            Component[] components = this.getComponents();
            Rectangle r = this.getBounds();
            for (Component c : components) {
                Dimension d;
                if (c instanceof JScrollPane || PanelWithFloatingToolbar.isCustomLayer(c)) {
                    c.setBounds(0, 0, r.width, r.height);
                    continue;
                }
                if (c instanceof EditorFloatingToolbar) {
                    d = c.getPreferredSize();
                    int rightInsets = EditorImpl.this.getVerticalScrollBar().getWidth() + (EditorImpl.this.isMirrored() ? EditorImpl.this.myGutterComponent.getWidth() : 0);
                    c.setBounds(r.width - d.width - rightInsets - 20, 20, d.width, d.height);
                    continue;
                }
                if (c instanceof JScrollBar || c instanceof StickyLinesPanel) continue;
                d = c.getPreferredSize();
                c.setBounds(r.width - d.width, 0, d.width, d.height);
                MyScrollBar vsb = EditorImpl.this.myVerticalScrollBar;
                if (vsb.getY() == d.height) continue;
                vsb.setBounds(vsb.getX(), d.height, vsb.getWidth(), vsb.getHeight() - d.height);
            }
        }

        public Dimension getPreferredSize() {
            return EditorImpl.this.myScrollPane.getPreferredSize();
        }

        private static boolean isCustomLayer(Component c) {
            JComponent jComponent;
            return c instanceof JComponent && (jComponent = (JComponent)c).getClientProperty(CUSTOM_LAYER_MARKER) != null;
        }
    }

    private final class MyInputMethodHandler
    implements InputMethodRequests {
        private static final int IME_INLAY_PRIORITY = 1000000;
        private RangeMarker composedRangeMarker;
        private Inlay<?> inlayLeft;
        private Inlay<?> inlayRight;

        private MyInputMethodHandler() {
        }

        @Nullable
        private ProperTextRange getRange() {
            if (this.composedRangeMarker == null) {
                return null;
            }
            return new ProperTextRange(this.composedRangeMarker.getStartOffset(), this.composedRangeMarker.getEndOffset());
        }

        @Override
        @NotNull
        public Rectangle getTextLocation(TextHitInfo offset) {
            if (EditorImpl.this.isDisposed()) {
                return new Rectangle();
            }
            Point caret = EditorImpl.this.logicalPositionToXY(EditorImpl.this.getCaretModel().getPrimaryCaret().getLogicalPosition());
            Rectangle r = new Rectangle(caret, new Dimension(1, EditorImpl.this.getLineHeight()));
            Point p = MyInputMethodHandler.getLocationOnScreen(EditorImpl.this.getContentComponent());
            r.translate(p.x, p.y);
            Rectangle rectangle = r;
            if (rectangle == null) {
                MyInputMethodHandler.$$$reportNull$$$0(0);
            }
            return rectangle;
        }

        @Override
        @Nullable
        public TextHitInfo getLocationOffset(int x, int y) {
            if (this.composedRangeMarker != null) {
                Point p = MyInputMethodHandler.getLocationOnScreen(EditorImpl.this.getContentComponent());
                p.x = x - p.x;
                p.y = y - p.y;
                int pos = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.xyToLogicalPosition(p));
                if (this.composedRangeMarker.getTextRange().containsInclusive(pos)) {
                    return TextHitInfo.leading(pos - this.composedRangeMarker.getStartOffset());
                }
            }
            return null;
        }

        private boolean isComposedTextShown() {
            return this.composedRangeMarker != null || this.inlayLeft != null || this.inlayRight != null;
        }

        @NotNull
        private static Point getLocationOnScreen(@NotNull Component component2) {
            if (component2 == null) {
                MyInputMethodHandler.$$$reportNull$$$0(1);
            }
            Point location = new Point();
            SwingUtilities.convertPointToScreen(location, component2);
            if (LOG.isDebugEnabled() && !component2.isShowing()) {
                Container parent;
                Class<?> type = component2.getClass();
                for (parent = component2.getParent(); parent != null && !parent.isShowing(); parent = parent.getParent()) {
                    type = parent.getClass();
                }
                String message = type.getName() + " is not showing";
                if (parent != null) {
                    message = message + " on visible  " + parent.getClass().getName();
                }
                LOG.debug(message);
            }
            Point point = location;
            if (point == null) {
                MyInputMethodHandler.$$$reportNull$$$0(2);
            }
            return point;
        }

        @Override
        public int getInsertPositionOffset() {
            int caretIndex;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (this.composedRangeMarker != null) {
                composedStartIndex = this.composedRangeMarker.getStartOffset();
                composedEndIndex = this.composedRangeMarker.getEndOffset();
            }
            if ((caretIndex = EditorImpl.this.getCaretModel().getOffset()) < composedStartIndex) {
                return caretIndex;
            }
            if (caretIndex < composedEndIndex) {
                return composedStartIndex;
            }
            return caretIndex - (composedEndIndex - composedStartIndex);
        }

        @NotNull
        private String getText(int startIdx, int endIdx) {
            if (startIdx >= 0 && endIdx > startIdx) {
                CharSequence chars = EditorImpl.this.getDocument().getImmutableCharSequence();
                String string = chars.subSequence(startIdx, endIdx).toString();
                if (string == null) {
                    MyInputMethodHandler.$$$reportNull$$$0(3);
                }
                return string;
            }
            return "";
        }

        @Override
        @NotNull
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            Object committed;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (this.composedRangeMarker != null) {
                composedStartIndex = this.composedRangeMarker.getStartOffset();
                composedEndIndex = this.composedRangeMarker.getEndOffset();
            }
            if (beginIndex < composedStartIndex) {
                if (endIndex <= composedStartIndex) {
                    committed = this.getText(beginIndex, endIndex);
                } else {
                    int firstPartLength = composedStartIndex - beginIndex;
                    committed = this.getText(beginIndex, beginIndex + firstPartLength) + this.getText(composedEndIndex, endIndex - firstPartLength);
                }
            } else {
                committed = this.getText(beginIndex + composedEndIndex - composedStartIndex, endIndex);
            }
            AttributedCharacterIterator attributedCharacterIterator = new AttributedString((String)committed).getIterator();
            if (attributedCharacterIterator == null) {
                MyInputMethodHandler.$$$reportNull$$$0(4);
            }
            return attributedCharacterIterator;
        }

        @Override
        public int getCommittedTextLength() {
            int length = EditorImpl.this.getDocument().getTextLength();
            if (this.composedRangeMarker != null) {
                length -= this.composedRangeMarker.getEndOffset() - this.composedRangeMarker.getStartOffset();
            }
            return length;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            String text2;
            if (EditorImpl.this.myCharKeyPressed) {
                EditorImpl.this.myNeedToSelectPreviousChar = true;
            }
            return (text2 = EditorImpl.this.getSelectionModel().getSelectedText()) == null ? null : new AttributedString(text2).getIterator();
        }

        @NotNull
        private static String createComposedString(int composedIndex, @NotNull AttributedCharacterIterator text2) {
            if (text2 == null) {
                MyInputMethodHandler.$$$reportNull$$$0(5);
            }
            StringBuilder strBuf = new StringBuilder();
            char c = text2.setIndex(composedIndex);
            while (c != '\uffff') {
                strBuf.append(c);
                c = text2.next();
            }
            String string = strBuf.toString();
            if (string == null) {
                MyInputMethodHandler.$$$reportNull$$$0(6);
            }
            return string;
        }

        private void setInputMethodCaretPosition(@NotNull InputMethodEvent e) {
            if (e == null) {
                MyInputMethodHandler.$$$reportNull$$$0(7);
            }
            if (this.composedRangeMarker != null) {
                int dot = this.composedRangeMarker.getStartOffset();
                TextHitInfo caretPos = e.getCaret();
                if (caretPos != null) {
                    dot += caretPos.getInsertionIndex();
                }
                EditorImpl.this.getCaretModel().moveToOffset(dot);
                EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private void runUndoTransparent(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                MyInputMethodHandler.$$$reportNull$$$0(8);
            }
            CommandProcessor.getInstance().runUndoTransparentAction(() -> CommandProcessor.getInstance().executeCommand(EditorImpl.this.myProject, () -> ApplicationManager.getApplication().runWriteAction(runnable2), "", (Object)EditorImpl.this.getDocument(), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument()));
        }

        private static boolean hasRelevantCommittedText(@NotNull InputMethodEvent e) {
            if (e == null) {
                MyInputMethodHandler.$$$reportNull$$$0(9);
            }
            if (e.getCommittedCharacterCount() <= 0) {
                return false;
            }
            AttributedCharacterIterator text2 = e.getText();
            return text2 == null || text2.first() != '\u00a5';
        }

        private void replaceInputMethodText(@NotNull InputMethodEvent e) {
            if (e == null) {
                MyInputMethodHandler.$$$reportNull$$$0(10);
            }
            if (EditorImpl.this.myNeedToSelectPreviousChar && SystemInfo.isMac && (Registry.is((String)"ide.mac.pressAndHold.brute.workaround") || Registry.is((String)"ide.mac.pressAndHold.workaround") && (MyInputMethodHandler.hasRelevantCommittedText(e) || e.getCaret() == null))) {
                EditorImpl.this.myNeedToSelectPreviousChar = false;
                EditorImpl.this.getCaretModel().runForEachCaret(caret -> {
                    int caretOffset = caret.getOffset();
                    if (caretOffset > 0) {
                        caret.setSelection(caretOffset - 1, caretOffset);
                    }
                });
            }
            boolean isCaretMoved = false;
            int caretPositionToRestore = 0;
            int composedStartIndex = -1;
            int commitCount = e.getCommittedCharacterCount();
            AttributedCharacterIterator text2 = e.getText();
            DocumentEx doc = EditorImpl.this.getDocument();
            if (this.inlayLeft != null || this.inlayRight != null) {
                int n = composedStartIndex = this.inlayLeft != null ? this.inlayLeft.getOffset() : this.inlayRight.getOffset();
                if (this.inlayLeft != null) {
                    Disposer.dispose(this.inlayLeft);
                    this.inlayLeft = null;
                }
                if (this.inlayRight != null) {
                    Disposer.dispose(this.inlayRight);
                    this.inlayRight = null;
                }
            }
            if (this.composedRangeMarker != null) {
                if (!EditorImpl.this.isViewer() && doc.isWritable()) {
                    composedStartIndex = this.composedRangeMarker.getStartOffset();
                    this.runUndoTransparent(() -> this.lambda$replaceInputMethodText$3((Document)doc));
                    if (this.composedRangeMarker.isValid()) {
                        composedStartIndex = this.composedRangeMarker.getStartOffset();
                    }
                }
                this.composedRangeMarker.dispose();
                this.composedRangeMarker = null;
            }
            if (composedStartIndex >= 0) {
                boolean bl = isCaretMoved = EditorImpl.this.getCaretModel().getOffset() != composedStartIndex;
                if (isCaretMoved) {
                    caretPositionToRestore = EditorImpl.this.getCaretModel().getCurrentCaret().getOffset();
                    if (caretPositionToRestore > composedStartIndex) {
                        caretPositionToRestore += commitCount;
                    }
                    EditorImpl.this.getCaretModel().moveToOffset(composedStartIndex);
                }
            }
            if (text2 != null) {
                int composedTextIndex;
                text2.first();
                if (commitCount > 0) {
                    char c = text2.current();
                    while (c != '\uffff' && commitCount > 0) {
                        if (c >= ' ' && c != '\u007f') {
                            EditorImpl.this.processKeyTyped(c);
                        }
                        c = text2.next();
                        --commitCount;
                    }
                }
                if (!EditorImpl.this.isViewer() && doc.isWritable() && (composedTextIndex = text2.getIndex()) < text2.getEndIndex()) {
                    String composedString = MyInputMethodHandler.createComposedString(composedTextIndex, text2);
                    if (Registry.is((String)"editor.input.method.inlay")) {
                        int leftLength;
                        this.runUndoTransparent(() -> EditorModificationUtil.deleteSelectedTextForAllCarets((Editor)EditorImpl.this));
                        int offset = EditorImpl.this.getCaretModel().getCurrentCaret().getOffset();
                        TextHitInfo caret2 = e.getCaret();
                        int n = leftLength = caret2 != null ? caret2.getInsertionIndex() : 0;
                        if (leftLength > 0) {
                            this.inlayLeft = EditorImpl.this.getInlayModel().addInlineElement(offset, false, -1000000, new InputMethodInlayRenderer(composedString.substring(0, leftLength)));
                        }
                        if (leftLength < composedString.length()) {
                            this.inlayRight = EditorImpl.this.getInlayModel().addInlineElement(offset, true, 1000000, new InputMethodInlayRenderer(composedString.substring(leftLength)));
                        }
                    } else {
                        this.runUndoTransparent(() -> EditorModificationUtilEx.insertStringAtCaret((Editor)EditorImpl.this, (String)composedString, (boolean)false, (boolean)false));
                        this.composedRangeMarker = EditorImpl.this.myDocument.createRangeMarker(EditorImpl.this.getCaretModel().getOffset(), EditorImpl.this.getCaretModel().getOffset() + composedString.length(), true);
                    }
                }
            }
            if (isCaretMoved) {
                EditorImpl.this.getCaretModel().moveToOffset(caretPositionToRestore);
            }
        }

        private /* synthetic */ void lambda$replaceInputMethodText$3(Document doc) {
            if (this.composedRangeMarker.isValid()) {
                doc.deleteString(this.composedRangeMarker.getStartOffset(), this.composedRangeMarker.getEndOffset());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 5, 7, 8, 9, 10 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextLocation";
                    break;
                }
                case 1: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocationOnScreen";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommittedText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComposedString";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocationOnScreen";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createComposedString";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setInputMethodCaretPosition";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "runUndoTransparent";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "hasRelevantCommittedText";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceInputMethodText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 5, 7, 8, 9, 10 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class CaretRectangle {
        @NotNull
        public final Point2D myPoint;
        public final float myWidth;
        @Nullable
        public final Caret myCaret;
        public final boolean myIsRtl;

        CaretRectangle(@NotNull Point2D point, float width, @Nullable Caret caret, boolean isRtl) {
            if (point == null) {
                CaretRectangle.$$$reportNull$$$0(0);
            }
            this.myPoint = point;
            this.myWidth = Math.max(width, 2.0f);
            this.myCaret = caret;
            this.myIsRtl = isRtl;
        }

        Point2D getPoint() {
            return this.myPoint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/openapi/editor/impl/EditorImpl$CaretRectangle", "<init>"));
        }
    }

    private class OpaqueAwareScrollBar
    extends JBScrollBar {
        private boolean myOpaque;

        private OpaqueAwareScrollBar(int orientation) {
            super(orientation);
            this.putClientProperty(ColorKey.FUNCTION_KEY, key -> EditorImpl.this.getColorsScheme().getColor(key));
            this.addPropertyChangeListener("opaque", event -> {
                this.revalidate();
                this.repaint();
            });
        }

        public void setOpaque(boolean opaque) {
            this.myOpaque = opaque;
            super.setOpaque(opaque || EditorImpl.this.shouldScrollBarBeOpaque());
        }

        public boolean isOptimizedDrawingEnabled() {
            return !EditorImpl.this.myBackgroundImageSet;
        }
    }

    private static final class EditorInputMethodListener
    implements InputMethodListener {
        private final MyInputMethodHandler myHandler;

        private EditorInputMethodListener(@NotNull MyInputMethodHandler handler) {
            if (handler == null) {
                EditorInputMethodListener.$$$reportNull$$$0(0);
            }
            this.myHandler = handler;
        }

        @Override
        public void inputMethodTextChanged(InputMethodEvent event) {
            this.myHandler.replaceInputMethodText(event);
            this.myHandler.setInputMethodCaretPosition(event);
            event.consume();
        }

        @Override
        public void caretPositionChanged(InputMethodEvent event) {
            this.myHandler.setInputMethodCaretPosition(event);
            event.consume();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/editor/impl/EditorImpl$EditorInputMethodListener", "<init>"));
        }
    }

    private static final class MyScrollPaneLayout
    extends JBScrollPane.Layout {
        private MyScrollPaneLayout() {
        }

        void setVerticalScrollBar(JScrollBar vsb) {
            this.vsb = vsb;
        }
    }

    private static @interface MouseSelectionState {
    }
}

