/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import java.util.List;

final class CaretDataInView {
    private final int[] selectionStarts;
    private final int[] selectionEnds;
    private final int caretCount;

    CaretDataInView(CaretModel caretModel, int startOffset, int endOffset) {
        List carets = caretModel.getAllCarets();
        this.selectionStarts = new int[carets.size()];
        this.selectionEnds = new int[carets.size()];
        int i2 = 0;
        for (Caret caret : carets) {
            if (!caret.hasSelection() || caret.getSelectionStart() >= endOffset || caret.getSelectionEnd() <= startOffset) continue;
            this.selectionStarts[i2] = caret.getSelectionStart();
            this.selectionEnds[i2] = caret.getSelectionEnd();
            ++i2;
        }
        this.caretCount = i2;
    }

    boolean isOffsetInSelection(int offset) {
        for (int i2 = 0; i2 < this.caretCount; ++i2) {
            if (offset < this.selectionStarts[i2] || offset >= this.selectionEnds[i2]) continue;
            return true;
        }
        return false;
    }
}

