/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.view.CaretLineSelections;
import com.intellij.openapi.editor.impl.view.CaretSelection;
import com.intellij.openapi.editor.impl.view.CornerType;
import com.intellij.openapi.editor.impl.view.EditorPainter;
import com.intellij.openapi.editor.impl.view.SelectionLinePainterKt;
import com.intellij.openapi.editor.impl.view.SelectionRectangle;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0014\u0010\"\u001a\u00020\u001f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020!0\u00112\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0016\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u00010$2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0016\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u00010$2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0016\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u00010$2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0016\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u00010$2\u0006\u0010.\u001a\u00020\u0005H\u0002J&\u00103\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00112\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\u001fH\u0002J*\u00106\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u00052\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\u001f2\b\b\u0002\u00107\u001a\u00020\u001fH\u0002J\"\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020:2\u0006\u00105\u001a\u00020\u001f2\b\b\u0002\u00107\u001a\u00020\u001fH\u0002J*\u0010;\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u00052\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\u001f2\b\b\u0002\u00107\u001a\u00020\u001fH\u0002J\"\u0010<\u001a\u00020\u001f2\u0006\u00109\u001a\u00020:2\u0006\u00105\u001a\u00020\u001f2\b\b\u0002\u00107\u001a\u00020\u001fH\u0002J\"\u0010=\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u00052\u0006\u00104\u001a\u00020\f2\b\b\u0002\u00107\u001a\u00020\u001fH\u0002J\u001a\u0010>\u001a\u00020\u001f2\u0006\u00109\u001a\u00020:2\b\b\u0002\u00107\u001a\u00020\u001fH\u0002J\"\u0010?\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u00052\u0006\u00104\u001a\u00020\f2\b\b\u0002\u00107\u001a\u00020\u001fH\u0002J\u001a\u0010@\u001a\u00020\u001f2\u0006\u00109\u001a\u00020:2\b\b\u0002\u00107\u001a\u00020\u001fH\u0002J\u0010\u0010A\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020BH\u0002J\u001e\u0010D\u001a\u00020\u001f2\u0006\u00104\u001a\u00020E2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010F\u001a\u00020EJ+\u0010G\u001a\u00020H2\u0006\u0010#\u001a\u00020B2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010L\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010MJ\u0010\u0010N\u001a\u00020H2\u0006\u0010#\u001a\u00020BH\u0002J(\u0010S\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020K0T2\u0006\u0010U\u001a\u00020\u00052\n\u0010V\u001a\u0006\u0012\u0002\b\u00030$H\u0002J(\u0010W\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020K0T2\u0006\u0010U\u001a\u00020\u00052\n\u0010V\u001a\u0006\u0012\u0002\b\u00030$H\u0002J\u0016\u0010X\u001a\u00020H2\u0006\u0010U\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\fJ\u0010\u0010Y\u001a\u00020H2\u0006\u0010Z\u001a\u00020PH\u0002J\u0006\u0010\\\u001a\u00020HJ\u000e\u0010]\u001a\u00020H2\u0006\u0010F\u001a\u00020\fJ\u000e\u0010^\u001a\u00020H2\u0006\u0010Z\u001a\u00020PR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014RG\u0010\u0017\u001a.\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019 \u001a*\u0015\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u00190\u0011\u00a2\u0006\u0002\b\u001b0\u0018\u00a2\u0006\u0002\b\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0016\u001a\u0004\b\u001c\u0010\u0014R!\u0010%\u001a\b\u0012\u0004\u0012\u00020!0\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0016\u001a\u0004\b&\u0010\u0014R\u001c\u0010O\u001a\u00020P*\u0006\u0012\u0002\b\u00030$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u0010\u0010[\u001a\u0004\u0018\u00010PX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lcom/intellij/openapi/editor/impl/view/SelectionLinePainter;", "", "graphics", "Ljava/awt/Graphics2D;", "lineHeight", "", "yShift", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Ljava/awt/Graphics2D;IILcom/intellij/openapi/editor/impl/EditorImpl;)V", "radius", "", "selectionBg", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/Nullable;", "caretSelections", "", "Lcom/intellij/openapi/editor/impl/view/CaretSelection;", "getCaretSelections", "()Ljava/util/List;", "caretSelections$delegate", "Lkotlin/Lazy;", "allCarets", "", "Lcom/intellij/openapi/editor/Caret;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getAllCarets", "allCarets$delegate", "isCFRInSelection", "", "cfr", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "isBlockInlayInSelection", "block", "Lcom/intellij/openapi/editor/Inlay;", "customFoldRegions", "getCustomFoldRegions", "customFoldRegions$delegate", "caretSelectionsForLine", "Lcom/intellij/openapi/editor/impl/view/CaretLineSelections;", "line", "yToVisualLine", "y", "customFoldRegionsFor", "visualLine", "blockInlayAbove", "selectedBlockInlayAbove", "blockInlayBelow", "selectedBlockInlayBelow", "hasCFREnd", "x", "left", "hasSelectionEndAboveLine", "checkBlockInlays", "hasSelectionEndAbove", "p", "Ljava/awt/geom/Point2D;", "hasSelectionEndBelowLine", "hasSelectionEndBelow", "hasSelectionAboveLine", "hasSelectionAbove", "hasSelectionBelowLine", "hasSelectionBelow", "isSelectionLeftBound", "Lcom/intellij/openapi/editor/impl/view/SelectionRectangle;", "isSelectionRightBound", "isInSelection", "", "width", "paintRoundedBlock", "", "cornerTypes", "", "Lcom/intellij/openapi/editor/impl/view/CornerType;", "lineExtensionWidth", "(Lcom/intellij/openapi/editor/impl/view/SelectionRectangle;[Lcom/intellij/openapi/editor/impl/view/CornerType;D)V", "paintRoundedSelection", "bounds2D", "Ljava/awt/geom/Rectangle2D;", "getBounds2D", "(Lcom/intellij/openapi/editor/Inlay;)Ljava/awt/geom/Rectangle2D;", "cornerTypesForFirstBlockInlay", "Lkotlin/Pair;", "bottomVisualLine", "inlay", "cornerTypesForLastBlockInlay", "paintAllBlockInlaysAbove", "paint", "rect", "currentRect", "flush", "extendLine", "paintSelection", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSelectionLinePainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionLinePainter.kt\ncom/intellij/openapi/editor/impl/view/SelectionLinePainter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,575:1\n1807#2,3:576\n1807#2,3:579\n777#2:583\n873#2,2:584\n1807#2,3:586\n1807#2,3:589\n1807#2,3:592\n1586#2:595\n1661#2,3:596\n777#2:611\n873#2,2:612\n1#3:582\n4253#4,12:599\n*S KotlinDebug\n*F\n+ 1 SelectionLinePainter.kt\ncom/intellij/openapi/editor/impl/view/SelectionLinePainter\n*L\n139#1:576,3\n143#1:579,3\n168#1:583\n168#1:584,2\n190#1:586,3\n245#1:589,3\n265#1:592,3\n119#1:595\n119#1:596,3\n151#1:611\n151#1:612,2\n151#1:599,12\n*E\n"})
public final class SelectionLinePainter {
    @NotNull
    private final Graphics2D graphics;
    private final int lineHeight;
    private final int yShift;
    @NotNull
    private final EditorImpl editor;
    private final double radius;
    @Nullable
    private final Color selectionBg;
    @NotNull
    private final Lazy caretSelections$delegate;
    @NotNull
    private final Lazy allCarets$delegate;
    @NotNull
    private final Lazy customFoldRegions$delegate;
    @Nullable
    private Rectangle2D currentRect;
    private double lineExtensionWidth;

    public SelectionLinePainter(@NotNull Graphics2D graphics, int lineHeight, int yShift, @NotNull EditorImpl editor2) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.graphics = graphics;
        this.lineHeight = lineHeight;
        this.yShift = yShift;
        this.editor = editor2;
        this.radius = (double)this.lineHeight / 6.0;
        this.selectionBg = this.editor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR);
        this.caretSelections$delegate = LazyKt.lazy(() -> SelectionLinePainter.caretSelections_delegate$lambda$0(this));
        this.allCarets$delegate = LazyKt.lazy(() -> SelectionLinePainter.allCarets_delegate$lambda$0(this));
        this.customFoldRegions$delegate = LazyKt.lazy(() -> SelectionLinePainter.customFoldRegions_delegate$lambda$0(this));
    }

    private final List<CaretSelection> getCaretSelections() {
        Lazy lazy = this.caretSelections$delegate;
        return (List)lazy.getValue();
    }

    private final List<Caret> getAllCarets() {
        Lazy lazy = this.allCarets$delegate;
        return (List)lazy.getValue();
    }

    public final boolean isCFRInSelection(@NotNull CustomFoldRegion cfr) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)cfr, (String)"cfr");
            Iterable $this$any$iv = this.getAllCarets();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Caret it = (Caret)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSelectionStart() <= cfr.getStartOffset() && cfr.getEndOffset() <= it.getSelectionEnd())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isBlockInlayInSelection(Inlay<?> block) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getAllCarets();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Caret it = (Caret)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSelectionStart() <= block.getOffset() && block.getOffset() <= it.getSelectionEnd())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<CustomFoldRegion> getCustomFoldRegions() {
        Lazy lazy = this.customFoldRegions$delegate;
        return (List)lazy.getValue();
    }

    private final CaretLineSelections caretSelectionsForLine(int line) {
        if (this.getCaretSelections().isEmpty()) {
            return new CaretLineSelections(this.editor, line, CollectionsKt.emptyList());
        }
        int it = CollectionsKt.binarySearch$default(this.getCaretSelections(), (int)0, (int)0, arg_0 -> SelectionLinePainter.caretSelectionsForLine$lambda$0(line, arg_0), (int)3, null);
        boolean bl = false;
        int lower = -it - 1;
        int it2 = CollectionsKt.binarySearch$default(this.getCaretSelections(), (int)0, (int)0, arg_0 -> SelectionLinePainter.caretSelectionsForLine$lambda$2(line, arg_0), (int)3, null);
        boolean bl2 = false;
        int upper = -it2 - 1;
        return new CaretLineSelections(this.editor, line, this.getCaretSelections().subList(lower, upper));
    }

    private final int yToVisualLine(int y) {
        return this.editor.yToVisualLine(y - this.yShift);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CustomFoldRegion> customFoldRegionsFor(int visualLine) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getCustomFoldRegions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CustomFoldRegion cfr = (CustomFoldRegion)element$iv$iv;
            boolean bl = false;
            int startLine = this.editor.offsetToVisualLine(cfr.getStartOffset());
            int endLine = this.editor.offsetToVisualLine(cfr.getEndOffset());
            boolean bl2 = startLine <= visualLine ? visualLine <= endLine : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Inlay<?> blockInlayAbove(int visualLine) {
        List<Inlay<?>> list2 = this.editor.getInlayModel().getBlockElementsForVisualLine(visualLine, true);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getBlockElementsForVisualLine(...)");
        Inlay inlay = (Inlay)CollectionsKt.lastOrNull(list2);
        if (inlay == null) {
            List<Inlay<?>> list3 = this.editor.getInlayModel().getBlockElementsForVisualLine(visualLine - 1, false);
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getBlockElementsForVisualLine(...)");
            inlay = (Inlay)CollectionsKt.lastOrNull(list3);
        }
        return inlay;
    }

    private final Inlay<?> selectedBlockInlayAbove(int visualLine) {
        Object object;
        Inlay<?> inlay = this.blockInlayAbove(visualLine);
        if (inlay != null) {
            Inlay<?> inlay2;
            Inlay<?> it = inlay2 = inlay;
            boolean bl = false;
            object = this.isBlockInlayInSelection(it) ? inlay2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final Inlay<?> blockInlayBelow(int visualLine) {
        List<Inlay<?>> list2 = this.editor.getInlayModel().getBlockElementsForVisualLine(visualLine, false);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getBlockElementsForVisualLine(...)");
        Inlay inlay = (Inlay)CollectionsKt.firstOrNull(list2);
        if (inlay == null) {
            List<Inlay<?>> list3 = this.editor.getInlayModel().getBlockElementsForVisualLine(visualLine + 1, true);
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getBlockElementsForVisualLine(...)");
            inlay = (Inlay)CollectionsKt.lastOrNull(list3);
        }
        return inlay;
    }

    private final Inlay<?> selectedBlockInlayBelow(int visualLine) {
        Object object;
        Inlay<?> inlay = this.blockInlayBelow(visualLine);
        if (inlay != null) {
            Inlay<?> inlay2;
            Inlay<?> it = inlay2 = inlay;
            boolean bl = false;
            object = this.isBlockInlayInSelection(it) ? inlay2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final boolean hasCFREnd(List<? extends CustomFoldRegion> cfr, double x, boolean left) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = cfr;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CustomFoldRegion it = (CustomFoldRegion)element$iv;
                    boolean bl2 = false;
                    double startX = this.editor.offsetToXY((int)it.getStartOffset()).x;
                    double endX = startX + (double)it.getWidthInPixels();
                    double pos = left ? startX : endX;
                    if (!(Math.abs(pos - x) < 0.01)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasSelectionEndAboveLine(int visualLine, double x, boolean left, boolean checkBlockInlays) {
        Rectangle2D rectangle2D;
        Inlay<?> inlay;
        if (visualLine <= 0) {
            return false;
        }
        List<CustomFoldRegion> it = this.customFoldRegionsFor(visualLine - 1);
        boolean bl = false;
        if (!((Collection)it).isEmpty()) {
            return this.hasCFREnd(it, x, left);
        }
        if (checkBlockInlays && (inlay = this.selectedBlockInlayAbove(visualLine - 1)) != null && (rectangle2D = this.getBounds2D(inlay)) != null) {
            Rectangle2D it2 = rectangle2D;
            boolean bl2 = false;
            double endX = left ? it2.getX() : it2.getX() + it2.getWidth();
            return Math.abs(endX - x) < 0.01;
        }
        return this.caretSelectionsForLine(visualLine - 1).hasSelectionEnd(left, x);
    }

    static /* synthetic */ boolean hasSelectionEndAboveLine$default(SelectionLinePainter selectionLinePainter, int n, double d, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        return selectionLinePainter.hasSelectionEndAboveLine(n, d, bl, bl2);
    }

    private final boolean hasSelectionEndAbove(Point2D p, boolean left, boolean checkBlockInlays) {
        return this.hasSelectionEndAboveLine(this.yToVisualLine((int)p.getY()), p.getX(), left, checkBlockInlays);
    }

    static /* synthetic */ boolean hasSelectionEndAbove$default(SelectionLinePainter selectionLinePainter, Point2D point2D, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return selectionLinePainter.hasSelectionEndAbove(point2D, bl, bl2);
    }

    private final boolean hasSelectionEndBelowLine(int visualLine, double x, boolean left, boolean checkBlockInlays) {
        Rectangle2D rectangle2D;
        Inlay<?> inlay;
        if (visualLine >= this.editor.getView().getVisibleLineCount()) {
            return false;
        }
        List<CustomFoldRegion> it = this.customFoldRegionsFor(visualLine);
        boolean bl = false;
        if (!((Collection)it).isEmpty()) {
            return this.hasCFREnd(it, x, left);
        }
        if (checkBlockInlays && (inlay = this.selectedBlockInlayBelow(visualLine - 1)) != null && (rectangle2D = this.getBounds2D(inlay)) != null) {
            Rectangle2D it2 = rectangle2D;
            boolean bl2 = false;
            double endX = left ? it2.getX() : it2.getX() + it2.getWidth();
            return Math.abs(endX - x) < 0.01;
        }
        return this.caretSelectionsForLine(visualLine).hasSelectionEnd(left, x);
    }

    static /* synthetic */ boolean hasSelectionEndBelowLine$default(SelectionLinePainter selectionLinePainter, int n, double d, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        return selectionLinePainter.hasSelectionEndBelowLine(n, d, bl, bl2);
    }

    private final boolean hasSelectionEndBelow(Point2D p, boolean left, boolean checkBlockInlays) {
        return this.hasSelectionEndBelowLine(this.yToVisualLine((int)p.getY() - this.lineHeight) + 1, p.getX(), left, checkBlockInlays);
    }

    static /* synthetic */ boolean hasSelectionEndBelow$default(SelectionLinePainter selectionLinePainter, Point2D point2D, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return selectionLinePainter.hasSelectionEndBelow(point2D, bl, bl2);
    }

    private final boolean hasSelectionAboveLine(int visualLine, double x, boolean checkBlockInlays) {
        Rectangle2D rectangle2D;
        Inlay<?> inlay;
        if (visualLine <= 0) {
            return false;
        }
        List<CustomFoldRegion> it = this.customFoldRegionsFor(visualLine - 1);
        boolean bl = false;
        if (!((Collection)it).isEmpty()) {
            boolean bl2;
            block6: {
                Iterable $this$any$iv = it;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CustomFoldRegion cfr = (CustomFoldRegion)element$iv;
                        boolean bl3 = false;
                        double startX = this.editor.offsetToXY((int)cfr.getStartOffset()).x;
                        double d = startX - 0.01;
                        boolean bl4 = x <= startX + (double)cfr.getWidthInPixels() + 0.01 ? d <= x : false;
                        if (!bl4) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            return bl2;
        }
        if (checkBlockInlays && (inlay = this.selectedBlockInlayAbove(visualLine)) != null && (rectangle2D = this.getBounds2D(inlay)) != null) {
            Rectangle2D it2 = rectangle2D;
            boolean bl5 = false;
            double d = it2.getX() - 0.01;
            return x <= it2.getX() + it2.getWidth() + 0.01 ? d <= x : false;
        }
        return this.caretSelectionsForLine(visualLine - 1).containsPosition(x);
    }

    static /* synthetic */ boolean hasSelectionAboveLine$default(SelectionLinePainter selectionLinePainter, int n, double d, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return selectionLinePainter.hasSelectionAboveLine(n, d, bl);
    }

    private final boolean hasSelectionAbove(Point2D p, boolean checkBlockInlays) {
        return this.hasSelectionAboveLine(this.yToVisualLine((int)p.getY()), p.getX(), checkBlockInlays);
    }

    static /* synthetic */ boolean hasSelectionAbove$default(SelectionLinePainter selectionLinePainter, Point2D point2D, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return selectionLinePainter.hasSelectionAbove(point2D, bl);
    }

    private final boolean hasSelectionBelowLine(int visualLine, double x, boolean checkBlockInlays) {
        Rectangle2D rectangle2D;
        Inlay<?> inlay;
        List<CustomFoldRegion> it = this.customFoldRegionsFor(visualLine);
        boolean bl = false;
        if (!((Collection)it).isEmpty()) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = it;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CustomFoldRegion cfr = (CustomFoldRegion)element$iv;
                        boolean bl3 = false;
                        double startX = this.editor.offsetToXY((int)cfr.getStartOffset()).x;
                        double d = startX - 0.01;
                        boolean bl4 = x <= startX + (double)cfr.getWidthInPixels() + 0.01 ? d <= x : false;
                        if (!bl4) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            return bl2;
        }
        if (checkBlockInlays && (inlay = this.selectedBlockInlayBelow(visualLine - 1)) != null && (rectangle2D = this.getBounds2D(inlay)) != null) {
            Rectangle2D it2 = rectangle2D;
            boolean bl5 = false;
            double d = it2.getX() - 0.01;
            return x <= it2.getX() + it2.getWidth() + 0.01 ? d <= x : false;
        }
        return this.caretSelectionsForLine(visualLine).containsPosition(x);
    }

    static /* synthetic */ boolean hasSelectionBelowLine$default(SelectionLinePainter selectionLinePainter, int n, double d, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return selectionLinePainter.hasSelectionBelowLine(n, d, bl);
    }

    private final boolean hasSelectionBelow(Point2D p, boolean checkBlockInlays) {
        return this.hasSelectionBelowLine(this.yToVisualLine((int)p.getY() - this.lineHeight) + 1, p.getX(), checkBlockInlays);
    }

    static /* synthetic */ boolean hasSelectionBelow$default(SelectionLinePainter selectionLinePainter, Point2D point2D, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return selectionLinePainter.hasSelectionBelow(point2D, bl);
    }

    private final boolean isSelectionLeftBound(SelectionRectangle block) {
        int visualLine = this.yToVisualLine((int)block.getTopLeft().getY());
        return !((Collection)this.customFoldRegionsFor(visualLine)).isEmpty() || this.caretSelectionsForLine(visualLine).hasSelectionEnd(true, block.getTopLeft().getX());
    }

    private final boolean isSelectionRightBound(SelectionRectangle block) {
        int visualLine = this.yToVisualLine((int)block.getTopLeft().getY());
        return !((Collection)this.customFoldRegionsFor(visualLine)).isEmpty() || this.caretSelectionsForLine(visualLine).hasSelectionEnd(false, block.getBottomRight().getX());
    }

    public final boolean isInSelection(float x, int y, float width) {
        int line = this.yToVisualLine(y);
        CaretSelection caretSelection = this.caretSelectionsForLine(line).selectionContaining(x);
        if (caretSelection == null) {
            return false;
        }
        CaretSelection selection = caretSelection;
        return selection.contains(x + width);
    }

    private final void paintRoundedBlock(SelectionRectangle block, CornerType[] cornerTypes, double lineExtensionWidth) {
        CornerType topLeftType = cornerTypes[0];
        CornerType topRightType = cornerTypes[1];
        CornerType bottomRightType = cornerTypes[2];
        CornerType bottomLeftType = cornerTypes[3];
        Path2D.Double path = new Path2D.Double();
        double leftExtensionWidth = this.editor.isRightAligned() ? lineExtensionWidth : 0.0;
        double rightExtensionWidth = this.editor.isRightAligned() ? 0.0 : lineExtensionWidth;
        Point2D.Double visualTopLeft = new Point2D.Double(block.getTopLeft().getX() - leftExtensionWidth, block.getTopLeft().getY());
        path.moveTo(visualTopLeft.x, visualTopLeft.y + this.radius);
        switch (WhenMappings.$EnumSwitchMapping$0[topLeftType.ordinal()]) {
            case 1: {
                path.lineTo(visualTopLeft.x, visualTopLeft.y);
                path.lineTo(visualTopLeft.x + this.radius, visualTopLeft.y);
                break;
            }
            case 2: {
                path.quadTo(visualTopLeft.x, visualTopLeft.y, visualTopLeft.x - this.radius, visualTopLeft.y);
                path.lineTo(visualTopLeft.x + this.radius, visualTopLeft.y);
                break;
            }
            case 3: {
                path.quadTo(visualTopLeft.x, visualTopLeft.y, visualTopLeft.x + this.radius, visualTopLeft.y);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Point2D.Double topRight = new Point2D.Double(block.getBottomRight().getX(), block.getTopLeft().getY());
        Point2D.Double visualTopRight = new Point2D.Double(topRight.x + rightExtensionWidth, topRight.y);
        path.lineTo(visualTopRight.x - this.radius, topRight.y);
        switch (WhenMappings.$EnumSwitchMapping$0[topRightType.ordinal()]) {
            case 1: {
                path.lineTo(visualTopRight.x, topRight.y);
                path.lineTo(visualTopRight.x, topRight.y + this.radius);
                break;
            }
            case 2: {
                path.lineTo(visualTopRight.x, topRight.y);
                path.lineTo(visualTopRight.x, topRight.y + this.radius);
                path.quadTo(visualTopRight.x, topRight.y, visualTopRight.x + this.radius, topRight.y);
                path.lineTo(visualTopRight.x, topRight.y);
                path.lineTo(visualTopRight.x, topRight.y + this.radius);
                break;
            }
            case 3: {
                path.quadTo(visualTopRight.x, topRight.y, visualTopRight.x, topRight.y + this.radius);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Point2D.Double visualBottomRight = new Point2D.Double(block.getBottomRight().getX() + rightExtensionWidth, block.getBottomRight().getY());
        path.lineTo(visualBottomRight.x, block.getBottomRight().getY() - this.radius);
        switch (WhenMappings.$EnumSwitchMapping$0[bottomRightType.ordinal()]) {
            case 1: {
                path.lineTo(visualBottomRight.x, block.getBottomRight().getY());
                path.lineTo(visualBottomRight.x - this.radius, block.getBottomRight().getY());
                break;
            }
            case 2: {
                path.quadTo(visualBottomRight.x, block.getBottomRight().getY(), visualBottomRight.x + this.radius, block.getBottomRight().getY());
                path.lineTo(visualBottomRight.x - this.radius, block.getBottomRight().getY());
                break;
            }
            case 3: {
                path.quadTo(visualBottomRight.x, block.getBottomRight().getY(), visualBottomRight.x - this.radius, block.getBottomRight().getY());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Point2D.Double visualBottomLeft = new Point2D.Double(block.getTopLeft().getX() - leftExtensionWidth, block.getBottomRight().getY());
        path.lineTo(visualBottomLeft.x + this.radius, block.getBottomRight().getY());
        switch (WhenMappings.$EnumSwitchMapping$0[bottomLeftType.ordinal()]) {
            case 1: {
                path.lineTo(visualBottomLeft.x, visualBottomLeft.y);
                path.lineTo(visualBottomLeft.x, visualBottomLeft.y - this.radius);
                break;
            }
            case 2: {
                path.lineTo(visualBottomLeft.x, visualBottomLeft.y);
                path.lineTo(visualBottomLeft.x, visualBottomLeft.y - this.radius);
                path.quadTo(visualBottomLeft.x, visualBottomLeft.y, visualBottomLeft.x - this.radius, visualBottomLeft.y);
                path.lineTo(visualBottomLeft.x, visualBottomLeft.y);
                path.lineTo(visualBottomLeft.x, visualBottomLeft.y - this.radius);
                break;
            }
            case 3: {
                path.quadTo(visualBottomLeft.x, visualBottomLeft.y, visualBottomLeft.x, visualBottomLeft.y - this.radius);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        path.lineTo(visualTopLeft.x, visualTopLeft.y + this.radius);
        path.closePath();
        Object oldAA = this.graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.setColor(this.selectionBg);
        this.graphics.fill(path);
        if (oldAA != null) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAA);
        } else {
            this.graphics.getRenderingHints().remove(RenderingHints.KEY_ANTIALIASING);
        }
    }

    private final void paintRoundedSelection(SelectionRectangle block) {
        Pair pair = new Pair((Object)this.isSelectionLeftBound(block), (Object)this.isSelectionRightBound(block));
        boolean leftBound = (Boolean)pair.component1();
        boolean rightBound = (Boolean)pair.component2();
        CornerType topLeftType = !leftBound || SelectionLinePainter.hasSelectionEndAbove$default(this, block.getTopLeft(), true, false, 4, null) ? CornerType.Straight : (SelectionLinePainter.hasSelectionAbove$default(this, block.getTopLeft(), false, 2, null) ? CornerType.InvertedRounded : CornerType.Rounded);
        Point2D.Double topRight = new Point2D.Double(block.getBottomRight().getX(), block.getTopLeft().getY());
        CornerType topRightType = !rightBound || SelectionLinePainter.hasSelectionEndAbove$default(this, topRight, false, false, 4, null) ? CornerType.Straight : (SelectionLinePainter.hasSelectionAbove$default(this, topRight, false, 2, null) ? CornerType.InvertedRounded : CornerType.Rounded);
        CornerType bottomRightType = !rightBound || SelectionLinePainter.hasSelectionEndBelow$default(this, block.getBottomRight(), false, false, 4, null) ? CornerType.Straight : (SelectionLinePainter.hasSelectionBelow$default(this, block.getBottomRight(), false, 2, null) ? CornerType.InvertedRounded : CornerType.Rounded);
        Point2D.Double bottomLeft = new Point2D.Double(block.getTopLeft().getX(), block.getBottomRight().getY());
        CornerType bottomLeftType = !leftBound || SelectionLinePainter.hasSelectionEndBelow$default(this, bottomLeft, true, false, 4, null) ? CornerType.Straight : (SelectionLinePainter.hasSelectionBelow$default(this, bottomLeft, false, 2, null) ? CornerType.InvertedRounded : CornerType.Rounded);
        CornerType[] cornerTypeArray = new CornerType[]{topLeftType, topRightType, bottomRightType, bottomLeftType};
        this.paintRoundedBlock(block, cornerTypeArray, this.lineExtensionWidth);
    }

    private final Rectangle2D getBounds2D(Inlay<?> $this$bounds2D) {
        Rectangle rectangle = $this$bounds2D.getBounds();
        if (rectangle == null) {
            throw new IllegalStateException("Inlay should not be folded");
        }
        Rectangle it = rectangle;
        boolean bl = false;
        return new Rectangle2D.Double(it.x, (double)it.y + (double)this.yShift, it.width, it.height);
    }

    private final Pair<CornerType, CornerType> cornerTypesForFirstBlockInlay(int bottomVisualLine, Inlay<?> inlay) {
        Rectangle2D bounds = this.getBounds2D(inlay);
        Pair pair = new Pair((Object)bounds.getX(), (Object)(bounds.getX() + bounds.getWidth()));
        double startX = ((Number)pair.component1()).doubleValue();
        double endX = ((Number)pair.component2()).doubleValue();
        CornerType topLeftType = this.hasSelectionEndAboveLine(bottomVisualLine, startX, true, false) ? CornerType.Straight : (this.hasSelectionAboveLine(bottomVisualLine, startX, false) ? CornerType.InvertedRounded : CornerType.Rounded);
        CornerType topRightType = this.hasSelectionEndAboveLine(bottomVisualLine, endX, false, false) ? CornerType.Straight : (this.hasSelectionAboveLine(bottomVisualLine, endX, false) ? CornerType.InvertedRounded : CornerType.Rounded);
        return new Pair((Object)topLeftType, (Object)topRightType);
    }

    private final Pair<CornerType, CornerType> cornerTypesForLastBlockInlay(int bottomVisualLine, Inlay<?> inlay) {
        Rectangle2D bounds = this.getBounds2D(inlay);
        Pair pair = new Pair((Object)bounds.getX(), (Object)(bounds.getX() + bounds.getWidth()));
        double startX = ((Number)pair.component1()).doubleValue();
        double endX = ((Number)pair.component2()).doubleValue();
        CornerType bottomLeftType = this.hasSelectionEndBelowLine(bottomVisualLine, startX, true, false) ? CornerType.Straight : (this.hasSelectionBelowLine(bottomVisualLine, startX, false) ? CornerType.InvertedRounded : CornerType.Rounded);
        CornerType bottomRightType = this.hasSelectionEndBelowLine(bottomVisualLine, endX, false, false) ? CornerType.Straight : (this.hasSelectionBelowLine(bottomVisualLine, endX, false) ? CornerType.InvertedRounded : CornerType.Rounded);
        return new Pair((Object)bottomLeftType, (Object)bottomRightType);
    }

    public final void paintAllBlockInlaysAbove(int bottomVisualLine, double lineExtensionWidth) {
        boolean bl;
        List<Inlay<?>> list2 = this.editor.getInlayModel().getBlockElementsForVisualLine(bottomVisualLine - 1, false);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getBlockElementsForVisualLine(...)");
        List<Inlay<?>> belowBlockInlays = list2;
        List<Inlay<?>> list3 = this.editor.getInlayModel().getBlockElementsForVisualLine(bottomVisualLine, true);
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getBlockElementsForVisualLine(...)");
        List<Inlay<?>> aboveBlockInlays = list3;
        List allInlays = CollectionsKt.plus((Collection)belowBlockInlays, (Iterable)aboveBlockInlays);
        boolean bl2 = bl = !((Collection)allInlays).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-SelectionLinePainter$paintAllBlockInlaysAbove$22 = false;
            String $i$a$-assert-SelectionLinePainter$paintAllBlockInlaysAbove$22 = "There should be at least one block inlay";
            throw new AssertionError((Object)$i$a$-assert-SelectionLinePainter$paintAllBlockInlaysAbove$22);
        }
        List $this$paintAllBlockInlaysAbove_u24lambda_u241 = allInlays;
        boolean bl3 = false;
        Pair pair = new Pair(CollectionsKt.first((List)$this$paintAllBlockInlaysAbove_u24lambda_u241), CollectionsKt.last((List)$this$paintAllBlockInlaysAbove_u24lambda_u241));
        Inlay firstInlay = (Inlay)pair.component1();
        Inlay lastInlay = (Inlay)pair.component2();
        Intrinsics.checkNotNull((Object)firstInlay);
        Pair<CornerType, CornerType> pair2 = this.cornerTypesForFirstBlockInlay(bottomVisualLine, firstInlay);
        CornerType firstTopLeftType = (CornerType)((Object)pair2.component1());
        CornerType firstTopRightType = (CornerType)((Object)pair2.component2());
        Intrinsics.checkNotNull((Object)lastInlay);
        Pair<CornerType, CornerType> pair3 = this.cornerTypesForLastBlockInlay(bottomVisualLine, lastInlay);
        CornerType lastBottomLeftType = (CornerType)((Object)pair3.component1());
        CornerType lastBottomRightType = (CornerType)((Object)pair3.component2());
        Function2 cornerTypesFor = SelectionLinePainter::paintAllBlockInlaysAbove$lambda$2;
        Iterator iterator = ((Iterable)allInlays).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Pair pair4;
            Pair pair5;
            int idx = n++;
            Inlay inlay = (Inlay)iterator.next();
            Intrinsics.checkNotNull((Object)inlay);
            Rectangle2D bounds = this.getBounds2D(inlay);
            if (idx == 0) {
                pair5 = TuplesKt.to((Object)((Object)firstTopLeftType), (Object)((Object)firstTopRightType));
            } else {
                Object e = allInlays.get(idx - 1);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                pair5 = (Pair)cornerTypesFor.invoke((Object)bounds, (Object)this.getBounds2D((Inlay)e));
            }
            Pair pair6 = pair5;
            CornerType topLeftType = (CornerType)((Object)pair6.component1());
            CornerType topRightType = (CornerType)((Object)pair6.component2());
            if (idx == CollectionsKt.getLastIndex((List)allInlays)) {
                pair4 = TuplesKt.to((Object)((Object)lastBottomLeftType), (Object)((Object)lastBottomRightType));
            } else {
                Object e = allInlays.get(idx + 1);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                pair4 = (Pair)cornerTypesFor.invoke((Object)bounds, (Object)this.getBounds2D((Inlay)e));
            }
            Pair pair7 = pair4;
            CornerType bottomLeftType = (CornerType)((Object)pair7.component1());
            CornerType bottomRightType = (CornerType)((Object)pair7.component2());
            SelectionRectangle block = new SelectionRectangle(new Point2D.Double(bounds.getX(), bounds.getY()), new Point2D.Double(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight()));
            CornerType[] cornerTypeArray = new CornerType[]{topLeftType, topRightType, bottomRightType, bottomLeftType};
            this.paintRoundedBlock(block, cornerTypeArray, lineExtensionWidth);
        }
    }

    private final void paint(Rectangle2D rect) {
        if (Registry.Companion.is("editor.disable.new.selection")) {
            SelectionLinePainterKt.access$getLOG$p().error("Using the new selection painting is disabled but SelectionLinePainter.paint was called, proceeding with caution");
            EditorPainter.fillRectExact(this.graphics, rect, this.selectionBg);
            return;
        }
        SelectionRectangle selectionRect = new SelectionRectangle(new Point2D.Double(rect.getX(), rect.getY()), new Point2D.Double(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight()));
        this.paintRoundedSelection(selectionRect);
    }

    public final void flush() {
        Rectangle2D rectangle2D = this.currentRect;
        if (rectangle2D != null) {
            Rectangle2D it = rectangle2D;
            boolean bl = false;
            this.paint(it);
        }
        this.currentRect = null;
        this.lineExtensionWidth = 0.0;
    }

    public final void extendLine(double width) {
        this.lineExtensionWidth += width;
    }

    public final void paintSelection(@NotNull Rectangle2D rect) {
        Rectangle2D rectangle2D;
        boolean intersects;
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Rectangle2D rectangle2D2 = this.currentRect;
        if (rectangle2D2 != null) {
            Rectangle2D it = rectangle2D2;
            boolean bl = false;
            if (Math.abs(it.getY() - rect.getY()) > 0.01) {
                this.flush();
            }
        }
        Rectangle2D rectangle2D3 = this.currentRect;
        if (rectangle2D3 != null) {
            Rectangle2D $this$paintSelection_u24lambda_u241 = rectangle2D3;
            boolean bl = false;
            v2 = $this$paintSelection_u24lambda_u241.getX() + $this$paintSelection_u24lambda_u241.getWidth() + 0.01 >= rect.getX();
        } else {
            v2 = intersects = false;
        }
        if (!intersects) {
            Rectangle2D rectangle2D4 = this.currentRect;
            if (rectangle2D4 != null) {
                Rectangle2D it = rectangle2D4;
                boolean bl = false;
                this.paint(it);
            }
            this.currentRect = null;
        }
        if ((rectangle2D = this.currentRect) == null || (rectangle2D = rectangle2D.createUnion(rect)) == null) {
            rectangle2D = rect;
        }
        this.currentRect = rectangle2D;
    }

    /*
     * WARNING - void declaration
     */
    private static final List caretSelections_delegate$lambda$0(SelectionLinePainter this$0) {
        void $this$mapTo$iv$iv;
        List<Caret> list2 = this$0.editor.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllCarets(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            VisualPosition visualPosition;
            void caret;
            Caret caret2 = (Caret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VisualPosition it = caret.getSelectionEndPosition();
            boolean bl2 = false;
            if (it.column != 0) {
                visualPosition = it;
            } else {
                Object object;
                SelectionLinePainter selectionLinePainter = this$0;
                try {
                    SelectionLinePainter $this$caretSelections_delegate_u24lambda_u240_u240_u240_u240 = selectionLinePainter;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)EditorUtil.getLastVisualLineColumnNumber($this$caretSelections_delegate_u24lambda_u240_u240_u240_u240.editor, it.line - 1));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Object columnNumber = object;
                visualPosition = Result.isFailure-impl((Object)columnNumber) ? it : new VisualPosition(it.line - 1, EditorUtil.getLastVisualLineColumnNumber(this$0.editor, it.line - 1));
            }
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"let(...)");
            VisualPosition end = visualPosition;
            EditorImpl editorImpl = this$0.editor;
            VisualPosition visualPosition2 = caret.getSelectionStartPosition();
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition2, (String)"getSelectionStartPosition(...)");
            collection.add(new CaretSelection(editorImpl, visualPosition2, end));
        }
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                CaretSelection it = (CaretSelection)a;
                boolean bl = false;
                it = (CaretSelection)b;
                Comparable comparable = Integer.valueOf(it.getStart().line);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.getStart().line));
            }
        };
        return CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    CaretSelection it = (CaretSelection)a;
                    boolean bl = false;
                    it = (CaretSelection)b;
                    Comparable comparable = Integer.valueOf(it.getStart().column);
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.getStart().column));
                }
                return n;
            }
        });
    }

    private static final List allCarets_delegate$lambda$0(SelectionLinePainter this$0) {
        return this$0.editor.getCaretModel().getAllCarets();
    }

    /*
     * WARNING - void declaration
     */
    private static final List customFoldRegions_delegate$lambda$0(SelectionLinePainter this$0) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        FoldRegion[] regions;
        FoldingModelImpl foldingModelImpl = this$0.editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModelImpl, (String)"getFoldingModel(...)");
        FoldingModelImpl foldingModel = foldingModelImpl;
        FoldRegion[] foldRegionArray = foldingModel.fetchTopLevel();
        if (foldRegionArray == null) {
            foldRegionArray = new FoldRegion[]{};
        }
        FoldRegion[] $this$filterIsInstance$iv = regions = foldRegionArray;
        boolean $i$f$filterIsInstance = false;
        FoldRegion[] foldRegionArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CustomFoldRegion)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CustomFoldRegion it = (CustomFoldRegion)element$iv$iv;
            boolean bl = false;
            if (!this$0.isCFRInSelection(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final int caretSelectionsForLine$lambda$0(int $line, CaretSelection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getEnd().line < $line ? -1 : 1;
    }

    private static final int caretSelectionsForLine$lambda$2(int $line, CaretSelection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStart().line <= $line ? -1 : 1;
    }

    private static final Pair paintAllBlockInlaysAbove$lambda$2(Rectangle2D bounds, Rectangle2D otherBounds) {
        CornerType cornerType;
        CornerType cornerType2;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)otherBounds, (String)"otherBounds");
        if (Math.abs(bounds.getX() - otherBounds.getX()) < 0.01) {
            cornerType2 = CornerType.Straight;
        } else {
            double d = otherBounds.getX() - 0.01;
            double d2 = otherBounds.getX() + otherBounds.getWidth() + 0.01;
            double d3 = bounds.getX();
            cornerType2 = (d <= d3 ? d3 <= d2 : false) ? CornerType.InvertedRounded : CornerType.Rounded;
        }
        CornerType leftType = cornerType2;
        double rightX = bounds.getX() + bounds.getWidth();
        if (Math.abs(rightX - otherBounds.getX() - otherBounds.getWidth()) < 0.01) {
            cornerType = CornerType.Straight;
        } else {
            double d = otherBounds.getX() - 0.01;
            cornerType = (rightX <= otherBounds.getX() + otherBounds.getWidth() + 0.01 ? d <= rightX : false) ? CornerType.InvertedRounded : CornerType.Rounded;
        }
        CornerType rightType = cornerType;
        return new Pair((Object)leftType, (Object)rightType);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CornerType.values().length];
            try {
                nArray[CornerType.Straight.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CornerType.InvertedRounded.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CornerType.Rounded.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

