/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.TrashBin;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class VirtualFileDeleteProvider
implements DeleteProvider {
    private static final Logger LOG = Logger.getInstance(VirtualFileDeleteProvider.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            VirtualFileDeleteProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext2) {
        VirtualFile[] files2;
        if (dataContext2 == null) {
            VirtualFileDeleteProvider.$$$reportNull$$$0(1);
        }
        return (files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext2)) != null && files2.length > 0;
    }

    public void deleteElement(@NotNull DataContext dataContext2) {
        String message;
        int returnValue;
        boolean toBin;
        Object[] files2;
        if (dataContext2 == null) {
            VirtualFileDeleteProvider.$$$reportNull$$$0(2);
        }
        if ((files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext2)) == null || files2.length == 0) {
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        boolean bl = toBin = TrashBin.isSupported() && GeneralSettings.getInstance().isDeletingToBin();
        if (!(toBin && ContainerUtil.all((Object[])files2, TrashBin::canMoveToTrash) || (returnValue = Messages.showOkCancelDialog((String)(message = VirtualFileDeleteProvider.createConfirmationMessage((VirtualFile[])files2)), (String)UIBundle.message((String)"delete.dialog.title", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) == 0)) {
            return;
        }
        Arrays.sort(files2, Comparator.comparing(VirtualFile::getPath));
        LinkedList problems = new LinkedList();
        CommandProcessor.getInstance().executeCommand(project2, () -> this.lambda$deleteElement$0(project2, (VirtualFile[])files2, toBin, problems), IdeBundle.message((String)"command.deleting.files", (Object[])new Object[0]), null);
    }

    private static void reportDeletionProblem(List<String> problems) {
        boolean more = false;
        if (problems.size() > 10) {
            problems = problems.subList(0, 10);
            more = true;
        }
        String message = IdeBundle.message((String)"dialog.message.could.not.erase.files.or.folders.0.1", (Object[])new Object[]{String.join((CharSequence)",\n  ", problems), more ? "\n  ..." : ""});
        Messages.showMessageDialog((String)message, (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }

    @NlsContexts.DialogMessage
    private static String createConfirmationMessage(VirtualFile[] filesToDelete) {
        if (filesToDelete.length == 1) {
            if (filesToDelete[0].isDirectory()) {
                return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.folder.confirmation.message", (Object[])new Object[]{filesToDelete[0].getName()});
            }
            return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.file.confirmation.message", (Object[])new Object[]{filesToDelete[0].getName()});
        }
        boolean hasFiles = false;
        boolean hasFolders = false;
        for (VirtualFile file2 : filesToDelete) {
            boolean isDirectory = file2.isDirectory();
            hasFiles |= !isDirectory;
            hasFolders |= isDirectory;
        }
        LOG.assertTrue(hasFiles || hasFolders);
        if (hasFiles && hasFolders) {
            return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.files.and.directories.confirmation.message", (Object[])new Object[]{filesToDelete.length});
        }
        if (hasFolders) {
            return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.folders.confirmation.message", (Object[])new Object[]{filesToDelete.length});
        }
        return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.files.and.files.confirmation.message", (Object[])new Object[]{filesToDelete.length});
    }

    private /* synthetic */ void lambda$deleteElement$0(Project project2, final VirtualFile[] files2, final boolean toBin, final LinkedList problems) {
        new Task.Modal(this, project2, IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator2.setIndeterminate(false);
                int i2 = 0;
                for (VirtualFile file2 : files2) {
                    if (indicator2.isCanceled()) break;
                    indicator2.setText(file2.getPresentableUrl());
                    indicator2.setFraction((double)i2++ / (double)files2.length);
                    try {
                        if (toBin && TrashBin.canMoveToTrash((VirtualFile)file2)) {
                            TrashBin.moveToTrash((Path)file2.toNioPath());
                        }
                        WriteAction.runAndWait(() -> file2.delete((Object)this));
                    }
                    catch (IOException e) {
                        LOG.info("Error when deleting " + String.valueOf(file2), (Throwable)e);
                        problems.add(file2.getName());
                    }
                }
            }

            public void onSuccess() {
                this.reportProblems();
            }

            public void onCancel() {
                this.reportProblems();
            }

            private void reportProblems() {
                if (!problems.isEmpty()) {
                    VirtualFileDeleteProvider.reportDeletionProblem(problems);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/fileChooser/actions/VirtualFileDeleteProvider$1", "run"));
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/actions/VirtualFileDeleteProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/actions/VirtualFileDeleteProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

