/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserPanel;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.table.TableView;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PlatformNioHelper;
import com.intellij.util.system.OS;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileChooserPanelImpl
extends JBPanel<FileChooserPanelImpl>
implements FileChooserPanel,
Disposable {
    private static final Logger LOG = Logger.getInstance(FileChooserPanelImpl.class);
    private static final String PROJECT_DIR_DETECTION_PROPERTY = "idea.chooser.lookup.for.project.dirs";
    private static final String SEPARATOR = "!/";
    private static final CoreLocalFileSystem FS = new CoreLocalFileSystem();
    private static final String OPEN = "open";
    private final FileTypeRegistry myRegistry;
    private final FileChooserDescriptor myDescriptor;
    private final Runnable myCallback;
    private final Consumer<@NlsContexts.DialogMessage @Nullable String> myErrorSink;
    @Nullable
    private final WatchService myWatcher;
    private final Map<Path, FileSystem> myOpenFileSystems;
    private final ComboBox<PathWrapper> myPath;
    private final ListTableModel<FsItem> myModel;
    private final TableView<FsItem> myList;
    private boolean myShowPathBar;
    private boolean myPathBarActive;
    private volatile boolean myShowHiddenFiles;
    private volatile boolean myDetectProjectDirectories;
    private final Object myLock;
    private int myCounter;
    private Pair<Integer, Future<?>> myCurrentTask;
    @Nullable
    private Path myCurrentDirectory;
    private final List<FsItem> myCurrentContent;
    @Nullable
    private WatchKey myWatchKey;
    private final List<@Nullable Path> myHistory;
    private int myHistoryIndex;
    private volatile boolean myReloadSuppressed;

    FileChooserPanelImpl(@NotNull FileChooserDescriptor descriptor2, @NotNull Runnable callback, @NotNull Consumer<@NlsContexts.DialogMessage @Nullable String> errorSink, Path @NotNull [] recentPaths) {
        if (descriptor2 == null) {
            FileChooserPanelImpl.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            FileChooserPanelImpl.$$$reportNull$$$0(1);
        }
        if (errorSink == null) {
            FileChooserPanelImpl.$$$reportNull$$$0(2);
        }
        if (recentPaths == null) {
            FileChooserPanelImpl.$$$reportNull$$$0(3);
        }
        super((LayoutManager)new GridBagLayout());
        this.myLock = new String("file.chooser.panel.lock");
        this.myCounter = 0;
        this.myCurrentTask = Pair.pair((Object)-1, CompletableFuture.completedFuture(null));
        this.myCurrentContent = new ArrayList<FsItem>();
        this.myHistory = new ArrayList<Path>();
        this.myHistoryIndex = -1;
        this.myReloadSuppressed = false;
        this.myRegistry = FileTypeRegistry.getInstance();
        this.myDescriptor = descriptor2;
        this.myCallback = callback;
        this.myErrorSink = errorSink;
        this.myWatcher = this.startWatchService();
        this.myOpenFileSystems = new ConcurrentHashMap<Path, FileSystem>();
        this.myShowHiddenFiles = descriptor2.isShowHiddenFiles();
        this.myShowPathBar = PropertiesComponent.getInstance().getBoolean("FileChooser.ShowPath", true);
        this.myDetectProjectDirectories = PropertiesComponent.getInstance().getBoolean(PROJECT_DIR_DETECTION_PROPERTY, true);
        JLabel label2 = new JLabel(descriptor2.getDescription());
        DefaultActionGroup group2 = new DefaultActionGroup();
        for (AnAction action2 : ((DefaultActionGroup)ActionManager.getInstance().getAction("FileChooserToolbar")).getChildActionsOrStubs()) {
            group2.addAction(action2);
        }
        for (AnAction action2 : ((DefaultActionGroup)ActionManager.getInstance().getAction("FileChooserSettings")).getChildActionsOrStubs()) {
            group2.addAction(action2).setAsSecondary(true);
        }
        ActionToolbar toolBar = ActionManager.getInstance().createActionToolbar("FileChooserDialog", (ActionGroup)group2, true);
        toolBar.setSecondaryActionsIcon(AllIcons.Actions.More, true);
        toolBar.setTargetComponent((JComponent)((Object)this));
        this.myPath = new ComboBox((Object[])((PathWrapper[])Stream.of(recentPaths).map(PathWrapper::new).toArray(PathWrapper[]::new)));
        this.myPath.setUsePreferredSizeAsMinimum(false);
        this.setupPathBar();
        MyColumnInfo nameColumn = new MyColumnInfo(this, UIBundle.message((String)"file.chooser.column.name", (Object[])new Object[0]), 0, FsItem.COMPARATOR){

            public String valueOf(FsItem item) {
                return item.name;
            }
        };
        MyColumnInfo sizeColumn = new MyColumnInfo(this, UIBundle.message((String)"file.chooser.column.size", (Object[])new Object[0]), 12, Comparator.comparing(item -> item.size)){

            public String valueOf(FsItem item) {
                return item.directory ? "--" : Formats.formatFileSize((long)item.size);
            }
        };
        MyColumnInfo dateColumn = new MyColumnInfo(this, UIBundle.message((String)"file.chooser.column.date", (Object[])new Object[0]), 15, Comparator.comparing(item -> item.lastUpdated)){

            public String valueOf(FsItem item) {
                return DateFormatUtil.formatPrettyDateTime((long)item.lastUpdated);
            }
        };
        this.myModel = new ListTableModel(new ColumnInfo[]{nameColumn, sizeColumn, dateColumn});
        this.myList = new TableView(this.myModel);
        this.setupDirectoryView();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myList);
        Insets pathInsets = this.myPath.getInsets();
        Insets scrollInsets = new Insets(JBUI.scale((int)5) - pathInsets.bottom, pathInsets.left, 0, pathInsets.right);
        scrollPane.setBorder(BorderFactory.createLineBorder(NamedColorUtil.getBoundsColor()));
        this.add(label2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.01, 10, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.add(toolBar.getComponent(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.01, 10, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.add((Component)this.myPath, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.01, 10, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.add(scrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.98, 10, 1, scrollInsets, 0, 0));
    }

    @Nullable
    private WatchService startWatchService() {
        try {
            WatchService watcher = FileSystems.getDefault().newWatchService();
            FileChooserPanelImpl.execute(() -> {
                while (true) {
                    try {
                        while (true) {
                            WatchKey key = watcher.take();
                            List<WatchEvent<?>> events = key.pollEvents();
                            key.reset();
                            if (events.isEmpty() || this.myReloadSuppressed) continue;
                            UIUtil.invokeLaterIfNeeded(() -> {
                                Object object = this.myLock;
                                synchronized (object) {
                                    if (key == this.myWatchKey && this.myCurrentDirectory != null) {
                                        this.reload(null);
                                    }
                                }
                            });
                        }
                    }
                    catch (InterruptedException key) {
                        continue;
                    }
                    catch (ClosedWatchServiceException e) {
                        return;
                    }
                    break;
                }
            });
            return watcher;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private void setupPathBar() {
        this.myPath.setVisible(this.myShowPathBar);
        this.myPath.setEditable(true);
        final JTextField pathEditor = (JTextField)this.myPath.getEditor().getEditorComponent();
        pathEditor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FileChooserPanelImpl.this.myPathBarActive = true;
            }
        });
        pathEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){

            protected void textChanged(@NotNull DocumentEvent e) {
                String text2;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (e.getType() == DocumentEvent.EventType.INSERT && e.getOffset() == 0 && e.getLength() == e.getDocument().getLength() && StringUtil.isQuotedString((String)(text2 = pathEditor.getText()))) {
                    EventQueue.invokeLater(() -> pathEditor.setText(text2.substring(1, text2.length() - 1)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileChooser/impl/FileChooserPanelImpl$5", "textChanged"));
            }
        });
        LocalFsFinder finder = new LocalFsFinder(false).withBaseDir(null);
        FileLookup.LookupFilter filter2 = f -> this.myShowHiddenFiles || !this.myDescriptor.isHidden((VirtualFile)new CoreLocalVirtualFile(FS, ((LocalFsFinder.IoFile)f).getFile()));
        FileTextFieldImpl ignored = new FileTextFieldImpl(pathEditor, finder, filter2, FileChooserFactoryImpl.getMacroMap(), this){

            @Override
            protected void setTextToFile(FileLookup.LookupFile file2) {
                super.setTextToFile(file2);
                Path path = FileChooserPanelImpl.this.typedPath();
                if (path != null) {
                    FileChooserPanelImpl.this.load(path, null, Set.of());
                }
            }
        };
        pathEditor.getActionMap().put("notify-field-accept", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FileChooserPanelImpl.this.myPath.isPopupVisible()) {
                    FileChooserPanelImpl.this.myPath.setPopupVisible(false);
                }
                FileChooserPanelImpl.this.load(FileChooserPanelImpl.this.typedPath(), null, Set.of());
            }
        });
    }

    @Nullable
    private Path typedPath() {
        Path path;
        String str;
        Object object = this.myPath.getEditor().getItem();
        if (object instanceof PathWrapper) {
            PathWrapper wrapper2 = (PathWrapper)object;
            return wrapper2.path;
        }
        if (object instanceof String && !(str = (String)object).isBlank() && (path = this.findByPath(OSAgnosticPathUtil.expandUserHome((String)str.trim()))) != null && path.isAbsolute()) {
            return path;
        }
        return null;
    }

    private void setupDirectoryView() {
        this.myList.getTableHeader().setDefaultRenderer(new MyHeaderCellRenderer(this.myList.getTableHeader().getDefaultRenderer()));
        this.myList.setDefaultRenderer(Object.class, (TableCellRenderer)new MyTableCellRenderer(this.myList.getDefaultRenderer(Object.class)));
        this.myList.resetDefaultFocusTraversalKeys();
        this.myList.setShowGrid(false);
        this.myList.setCellSelectionEnabled(false);
        this.myList.setColumnSelectionAllowed(false);
        this.myList.setRowSelectionAllowed(true);
        this.myList.setSelectionMode(this.myDescriptor.isChooseMultiple() ? 2 : 0);
        this.myList.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FileChooserPanelImpl.this.myPathBarActive = false;
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                int idx;
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (e.getButton() == 1 && e.getClickCount() == 2 && (idx = FileChooserPanelImpl.this.myList.rowAtPoint(e.getPoint())) >= 0) {
                    FileChooserPanelImpl.this.myList.setRowSelectionInterval(idx, idx);
                    Action action2 = FileChooserPanelImpl.this.myList.getActionMap().get(FileChooserPanelImpl.OPEN);
                    if (action2 != null) {
                        action2.actionPerformed(null);
                    }
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileChooser/impl/FileChooserPanelImpl$9", "onClick"));
            }
        }.installOn(this.myList, true);
        this.myList.getActionMap().put(OPEN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserPanelImpl.this.openSelectedRow();
            }
        });
        this.myList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), OPEN);
        TableSpeedSearch.installOn(this.myList);
        this.myList.getActionMap().put("selectPreviousColumn", this.myList.getActionMap().get("selectFirstRow"));
        this.myList.getActionMap().put("selectNextColumn", this.myList.getActionMap().get("selectLastRow"));
        this.myList.setTransferHandler(new TransferHandler(null){

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                List items2 = FileChooserPanelImpl.this.myList.getSelectedObjects();
                return items2.isEmpty() ? null : new TextTransferable(items2.stream().map(item -> item.name).collect(Collectors.joining("\n")));
            }
        });
    }

    private void openSelectedRow() {
        int[] selection = this.myList.getSelectedRows();
        if (selection.length == 1) {
            FsItem item = (FsItem)this.myList.getRow(selection[0]);
            if (item.directory) {
                this.load(item.path, null, EnumSet.of(OpenFlags.UPDATE_PATH_BAR));
            } else if (this.myDescriptor.isChooseJarContents() && this.myRegistry.getFileTypeByFileName(item.name) == ArchiveFileType.INSTANCE) {
                this.load(item.path, null, EnumSet.of(OpenFlags.UPDATE_PATH_BAR, OpenFlags.INTO_ARCHIVE));
            } else {
                this.myCallback.run();
            }
        }
    }

    JComponent getPreferredFocusedComponent() {
        return this.myShowPathBar ? this.myPath : this.myList;
    }

    @NotNull
    @NotNull List<@NotNull Path> chosenPaths() {
        if (this.myShowPathBar && this.myPathBarActive) {
            Path path = this.typedPath();
            List<Path> list2 = path != null ? List.of(path) : List.of();
            if (list2 == null) {
                FileChooserPanelImpl.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (this.myList.getSelectedObjects().isEmpty()) {
            List<Path> list3 = this.myCurrentDirectory != null ? List.of(this.myCurrentDirectory) : List.of();
            if (list3 == null) {
                FileChooserPanelImpl.$$$reportNull$$$0(5);
            }
            return list3;
        }
        List<Path> list4 = this.myList.getSelectedObjects().stream().filter(r -> r.selectable).map(r -> r.path).filter(Objects::nonNull).collect(Collectors.toList());
        if (list4 == null) {
            FileChooserPanelImpl.$$$reportNull$$$0(6);
        }
        return list4;
    }

    @NotNull
    public JComponent getComponent() {
        FileChooserPanelImpl fileChooserPanelImpl = this;
        if (fileChooserPanelImpl == null) {
            FileChooserPanelImpl.$$$reportNull$$$0(7);
        }
        return fileChooserPanelImpl;
    }

    public void load(@Nullable Path path) {
        if (path != null && !path.isAbsolute()) {
            LOG.info("unexpected relative path: " + String.valueOf(path));
            path = null;
        }
        this.load(path, null, EnumSet.of(OpenFlags.UPDATE_PATH_BAR));
    }

    public void loadParent() {
        if (this.myCurrentDirectory != null) {
            this.load(FileChooserPanelImpl.parent(this.myCurrentDirectory), null, EnumSet.of(OpenFlags.UPDATE_PATH_BAR, OpenFlags.UPPER_LEVEL));
        }
    }

    public boolean hasHistory(boolean backward) {
        return !this.myHistory.isEmpty() && (backward ? this.myHistoryIndex > 0 : this.myHistoryIndex < this.myHistory.size() - 1);
    }

    public void loadHistory(boolean backward) {
        Path path = this.myHistory.get(backward ? (this.myHistoryIndex = this.myHistoryIndex - 1) : (this.myHistoryIndex = this.myHistoryIndex + 1));
        this.load(path, null, EnumSet.of(OpenFlags.UPDATE_PATH_BAR, OpenFlags.KEEP_HISTORY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(@Nullable Path focusOn) {
        FsItem value;
        if (focusOn == null && (value = (FsItem)this.myList.getSelectedObject()) != null) {
            focusOn = value.path;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.load(this.myCurrentDirectory, focusOn, EnumSet.of(OpenFlags.RELOAD, OpenFlags.UPDATE_PATH_BAR, OpenFlags.KEEP_HISTORY));
        }
    }

    public void reloadAfter(@NotNull ThrowableComputable<@Nullable Path, IOException> task) throws IOException {
        if (task == null) {
            FileChooserPanelImpl.$$$reportNull$$$0(8);
        }
        try {
            this.myReloadSuppressed = true;
            this.reload((Path)task.compute());
        }
        finally {
            this.myReloadSuppressed = false;
        }
    }

    public boolean pathBar() {
        return this.myShowPathBar;
    }

    public boolean togglePathBar() {
        this.myShowPathBar = !this.myShowPathBar;
        PropertiesComponent.getInstance().setValue("FileChooser.ShowPath", Boolean.toString(this.myShowPathBar));
        this.myPath.setVisible(this.myShowPathBar);
        ((JComponent)(this.myShowPathBar ? this.myPath : this.myList)).requestFocusInWindow();
        return this.myShowPathBar;
    }

    public boolean hiddenFiles() {
        return this.myShowHiddenFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleHiddenFiles() {
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = this.myShowHiddenFiles = !this.myShowHiddenFiles;
            if (this.myCurrentDirectory != null) {
                FsItem selection = (FsItem)this.myList.getSelectedObject();
                this.myModel.setItems(this.myShowHiddenFiles ? new ArrayList<FsItem>(this.myCurrentContent) : new ArrayList(ContainerUtil.filter(this.myCurrentContent, item -> item.visible)));
                this.myList.setSelection(selection != null ? List.of(selection) : List.of());
            }
            return this.myShowHiddenFiles;
        }
    }

    public boolean projectDetection() {
        return this.myDetectProjectDirectories;
    }

    public boolean toggleProjectDetection() {
        boolean newState;
        this.myDetectProjectDirectories = newState = !this.myDetectProjectDirectories;
        PropertiesComponent.getInstance().setValue(PROJECT_DIR_DETECTION_PROPERTY, newState);
        this.reload(null);
        return newState;
    }

    @Nullable
    public Path currentDirectory() {
        return this.myCurrentDirectory;
    }

    @NotNull
    public List<Path> selectedPaths() {
        List<Path> list2 = this.myList.getSelectedObjects().stream().filter(r -> r.path != null && r.path.getParent() != null).map(r -> r.path).collect(Collectors.toList());
        if (list2 == null) {
            FileChooserPanelImpl.$$$reportNull$$$0(9);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.cancelCurrentTask();
        }
        if (this.myWatcher != null) {
            try {
                this.myWatcher.close();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        this.myOpenFileSystems.forEach((p, fs) -> {
            try {
                fs.close();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(@Nullable Path path, @Nullable Path focusOn, Set<OpenFlags> flags) {
        Object object = this.myLock;
        synchronized (object) {
            Path childDir;
            boolean updateHistory;
            boolean updatePathBar = flags.contains((Object)OpenFlags.UPDATE_PATH_BAR);
            boolean bl = updateHistory = !flags.contains((Object)OpenFlags.KEEP_HISTORY);
            if (updatePathBar) {
                this.myPath.setItem((Object)(path != null ? new PathWrapper(path) : null));
            }
            this.myModel.setItems(new ArrayList());
            this.myList.clearSelection();
            this.myList.setPaintBusy(true);
            Path path2 = childDir = flags.contains((Object)OpenFlags.UPPER_LEVEL) ? this.myCurrentDirectory : null;
            if (!flags.contains((Object)OpenFlags.RELOAD)) {
                this.myCurrentDirectory = null;
            }
            this.myCurrentContent.clear();
            this.cancelCurrentTask();
            int id2 = this.myCounter++;
            if (LOG.isTraceEnabled()) {
                LOG.trace("starting: " + id2 + ", " + String.valueOf(path));
            }
            this.myCurrentTask = Pair.pair((Object)id2, FileChooserPanelImpl.execute(() -> {
                Path directory = this.directoryToLoad(path, flags.contains((Object)OpenFlags.INTO_ARCHIVE));
                if (directory != null) {
                    Path pathToSelect = focusOn != null ? focusOn : (childDir != null && childDir.getParent() == null && !FileChooserPanelImpl.isLocalFs(childDir) ? FileChooserPanelImpl.parent(childDir) : childDir);
                    this.loadDirectory(id2, directory, pathToSelect, updatePathBar, updateHistory);
                } else {
                    this.loadRoots(id2, childDir, updatePathBar, updateHistory);
                }
            }));
        }
    }

    private void cancelCurrentTask() {
        ((Future)this.myCurrentTask.second).cancel(true);
        if (this.myWatchKey != null) {
            this.myWatchKey.cancel();
            this.myWatchKey = null;
        }
    }

    @Nullable
    private Path directoryToLoad(@Nullable Path path, boolean asZip) {
        if (path != null && asZip) {
            try {
                FileSystem fs = this.myOpenFileSystems.computeIfAbsent(path, k -> {
                    try {
                        return FileSystems.newFileSystem(path, (ClassLoader)null);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
                return fs.getRootDirectories().iterator().next();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return path.getParent();
            }
        }
        Path current = path;
        while (current != null) {
            try {
                BasicFileAttributes attributes = Files.readAttributes(current, BasicFileAttributes.class, new LinkOption[0]);
                return attributes.isDirectory() ? current : current.getParent();
            }
            catch (Exception e) {
                LOG.trace((Throwable)e);
                current = FileChooserPanelImpl.parent(current);
            }
        }
        return null;
    }

    private void loadDirectory(int id2, Path directory, @Nullable Path pathToSelect, boolean updatePathBar, boolean updateHistory) {
        AtomicBoolean cancelled = new AtomicBoolean(false);
        PreloadedDirectory vfsDirectory = new PreloadedDirectory(directory);
        this.update(id2, cancelled, () -> {
            this.myCurrentDirectory = directory;
            this.updatePathBarAndHistory(directory, updatePathBar, updateHistory);
        });
        AtomicReference selection = new AtomicReference();
        AtomicReference<String> error = new AtomicReference<String>();
        try {
            PlatformNioHelper.visitDirectory(directory, null, (file2, result2) -> {
                LazyDirectoryOrFile virtualFile;
                BasicFileAttributes attrs;
                try {
                    attrs = (BasicFileAttributes)result2.get();
                }
                catch (Exception e) {
                    error.set(e.getMessage());
                    return true;
                }
                if (attrs.isSymbolicLink()) {
                    try {
                        attrs = new DelegatingFileAttributes(Files.readAttributes(file2, BasicFileAttributes.class, new LinkOption[0]));
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
                boolean visible = !this.myDescriptor.isHidden((VirtualFile)(virtualFile = new LazyDirectoryOrFile((VirtualFile)vfsDirectory, (Path)file2, attrs)));
                boolean selectable = this.myDescriptor.isSelectable((VirtualFile)virtualFile);
                Icon icon2 = this.myDetectProjectDirectories || !virtualFile.isDirectory() ? this.myDescriptor.getIcon((VirtualFile)virtualFile) : AllIcons.Nodes.Folder;
                FsItem item = new FsItem((Path)file2, file2.getFileName().toString(), attrs, visible, selectable, icon2);
                this.update(id2, cancelled, () -> {
                    this.myCurrentContent.add(item);
                    if (visible || this.myShowHiddenFiles) {
                        this.myModel.addRow((Object)item);
                    }
                });
                if (pathToSelect != null && file2.equals(pathToSelect)) {
                    selection.set(item);
                }
                return !cancelled.get();
            });
        }
        catch (IOException | RuntimeException e) {
            LOG.warn(directory.toString(), (Throwable)e);
            error.set(e.getMessage());
        }
        if (!cancelled.get()) {
            WatchKey watchKey;
            block6: {
                watchKey = null;
                if (this.myWatcher != null && FileChooserPanelImpl.isLocalFs(directory)) {
                    try {
                        watchKey = directory.register(this.myWatcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug("cannot watch " + String.valueOf(directory), (Throwable)e);
                    }
                }
            }
            WatchKey _watchKey = watchKey;
            this.update(id2, () -> {
                this.myList.setPaintBusy(false);
                this.updateSelection(selection);
                this.reportError("file.chooser.cannot.load.dir", error);
                this.myWatchKey = _watchKey;
            }, () -> {
                if (_watchKey != null) {
                    _watchKey.cancel();
                }
            });
        }
    }

    private void loadRoots(int id2, @Nullable Path pathToSelect, boolean updatePathBar, boolean updateHistory) {
        AtomicBoolean cancelled = new AtomicBoolean(false);
        this.update(id2, cancelled, () -> {
            this.myCurrentDirectory = null;
            this.updatePathBarAndHistory(null, updatePathBar, updateHistory);
        });
        ArrayList<Path> roots = new ArrayList<Path>();
        for (Path path : FileSystems.getDefault().getRootDirectories()) {
            roots.add(path);
        }
        if (WSLUtil.isSystemCompatible() && Experiments.getInstance().isFeatureEnabled("wsl.p9.show.roots.in.file.chooser")) {
            try {
                List<WSLDistribution> distributions = WslDistributionManager.getInstance().getInstalledDistributionsFuture().get(200L, TimeUnit.MILLISECONDS);
                for (WSLDistribution distribution : distributions) {
                    roots.add(distribution.getUNCRootPath());
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        AtomicReference<FsItem> selection = new AtomicReference<FsItem>();
        AtomicReference<String> atomicReference = new AtomicReference<String>();
        for (Path root : roots) {
            if (cancelled.get()) break;
            try {
                BasicFileAttributes attrs = Files.readAttributes(root, BasicFileAttributes.class, new LinkOption[0]);
                LazyDirectoryOrFile virtualFile = new LazyDirectoryOrFile(null, root, attrs);
                Object name2 = NioFiles.getFileName((Path)root);
                if (((String)name2).length() > 1 && ((String)name2).endsWith(File.separator)) {
                    name2 = ((String)name2).substring(0, ((String)name2).length() - 1);
                }
                if (OS.CURRENT == OS.Windows) {
                    try {
                        String store = Files.getFileStore(root).name();
                        if (!store.isBlank()) {
                            name2 = (String)name2 + " [" + store + "]";
                        }
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
                FsItem item = new FsItem(root, (String)name2, null, true, this.myDescriptor.isSelectable((VirtualFile)virtualFile), AllIcons.Nodes.Folder);
                this.update(id2, cancelled, () -> this.myModel.addRow((Object)item));
                if (pathToSelect == null || !root.equals(pathToSelect)) continue;
                selection.set(item);
            }
            catch (Exception e) {
                LOG.warn(root.toString(), (Throwable)e);
                atomicReference.set(e.getMessage());
            }
        }
        if (!cancelled.get()) {
            this.update(id2, cancelled, () -> {
                this.myList.setPaintBusy(false);
                this.updateSelection(selection);
                this.reportError("file.chooser.cannot.load.roots", error);
            });
        }
    }

    @Nullable
    private static Path parent(Path path) {
        Path parent = path.getParent();
        if (parent == null && !FileChooserPanelImpl.isLocalFs(path)) {
            try {
                return Path.of(FileChooserPanelImpl.storeName(path), new String[0]);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        return parent;
    }

    @Nullable
    private Path findByPath(String text2) {
        FileSystem fs;
        Path archive;
        int p = text2.lastIndexOf(SEPARATOR);
        if (p > 0 && this.myDescriptor.isChooseJarContents() && (archive = NioFiles.toPath((String)text2.substring(0, p))) != null && this.myRegistry.getFileTypeByFileName(archive.getFileName().toString()) == ArchiveFileType.INSTANCE && (fs = this.myOpenFileSystems.computeIfAbsent(archive, k -> {
            try {
                return FileSystems.newFileSystem(archive, (ClassLoader)null);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return null;
            }
        })) != null) {
            return fs.getRootDirectories().iterator().next().resolve(text2.substring(p + 2));
        }
        return NioFiles.toPath((String)text2);
    }

    private static boolean isLocalFs(Path path) {
        return path.getFileSystem() == FileSystems.getDefault();
    }

    private static String storeName(Path path) {
        return UriUtil.trimTrailingSlashes((String)path.getFileSystem().getFileStores().iterator().next().name());
    }

    private static Future<Void> execute(Runnable operation2) {
        return CompletableFuture.runAsync(operation2, ProcessIOExecutorService.INSTANCE).exceptionally(t -> {
            LOG.error(t);
            return null;
        });
    }

    private void update(int id2, AtomicBoolean cancelled, Runnable operation2) {
        this.update(id2, operation2, () -> cancelled.set(true));
    }

    private void update(int id2, Runnable whenActive, Runnable whenCancelled) {
        UIUtil.invokeLaterIfNeeded(() -> {
            Object object = this.myLock;
            synchronized (object) {
                boolean active = (Integer)this.myCurrentTask.first == id2 && !((Future)this.myCurrentTask.second).isCancelled();
                (active ? whenActive : whenCancelled).run();
            }
        });
    }

    private void updatePathBarAndHistory(@Nullable Path path, boolean updatePathBar, boolean updateHistory) {
        if (updatePathBar) {
            this.myPath.setItem((Object)(path != null ? new PathWrapper(path) : null));
        }
        if (updateHistory) {
            this.myHistory.subList(++this.myHistoryIndex, this.myHistory.size()).clear();
            this.myHistory.add(path);
        }
    }

    private void updateSelection(AtomicReference<FsItem> selection) {
        if (selection.get() != null) {
            this.myList.setSelection(List.of(selection.get()));
        } else {
            this.myList.clearSelection();
        }
    }

    private void reportError(String key, AtomicReference<String> error) {
        String message = error.get();
        this.myErrorSink.accept(message != null ? UIBundle.message((String)key, (Object[])new Object[]{message}) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorSink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentPaths";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/impl/FileChooserPanelImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/impl/FileChooserPanelImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "chosenPaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reloadAfter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 9 -> new IllegalStateException(string);
        };
    }

    private static final class PathWrapper {
        private final Path path;

        private PathWrapper(Path path) {
            this.path = path;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof FsItem)) return false;
            FsItem item = (FsItem)o;
            if (!this.path.equals(item.path)) return false;
            return true;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            if (!FileChooserPanelImpl.isLocalFs(this.path)) {
                try {
                    String store = FileChooserPanelImpl.storeName(this.path);
                    if (!store.isBlank()) {
                        return store + "!" + String.valueOf(this.path);
                    }
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
            return this.path.toString();
        }
    }

    private static final class FsItem {
        private final Path path;
        @NlsSafe
        private final String name;
        private final boolean directory;
        private final long size;
        private final long lastUpdated;
        private final boolean visible;
        private final boolean selectable;
        @Nullable
        private final Icon icon;
        private static final Comparator<FsItem> COMPARATOR = (o1, o2) -> {
            int byType = Boolean.compare(o2.directory, o1.directory);
            if (byType != 0) {
                return byType;
            }
            byType = Boolean.compare(o1.name.startsWith("\\\\"), o2.name.startsWith("\\\\"));
            if (byType != 0) {
                return byType;
            }
            return NaturalComparator.INSTANCE.compare(o1.name, o2.name);
        };

        private FsItem(Path path, String name2, @Nullable BasicFileAttributes attrs, boolean visible, boolean selectable, @Nullable Icon icon2) {
            this.path = path;
            this.name = name2;
            this.directory = attrs == null || attrs.isDirectory();
            this.size = attrs == null || attrs.isDirectory() ? 0L : attrs.size();
            this.lastUpdated = attrs == null ? 0L : attrs.lastModifiedTime().toMillis();
            this.visible = visible;
            this.selectable = selectable;
            this.icon = icon2;
        }
    }

    private static final class MyHeaderCellRenderer
    extends MyDelegatingTableCellRenderer {
        private MyHeaderCellRenderer(TableCellRenderer delegate) {
            super(delegate);
        }

        @Override
        protected void customizeComponent(JTable table2, int row2, int column, JLabel label2) {
            label2.setHorizontalAlignment(2);
        }
    }

    private static final class MyTableCellRenderer
    extends MyDelegatingTableCellRenderer {
        private MyTableCellRenderer(TableCellRenderer delegate) {
            super(delegate);
        }

        @Override
        protected void customizeComponent(JTable table2, int row2, int column, JLabel label2) {
            FsItem item = (FsItem)((TableView)table2).getRow(row2);
            label2.setIcon(column == 0 ? item.icon : null);
            label2.setHorizontalAlignment(2);
            label2.setToolTipText(column == 1 ? DateFormatUtil.formatDateTime((long)item.lastUpdated) : null);
            label2.setEnabled(item.selectable);
        }
    }

    private static enum OpenFlags {
        UPPER_LEVEL,
        INTO_ARCHIVE,
        RELOAD,
        UPDATE_PATH_BAR,
        KEEP_HISTORY;

    }

    private static final class PreloadedDirectory
    extends CoreLocalVirtualFile {
        private final List<LazyDirectoryOrFile> myChildren = new ArrayList<LazyDirectoryOrFile>();

        private PreloadedDirectory(Path file2) {
            super(FS, file2, true);
        }

        @Nullable
        public VirtualFile getParent() {
            return null;
        }

        @Nullable
        public VirtualFile findChild(@NotNull String name2) {
            if (name2 == null) {
                PreloadedDirectory.$$$reportNull$$$0(0);
            }
            if (name2.indexOf(47) >= 0 || name2.indexOf(92) >= 0) {
                throw new IllegalArgumentException(name2);
            }
            return (VirtualFile)ContainerUtil.find(this.myChildren, f -> name2.equals(f.getName()));
        }

        public VirtualFile[] getChildren() {
            return VfsUtilCore.toVirtualFileArray(this.myChildren);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/fileChooser/impl/FileChooserPanelImpl$PreloadedDirectory", "findChild"));
        }
    }

    private static final class LazyDirectoryOrFile
    extends CoreLocalVirtualFile {
        @Nullable
        private final VirtualFile myParent;
        @Nullable
        private final Map<String, Optional<LazyDirectoryOrFile>> myChildren;

        private LazyDirectoryOrFile(@Nullable VirtualFile parent, Path file2, BasicFileAttributes attrs) {
            super(FS, file2, attrs);
            this.myParent = parent;
            HashMap hashMap = this.myChildren = attrs.isDirectory() ? new HashMap() : null;
            if (parent instanceof PreloadedDirectory) {
                PreloadedDirectory preloaded = (PreloadedDirectory)parent;
                preloaded.myChildren.add(this);
            }
        }

        @Nullable
        public VirtualFile getParent() {
            return this.myParent;
        }

        @Nullable
        public VirtualFile findChild(@NotNull String name2) {
            if (name2 == null) {
                LazyDirectoryOrFile.$$$reportNull$$$0(0);
            }
            if (name2.indexOf(47) >= 0 || name2.indexOf(92) >= 0) {
                throw new IllegalArgumentException(name2);
            }
            return this.myChildren == null ? null : (VirtualFile)this.myChildren.computeIfAbsent(name2, k -> {
                try {
                    Path childFile = this.getFile().resolve(name2);
                    BasicFileAttributes attrs = Files.readAttributes(childFile, BasicFileAttributes.class, new LinkOption[0]);
                    return Optional.of(new LazyDirectoryOrFile((VirtualFile)this, childFile, attrs));
                }
                catch (Exception e) {
                    LOG.trace((Throwable)e);
                    return Optional.empty();
                }
            }).orElse(null);
        }

        public VirtualFile[] getChildren() {
            return this.myChildren == null ? EMPTY_ARRAY : (VirtualFile[])this.myChildren.values().stream().map(o -> o.orElse(null)).filter(Objects::nonNull).toArray(VirtualFile[]::new);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/fileChooser/impl/FileChooserPanelImpl$LazyDirectoryOrFile", "findChild"));
        }
    }

    private static final class DelegatingFileAttributes
    implements BasicFileAttributes {
        private final BasicFileAttributes myDelegate;

        private DelegatingFileAttributes(BasicFileAttributes delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public FileTime lastModifiedTime() {
            return this.myDelegate.lastModifiedTime();
        }

        @Override
        public FileTime lastAccessTime() {
            return this.myDelegate.lastAccessTime();
        }

        @Override
        public FileTime creationTime() {
            return this.myDelegate.creationTime();
        }

        @Override
        public boolean isRegularFile() {
            return this.myDelegate.isRegularFile();
        }

        @Override
        public boolean isDirectory() {
            return this.myDelegate.isDirectory();
        }

        @Override
        public boolean isSymbolicLink() {
            return true;
        }

        @Override
        public boolean isOther() {
            return this.myDelegate.isOther();
        }

        @Override
        public long size() {
            return this.myDelegate.size();
        }

        @Override
        public Object fileKey() {
            return this.myDelegate.fileKey();
        }
    }

    private static abstract class MyColumnInfo
    extends ColumnInfo<FsItem, String> {
        private final int myWidth;
        private final Comparator<FsItem> myComparator;

        private MyColumnInfo(@NlsContexts.ColumnName String name2, int width, Comparator<FsItem> comparator) {
            super(name2);
            this.myWidth = width;
            this.myComparator = comparator;
        }

        public int getWidth(JTable table2) {
            return this.myWidth == 0 ? 0 : table2.getFontMetrics(table2.getFont()).charWidth('X') * this.myWidth;
        }

        public Comparator<FsItem> getComparator() {
            return this.myComparator;
        }
    }

    private static abstract class MyDelegatingTableCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer myDelegate;

        private MyDelegatingTableCellRenderer(TableCellRenderer delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean selected, boolean focused, int row2, int column) {
            Component component2 = this.myDelegate.getTableCellRendererComponent(table2, value, selected, false, row2, column);
            if (component2 instanceof JLabel) {
                JLabel label2 = (JLabel)component2;
                this.customizeComponent(table2, row2, column, label2);
            }
            return component2;
        }

        protected abstract void customizeComponent(JTable var1, int var2, int var3, JLabel var4);
    }
}

