/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.fileEditor.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/fileEditor/impl/ClientCurrentEditorProvider;", "Lcom/intellij/openapi/fileEditor/impl/CurrentEditorProvider;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "getCurrentEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nClientCurrentEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientCurrentEditorProvider.kt\ncom/intellij/openapi/fileEditor/impl/ClientCurrentEditorProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n13#2:42\n30#3,2:43\n184#4,2:45\n1#5:47\n*S KotlinDebug\n*F\n+ 1 ClientCurrentEditorProvider.kt\ncom/intellij/openapi/fileEditor/impl/ClientCurrentEditorProvider\n*L\n18#1:42\n24#1:43,2\n25#1:45,2\n*E\n"})
public final class ClientCurrentEditorProvider
implements CurrentEditorProvider {
    @NotNull
    private final ClientAppSession session;

    public ClientCurrentEditorProvider(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    @Override
    @Nullable
    public FileEditor getCurrentEditor(@Nullable Project project2) {
        FileEditor fileEditor;
        if (this.session.isDisposed()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ClientCurrentEditorProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("The client (" + ClientId.Companion.getCurrent() + ") session has expired.", new Throwable());
            return null;
        }
        if (project2 == null) {
            TextEditor textEditor;
            Object v2;
            block7: {
                ComponentManager $this$service$iv = (ComponentManager)this.session;
                boolean $i$f$service = false;
                Class<ClientEditorManager> serviceClass$iv = ClientEditorManager.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Sequence $this$firstOrNull$iv = ((ClientEditorManager)object).editorsSequence();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Editor it = (Editor)element$iv;
                    boolean bl = false;
                    if (!UIUtil.hasFocus((Component)it.getContentComponent())) continue;
                    v2 = element$iv;
                    break block7;
                }
                v2 = null;
            }
            Editor editor2 = v2;
            if (editor2 != null) {
                Editor it = editor2;
                boolean bl = false;
                textEditor = TextEditorProvider.Companion.getInstance().getTextEditor(it);
            } else {
                textEditor = null;
            }
            return (FileEditor)textEditor;
        }
        if (this.session.isController() && (fileEditor = FocusBasedCurrentEditorProvider.getCurrentEditorEx()) != null) {
            FileEditor editor3 = fileEditor;
            boolean bl = false;
            return editor3;
        }
        return FileEditorManager.getInstance((Project)project2).getSelectedEditor();
    }
}

